// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

package xyz.apiote.bimba.czwek.repo

import xyz.apiote.bimba.czwek.api.LineTypeV1
import xyz.apiote.bimba.czwek.api.LineTypeV2
import xyz.apiote.bimba.czwek.api.LineTypeV3
import xyz.apiote.bimba.czwek.api.transitous.model.Mode

enum class LineType {
	WALK,

	METRO_UNDERGROUND, TRAIN, CABLE_TRAM, CABLE_RAIL, MONORAIL,

	TRAIN_RAPID, TRAIN_DISTANCE, TRAIN_INTERREGIO, TRAIN_CAR_TRANSPORT, TRAIN_SLEEPER, TRAIN_REGIO,
	TRAIN_TOURIST, TRAIN_SHUTTLE, TRAIN_SUBURBAN, TRAIN_REPLACEMENT, TRAIN_SPECIAL,
	TRAIN_LORRY_TRANSPORT, TRAIN_ALL, TRAIN_CROSS_COUNTRY, TRAIN_VEHICLE_TRANSPORT, TRAIN_RACK,
	TRAIN_ADDITIONAL,

	COACH, COACH_CROSS_COUNTRY, COACH_INTERREGIO, COACH_SHUTTLE, COACH_REGIO, COACH_SPECIAL,
	COACH_SIGHTSEEING, COACH_TOURIST, COACH_COMMUTER, COACH_ALL,

	URBAN, URBAN_METRO, URBAN_UNDERGROUND, URBAN_RAIL, URBAN_ALL, URBAN_MONORAIL,

	BUS, BUS_REGIO, BUS_RAPID, BUS_STOPPING, BUS_LOCAL, BUS_NIGHT, BUS_POST, BUS_SPECIAL_NEEDS,
	BUS_MOBILITY, BUS_MOBILITY_REGISTERED, BUS_SIGHTSEEING, BUS_SHUTTLE, BUS_SCHOOL,
	BUS_SCHOOL_PUBLIC_SERVICE, BUS_RAIL_REPLACEMENT, BUS_DEMAND, BUS_ALL,

	TROLLEYBUS,

	TRAM, TRAM_CITY, TRAM_LOCAL, TRAM_REGIO, TRAM_SIGHTSEEING, TRAM_SHUTTLE, TRAM_ALL,

	WATER,

	AIR,

	FERRY,

	AERIAL_LIFT, TELECABIN, CABLE_CAR, ELEVATOR, CHAIR_LIFT, DRAG_LIFT, TELECABIN_SMALL, TELECABIN_ALL,

	FUNICULAR,

	TAXI, TAXI_COMMUNAL, TAXI_WATER, TAXI_RAIL, TAXI_BIKE, TAXI_LICENSED, TAXI_PRIVATE_HIRE, TAXI_ALL,

	MISC,

	HORSE_CARIAGE;


	fun isActive(): Boolean {
		return this == WALK
	}

	companion object {
		fun of(t: LineTypeV1): LineType {
			return when (t) {
				LineTypeV1.UNKNOWN -> valueOf("UNKNOWN")
				LineTypeV1.TRAM -> valueOf("TRAM")
				LineTypeV1.BUS -> valueOf("BUS")
			}
		}

		fun of(t: LineTypeV2): LineType {
			return when (t) {
				LineTypeV2.UNKNOWN -> valueOf("UNKNOWN")
				LineTypeV2.TRAM -> valueOf("TRAM")
				LineTypeV2.BUS -> valueOf("BUS")
				LineTypeV2.TROLLEYBUS -> valueOf("TROLLEYBUS")
			}
		}

		fun of(t: LineTypeV3): LineType {
			return when (t) {
				LineTypeV3.UNKNOWN -> valueOf("UNKNOWN")
				LineTypeV3.TRAM -> valueOf("TRAM")
				LineTypeV3.BUS -> valueOf("BUS")
				LineTypeV3.TROLLEYBUS -> valueOf("TROLLEYBUS")
				LineTypeV3.METRO -> valueOf("METRO")
				LineTypeV3.RAIL -> valueOf("RAIL")
				LineTypeV3.FERRY -> valueOf("FERRY")
				LineTypeV3.CABLE_TRAM -> valueOf("CABLE_TRAM")
				LineTypeV3.CABLE_CAR -> valueOf("CABLE_CAR")
				LineTypeV3.FUNICULAR -> valueOf("FUNICULAR")
				LineTypeV3.MONORAIL -> valueOf("MONORAIL")
			}
		}

		fun fromTransitous2(mode: Mode, routeType: Int?): LineType {
			return if (routeType != null) {
				when (routeType) {
					0 -> TRAM
					1 -> METRO_UNDERGROUND
					2 -> TRAIN
					3 -> BUS
					4 -> FERRY
					5 -> CABLE_TRAM
					6 -> CABLE_RAIL
					7 -> FUNICULAR
					11 -> TROLLEYBUS
					12 -> MONORAIL
					100 -> TRAIN
					101 -> TRAIN_RAPID
					102 -> TRAIN_DISTANCE
					103 -> TRAIN_INTERREGIO
					104 -> TRAIN_CAR_TRANSPORT
					105 -> TRAIN_SLEEPER
					106 -> TRAIN_REGIO
					107 -> TRAIN_TOURIST
					108 -> TRAIN_SHUTTLE
					109 -> TRAIN_SUBURBAN
					110 -> TRAIN_REPLACEMENT
					111 -> TRAIN_SPECIAL
					112 -> TRAIN_LORRY_TRANSPORT
					113 -> TRAIN_ALL
					114 -> TRAIN_CROSS_COUNTRY
					115 -> TRAIN_VEHICLE_TRANSPORT
					116 -> TRAIN_RACK
					117 -> TRAIN_ADDITIONAL
					200 -> COACH
					201 -> COACH_CROSS_COUNTRY
					202 -> COACH_INTERREGIO
					203 -> COACH_SHUTTLE
					204 -> COACH_REGIO
					205 -> COACH_SPECIAL
					206 -> COACH_SIGHTSEEING
					207 -> COACH_TOURIST
					208 -> COACH_COMMUTER
					209 -> COACH_ALL
					400 -> URBAN
					401 -> URBAN_METRO
					402 -> URBAN_UNDERGROUND
					403 -> URBAN_RAIL
					404 -> URBAN_ALL
					405 -> URBAN_MONORAIL
					700 -> BUS
					701 -> BUS_REGIO
					702 -> BUS_RAPID
					703 -> BUS_STOPPING
					704 -> BUS_LOCAL
					705 -> BUS_NIGHT
					706 -> BUS_POST
					707 -> BUS_SPECIAL_NEEDS
					708 -> BUS_MOBILITY
					709 -> BUS_MOBILITY_REGISTERED
					710 -> BUS_SIGHTSEEING
					711 -> BUS_SHUTTLE
					712 -> BUS_SCHOOL
					713 -> BUS_SCHOOL_PUBLIC_SERVICE
					714 -> BUS_RAIL_REPLACEMENT
					715 -> BUS_DEMAND
					716 -> BUS_ALL
					800 -> TROLLEYBUS
					900 -> TRAM
					901 -> TRAM_CITY
					902 -> TRAM_LOCAL
					903 -> TRAM_REGIO
					904 -> TRAM_SIGHTSEEING
					905 -> TRAM_SHUTTLE
					906 -> TRAM_ALL
					1000 -> WATER
					1100 -> AIR
					1200 -> FERRY
					1300 -> AERIAL_LIFT
					1301 -> TELECABIN
					1302 -> CABLE_CAR
					1303 -> ELEVATOR
					1304 -> CHAIR_LIFT
					1305 -> DRAG_LIFT
					1306 -> TELECABIN_SMALL
					1307 -> TELECABIN_ALL
					1400 -> FUNICULAR
					1500 -> TAXI
					1501 -> TAXI_COMMUNAL
					1502 -> TAXI_WATER
					1503 -> TAXI_RAIL
					1504 -> TAXI_BIKE
					1505 -> TAXI_LICENSED
					1506 -> TAXI_PRIVATE_HIRE
					1507 -> TAXI_ALL
					1700 -> MISC
					1702 -> HORSE_CARIAGE
					else -> MISC
				}
			} else {
				when (mode) {
					Mode.AIRPLANE -> AIR
					Mode.WALK -> WALK
					Mode.BIKE -> MISC
					Mode.CAR -> MISC
					Mode.RENTAL -> MISC
					Mode.TRANSIT -> MISC
					Mode.TRAM -> TRAM
					Mode.SUBWAY -> URBAN_UNDERGROUND
					Mode.FERRY -> FERRY
					Mode.METRO -> URBAN_METRO
					Mode.BUS -> BUS
					Mode.COACH -> COACH
					Mode.RAIL -> TRAIN
					Mode.HIGHSPEED_RAIL -> TRAIN_RAPID
					Mode.LONG_DISTANCE -> TRAIN_DISTANCE
					Mode.NIGHT_RAIL -> TRAIN_SLEEPER
					Mode.REGIONAL_FAST_RAIL -> TRAIN
					Mode.REGIONAL_RAIL -> TRAIN_REGIO
					Mode.OTHER -> MISC
					Mode.CAR_PARKING -> MISC
					Mode.CAR_DROPOFF -> MISC
					Mode.ODM -> MISC // On Demand Mobility?
					Mode.FLEX -> MISC
					Mode.CABLE_CAR -> CABLE_RAIL
					Mode.FUNICULAR -> FUNICULAR
					Mode.AREAL_LIFT -> AERIAL_LIFT
					Mode.SUBURBAN -> URBAN_METRO
					Mode.AERIAL_LIFT -> AERIAL_LIFT
				}
			}
		}
	}
}
