// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

package xyz.apiote.bimba.czwek.repo

import android.os.Parcelable
import android.util.Log
import kotlinx.parcelize.Parcelize
import java.time.LocalDate
import java.time.LocalTime
import java.time.ZoneId
import java.time.ZonedDateTime


enum class TimeReference {
	DEPART_AFTER, ARRIVE_BY;

	fun id(): Int {
		return when (this) {
			DEPART_AFTER -> 1
			ARRIVE_BY -> 2
		}
	}
}

@Parcelize
data class JourneyParams(
	val timeReference: TimeReference,
	val date: LocalDate?,
	val time: LocalTime?,
	val wheelchairAccessible: Boolean,
	val bicycle: Boolean
) : Parcelable {
	fun getDateTime(zone: ZoneId): ZonedDateTime {
		Log.i("Journey Params", "date: ${date}, time: ${time}")
		val t = ZonedDateTime.now().let {
			return@let if (date != null) {
				it.withYear(date.year).withMonth(date.monthValue).withDayOfMonth(date.dayOfMonth)
			} else {
				it
			}
		}.let {
			return@let if (time != null) {
				it.withHour(time.hour).withMinute(time.minute).withZoneSameLocal(zone)
			} else {
				it
			}
		}
		Log.i("Journey Params", "datetime: ${t}")
		return t
	}
}