// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

package xyz.apiote.bimba.czwek.repo

import xyz.apiote.bimba.czwek.units.DistanceUnit
import xyz.apiote.bimba.czwek.units.TimeUnit
import java.time.ZonedDateTime

data class Journey(
	val startTime: ZonedDateTime,
	val endTime: ZonedDateTime,
	val legs: List<Leg>,
	val duration: TimeUnit
)

data class Leg(
	val start: Event,
	val end: Event,
	val origin: xyz.apiote.bimba.czwek.data.traffic.Place,
	val destination: xyz.apiote.bimba.czwek.data.traffic.Place,
	val agencyName: String?,
	val distance: DistanceUnit?,
	val duration: TimeUnit,
	val intermediateStops: List<StopTime>,
	val shape: List<Position>,
	val isScheduled: Boolean,
	val isCanceled: Boolean,
	/* TODO
	val rental: Rental?,
	val steps: List<StepInstruction>?,*/
)