// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

package xyz.apiote.bimba.czwek.repo

import android.content.Context
import android.graphics.drawable.Drawable

interface Queryable {
	fun location(): Position?
}

interface Locatable {
	fun icon(context: Context, scale: Float = 1f): Drawable
	fun location(): Position
	fun id(): String
}

interface Repository {
	suspend fun getFavourite(stopCode: String): Favourite?
	suspend fun getFavourites(feedIDs: Set<String> = emptySet()): List<Favourite>

	suspend fun saveFavourite(favourite: Favourite)
	suspend fun saveFavourites(favourites: Set<Favourite>)
}