// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

package xyz.apiote.bimba.czwek

import android.content.Context
import java.time.ZonedDateTime
import java.time.format.DateTimeFormatter
import java.time.format.FormatStyle

fun ZonedDateTime.formatTimeHM(): String {
	return format(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT))
}

fun ZonedDateTime.formatTimeHMS(): String {
	return format(DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM))
}

fun ZonedDateTime.formatTimeAtHM(context: Context): String {
	return context.getString(R.string.at_time_string, formatTimeHM())
}

fun ZonedDateTime.formatTimeAboutHM(context: Context): String {
	return context.getString(R.string.about_time_string, formatTimeHM())
}

fun ZonedDateTime.formatTimeAtHMS(context: Context): String {
	return context.getString(R.string.at_time_string, formatTimeHMS())
}

fun ZonedDateTime.formatDate(): String {
	return format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT))
}

fun ZonedDateTime.isDateSame(other: ZonedDateTime): Boolean {
	val compareOther = other.withZoneSameInstant(this.zone)
	return compareOther.dayOfYear == this.dayOfYear
}

fun ZonedDateTime.isTimeSame(other: ZonedDateTime): Boolean {
	val compareOther = other.withZoneSameInstant(this.zone)
	return compareOther.hour == this.hour && compareOther.minute == this.minute
}

fun ZonedDateTime.formatDateTime(): String {
	return format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT))
}