// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

package xyz.apiote.bimba.czwek.data.traffic

import android.content.Context
import android.os.Parcelable
import kotlinx.parcelize.Parcelize
import xyz.apiote.bimba.czwek.data.ResultFlowItem
import xyz.apiote.bimba.czwek.repo.Position
import xyz.apiote.bimba.czwek.repo.Queryable
import xyz.apiote.bimba.czwek.repo.Stop
import java.time.ZoneId

@Parcelize
data class PointOfInterest(
	val poiName: String,
	val poiDescription: String,
	val poiPosition: Position,
	val tz: ZoneId,
) :
	Place, Queryable, Parcelable, ResultFlowItem {
	override fun getName() = poiName

	override fun getDescription(context: Context, decoration: Stop.LineDecoration) = poiDescription

	override fun getLatitude() = poiPosition.positionLatitude

	override fun getLongitude() = poiPosition.positionLongitude

	override fun getJourneyID() = "${poiPosition.positionLatitude},${poiPosition.positionLongitude},0"

	override fun getShortName() = poiName

	override fun getPosition() = poiPosition

	@Suppress("RedundantNullableReturnType")
	override fun location(): Position? = poiPosition

	override fun getTimezone(): ZoneId = tz
}