// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

package xyz.apiote.bimba.czwek.data.traffic

import android.content.Context
import xyz.apiote.bimba.czwek.repo.Position
import xyz.apiote.bimba.czwek.repo.Stop
import java.time.ZoneId

interface Place {
	fun getName(): String
	fun getDescription(context: Context, decoration: Stop.LineDecoration): String
	fun getLatitude(): Double
	fun getLongitude(): Double
	fun getJourneyID(): String
	fun getShortName(): String
	fun getPosition(): Position
	fun getTimezone(): ZoneId

	companion object {
		fun fromTransitousPlace(transitousPlace: xyz.apiote.bimba.czwek.api.transitous.model.Place): Place {
			return if (transitousPlace.stopId != null) {
				Stop(transitousPlace)
			} else {
				PointOfInterest(
					transitousPlace.name,
					"",
					Position(transitousPlace.lat.toDouble(), transitousPlace.lon.toDouble()),
					tz = transitousPlace.tz?.let { ZoneId.of(it) } ?: ZoneId.systemDefault(),
				)
			}
		}
	}
}