// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

package xyz.apiote.bimba.czwek.data.sknow

import kotlinx.serialization.Serializable
import java.time.ZonedDateTime

@Serializable
data class InfrastructureDistortion(val Value: Boolean, val Kind: InfrastructureDistortionID)

@Serializable
data class LongTermWorks(
	val Value: Boolean,
	val Kind: LongTermWorksID,
	val Start: Long, //ZonedDateTime?,
	val End: Long //ZonedDateTime?
)

@Serializable
data class SocialDisturbance(val Value: Boolean, val Kinds: List<SocialDisturbanceID>)

@Serializable
data class StopUpdate(
	val SkidderID: String,
	val T: Long, //ZonedDateTime,
	val Infrastructure: List<InfrastructureDistortion>,
	val Works: List<LongTermWorks>,
	val Disturbance: SocialDisturbance?
) {
	companion object {
		fun empty(): StopUpdate =
			StopUpdate("", ZonedDateTime.now().toEpochSecond(), emptyList(), emptyList(), null)
	}
}