// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

package xyz.apiote.bimba.czwek.data.sknow

import kotlinx.serialization.Serializable

@Serializable
data class TimedBool(val T: Long)

@Serializable
data class TimedPeriod(val T: Long, val Start: Long?, val End: Long?)

data class StopResponse(
	val SkidderID: String,
	val ErrorMessage: String,
	val Infrastructure: Map<InfrastructureDistortionID, TimedBool>,
	val Works: Map<LongTermWorksID, TimedPeriod>,
	val Disturbance: SocialDisturbance?
) {
	constructor(a: StopResponseA) : this(
		a.SkidderID,
		a.ErrorMessage,
		a.Infrastructure ?: emptyMap(),
		a.Works ?: emptyMap(),
		a.Disturbance
	)
}
