// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

package xyz.apiote.bimba.czwek.data.sknow

import android.content.Context
import kotlinx.coroutines.channels.ReceiveChannel
import kotlinx.coroutines.channels.SendChannel
import xyz.apiote.bimba.czwek.data.sources.Sknow
import xyz.apiote.bimba.czwek.repo.Position

class SknowRepository {
	private val sources: MutableMap<Position, Sknow> = mutableMapOf()

	suspend fun startStop(
		context: Context,
		position: Position,
		updates: ReceiveChannel<StopUpdate>,
		stops: SendChannel<StopResponse>
	) {
		if (!sources.contains(position)) {
			sources[position] =
				Sknow(context, position.positionLatitude, position.positionLongitude, updates, stops)
			sources[position]!!.startStop()
		}
	}

	fun isStopRunning(position: Position) = sources[position]?.running?.value ?: false

	fun stopStop(position: Position) {
		sources[position]?.stopStop()
	}
}