// SPDX-FileCopyrightText: Adam Evyčędo
//
// SPDX-License-Identifier: GPL-3.0-or-later

@file:OptIn(ExperimentalSerializationApi::class)

package xyz.apiote.bimba.czwek.data.sknow

import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.KSerializer
import kotlinx.serialization.Serializable
import kotlinx.serialization.Serializer
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder

@Serializer(forClass = InfrastructureDistortionID::class)
object InfrastructureDistortionIDSerialiser : KSerializer<InfrastructureDistortionID> {
	override fun serialize(encoder: Encoder, value: InfrastructureDistortionID) {
		encoder.encodeInt(value.ordinal)
	}

	override fun deserialize(decoder: Decoder): InfrastructureDistortionID {
		return InfrastructureDistortionID.ofOrdinal(decoder.decodeInt())
	}
}

@Serializable(with = InfrastructureDistortionIDSerialiser::class)
enum class InfrastructureDistortionID {
	BIN_BROKEN, BIN_FULL, SHELTER_BROKEN, BENCH_BROKEN, TIMETABLE_BROKEN, TIMETABLE_MISSING, RTID_NOT_FUNCTIONING;

	companion object {
		fun ofOrdinal(o: Int): InfrastructureDistortionID {
			return when (o) {
				BIN_BROKEN.ordinal -> BIN_BROKEN
				BIN_FULL.ordinal -> BIN_FULL
				SHELTER_BROKEN.ordinal -> SHELTER_BROKEN
				BENCH_BROKEN.ordinal -> BENCH_BROKEN
				TIMETABLE_BROKEN.ordinal -> TIMETABLE_BROKEN
				TIMETABLE_MISSING.ordinal -> TIMETABLE_MISSING
				RTID_NOT_FUNCTIONING.ordinal -> RTID_NOT_FUNCTIONING
				else -> TODO()
			}
		}
	}
}

@Serializer(forClass = LongTermWorksID::class)
object LongTermWorksIDSerialiser : KSerializer<LongTermWorksID> {
	override fun serialize(encoder: Encoder, value: LongTermWorksID) {
		encoder.encodeInt(value.ordinal)
	}

	override fun deserialize(decoder: Decoder): LongTermWorksID {
		val key = decoder.decodeInt()
		TODO("deserialiser is not really needed")
	}
}

@Serializable(with = LongTermWorksIDSerialiser::class)
enum class LongTermWorksID {
	STOP_OUT_OF_OPERATION, WALKING_DIVERSION, STOP_TEMPORARY
}

@Serializer(forClass = SocialDisturbanceID::class)
object SocialDisturbanceIDSerialiser : KSerializer<SocialDisturbanceID> {
	override fun serialize(encoder: Encoder, value: SocialDisturbanceID) {
		encoder.encodeInt(value.ordinal)
	}

	override fun deserialize(decoder: Decoder): SocialDisturbanceID {
		val key = decoder.decodeInt()
		TODO("deserialiser is not really needed")
	}
}

@Serializable(with = SocialDisturbanceIDSerialiser::class)
enum class SocialDisturbanceID {
	DRUNK, LOUD, HARASSING
}

