/*
all_in_gold, the master of archery sight calibration.
Copyright (C) 2019 Michael Schröder (mi.schroeder@netcologne.de)

This file is part of all_in_gold.

all_in_gold is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

all_in_gold is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with all_in_gold.  If not, see <http://www.gnu.org/licenses/>.
*/

package x653.all_in_gold;
import java.util.ArrayList;

//  CSV liest und schreibt die Pfeile als CSV-Datei

class CSV {
    static ArrayList<Arrow> parseArrows(String string){
        ArrayList<Arrow> arrows = new ArrayList<>();
        if (string!=null) {
            String[] lines = string.split("\n");
            for (String line : lines) {
                String[] cols = line.split("\t");
                if (cols.length == 4) {
                    arrows.add(new Arrow(Float.valueOf(cols[0]),Float.valueOf(cols[1]),
                            Float.valueOf(cols[2]), Float.valueOf(cols[3]))
                    );
                }
            }
        }
        return arrows;
    }

    static String toCSVString(ArrayList<Arrow> arrows){
        StringBuilder stringBuilder=new StringBuilder();
        for (Arrow arrow:arrows){
            stringBuilder.append(arrow.getDistance());
            stringBuilder.append("\t");
            stringBuilder.append(arrow.getElevation());
            stringBuilder.append("\t");
            stringBuilder.append(arrow.getX());
            stringBuilder.append("\t");
            stringBuilder.append(arrow.getY());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}
