/*! @license
 * Shaka Player
 * Copyright 2016 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */

declare class GlobalError extends Error {}

//!! generated by clutz.
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka {
  class Player extends shaka.util.FakeEventTarget implements shaka.util.IDestroyable {
    private noStructuralTyping_shaka_Player : any;
    constructor (mediaElement ? : HTMLMediaElement | null , videoContainer ? : HTMLElement | null , dependencyInjector ? : (a : shaka.Player | null ) => any ) ;
    /**
     * Adds the given chapters track to the loaded manifest.  <code>load()</code>
     * must resolve before calling.  The presentation must have a duration.
     * This returns the created track.
     */
    addChaptersTrack (uri : string , language : string , mimeType ? : string ) : Promise < shaka.extern.TextTrack > ;
    /**
     * Load a new font on the page. If the font was already loaded, it does
     * nothing.
     */
    addFont (name : string , url : string ) : Promise < undefined > ;
    /**
     * Adds the given text track to the loaded manifest.  <code>load()</code> must
     * resolve before calling.  The presentation must have a duration.
     * This returns the created track, which can immediately be selected by the
     * application.  The track will not be automatically selected.
     */
    addTextTrackAsync (uri : string , language : string , kind : string , mimeType ? : string , codec ? : string , label ? : string , forced ? : boolean ) : Promise < shaka.extern.TextTrack > ;
    /**
     * Adds the given thumbnails track to the loaded manifest.
     * <code>load()</code> must resolve before calling.  The presentation must
     * have a duration.
     * This returns the created track, which can immediately be used by the
     * application.
     */
    addThumbnailsTrack (uri : string , mimeType ? : string ) : Promise < shaka.extern.ImageTrack > ;
    /**
     * Attaches the player to a media element.
     * If the player was already attached to a media element, first detaches from
     * that media element.
     */
    attach (mediaElement : HTMLMediaElement , initializeMediaSource ? : boolean ) : Promise < any > ;
    /**
     * Calling <code>attachCanvas</code> will tell the player to set canvas
     * element for LCEVC decoding.
     */
    attachCanvas (canvas : HTMLCanvasElement | null ) : any ;
    /**
     * Cancel trick-play. If the player has not loaded content or is still loading
     * content this will be a no-op.
     */
    cancelTrickPlay ( ) : any ;
    /**
     * Changes low latency configuration settings on the Player.
     * @param config This object should follow the {@link shaka.extern.PlayerConfiguration} object.  Not all fields need to be set; unset fields retain their old values.
     */
    configurationForLowLatency (config : object ) : any ;
    /**
     * Changes configuration settings on the Player.  This checks the names of
     * keys and the types of values to avoid coding errors.  If there are errors,
     * this logs them to the console and returns false.  Correct fields are still
     * applied even if there are other errors.  You can pass an explicit
     * <code>undefined</code> value to restore the default value.  This has two
     * modes of operation:
     * <p>
     * First, this can be passed a single "plain" object.  This object should
     * follow the {@link shaka.extern.PlayerConfiguration} object.  Not all fields
     * need to be set; unset fields retain their old values.
     * <p>
     * Second, this can be passed two arguments.  The first is the name of the key
     * to set.  This should be a '.' separated path to the key.  For example,
     * <code>'streaming.alwaysStreamText'</code>.  The second argument is the
     * value to set.
     * @param config This should either be a field name or an object.
     * @param value In the second mode, this is the value to set.
     */
    configure (config : string | object , value ? : any ) : boolean ;
    /**
     * After destruction, a Player object cannot be used again.
     */
    destroy ( ) : Promise < any > ;
    /**
     * Calls |destroy| on each PreloadManager object this player has created.
     */
    destroyAllPreloads ( ) : any ;
    /**
     * Detach the player from the current media element. Leaves the player in a
     * state where it cannot play media, until it has been attached to something
     * else.
     */
    detach (keepAdManager ? : boolean ) : Promise < any > ;
    /**
     * Detach the player from the current media element, if any, and returns a
     * PreloadManager that contains the loaded manifest of that asset, if any.
     * Allows for the asset to be re-loaded by this player faster, in the future.
     * When in src= mode, this detach but does not make a PreloadManager.
     * Leaves the player in a state where it cannot play media, until it has been
     * attached to something else.
     */
    detachAndSavePreload (keepAdManager ? : boolean , savePosition ? : boolean ) : Promise < shaka.media.PreloadManager | null > ;
    /**
     * Get the drm info used to initialize EME. If EME is not being used, this
     * will return <code>null</code>. If the player is idle or has not initialized
     * EME yet, this will return <code>null</code>.
     */
    drmInfo ( ) : shaka.extern.DrmInfo | null ;
    /**
     * Returns the active sessions metadata
     */
    getActiveSessionsMetadata ( ) : shaka.extern.DrmSessionMetadata [] ;
    /**
     * Returns a shaka.ads.AdManager instance, responsible for Dynamic
     * Ad Insertion functionality.
     */
    getAdManager ( ) : shaka.extern.IAdManager | null ;
    /**
     * Returns Thumbnail objects for each thumbnail.
     * If the player has not loaded content, this will return a null.
     */
    getAllThumbnails (trackId ? : number | null ) : Promise < shaka.extern.Thumbnail [] | null > ;
    /**
     * Get the uri to the asset that the player has loaded. If the player has not
     * loaded content, this will return <code>null</code>.
     */
    getAssetUri ( ) : string | null ;
    /**
     * Return a list of audio languages available. If the player has not loaded
     * any content, this will return an empty list.
     * <br>
     * This API is deprecated and will be removed in version 5.0, please migrate
     * to using `getAudioTracks` and `selectAudioTrack`.
     */
    getAudioLanguages ( ) : string [] ;
    /**
     * Return a list of audio language-role combinations available.  If the
     * player has not loaded any content, this will return an empty list.
     * <br>
     * This API is deprecated and will be removed in version 5.0, please migrate
     * to using `getAudioTracks` and `selectAudioTrack`.
     */
    getAudioLanguagesAndRoles ( ) : shaka.extern.LanguageRole [] ;
    /**
     * Return a list of audio tracks compatible with the current video track.
     */
    getAudioTracks ( ) : shaka.extern.AudioTrack [] ;
    /**
     * Returns the ratio of video length buffered compared to buffering Goal
     */
    getBufferFullness ( ) : number ;
    /**
     * Get information about what the player has buffered. If the player has not
     * loaded content or is currently loading content, the buffered content will
     * be empty.
     */
    getBufferedInfo ( ) : shaka.extern.BufferedInfo ;
    /**
     * This returns the list of chapters.
     */
    getChapters (language : string ) : shaka.extern.Chapter [] ;
    /**
     * This returns the list of chapters.
     */
    getChaptersAsync (language : string ) : Promise < shaka.extern.Chapter [] > ;
    /**
     * Return a list of chapters tracks.
     */
    getChaptersTracks ( ) : shaka.extern.TextTrack [] ;
    /**
     * Return a copy of the current configuration.  Modifications of the returned
     * value will not affect the Player's active configuration.  You must call
     * <code>player.configure()</code> to make changes.
     */
    getConfiguration ( ) : shaka.extern.PlayerConfiguration ;
    /**
     * Return a copy of the current configuration for low latency.
     */
    getConfigurationForLowLatency ( ) : object ;
    /**
     * Get the next known expiration time for any EME session. If the session
     * never expires, this will return <code>Infinity</code>. If there are no EME
     * sessions, this will return <code>Infinity</code>. If the player has not
     * loaded content, this will return <code>Infinity</code>.
     */
    getExpiration ( ) : number ;
    /**
     * Gets information about the currently fetched video, audio, and text.
     * In the case of a multi-codec or multi-mimeType manifest, this can let you
     * determine the exact codecs and mimeTypes being fetched at the moment.
     */
    getFetchedPlaybackInfo ( ) : shaka.extern.PlaybackInfo ;
    /**
     * Return a list of image tracks that can be switched to.
     * If the player has not loaded content, this will return an empty list.
     */
    getImageTracks ( ) : shaka.extern.ImageTrack [] ;
    /**
     * Gets a map of EME key ID to the current key status.
     */
    getKeyStatuses ( ) : { [ key: string ]: string } ;
    /**
     * Get the current load mode.
     */
    getLoadMode ( ) : shaka.Player.LoadMode ;
    /**
     * Get the manifest that the player has loaded. If the player has not loaded
     * any content, this will return <code>null</code>.
     * NOTE: This structure is NOT covered by semantic versioning compatibility
     * guarantees.  It may change at any time!
     * This is marked as deprecated to warn Closure Compiler users at compile-time
     * to avoid using this method.
     */
    getManifest ( ) : shaka.extern.Manifest | null ;
    /**
     * Get the type of manifest parser that the player is using. If the player has
     * not loaded any content, this will return <code>null</code>.
     */
    getManifestParserFactory ( ) : ( shaka.extern.ManifestParser.Factory ) | null ;
    /**
     * Get the current manifest type.
     */
    getManifestType ( ) : string | null ;
    /**
     * Get the media element that the player is currently using to play loaded
     * content. If the player has not loaded content, this will return
     * <code>null</code>.
     */
    getMediaElement ( ) : HTMLMediaElement | null ;
    getNetworkingEngine ( ) : shaka.net.NetworkingEngine | null ;
    /**
     * Return a copy of the current non default configuration.  Modifications of
     * the returned value will not affect the Player's active configuration.
     * You must call <code>player.configure()</code> to make changes.
     */
    getNonDefaultConfiguration ( ) : object ;
    /**
     * Get the playback rate of what is playing right now. If we are using trick
     * play, this will return the trick play rate.
     * If no content is playing, this will return 0.
     * If content is buffering, this will return the expected playback rate once
     * the video starts playing.
     * <p>
     * If the player has not loaded content, this will return a playback rate of
     * 0.
     */
    getPlaybackRate ( ) : number ;
    /**
     * Get the current playhead position as a date.
     */
    getPlayheadTimeAsDate ( ) : Date | null ;
    /**
     * Get the presentation start time as a date.
     */
    getPresentationStartTimeAsDate ( ) : Date | null ;
    /**
     * Returns a shaka.queue.QueueManager instance, responsible for queue
     * management.
     */
    getQueueManager ( ) : shaka.extern.IQueueManager | null ;
    /**
     * Get the presentation segment availability duration. This should only be
     * called when the player has loaded a live stream. If the player has not
     * loaded a live stream, this will return <code>null</code>.
     */
    getSegmentAvailabilityDuration ( ) : number | null ;
    /**
     * Get statistics for the current playback session. If the player is not
     * playing content, this will return an empty stats object.
     */
    getStats ( ) : shaka.extern.Stats ;
    /**
     * Return a list of text languages available. If the player has not loaded
     * any content, this will return an empty list.
     * <br>
     * This API is deprecated and will be removed in version 5.0, please migrate
     * to using `getTextTracks` and `selectTextTrack`.
     */
    getTextLanguages ( ) : string [] ;
    /**
     * Return a list of text language-role combinations available.  If the player
     * has not loaded any content, this will be return an empty list.
     * <br>
     * This API is deprecated and will be removed in version 5.0, please migrate
     * to using `getTextTracks` and `selectTextTrack`.
     */
    getTextLanguagesAndRoles ( ) : shaka.extern.LanguageRole [] ;
    /**
     * Return a list of text tracks that can be switched to.
     * <p>
     * If the player has not loaded content, this will return an empty list.
     */
    getTextTracks ( ) : shaka.extern.TextTrack [] ;
    /**
     * Return a Thumbnail object from a time.
     * If the player has not loaded content, this will return a null.
     */
    getThumbnails (trackId : number | null , time : number ) : Promise < shaka.extern.Thumbnail | null > ;
    /**
     * Return a list of variant tracks that can be switched to.
     * <p>
     * If the player has not loaded content, this will return an empty list.
     */
    getVariantTracks ( ) : shaka.extern.TrackList ;
    /**
     * Return a list of video tracks compatible with the current audio track.
     */
    getVideoTracks ( ) : shaka.extern.VideoTrack [] ;
    /**
     * Go to live in a live stream.
     */
    goToLive ( ) : any ;
    /**
     * Check if the manifest contains only audio-only content. If the player has
     * not loaded content, this will return <code>false</code>.
     * <p>
     * The player does not support content that contain more than one type of
     * variants (i.e. mixing audio-only, video-only, audio-video). Content will be
     * filtered to only contain one type of variant.
     */
    isAudioOnly ( ) : boolean ;
    /**
     * Check if the player is currently in a buffering state (has too little
     * content to play smoothly). If the player has not loaded content, this will
     * return <code>false</code>.
     */
    isBuffering ( ) : boolean ;
    /**
     * Indicate if the video has ended.
     */
    isEnded ( ) : boolean ;
    /**
     * Indicates if the player has fully loaded the stream.
     */
    isFullyLoaded ( ) : boolean ;
    /**
     * Get if the player is playing in-progress content. If the player has not
     * loaded content, this will return <code>false</code>.
     */
    isInProgress ( ) : boolean ;
    /**
     * Get if the player is playing live content. If the player has not loaded
     * content, this will return <code>false</code>.
     */
    isLive ( ) : boolean ;
    /**
     * Indicate if we are using remote playback.
     */
    isRemotePlayback ( ) : boolean ;
    /**
     * Check if the text displayer is enabled.
     */
    isTextTrackVisible ( ) : boolean ;
    /**
     * Check if the manifest contains only video-only content. If the player has
     * not loaded content, this will return <code>false</code>.
     * <p>
     * The player does not support content that contain more than one type of
     * variants (i.e. mixing audio-only, video-only, audio-video). Content will be
     * filtered to only contain one type of variant.
     */
    isVideoOnly ( ) : boolean ;
    /**
     * Get the key system currently used by EME. If EME is not being used, this
     * will return an empty string. If the player has not loaded content, this
     * will return an empty string.
     */
    keySystem ( ) : string ;
    /**
     * Loads a new stream.
     * If another stream was already playing, first unloads that stream.
     * @param startTime When <code>startTime</code> is <code>null</code> or <code>undefined</code>, playback will start at the default start time (0 for VOD and liveEdge for LIVE).
     */
    load (assetUriOrPreloader : string | shaka.media.PreloadManager | null , startTime ? : number | null | Date , mimeType ? : string | null ) : Promise < any > ;
    /**
     * Starts to preload a given asset, and returns a PreloadManager object that
     * represents that preloading process.
     * The PreloadManager will load the manifest for that asset, as well as the
     * initialization segment. It will not preload anything more than that;
     * this feature is intended for reducing start-time latency, not for fully
     * downloading assets before playing them (for that, use
     * |shaka.offline.Storage|).
     * You can pass that PreloadManager object in to the |load| method on this
     * Player instance to finish loading that particular asset, or you can call
     * the |destroy| method on the manager if the preload is no longer necessary.
     * If this returns null rather than a PreloadManager, that indicates that the
     * asset must be played with src=, which cannot be preloaded.
     * @param startTime When <code>startTime</code> is <code>null</code> or <code>undefined</code>, playback will start at the default start time (0 for VOD and liveEdge for LIVE).
     */
    preload (assetUri : string , startTime ? : number | null | Date , mimeType ? : string | null , config ? : shaka.extern.PlayerConfiguration | null ) : Promise < shaka.media.PreloadManager | null > ;
    /**
     * Releases all of the mutexes of the player. Meant for use by the tests.
     */
    releaseAllMutexes ( ) : any ;
    /**
     * Reset configuration to default.
     */
    resetConfiguration ( ) : any ;
    /**
     * Retry streaming after a streaming failure has occurred. When the player has
     * not loaded content or is loading content, this will be a no-op and will
     * return <code>false</code>.
     * <p>
     * If the player has loaded content, and streaming has not seen an error, this
     * will return <code>false</code>.
     * <p>
     * If the player has loaded content, and streaming seen an error, but the
     * could not resume streaming, this will return <code>false</code>.
     */
    retryStreaming (retryDelaySeconds ? : number ) : boolean ;
    /**
     * Get the range of time (in seconds) that seeking is allowed. If the player
     * has not loaded content and the manifest is HLS, this will return a range
     * from 0 to 0.
     */
    seekRange ( ) : shaka.extern.BufferedRange ;
    /**
     * Sets the current audio language and current variant role to the selected
     * language, role and channel count, and chooses a new variant if need be.
     * If the player has not loaded any content, this will be a no-op.
     * <br>
     * This API is deprecated and will be removed in version 5.0, please migrate
     * to using `getAudioTracks` and `selectAudioTrack`.
     */
    selectAudioLanguage (language : string , role ? : string , channelsCount ? : number , safeMargin ? : number , codec ? : string , spatialAudio ? : boolean , label ? : string ) : any ;
    /**
     * Select an audio track compatible with the current video track.
     * If the player has not loaded any content, this will be a no-op.
     * @param safeMargin Optional amount of buffer (in seconds) to retain when clearing the buffer. Useful for switching quickly without causing a buffering event. Defaults to 0 if not provided. Can cause hiccups on some browsers if chosen too small, e.g. The amount of two segments is a fair minimum to consider as safeMargin value.
     */
    selectAudioTrack (audioTrack : shaka.extern.AudioTrack , safeMargin ? : number ) : any ;
    /**
     * Sets the current text language and current text role to the selected
     * language and role, and chooses a new variant if need be. If the player has
     * not loaded any content, this will be a no-op.
     * <br>
     * This API is deprecated and will be removed in version 5.0, please migrate
     * to using `getTextTracks` and `selectTextTrack`.
     */
    selectTextLanguage (language : string , role ? : string , forced ? : boolean ) : any ;
    /**
     * Select a specific text track. <code>track</code> should come from a call to
     * <code>getTextTracks</code>. If the track is not found, this will be a
     * no-op. If the player has not loaded content, this will be a no-op.
     * <p>
     * Note that <code>AdaptationEvents</code> are not fired for manual track
     * selections.
     */
    selectTextTrack (track : shaka.extern.TextTrack ) : any ;
    /**
     * Select a specific variant track to play.  <code>track</code> should come
     * from a call to <code>getVariantTracks</code>. If <code>track</code> cannot
     * be found, this will be a no-op. If the player has not loaded content, this
     * will be a no-op.
     * <p>
     * Changing variants will take effect once the currently buffered content has
     * been played. To force the change to happen sooner, use
     * <code>clearBuffer</code> with <code>safeMargin</code>. Setting
     * <code>clearBuffer</code> to <code>true</code> will clear all buffered
     * content after <code>safeMargin</code>, allowing the new variant to start
     * playing sooner.
     * <p>
     * Note that <code>AdaptationEvents</code> are not fired for manual track
     * selections.
     * @param safeMargin Optional amount of buffer (in seconds) to retain when clearing the buffer. Useful for switching variant quickly without causing a buffering event. Defaults to 0 if not provided. Ignored if clearBuffer is false. Can cause hiccups on some browsers if chosen too small, e.g. The amount of two segments is a fair minimum to consider as safeMargin value.
     */
    selectVariantTrack (track : shaka.extern.Track , clearBuffer ? : boolean , safeMargin ? : number ) : any ;
    /**
     * Select variant tracks that have a given label. This assumes the
     * label uniquely identifies an audio stream, so all the variants
     * are expected to have the same variant.audio.
     * This API is deprecated and will be removed in version 5.0, please migrate
     * to using `getAudioTracks` and `selectAudioTrack`.
     * @param clearBuffer Optional clear buffer or not when switch to new variant Defaults to true if not provided
     * @param safeMargin Optional amount of buffer (in seconds) to retain when clearing the buffer. Defaults to 0 if not provided. Ignored if clearBuffer is false.
     */
    selectVariantsByLabel (label : string , clearBuffer ? : boolean , safeMargin ? : number ) : any ;
    /**
     * Select a video track compatible with the current audio track.
     * If the player has not loaded any content, this will be a no-op.
     * @param safeMargin Optional amount of buffer (in seconds) to retain when clearing the buffer. Useful for switching quickly without causing a buffering event. Defaults to 0 if not provided. Can cause hiccups on some browsers if chosen too small, e.g. The amount of two segments is a fair minimum to consider as safeMargin value.
     */
    selectVideoTrack (videoTrack : shaka.extern.VideoTrack , clearBuffer ? : boolean , safeMargin ? : number ) : any ;
    /**
     * Set the maximum resolution that the platform's hardware can handle.
     */
    setMaxHardwareResolution (width : number , height : number ) : any ;
    /**
     * Enable or disable the text displayer.  If the player is in an unloaded
     * state, the request will be applied next time content is loaded.
     */
    setTextTrackVisibility (isVisible : boolean ) : any ;
    /**
     * Set the videoContainer to construct UITextDisplayer.
     */
    setVideoContainer (videoContainer : HTMLElement | null ) : any ;
    /**
     * Enable trick play to skip through content without playing by repeatedly
     * seeking. For example, a rate of 2.5 would result in 2.5 seconds of content
     * being skipped every second. A negative rate will result in moving
     * backwards.
     * <p>
     * If the player has not loaded content or is still loading content this will
     * be a no-op. Wait until <code>load</code> has completed before calling.
     * <p>
     * Trick play will be canceled automatically if the playhead hits the
     * beginning or end of the seekable range for the content.
     */
    trickPlay (rate : number , useTrickPlayTrack ? : boolean ) : any ;
    /**
     * Unloads the currently playing stream, if any.
     */
    unload (initializeMediaSource ? : boolean , keepAdManager ? : boolean ) : Promise < any > ;
    /**
     * Unloads the currently playing stream, if any, and returns a PreloadManager
     * that contains the loaded manifest of that asset, if any.
     * Allows for the asset to be re-loaded by this player faster, in the future.
     * When in src= mode, this unloads but does not make a PreloadManager.
     */
    unloadAndSavePreload (initializeMediaSource ? : boolean , keepAdManager ? : boolean , savePosition ? : boolean ) : Promise < shaka.media.PreloadManager | null > ;
    /**
     * Provides a way to update the stream start position during the media loading
     * process. Can for example be called from the <code>manifestparsed</code>
     * event handler to update the start position based on information in the
     * manifest.
     */
    updateStartTime (startTime : number | Date | null ) : any ;
    /**
     * Enable or disable trick play track if the currently loaded content
     * has it.
     */
    useTrickPlayTrackIfAvailable (on : boolean ) : any ;
    /**
     * Return whether the browser provides basic support.  If this returns false,
     * Shaka Player cannot be used at all.  In this case, do not construct a
     * Player instance and do not use the library.
     */
    static isBrowserSupported ( ) : boolean ;
    /**
     * Probes the browser to determine what features are supported.  This makes a
     * number of requests to EME/MSE/etc which may result in user prompts.  This
     * should only be used for diagnostics.
     * <p>
     * NOTE: This may show a request to the user for permission.
     */
    static probeSupport (promptsOkay ? : boolean ) : Promise < shaka.extern.SupportType > ;
    /**
     * Registers a plugin callback that will be called with
     * <code>support()</code>.  The callback will return the value that will be
     * stored in the return value from <code>support()</code>.
     */
    static registerSupportPlugin (name : string , callback : ( ) => any ) : any ;
    /**
     * Set a factory to create an ad manager during player construction time.
     * This method needs to be called before instantiating the Player class.
     */
    static setAdManagerFactory (factory : shaka.extern.IAdManager.Factory ) : any ;
    /**
     * Set a factory to create an queue manager during player construction time.
     * This method needs to be called before instantiating the Player class.
     */
    static setQueueManagerFactory (factory : shaka.extern.IQueueManager.Factory ) : any ;
    static version : string ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.Player {
  /**
   * In order to know what method of loading the player used for some content, we
   * have this enum. It lets us know if content has not been loaded, loaded with
   * media source, or loaded with src equals.
   * This enum has a low resolution, because it is only meant to express the
   * outer limits of the various states that the player is in. For example, when
   * someone calls a public method on player, it should not matter if they have
   * initialized drm engine, it should only matter if they finished loading
   * content.
   */
  /**
   * In order to know what method of loading the player used for some content, we
   * have this enum. It lets us know if content has not been loaded, loaded with
   * media source, or loaded with src equals.
   * This enum has a low resolution, because it is only meant to express the
   * outer limits of the various states that the player is in. For example, when
   * someone calls a public method on player, it should not matter if they have
   * initialized drm engine, it should only matter if they finished loading
   * content.
   */
  enum LoadMode {
    DESTROYED = 0.0 ,
    MEDIA_SOURCE = 2.0 ,
    NOT_LOADED = 1.0 ,
    SRC_EQUALS = 3.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.abr {
  class SimpleAbrManager implements shaka.extern.AbrManager , shaka.util.IReleasable {
    private noStructuralTyping_shaka_abr_SimpleAbrManager : any;
    chooseVariant (preferFastSwitching ? : boolean ) : shaka.extern.Variant ;
    configure (config : any ) : any ;
    disable ( ) : any ;
    enable ( ) : any ;
    getBandwidthEstimate ( ) : any ;
    init (switchCallback : any ) : any ;
    playbackRateChanged (rate : any ) : any ;
    release ( ) : any ;
    segmentDownloaded (deltaTimeMs : number , numBytes : number , allowSwitch : boolean , request ? : shaka.extern.Request , context ? : shaka.extern.RequestContext ) : any ;
    setCmsdManager (cmsdManager : any ) : any ;
    setMediaElement (mediaElement : any ) : any ;
    setVariants (variants : any ) : any ;
    stop ( ) : any ;
    trySuggestStreams ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.cea {
  /**
   * CEA-X08 captions decoder.
   */
  class CeaDecoder implements shaka.extern.ICaptionDecoder {
    private noStructuralTyping_shaka_cea_CeaDecoder : any;
    clear ( ) : any ;
    decode ( ) : shaka.extern.ICaptionDecoder.ClosedCaption [] ;
    extract (userDataSeiMessage : Uint8Array , pts : number ) : any ;
    getStreams ( ) : string [] ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.cea {
  /**
   * MPEG4 stream parser used for extracting 708 closed captions data.
   */
  class Mp4CeaParser implements shaka.extern.ICeaParser {
    private noStructuralTyping_shaka_cea_Mp4CeaParser : any;
    init (initSegment : ArrayBuffer | ArrayBufferView ) : any ;
    parse (mediaSegment : ArrayBuffer | ArrayBufferView ) : shaka.extern.ICeaParser.CaptionPacket [] ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.cea {
  /**
   * MPEG TS CEA parser.
   */
  class TsCeaParser implements shaka.extern.ICeaParser {
    private noStructuralTyping_shaka_cea_TsCeaParser : any;
    init (initSegment : ArrayBuffer | ArrayBufferView ) : any ;
    parse (mediaSegment : ArrayBuffer | ArrayBufferView ) : shaka.extern.ICeaParser.CaptionPacket [] ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.config {
  enum AutoShowText {
    ALWAYS = 1.0 ,
    IF_PREFERRED_TEXT_LANGUAGE = 2.0 ,
    IF_SUBTITLES_MAY_BE_NEEDED = 3.0 ,
    NEVER = 0.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.config {
  enum CodecSwitchingStrategy {
    RELOAD = 'reload' ,
    SMOOTH = 'smooth' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.config {
  enum CrossBoundaryStrategy {
    KEEP = 'keep' ,
    RESET = 'reset' ,
    RESET_ON_ENCRYPTION_CHANGE = 'RESET_ON_ENCRYPTION_CHANGE' ,
    RESET_TO_ENCRYPTED = 'reset_to_encrypted' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.config {
  enum RepeatMode {
    ALL = 1.0 ,
    OFF = 0.0 ,
    SINGLE = 2.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.dash {
  /**
   * Creates a new DASH parser.
   */
  class DashParser implements shaka.extern.ManifestParser {
    private noStructuralTyping_shaka_dash_DashParser : any;
    banLocation (uri : any ) : any ;
    configure (config : shaka.extern.ManifestConfiguration , isPreloadFn ? : ( ) => boolean ) : any ;
    onExpirationUpdated (sessionId : any , expiration : any ) : any ;
    onInitialVariantChosen (variant : any ) : any ;
    setMediaElement (mediaElement : any ) : any ;
    start (uri : any , playerInterface : any ) : any ;
    stop ( ) : any ;
    update ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka {
  class dependencies {
    private noStructuralTyping_shaka_dependencies : any;
    /**
     * Registers a new dependency.
     * @param key which is used for retrieving a dependency
     * @param dep a dependency
     */
    static add (key : shaka.dependencies.Allowed , dep : any ) : any ;
    /**
     * Check if we have a dependency for the key.
     * @param key key
     */
    static has (key : shaka.dependencies.Allowed ) : boolean ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.dependencies {
  enum Allowed {
    ISOBoxer = 'ISOBoxer' ,
    muxjs = 'muxjs' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.drm {
  class FairPlay {
    private noStructuralTyping_shaka_drm_FairPlay : any;
    /**
     * Common FairPlay response transform for some DRMs providers.
     */
    static commonFairPlayResponse (type : shaka.net.NetworkingEngine.RequestType , response : shaka.extern.Response , context ? : shaka.extern.RequestContext ) : any ;
    /**
     * Conax FairPlay request.
     */
    static conaxFairPlayRequest (type : shaka.net.NetworkingEngine.RequestType , request : shaka.extern.Request , context ? : shaka.extern.RequestContext ) : any ;
    /**
     * Conax initDataTransform configuration.
     */
    static conaxInitDataTransform (initData : Uint8Array , initDataType : string , drmInfo : shaka.extern.DrmInfo | null ) : Uint8Array ;
    /**
     * Using the default method, extract a content ID from the init data.  This is
     * based on the FairPlay example documentation.
     */
    static defaultGetContentId (initData : ArrayBuffer | ArrayBufferView ) : string ;
    /**
     * ExpressPlay FairPlay request.
     */
    static expressplayFairPlayRequest (type : shaka.net.NetworkingEngine.RequestType , request : shaka.extern.Request , context ? : shaka.extern.RequestContext ) : any ;
    /**
     * ExpressPlay initDataTransform configuration.
     */
    static expressplayInitDataTransform (initData : Uint8Array , initDataType : string , drmInfo : shaka.extern.DrmInfo | null ) : Uint8Array ;
    /**
     * EZDRM FairPlay request.
     */
    static ezdrmFairPlayRequest (type : shaka.net.NetworkingEngine.RequestType , request : shaka.extern.Request , context ? : shaka.extern.RequestContext ) : any ;
    /**
     * EZDRM initDataTransform configuration.
     */
    static ezdrmInitDataTransform (initData : Uint8Array , initDataType : string , drmInfo : shaka.extern.DrmInfo | null ) : Uint8Array ;
    /**
     * Transforms the init data buffer using the given data.  The format is:
     * <pre>
     * [4 bytes] initDataSize
     * [initDataSize bytes] initData
     * [4 bytes] contentIdSize
     * [contentIdSize bytes] contentId
     * [4 bytes] certSize
     * [certSize bytes] cert
     * </pre>
     * @param cert The server certificate; this will throw if not provided.
     */
    static initDataTransform (initData : ArrayBuffer | ArrayBufferView , contentId : ArrayBuffer | ArrayBufferView | string , cert : ArrayBuffer | ArrayBufferView | null ) : Uint8Array ;
    /**
     * Check if FairPlay is supported.
     */
    static isFairPlaySupported ( ) : Promise < boolean > ;
    /**
     * Mux FairPlay request.
     */
    static muxFairPlayRequest (type : shaka.net.NetworkingEngine.RequestType , request : shaka.extern.Request , context ? : shaka.extern.RequestContext ) : any ;
    /**
     * Mux initDataTransform configuration.
     */
    static muxInitDataTransform (initData : Uint8Array , initDataType : string , drmInfo : shaka.extern.DrmInfo | null ) : Uint8Array ;
    /**
     * Verimatrix FairPlay request.
     */
    static verimatrixFairPlayRequest (type : shaka.net.NetworkingEngine.RequestType , request : shaka.extern.Request , context ? : shaka.extern.RequestContext ) : any ;
    /**
     * Verimatrix initDataTransform configuration.
     */
    static verimatrixInitDataTransform (initData : Uint8Array , initDataType : string , drmInfo : shaka.extern.DrmInfo | null ) : Uint8Array ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.lcevc {
  class Dec implements shaka.util.IReleasable {
    private noStructuralTyping_shaka_lcevc_Dec : any;
    constructor (media : HTMLVideoElement | null , canvas : HTMLCanvasElement | null , lcevcConfig : shaka.extern.LcevcConfiguration , isDualTrack : boolean ) ;
    /**
     * Close LCEVC Decoder.
     */
    release ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media {
  /**
   * A set of variants that we want to adapt between.
   */
  class AdaptationSet {
    private noStructuralTyping_shaka_media_AdaptationSet : any;
    constructor (root : shaka.extern.Variant , candidates ? : Iterable < shaka.extern.Variant > , compareCodecs ? : boolean ) ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media {
  /**
   * Closed Caption Parser provides all operations for parsing the closed captions
   * embedded in Dash videos streams.
   */
  class ClosedCaptionParser implements shaka.media.IClosedCaptionParser {
    private noStructuralTyping_shaka_media_ClosedCaptionParser : any;
    /**
     * Closed Caption Parser provides all operations for parsing the closed captions
     * embedded in Dash videos streams.
     */
    constructor (mimeType : string ) ;
    static findDecoder ( ) : ( shaka.extern.CaptionDecoderPlugin ) | null ;
    static findParser (mimeType : string ) : ( shaka.extern.CeaParserPlugin ) | null ;
    static registerDecoder (plugin : shaka.extern.CaptionDecoderPlugin ) : any ;
    static registerParser (mimeType : string , plugin : shaka.extern.CeaParserPlugin ) : any ;
    static unregisterDecoder ( ) : any ;
    static unregisterParser (mimeType : string ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media {
  /**
   * The IClosedCaptionParser defines the interface to provide all operations for
   * parsing the closed captions embedded in Dash videos streams.
   * TODO: Remove this interface and move method definitions
   * directly to ClosedCaptionParser.
   */
  interface IClosedCaptionParser {
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media {
  /**
   * Creates an InitSegmentReference, which provides the location to an
   * initialization segment.
   */
  class InitSegmentReference {
    private noStructuralTyping_shaka_media_InitSegmentReference : any;
    constructor (uris : ( ) => string [] , startByte : number , endByte : number | null , mediaQuality ? : null | shaka.extern.MediaQualityInfo , timescale ? : null | number , segmentData ? : null | ArrayBuffer | ArrayBufferView , aesKey ? : shaka.extern.aesKey | null , encrypted ? : boolean ) ;
    /**
     * Returns the offset from the start of the resource to the end of the
     * segment, inclusive.  A value of null indicates that the segment extends
     * to the end of the resource.
     */
    getEndByte ( ) : number | null ;
    /**
     * Returns the offset from the start of the resource to the
     * start of the segment.
     */
    getStartByte ( ) : number ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media {
  class ManifestParser {
    private noStructuralTyping_shaka_media_ManifestParser : any;
    /**
     * Registers a manifest parser by file extension.
     * @param extension The file extension of the manifest.
     * @param parserFactory The factory used to create parser instances.
     */
    static registerParserByExtension (extension : string , parserFactory : shaka.extern.ManifestParser.Factory ) : any ;
    /**
     * Registers a manifest parser by MIME type.
     * @param mimeType The MIME type of the manifest.
     * @param parserFactory The factory used to create parser instances.
     */
    static registerParserByMime (mimeType : string , parserFactory : shaka.extern.ManifestParser.Factory ) : any ;
    /**
     * Unregisters a manifest parser by MIME type.
     * @param mimeType The MIME type of the manifest.
     */
    static unregisterParserByMime (mimeType : string ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media.ManifestParser {
  enum AccessibilityPurpose {
    HARD_OF_HEARING = 'hard of hearing' ,
    SPOKEN_SUBTITLES = 'spoken subtitles' ,
    VISUALLY_IMPAIRED = 'visually impaired' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media {
  /**
   * A meta-SegmentIndex composed of multiple other SegmentIndexes.
   * Used in constructing multi-Period Streams for DASH.
   */
  class MetaSegmentIndex extends shaka.media.SegmentIndex implements Iterable < shaka.media.SegmentReference | null > {
    private noStructuralTyping_shaka_media_MetaSegmentIndex : any;
    /**
     * A meta-SegmentIndex composed of multiple other SegmentIndexes.
     * Used in constructing multi-Period Streams for DASH.
     */
    constructor ( ) ;
    //!! Symbol.iterator inserted by Clutz for Iterable subtype
    [Symbol.iterator]():  Iterator < shaka.media.SegmentReference | null > ;
    evict (time : number ) : any ;
    find (time : any ) : any ;
    fit (windowStart : number , windowEnd : number | null , c ? : boolean ) : any ;
    forEachTopLevelReference (fn : any ) : any ;
    get (position : any ) : any ;
    merge (references : any ) : any ;
    mergeAndEvict (references : shaka.media.SegmentReference [] , windowStart : number ) : any ;
    offset (offset : number ) : any ;
    release ( ) : any ;
    updateEvery (interval : number , updateCallback : ( ) => ( shaka.media.SegmentReference | null ) [] | null ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media {
  class PreloadManager extends shaka.util.FakeEventTarget implements shaka.util.IDestroyable {
    private noStructuralTyping_shaka_media_PreloadManager : any;
    constructor (assetUri : string , mimeType : string | null , startTime : number | null | Date , playerInterface : any ) ;
    /**
     * Releases or stops all non-entrusted resources.
     */
    destroy ( ) : Promise < any > ;
    /**
     * Gets the preloaded text track if it exists.
     */
    getPrefetchedTextTrack ( ) : shaka.extern.TextTrack | null ;
    /**
     * Gets the preloaded variant track if it exists.
     */
    getPrefetchedVariantTrack ( ) : shaka.extern.Track | null ;
    /**
     * Waits for the loading to be finished (or to fail with an error).
     */
    waitForFinish ( ) : Promise < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media {
  /**
   * PresentationTimeline.
   */
  class PresentationTimeline {
    private noStructuralTyping_shaka_media_PresentationTimeline : any;
    constructor (presentationStartTime : number | null , presentationDelay : number , autoCorrectDrift ? : boolean ) ;
    /**
     * Gets the presentation's segment availability time offset. This should be
     * only configured for Low Latency Dash.
     */
    getAvailabilityTimeOffset ( ) : number ;
    /**
     * Gets the presentation delay in seconds.
     */
    getDelay ( ) : number ;
    getDuration ( ) : number ;
    getInitialProgramDateTime ( ) : number | null ;
    getMaxSegmentDuration ( ) : number ;
    /**
     * Gets the end time of the last available segment.
     */
    getMaxSegmentEndTime ( ) : number | null ;
    getPresentationStartTime ( ) : number | null ;
    /**
     * Gets the seek range start time, offset by the given amount.  This is used
     * to ensure that we don't "fall" back out of the seek window while we are
     * buffering.
     * @param offset The offset to add to the start time for live streams.
     */
    getSafeSeekRangeStart (offset : number ) : number ;
    /**
     * Gets the seek range end.
     */
    getSeekRangeEnd ( ) : number ;
    /**
     * Gets the seek range start time.
     */
    getSeekRangeStart ( ) : number ;
    /**
     * Gets the presentation's segment availability duration.
     */
    getSegmentAvailabilityDuration ( ) : number ;
    /**
     * Gets the presentation's current segment availability end time.  Segments
     * starting after this time should be assumed to be unavailable.
     */
    getSegmentAvailabilityEnd ( ) : number ;
    /**
     * Gets the presentation's current segment availability start time.  Segments
     * ending at or before this time should be assumed to be unavailable.
     */
    getSegmentAvailabilityStart ( ) : number ;
    isInProgress ( ) : boolean ;
    isLive ( ) : boolean ;
    /**
     * Returns if the presentation timeline's start time is locked.
     */
    isStartTimeLocked ( ) : boolean ;
    /**
     * Lock the presentation timeline's start time.  After this is called, no
     * further adjustments to presentationStartTime_ will be permitted.
     * This should be called after all Periods have been parsed, and all calls to
     * notifySegments() from the initial manifest parse have been made.
     * Without this, we can get assertion failures in SegmentIndex for certain
     * DAI content.  If DAI adds ad segments to the manifest faster than
     * real-time, adjustments to presentationStartTime_ can cause availability
     * windows to jump around on updates.
     */
    lockStartTime ( ) : any ;
    /**
     * Gives PresentationTimeline a Stream's maximum segment duration so it can
     * size and position the segment availability window.  This function should be
     * called once for each Stream (no more, no less), but does not have to be
     * called if notifySegments() is called instead for a particular stream.
     * @param maxSegmentDuration The maximum segment duration for a particular stream.
     */
    notifyMaxSegmentDuration (maxSegmentDuration : number ) : any ;
    /**
     * Gives PresentationTimeline a Stream's minimum segment start time.
     */
    notifyMinSegmentStartTime (startTime : number ) : any ;
    /**
     * Gives PresentationTimeline an startTime and endTime of the period.
     * This should be only set for Dash.
     */
    notifyPeriodDuration (startTime : number , endTime : number ) : any ;
    /**
     * Gives PresentationTimeline an array of segments so it can size and position
     * the segment availability window, and account for missing segment
     * information.  These segments do not necessarily need to all be from the
     * same stream.
     */
    notifySegments (references : shaka.media.SegmentReference [] ) : any ;
    /**
     * Gives PresentationTimeline a Stream's timeline so it can size and position
     * the segment availability window, and account for missing segment
     * information.
     */
    notifyTimeRange (timeline : shaka.media.PresentationTimeline.TimeRange [] , startOffset : number ) : any ;
    /**
     * Offsets the segment times by the given amount.
     * @param offset The number of seconds to offset by.  A positive number adjusts the segment times forward.
     */
    offset (offset : number ) : any ;
    /**
     * Sets the presentation's segment availability time offset. This should be
     * only set for Low Latency Dash.
     * The segments are available earlier for download than the availability start
     * time, so we can move closer to the live edge.
     */
    setAvailabilityTimeOffset (offset : number ) : any ;
    /**
     * Sets the clock offset, which is the difference between the client's clock
     * and the server's clock, in milliseconds (i.e., serverTime = Date.now() +
     * clockOffset).
     * @param offset The clock offset, in ms.
     */
    setClockOffset (offset : number ) : any ;
    /**
     * Sets the presentation delay in seconds.
     */
    setDelay (delay : number ) : any ;
    /**
     * Sets the presentation's duration.
     * @param duration The presentation's duration in seconds. Infinity indicates that the presentation continues indefinitely.
     */
    setDuration (duration : number ) : any ;
    /**
     * Sets the initial program date time.
     */
    setInitialProgramDateTime (initialProgramDateTime : number ) : any ;
    /**
     * Sets the presentation's start time.
     * @param presentationStartTime The wall-clock time, in seconds, when the presentation started or will start. Only required for live.
     */
    setPresentationStartTime (presentationStartTime : number ) : any ;
    /**
     * Sets the presentation's segment availability duration. The segment
     * availability duration should only be set for live.
     * @param segmentAvailabilityDuration The presentation's new segment availability duration in seconds.
     */
    setSegmentAvailabilityDuration (segmentAvailabilityDuration : number ) : any ;
    /**
     * Sets the presentation's static flag.
     * @param isStatic If true, the presentation is static, meaning all segments are available at once.
     */
    setStatic (isStatic : boolean ) : any ;
    /**
     * Sets the start time of the user-defined seek range.  This is only used for
     * VOD content.
     */
    setUserSeekStart (time : number ) : any ;
    /**
     * True if the presentation start time is being used to calculate the live
     * edge.
     * Using the presentation start time means that the stream may be subject to
     * encoder drift.  At runtime, we will avoid using the presentation start time
     * whenever possible.
     */
    usingPresentationStartTime ( ) : boolean ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media.PresentationTimeline {
  type TimeRange = { end : number , partialSegments : number , segmentPosition : number , start : number , unscaledStart : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media {
  /**
   * SegmentIndex.
   */
  class SegmentIndex implements shaka.extern.SegmentIndex , shaka.util.IReleasable , Iterable < shaka.media.SegmentReference | null > {
    private noStructuralTyping_shaka_media_SegmentIndex : any;
    /**
     * SegmentIndex.
     */
    constructor (references : shaka.media.SegmentReference [] ) ;
    //!! Symbol.iterator inserted by Clutz for Iterable subtype
    [Symbol.iterator]():  Iterator < shaka.media.SegmentReference | null > ;
    /**
     * Removes all SegmentReferences that end before the given time.
     * @param time The time in seconds.
     */
    evict (time : number ) : any ;
    find (time : any ) : any ;
    /**
     * Drops references that start after windowEnd, or end before windowStart,
     * and contracts the last reference so that it ends at windowEnd.
     * Do not call on the last period of a live presentation (unknown duration).
     * It is okay to call on the other periods of a live presentation, where the
     * duration is known and another period has been added.
     * @param isNew Whether this is a new SegmentIndex and we shouldn't update the number of evicted elements.
     */
    fit (windowStart : number , windowEnd : number | null , isNew ? : boolean ) : any ;
    get (position : any ) : any ;
    /**
     * Returns a new iterator that initially points to the segment that contains
     * the given time, or the nearest independent segment before it.
     * Like the normal iterator, next() must be called first to get to the first
     * element. Returns null if we do not find a segment at the
     * requested time.
     * The first segment returned by the iterator _MUST_ be an independent
     * segment.  Assumes that only partial references can be dependent, based on
     * RFC 8216 rev 13, section 8.1: "Each (non-Partial) Media Segment in a Media
     * Playlist will contain at least one independent frame."
     */
    getIteratorForTime (time : number , allowNonIndependent ? : boolean , reverse ? : boolean ) : shaka.media.SegmentIterator | null ;
    getNumEvicted ( ) : any ;
    getNumReferences ( ) : any ;
    /**
     * Marks the index as immutable.  Segments cannot be added or removed after
     * this point.  This doesn't affect the references themselves.  This also
     * makes the destroy/release methods do nothing.
     * This is mainly for testing.
     */
    markImmutable ( ) : any ;
    /**
     * Merges the given SegmentReferences and evicts the ones that end before the
     * given time.  Supports extending the original references only.
     * Will not replace old references or interleave new ones.
     * Used, for example, by the DASH and HLS parser, where manifests may not list
     * all available references, so we must keep available references in memory to
     * fill the availability window.
     * @param references The list of SegmentReferences, which must be sorted first by their start times (ascending) and second by their end times (ascending).
     * @param windowStart The start of the availability window to filter out the references that are no longer available.
     */
    mergeAndEvict (references : shaka.media.SegmentReference [] , windowStart : number ) : any ;
    /**
     * Offset all segment references by a fixed amount.
     * @param offset The amount to add to each segment's start and end times.
     */
    offset (offset : number ) : any ;
    release ( ) : any ;
    /**
     * Updates the references every so often.  Stops when the references list
     * returned by the callback is null.
     * @param interval The interval in seconds.
     */
    updateEvery (interval : number , updateCallback : ( ) => ( shaka.media.SegmentReference | null ) [] | null ) : any ;
    /**
     * Create a SegmentIndex for a single segment of the given start time and
     * duration at the given URIs.
     */
    static forSingleSegment (startTime : number , duration : number , uris : string [] ) : shaka.media.SegmentIndex ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media {
  /**
   * An iterator over a SegmentIndex's references.
   */
  class SegmentIterator implements Iterator < shaka.media.SegmentReference | null > {
    private noStructuralTyping_shaka_media_SegmentIterator : any;
    /**
     * An iterator over a SegmentIndex's references.
     */
    constructor (segmentIndex : shaka.media.SegmentIndex , index : number , partialSegmentIndex : number , reverse : boolean ) ;
    current ( ) : shaka.media.SegmentReference | null ;
    currentPosition ( ) : number ;
    next ( ) : IteratorResult < shaka.media.SegmentReference | null > ;
    resetToLastIndependent ( ) : any ;
    setReverse (reverse : boolean ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media.SegmentPrefetch {
  type FetchDispatcher = (a : shaka.media.InitSegmentReference | shaka.media.SegmentReference , b : shaka.extern.Stream , c ? : ( (a : ArrayBuffer | ArrayBufferView ) => Promise < any > ) | null ) => shaka.net.NetworkingEngine.PendingRequest ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media {
  /**
   * SegmentReference provides the start time, end time, and location to a media
   * segment.
   */
  class SegmentReference {
    private noStructuralTyping_shaka_media_SegmentReference : any;
    constructor (startTime : number , endTime : number , uris : ( ) => string [] , startByte : number , endByte : number | null , initSegmentReference : shaka.media.InitSegmentReference | null , timestampOffset : number , appendWindowStart : number , appendWindowEnd : number , partialReferences ? : shaka.media.SegmentReference [] , tilesLayout ? : string | null , tileDuration ? : number | null , syncTime ? : number | null , status ? : shaka.media.SegmentReference.Status , aesKey ? : shaka.extern.aesKey | null , allPartialSegments ? : boolean ) ;
    /**
     * Returns the offset from the start of the resource to the end of the
     * segment, inclusive.  A value of null indicates that the segment extends to
     * the end of the resource.
     */
    getEndByte ( ) : number | null ;
    /**
     * Returns the segment's end time in seconds.
     */
    getEndTime ( ) : number ;
    /**
     * Return the segment data.
     */
    getSegmentData (allowDeleteOnSingleUse ? : boolean ) : ArrayBuffer | ArrayBufferView | null ;
    /**
     * Returns the offset from the start of the resource to the
     * start of the segment.
     */
    getStartByte ( ) : number ;
    /**
     * Returns the segment's start time in seconds.
     */
    getStartTime ( ) : number ;
    /**
     * Returns the segment's status.
     */
    getStatus ( ) : shaka.media.SegmentReference.Status ;
    /**
     * Returns the segment's thumbnail sprite.
     */
    getThumbnailSprite ( ) : shaka.media.SegmentReference.ThumbnailSprite | null ;
    /**
     * Returns the segment's explicit tile duration.
     * Only defined in image segments.
     */
    getTileDuration ( ) : number | null ;
    /**
     * Returns the segment's tiles layout. Only defined in image segments.
     */
    getTilesLayout ( ) : string | null ;
    /**
     * Creates and returns the URIs of the resource containing the segment.
     */
    getUris ( ) : string [] ;
    /**
     * Returns true if the segment has a byterange optimization.
     */
    hasByterangeOptimization ( ) : boolean ;
    /**
     * Returns true if the segment is independent.
     */
    isIndependent ( ) : boolean ;
    /**
     * Returns true if reference as being the last part of the full segment.
     */
    isLastPartial ( ) : boolean ;
    /**
     * Returns true if the segment is partial.
     */
    isPartial ( ) : boolean ;
    /**
     * Returns true if the segment is preloaded.
     */
    isPreload ( ) : boolean ;
    /**
     * Mark the reference as byterange optimization.
     * The "byterange optimization" means that it is playable using MP4 low
     * latency streaming with chunked data.
     */
    markAsByterangeOptimization ( ) : any ;
    /**
     * Mark the reference as being the last part of the full segment
     */
    markAsLastPartial ( ) : any ;
    /**
     * Mark the reference as non-independent.
     */
    markAsNonIndependent ( ) : any ;
    /**
     * Mark the reference as partial.
     */
    markAsPartial ( ) : any ;
    /**
     * Mark the reference as preload.
     */
    markAsPreload ( ) : any ;
    /**
     * Mark the reference as unavailable.
     */
    markAsUnavailable ( ) : any ;
    /**
     * Offset the segment reference by a fixed amount.
     * @param offset The amount to add to the segment's start and end times.
     */
    offset (offset : number ) : any ;
    /**
     * Set the segment data.
     */
    setSegmentData (segmentData : ArrayBuffer | ArrayBufferView , singleUse ? : boolean ) : any ;
    /**
     * Set the segment's thumbnail sprite.
     */
    setThumbnailSprite (thumbnailSprite : shaka.media.SegmentReference.ThumbnailSprite ) : any ;
    /**
     * Sync this segment against a particular sync time that will serve as "0" in
     * the presentation timeline.
     */
    syncAgainst (lowestSyncTime : number ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media.SegmentReference {
  /**
   * Rather than using booleans to communicate what the state of the reference,
   * we have this enum.
   */
  /**
   * Rather than using booleans to communicate what the state of the reference,
   * we have this enum.
   */
  enum Status {
    AVAILABLE = 0.0 ,
    MISSING = 2.0 ,
    UNAVAILABLE = 1.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.media.SegmentReference {
  type ThumbnailSprite = { height : number , positionX : number , positionY : number , width : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net {
  class HttpFetchPlugin {
    private noStructuralTyping_shaka_net_HttpFetchPlugin : any;
    /**
     * Determine if the Fetch API is supported in the browser. Note: this is
     * deliberately exposed as a method to allow the client app to use the same
     * logic as Shaka when determining support.
     */
    static isSupported ( ) : boolean ;
    static parse (uri : string , request : shaka.extern.Request , requestType : shaka.net.NetworkingEngine.RequestType , progressUpdated : shaka.extern.ProgressUpdated , headersReceived : shaka.extern.HeadersReceived , config : shaka.extern.SchemePluginConfig ) : shaka.extern.IAbortableOperation < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net {
  class HttpXHRPlugin {
    private noStructuralTyping_shaka_net_HttpXHRPlugin : any;
    static parse (uri : string , request : shaka.extern.Request , requestType : shaka.net.NetworkingEngine.RequestType , progressUpdated : shaka.extern.ProgressUpdated , headersReceived : shaka.extern.HeadersReceived , config : shaka.extern.SchemePluginConfig ) : shaka.extern.IAbortableOperation < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net {
  /**
   * NetworkingEngine wraps all networking operations.  This accepts plugins that
   * handle the actual request.  A plugin is registered using registerScheme.
   * Each scheme has at most one plugin to handle the request.
   */
  class NetworkingEngine extends shaka.util.FakeEventTarget implements shaka.util.IDestroyable {
    private noStructuralTyping_shaka_net_NetworkingEngine : any;
    /**
     * NetworkingEngine wraps all networking operations.  This accepts plugins that
     * handle the actual request.  A plugin is registered using registerScheme.
     * Each scheme has at most one plugin to handle the request.
     */
    constructor (onProgressUpdated ? : shaka.net.NetworkingEngine.onProgressUpdated , onHeadersReceived ? : shaka.net.NetworkingEngine.OnHeadersReceived , onDownloadCompleted ? : shaka.net.NetworkingEngine.OnDownloadCompleted , onDownloadFailed ? : shaka.net.NetworkingEngine.OnDownloadFailed , onRequest ? : shaka.net.NetworkingEngine.OnRequest , onRetry ? : shaka.net.NetworkingEngine.OnRetry , onResponse ? : shaka.net.NetworkingEngine.OnResponse ) ;
    /**
     * Clears all request filters.
     */
    clearAllRequestFilters ( ) : any ;
    /**
     * Clears all response filters.
     */
    clearAllResponseFilters ( ) : any ;
    /**
     * Clears Common Access Token map.
     */
    clearCommonAccessTokenMap ( ) : any ;
    configure (config : shaka.extern.NetworkingConfiguration ) : any ;
    destroy ( ) : Promise < any > ;
    /**
     * Registers a new request filter.  All filters are applied in the order they
     * are registered.
     */
    registerRequestFilter (filter : shaka.extern.RequestFilter ) : any ;
    /**
     * Registers a new response filter.  All filters are applied in the order they
     * are registered.
     */
    registerResponseFilter (filter : shaka.extern.ResponseFilter ) : any ;
    /**
     * Makes a network request and returns the resulting data.
     */
    request (type : shaka.net.NetworkingEngine.RequestType , request : shaka.extern.Request , context ? : shaka.extern.RequestContext ) : shaka.net.NetworkingEngine.PendingRequest ;
    /**
     * Removes a request filter.
     */
    unregisterRequestFilter (filter : shaka.extern.RequestFilter ) : any ;
    /**
     * Removes a response filter.
     */
    unregisterResponseFilter (filter : shaka.extern.ResponseFilter ) : any ;
    /**
     * Gets a copy of the default retry parameters.
     */
    static defaultRetryParameters ( ) : shaka.extern.RetryParameters ;
    /**
     * Makes a simple network request for the given URIs.
     */
    static makeRequest (uris : string [] , retryParams : shaka.extern.RetryParameters , streamDataCallback ? : ( (a : ArrayBuffer | ArrayBufferView ) => Promise < any > ) | null ) : shaka.extern.Request ;
    /**
     * Registers a scheme plugin.  This plugin will handle all requests with the
     * given scheme.  If a plugin with the same scheme already exists, it is
     * replaced, unless the existing plugin is of higher priority.
     * If no priority is provided, this defaults to the highest priority of
     * APPLICATION.
     */
    static registerScheme (scheme : string , plugin : shaka.extern.SchemePlugin , priority ? : number , progressSupport ? : boolean ) : any ;
    /**
     * Removes a scheme plugin.
     */
    static unregisterScheme (scheme : string ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net.NetworkingEngine {
  /**
   * A more advanced form of the RequestType structure, meant to describe
   * sub-types of basic request types.
   * For example, an INIT_SEGMENT is a sub-type of SEGMENT.
   * This is meant to allow for more specificity to be added to the request type
   * data, without breaking backwards compatibility.
   */
  /**
   * A more advanced form of the RequestType structure, meant to describe
   * sub-types of basic request types.
   * For example, an INIT_SEGMENT is a sub-type of SEGMENT.
   * This is meant to allow for more specificity to be added to the request type
   * data, without breaking backwards compatibility.
   */
  enum AdvancedRequestType {
    INIT_SEGMENT = 0.0 ,
    INTERSTITIAL_AD_URL = 12.0 ,
    INTERSTITIAL_ASSET_LIST = 11.0 ,
    MASTER_PLAYLIST = 3.0 ,
    MEDIATAILOR_SESSION_INFO = 7.0 ,
    MEDIATAILOR_STATIC_RESOURCE = 9.0 ,
    MEDIATAILOR_TRACKING_EVENT = 10.0 ,
    MEDIATAILOR_TRACKING_INFO = 8.0 ,
    MEDIA_PLAYLIST = 2.0 ,
    MEDIA_SEGMENT = 1.0 ,
    MPD = 4.0 ,
    MPD_PATCH = 6.0 ,
    MSS = 5.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net.NetworkingEngine {
  /**
   * A wrapper class for the number of bytes remaining to be downloaded for the
   * request.
   * Instead of using PendingRequest directly, this class is needed to be sent to
   * plugin as a parameter, and a Promise is returned, before PendingRequest is
   * created.
   */
  class NumBytesRemainingClass {
    private noStructuralTyping_shaka_net_NetworkingEngine_NumBytesRemainingClass : any;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net.NetworkingEngine {
  type OnDownloadCompleted = (a : shaka.extern.Request , b : shaka.extern.Response ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net.NetworkingEngine {
  type OnDownloadFailed = (a : shaka.extern.Request , b : shaka.util.Error | null , c : number , d : boolean ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net.NetworkingEngine {
  type OnHeadersReceived = (a : { [ key: string ]: string } , b : shaka.extern.Request , c : shaka.net.NetworkingEngine.RequestType ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net.NetworkingEngine {
  type OnRequest = (a : shaka.net.NetworkingEngine.RequestType , b : shaka.extern.Request , c : shaka.extern.RequestContext | undefined ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net.NetworkingEngine {
  type OnResponse = (a : shaka.net.NetworkingEngine.RequestType , b : shaka.extern.Response , c : shaka.extern.RequestContext | undefined ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net.NetworkingEngine {
  type OnRetry = (a : shaka.net.NetworkingEngine.RequestType , b : shaka.extern.RequestContext | undefined , c : string , d : string ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net.NetworkingEngine {
  /**
   * A pending network request. This can track the current progress of the
   * download, and allows the request to be aborted if the network is slow.
   */
  class PendingRequest extends shaka.util.AbortableOperation < any > implements shaka.extern.IAbortableOperation < any > {
    private noStructuralTyping_shaka_net_NetworkingEngine_PendingRequest : any;
    /**
     * A pending network request. This can track the current progress of the
     * download, and allows the request to be aborted if the network is slow.
     */
    constructor (promise : Promise < any > , onAbort : shaka.extern.CreateSegmentIndexFunction , numBytesRemainingObj : shaka.net.NetworkingEngine.NumBytesRemainingClass | null ) ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net.NetworkingEngine {
  /**
   * Priority level for network scheme plugins.
   * If multiple plugins are provided for the same scheme, only the
   * highest-priority one is used.
   */
  /**
   * Priority level for network scheme plugins.
   * If multiple plugins are provided for the same scheme, only the
   * highest-priority one is used.
   */
  enum PluginPriority {
    APPLICATION = 3.0 ,
    FALLBACK = 1.0 ,
    PREFERRED = 2.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net.NetworkingEngine {
  /**
   * Request types.  Allows a filter to decide which requests to read/alter.
   */
  /**
   * Request types.  Allows a filter to decide which requests to read/alter.
   */
  enum RequestType {
    ADS = 7.0 ,
    APP = 3.0 ,
    CMCD = 9.0 ,
    CONTENT_STEERING = 8.0 ,
    KEY = 6.0 ,
    LICENSE = 2.0 ,
    MANIFEST = 0.0 ,
    SEGMENT = 1.0 ,
    SERVER_CERTIFICATE = 5.0 ,
    TIMING = 4.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.net.NetworkingEngine {
  type onProgressUpdated = (a : number , b : number , c : boolean , d ? : shaka.extern.Request , e ? : shaka.extern.RequestContext ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka {
  class polyfill {
    private noStructuralTyping_shaka_polyfill : any;
    /**
     * Install all polyfills.
     */
    static installAll ( ) : any ;
    /**
     * Registers a new polyfill to be installed.
     * @param priority An optional number priority.  Higher priorities will be executed before lower priority ones.  Default is 0.
     */
    static register (polyfill : ( ) => any , priority ? : number ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.polyfill {
  /**
   * A polyfill to add support for EncryptionScheme queries in EME.
   * Because this polyfill can't know what schemes the UA or CDM actually support,
   * it assumes support for the historically-supported schemes of each well-known
   * key system.
   */
  class EmeEncryptionScheme {
    private noStructuralTyping_shaka_polyfill_EmeEncryptionScheme : any;
    /**
     * Installs the polyfill.  To avoid the possibility of extra user prompts,
     * this will shim EME so long as it exists, without checking support for
     * encryptionScheme upfront.  The support check will happen on-demand the
     * first time EME is used.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.polyfill {
  /**
   * A polyfill to add support for EncryptionScheme queries in MediaCapabilities.
   * Because this polyfill can't know what schemes the UA or CDM actually support,
   * it assumes support for the historically-supported schemes of each well-known
   * key system.
   */
  class MCapEncryptionScheme {
    private noStructuralTyping_shaka_polyfill_MCapEncryptionScheme : any;
    /**
     * Installs the polyfill.  To avoid the possibility of extra user prompts,
     * this will shim MC so long as it exists, without checking support for
     * encryptionScheme upfront.  The support check will happen on-demand the
     * first time MC is used.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.polyfill {
  class MediaCapabilities {
    private noStructuralTyping_shaka_polyfill_MediaCapabilities : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
    /**
     * A copy of the MediaCapabilities instance, to prevent Safari from
     * garbage-collecting the polyfilled method on it. We make it public and export
     * it to ensure that it is not stripped out by the compiler.
     */
    static originalMcap : any | null ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.polyfill {
  class MediaSource {
    private noStructuralTyping_shaka_polyfill_MediaSource : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.polyfill {
  class PatchedMediaKeysApple {
    private noStructuralTyping_shaka_polyfill_PatchedMediaKeysApple : any;
    /**
     * Installs the polyfill if needed.
     * @param enableUninstall enables uninstalling the polyfill
     */
    static install (enableUninstall ? : boolean ) : any ;
    /**
     * Uninstalls the polyfill if needed and enabled.
     */
    static uninstall ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.polyfill {
  class PatchedMediaKeysCert {
    private noStructuralTyping_shaka_polyfill_PatchedMediaKeysCert : any;
    /**
     * Installs the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.polyfill {
  class PatchedMediaKeysWebkit {
    private noStructuralTyping_shaka_polyfill_PatchedMediaKeysWebkit : any;
    /**
     * Installs the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.polyfill {
  class RandomUUID {
    private noStructuralTyping_shaka_polyfill_RandomUUID : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.polyfill {
  class Symbol {
    private noStructuralTyping_shaka_polyfill_Symbol : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.polyfill {
  class TypedArray {
    private noStructuralTyping_shaka_polyfill_TypedArray : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.polyfill {
  class VTTCue {
    private noStructuralTyping_shaka_polyfill_VTTCue : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.polyfill {
  class VideoPlayPromise {
    private noStructuralTyping_shaka_polyfill_VideoPlayPromise : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.polyfill {
  class VideoPlaybackQuality {
    private noStructuralTyping_shaka_polyfill_VideoPlaybackQuality : any;
    /**
     * Install the polyfill if needed.
     */
    static install ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text {
  class Cue {
    private noStructuralTyping_shaka_text_Cue : any;
    constructor (startTime : number , endTime : number , payload : string ) ;
    /**
     * Text background color as a CSS color, e.g. "#FFFFFF" or "white".
     */
    backgroundColor : string ;
    /**
     * The URL of the background image, e.g. "data:[mime type];base64,[data]".
     */
    backgroundImage : string ;
    /**
     * The border around this cue as a CSS border.
     */
    border : string ;
    /**
     * The number of horizontal and vertical cells into which the Root Container
     * Region area is divided.
     */
    cellResolution : { columns : number , rows : number } ;
    /**
     * Text color as a CSS color, e.g. "#FFFFFF" or "white".
     */
    color : string ;
    /**
     * Text direction of the cue.
     */
    direction : shaka.text.Cue.direction ;
    /**
     * Vertical alignments of the cues within their extents.
     * 'BEFORE' means displaying the captions at the top of the text display
     * container box, 'CENTER' means in the middle, 'AFTER' means at the bottom.
     */
    displayAlign : shaka.text.Cue.displayAlign ;
    /**
     * The end time of the cue in seconds, relative to the start of the
     * presentation.
     */
    endTime : number ;
    /**
     * Text font family.
     */
    fontFamily : string ;
    /**
     * Text font size in px or em (e.g. '100px'/'100em').
     */
    fontSize : string ;
    /**
     * Text font style. Normal, italic or oblique.
     */
    fontStyle : shaka.text.Cue.fontStyle ;
    /**
     * Text font weight. Either normal or bold.
     */
    fontWeight : shaka.text.Cue.fontWeight ;
    /**
     * Id of the cue.
     */
    id : string ;
    /**
     * If true, this represents a container element that is "above" the main
     * cues. For example, the <body> and <div> tags that contain the <p> tags
     * in a TTML file. This controls the flow of the final cues; any nested cues
     * within an "isContainer" cue will be laid out as separate lines.
     */
    isContainer : boolean ;
    /**
     * Text letter spacing as a CSS letter-spacing value.
     */
    letterSpacing : string ;
    /**
     * The offset from the display box in either number of lines or
     * percentage depending on the value of lineInterpretation.
     */
    line : number | null ;
    /**
     * Line alignment of the cue box.
     * Start alignment means the cue box’s top side (for horizontal cues), left
     * side (for vertical growing right), or right side (for vertical growing
     * left) is aligned at the line.
     * Center alignment means the cue box is centered at the line.
     * End alignment The cue box’s bottom side (for horizontal cues), right side
     * (for vertical growing right), or left side (for vertical growing left) is
     * aligned at the line.
     */
    lineAlign : shaka.text.Cue.lineAlign ;
    /**
     * Whether or not the cue only acts as a line break between two nested cues.
     * Should only appear in nested cues.
     */
    lineBreak : boolean ;
    /**
     * Separation between line areas inside the cue box in px or em
     * (e.g. '100px'/'100em'). If not specified, this should be no less than
     * the largest font size applied to the text in the cue.
     */
    lineHeight : string ;
    /**
     * The way to interpret line field. (Either as an integer line number or
     * percentage from the display box).
     */
    lineInterpretation : shaka.text.Cue.lineInterpretation ;
    /**
     * Text line padding as a CSS line-padding value.
     */
    linePadding : string ;
    /**
     * Nested cues, which should be laid out horizontally in one block.
     * Top-level cues are blocks, and nested cues are inline elements.
     * Cues can be nested arbitrarily deeply.
     */
    nestedCues : shaka.text.Cue [] ;
    /**
     * Opacity of the cue element, from 0-1.
     */
    opacity : number ;
    /**
     * The text payload of the cue.  If nestedCues is non-empty, this should be
     * empty.  Top-level block containers should have no payload of their own.
     */
    payload : string ;
    /**
     * The indent (in percent) of the cue box in the direction defined by the
     * writing direction.
     */
    position : number | null ;
    /**
     * Position alignment of the cue.
     */
    positionAlign : shaka.text.Cue.positionAlign ;
    /**
     * The region to render the cue into.  Only supported on top-level cues,
     * because nested cues are inline elements.
     */
    region : shaka.text.CueRegion | null ;
    /**
     * Used to indicate the type of ruby tag that should be used when rendering
     * the cue. Valid values: ruby, rp, rt.
     */
    rubyTag : string | null ;
    /**
     * Size of the cue box (in percents), where 0 means "auto".
     */
    size : number ;
    /**
     * The start time of the cue in seconds, relative to the start of the
     * presentation.
     */
    startTime : number ;
    /**
     * Alignment of the text inside the cue box.
     */
    textAlign : shaka.text.Cue.textAlign ;
    /**
     * Text combine upright as a CSS text-combine-upright value.
     */
    textCombineUpright : string ;
    /**
     * Text decoration. A combination of underline, overline
     * and line through. Empty array means no decoration.
     */
    textDecoration : shaka.text.Cue.textDecoration [] ;
    /**
     * Text shadow color as a CSS text-shadow value.
     */
    textShadow : string ;
    /**
     * Text stroke color as a CSS color, e.g. "#FFFFFF" or "white".
     */
    textStrokeColor : string ;
    /**
     * Text stroke width as a CSS stroke-width value.
     */
    textStrokeWidth : string ;
    /**
     * Whether or not line wrapping should be applied to the cue.
     */
    wrapLine : boolean ;
    /**
     * Text writing mode of the cue.
     */
    writingMode : shaka.text.Cue.writingMode ;
    /**
     * Parses cue payload, searches for styling entities and, if needed,
     * modifies original payload and creates nested cues to better represent
     * styling found in payload. All changes are done in-place.
     */
    static parseCuePayload (cue : shaka.text.Cue , styles ? : Map < string , shaka.text.Cue > ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.Cue {
  /**
   * Default text background color according to
   * https://w3c.github.io/webvtt/#default-text-background
   */
  /**
   * Default text background color according to
   * https://w3c.github.io/webvtt/#default-text-background
   */
  enum defaultTextBackgroundColor {
    bg_black = 'black' ,
    bg_blue = 'blue' ,
    bg_cyan = 'cyan' ,
    bg_lime = 'lime' ,
    bg_magenta = 'magenta' ,
    bg_red = 'red' ,
    bg_white = 'white' ,
    bg_yellow = 'yellow' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.Cue {
  /**
   * Default text color according to
   * https://w3c.github.io/webvtt/#default-text-color
   */
  /**
   * Default text color according to
   * https://w3c.github.io/webvtt/#default-text-color
   */
  enum defaultTextColor {
    black = 'black' ,
    blue = 'blue' ,
    cyan = 'cyan' ,
    lime = 'lime' ,
    magenta = 'magenta' ,
    red = 'red' ,
    white = 'white' ,
    yellow = 'yellow' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.Cue {
  enum direction {
    HORIZONTAL_LEFT_TO_RIGHT = 'ltr' ,
    HORIZONTAL_RIGHT_TO_LEFT = 'rtl' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.Cue {
  /**
   * Vertical alignments of the cues within their extents.
   * 'BEFORE' means displaying at the top of the captions container box, 'CENTER'
   * means in the middle, 'AFTER' means at the bottom.
   */
  /**
   * Vertical alignments of the cues within their extents.
   * 'BEFORE' means displaying at the top of the captions container box, 'CENTER'
   * means in the middle, 'AFTER' means at the bottom.
   */
  enum displayAlign {
    AFTER = 'after' ,
    BEFORE = 'before' ,
    CENTER = 'center' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.Cue {
  enum fontStyle {
    ITALIC = 'italic' ,
    NORMAL = 'normal' ,
    OBLIQUE = 'oblique' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.Cue {
  /**
   * In CSS font weight can be a number, where 400 is normal and 700 is bold.
   * Use these values for the enum for consistency.
   */
  /**
   * In CSS font weight can be a number, where 400 is normal and 700 is bold.
   * Use these values for the enum for consistency.
   */
  enum fontWeight {
    BOLD = 700.0 ,
    NORMAL = 400.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.Cue {
  enum lineAlign {
    CENTER = 'center' ,
    END = 'end' ,
    START = 'start' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.Cue {
  enum lineInterpretation {
    LINE_NUMBER = 0.0 ,
    PERCENTAGE = 1.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.Cue {
  enum positionAlign {
    AUTO = 'auto' ,
    CENTER = 'center' ,
    LEFT = 'line-left' ,
    RIGHT = 'line-right' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.Cue {
  enum textAlign {
    CENTER = 'center' ,
    END = 'end' ,
    LEFT = 'left' ,
    RIGHT = 'right' ,
    START = 'start' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.Cue {
  enum textDecoration {
    LINE_THROUGH = 'lineThrough' ,
    OVERLINE = 'overline' ,
    UNDERLINE = 'underline' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.Cue {
  enum writingMode {
    HORIZONTAL_TOP_TO_BOTTOM = 'horizontal-tb' ,
    VERTICAL_LEFT_TO_RIGHT = 'vertical-lr' ,
    VERTICAL_RIGHT_TO_LEFT = 'vertical-rl' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text {
  class CueRegion {
    private noStructuralTyping_shaka_text_CueRegion : any;
    /**
     * The width of the rendering area in heightUnits.
     */
    height : number ;
    /**
     * The units (percentage, pixels or lines) the region height is in.
     */
    heightUnits : shaka.text.CueRegion.units ;
    /**
     * Region identifier.
     */
    id : string ;
    /**
     * The X offset to start the rendering area in percentage (0-100) of this
     * region width.
     */
    regionAnchorX : number ;
    /**
     * The Y offset to start the rendering area in percentage (0-100) of the
     * region height.
     */
    regionAnchorY : number ;
    /**
     * If scroll=UP, it means that cues in the region will be added to the
     * bottom of the region and will push any already displayed cues in the
     * region up.  Otherwise (scroll=NONE) cues will stay fixed at the location
     * they were first painted in.
     */
    scroll : shaka.text.CueRegion.scrollMode ;
    /**
     * The units (percentage or pixels) the region viewportAnchors are in.
     */
    viewportAnchorUnits : shaka.text.CueRegion.units ;
    /**
     * The X offset to start the rendering area in viewportAnchorUnits of the
     * video width.
     */
    viewportAnchorX : number ;
    /**
     * The X offset to start the rendering area in viewportAnchorUnits of the
     * video height.
     */
    viewportAnchorY : number ;
    /**
     * The width of the rendering area in widthUnits.
     */
    width : number ;
    /**
     * The units (percentage or pixels) the region width is in.
     */
    widthUnits : shaka.text.CueRegion.units ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.CueRegion {
  enum scrollMode {
    NONE = '' ,
    UP = 'up' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text.CueRegion {
  enum units {
    LINES = 2.0 ,
    PERCENTAGE = 1.0 ,
    PX = 0.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text {
  class Mp4TtmlParser implements shaka.extern.TextParser {
    private noStructuralTyping_shaka_text_Mp4TtmlParser : any;
    parseInit (data : any ) : any ;
    parseMedia (data : any , time : any , uri : any ) : any ;
    setManifestType (manifestType : any ) : any ;
    setSequenceMode (sequenceMode : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text {
  class Mp4VttParser implements shaka.extern.TextParser {
    private noStructuralTyping_shaka_text_Mp4VttParser : any;
    parseInit (data : any ) : any ;
    parseMedia (data : any , time : any ) : any ;
    setManifestType (manifestType : any ) : any ;
    setSequenceMode (sequenceMode : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text {
  /**
   * A text displayer plugin using the browser's native VTTCue interface.
   */
  class NativeTextDisplayer implements shaka.extern.TextDisplayer {
    private noStructuralTyping_shaka_text_NativeTextDisplayer : any;
    /**
     * A text displayer plugin using the browser's native VTTCue interface.
     */
    constructor (player : shaka.Player | null ) ;
    append (cues : any ) : any ;
    configure (config : any ) : any ;
    destroy ( ) : any ;
    enableTextDisplayer ( ) : any ;
    isTextVisible ( ) : any ;
    remove (start : any , end : any ) : any ;
    setTextLanguage (language : any ) : any ;
    setTextVisibility (on : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text {
  /**
   * A text displayer plugin using the browser's native VTTCue interface.
   */
  class SimpleTextDisplayer implements shaka.extern.TextDisplayer {
    private noStructuralTyping_shaka_text_SimpleTextDisplayer : any;
    /**
     * A text displayer plugin using the browser's native VTTCue interface.
     */
    constructor (video : HTMLMediaElement | null , label : string ) ;
    append (cues : any ) : any ;
    configure (config : any ) : any ;
    destroy ( ) : any ;
    enableTextDisplayer ( ) : any ;
    isTextVisible ( ) : any ;
    remove (start : any , end : any ) : any ;
    setTextLanguage (language : any ) : any ;
    setTextVisibility (on : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text {
  /**
   * A stub text displayer plugin that does nothing
   */
  class StubTextDisplayer implements shaka.extern.TextDisplayer {
    private noStructuralTyping_shaka_text_StubTextDisplayer : any;
    append (cues : any ) : any ;
    configure (config : any ) : any ;
    destroy ( ) : any ;
    enableTextDisplayer ( ) : any ;
    isTextVisible ( ) : any ;
    remove (start : any , end : any ) : any ;
    setTextLanguage (language : any ) : any ;
    setTextVisibility (on : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text {
  class TextEngine implements shaka.util.IDestroyable {
    private noStructuralTyping_shaka_text_TextEngine : any;
    constructor (displayer : shaka.extern.TextDisplayer | null ) ;
    destroy ( ) : Promise < any > ;
    static findParser (mimeType : any ) : ( shaka.extern.TextParserPlugin ) | null ;
    static registerParser (mimeType : string , plugin : shaka.extern.TextParserPlugin ) : any ;
    static unregisterParser (mimeType : string ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text {
  class TtmlTextParser implements shaka.extern.TextParser {
    private noStructuralTyping_shaka_text_TtmlTextParser : any;
    parseInit (data : any ) : any ;
    parseMedia (data : any , time : any , uri : any , images : any ) : any ;
    setManifestType (manifestType : any ) : any ;
    setSequenceMode (sequenceMode : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text {
  /**
   * The text displayer plugin for the Shaka Player UI.  Can also be used directly
   * by providing an appropriate container element.
   */
  class UITextDisplayer implements shaka.extern.TextDisplayer {
    private noStructuralTyping_shaka_text_UITextDisplayer : any;
    /**
     * The text displayer plugin for the Shaka Player UI.  Can also be used directly
     * by providing an appropriate container element.
     */
    constructor (video : HTMLMediaElement | null , videoContainer : HTMLElement | null ) ;
    append (cues : any ) : any ;
    configure (config : any ) : any ;
    destroy ( ) : any ;
    enableTextDisplayer ( ) : any ;
    isTextVisible ( ) : any ;
    remove (start : any , end : any ) : any ;
    setTextLanguage (language : any ) : any ;
    setTextVisibility (on : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text {
  class VttTextParser implements shaka.extern.TextParser {
    private noStructuralTyping_shaka_text_VttTextParser : any;
    parseInit (data : any ) : any ;
    parseMedia (data : any , time : any ) : any ;
    setManifestType (manifestType : any ) : any ;
    setSequenceMode (sequenceMode : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.text {
  class WebVttGenerator {
    private noStructuralTyping_shaka_text_WebVttGenerator : any;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.transmuxer {
  class TransmuxerEngine implements shaka.util.IDestroyable {
    private noStructuralTyping_shaka_transmuxer_TransmuxerEngine : any;
    destroy ( ) : Promise < any > ;
    static findTransmuxer (mimeType : string , contentType ? : string ) : ( shaka.extern.TransmuxerPlugin ) | null ;
    static registerTransmuxer (mimeType : string , plugin : shaka.extern.TransmuxerPlugin , priority : number ) : any ;
    static unregisterTransmuxer (mimeType : string , priority : number ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.transmuxer.TransmuxerEngine {
  /**
   * Priority level for transmuxer plugins.
   * If multiple plugins are provided for the same mime type, only the
   * highest-priority one is used.
   */
  /**
   * Priority level for transmuxer plugins.
   * If multiple plugins are provided for the same mime type, only the
   * highest-priority one is used.
   */
  enum PluginPriority {
    APPLICATION = 4.0 ,
    FALLBACK = 1.0 ,
    PREFERRED = 3.0 ,
    PREFERRED_SECONDARY = 2.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  /**
   * A utility to wrap abortable operations.  Note that these are not cancelable.
   * Cancellation implies undoing what has been done so far, whereas aborting only
   * means that further work is stopped.
   */
  class AbortableOperation < T > implements shaka.extern.IAbortableOperation < T > {
    private noStructuralTyping_shaka_util_AbortableOperation : any;
    /**
     * A utility to wrap abortable operations.  Note that these are not cancelable.
     * Cancellation implies undoing what has been done so far, whereas aborting only
     * means that further work is stopped.
     */
    constructor (promise : Promise < T > , onAbort : shaka.extern.CreateSegmentIndexFunction ) ;
    abort ( ) : any ;
    aborted ( ) : boolean ;
    chain < U > (onSuccess : undefined | Function , onError ? : (a : any ) => any ) : shaka.util.AbortableOperation < U > ;
    finally (onFinal : any ) : any ;
    promise : Promise < T > ;
    static aborted ( ) : shaka.util.AbortableOperation < any > ;
    static all (operations : shaka.util.AbortableOperation < any > [] ) : shaka.util.AbortableOperation < any > ;
    static completed < U > (value : U ) : shaka.util.AbortableOperation < U > ;
    static failed (error : shaka.util.Error ) : shaka.util.AbortableOperation < any > ;
    static notAbortable < U > (promise : Promise < U > ) : shaka.util.AbortableOperation < U > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class BufferUtils {
    private noStructuralTyping_shaka_util_BufferUtils : any;
    /**
     * Compare two buffers for equality.  For buffers of different types, this
     * compares the underlying buffers as binary data.
     */
    static equal (arr1 : ArrayBuffer | ArrayBufferView | null , arr2 : ArrayBuffer | ArrayBufferView | null ) : boolean ;
    /**
     * Gets an ArrayBuffer that contains the data from the given TypedArray.  Note
     * this will allocate a new ArrayBuffer if the object is a partial view of
     * the data.
     */
    static toArrayBuffer (view : ArrayBuffer | ArrayBufferView ) : ArrayBuffer ;
    /**
     * Creates a DataView over the given buffer.
     */
    static toDataView (buffer : ArrayBuffer | ArrayBufferView , offset ? : number , length ? : number ) : DataView ;
    /**
     * Creates a new Uint16Array view on the same buffer.  This clamps the values
     * to be within the same view (i.e. you can't use this to move past the end
     * of the view, even if the underlying buffer is larger).  However, you can
     * pass a negative offset to access the data before the view.
     * @param offset The offset from the beginning of this data's view to start the new view at.
     * @param length The byte length of the new view.
     */
    static toUint16 (data : ArrayBuffer | ArrayBufferView , offset ? : number , length ? : number ) : Uint16Array ;
    /**
     * Creates a new Uint8Array view on the same buffer.  This clamps the values
     * to be within the same view (i.e. you can't use this to move past the end
     * of the view, even if the underlying buffer is larger).  However, you can
     * pass a negative offset to access the data before the view.
     * @param offset The offset from the beginning of this data's view to start the new view at.
     * @param length The byte length of the new view.
     */
    static toUint8 (data : ArrayBuffer | ArrayBufferView , offset ? : number , length ? : number ) : Uint8Array ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util.CmcdManager {
  enum StreamingFormat {
    DASH = 'd' ,
    HLS = 'h' ,
    LOW_LATENCY_DASH = 'ld' ,
    LOW_LATENCY_HLS = 'lh' ,
    OTHER = 'o' ,
    SMOOTH = 's' ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class CmsdManager {
    private noStructuralTyping_shaka_util_CmsdManager : any;
    constructor (config : shaka.extern.CmsdConfiguration ) ;
    /**
     * Gets the current bandwidth estimate.
     */
    getBandwidthEstimate (defaultEstimate : number ) : number ;
    /**
     * Returns the estimated throughput in bits per second. If there is no
     * estimated throughput or it's not enabled, it returns null.
     */
    getEstimatedThroughput ( ) : number | null ;
    /**
     * Returns the max bitrate in bits per second. If there is no max bitrate or
     * it's not enabled, it returns null.
     */
    getMaxBitrate ( ) : number | null ;
    /**
     * Returns the response delay in milliseconds. If there is no response delay
     * or it's not enabled, it returns null.
     */
    getResponseDelay ( ) : number | null ;
    /**
     * Returns the RTT in milliseconds. If there is no RTT or it's not enabled,
     * it returns null.
     */
    getRoundTripTime ( ) : number | null ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class ConfigUtils {
    private noStructuralTyping_shaka_util_ConfigUtils : any;
    /**
     * Convert config from ('fieldName', value) format to a partial config object.
     * E. g. from ('manifest.retryParameters.maxAttempts', 1) to
     * { manifest: { retryParameters: { maxAttempts: 1 }}}.
     */
    static convertToConfigObject (fieldName : string , value : any ) : object ;
    static getDifferenceFromConfigObjects (object : object , base : object ) : object ;
    static mergeConfigObjects (destination : object , source : object , template : object , overrides : object , path : string ) : boolean ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class DataViewReader {
    private noStructuralTyping_shaka_util_DataViewReader : any;
    constructor (data : ArrayBuffer | ArrayBufferView , endianness : shaka.util.DataViewReader.Endianness ) ;
    /**
     * Gets the byte length of the DataView.
     */
    getLength ( ) : number ;
    /**
     * Gets the current byte position.
     */
    getPosition ( ) : number ;
    hasMoreData ( ) : boolean ;
    /**
     * Reads the specified number of raw bytes.
     * @param bytes The number of bytes to read.
     * @param clone True to clone the data into a new buffer, false to create a view on the existing buffer.  Creating a view on the existing buffer will keep the entire buffer in memory so long as the view is reachable.  Use false for temporary values, and true for values that need to outlive the underlying buffer.
     */
    readBytes (bytes : number , clone : boolean ) : Uint8Array ;
    /**
     * Reads a signed 32 bit integer, and advances the reader.
     */
    readInt32 ( ) : number ;
    /**
     * Keeps reading until it reaches a byte that equals to zero.  The text is
     * assumed to be UTF-8.
     */
    readTerminatedString ( ) : string ;
    /**
     * Reads an unsigned 16 bit integer, and advances the reader.
     */
    readUint16 ( ) : number ;
    /**
     * Reads an unsigned 32 bit integer, and advances the reader.
     */
    readUint32 ( ) : number ;
    /**
     * Reads an unsigned 64 bit integer, and advances the reader.
     */
    readUint64 ( ) : number ;
    /**
     * Reads an unsigned 8 bit integer, and advances the reader.
     */
    readUint8 ( ) : number ;
    /**
     * Rewinds the specified number of bytes.
     * @param bytes The number of bytes to rewind.
     */
    rewind (bytes : number ) : any ;
    /**
     * Seeks to a specified position.
     * @param position The desired byte position within the DataView.
     */
    seek (position : number ) : any ;
    /**
     * Skips the specified number of bytes.
     * @param bytes The number of bytes to skip.
     */
    skip (bytes : number ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util.DataViewReader {
  /**
   * Endianness.
   */
  /**
   * Endianness.
   */
  enum Endianness {
    BIG_ENDIAN = 0.0 ,
    LITTLE_ENDIAN = 1.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class Dom {
    private noStructuralTyping_shaka_util_Dom : any;
    /**
     * Remove all source elements and src attribute from a video element.
     * Returns true if any change was made.
     */
    static clearSourceFromVideo (video : HTMLMediaElement ) : boolean ;
    /**
     * Remove all of the child nodes of an element.
     */
    static removeAllChildren (element : Element ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class Error extends GlobalError implements shaka.extern.Error {
    private noStructuralTyping_shaka_util_Error : any;
    constructor (severity : shaka.util.Error.Severity , category : shaka.util.Error.Category , code : shaka.util.Error.Code ,  ...varArgs : any [] ) ;
    category : any ;
    code : any ;
    data : any ;
    handled : any ;
    severity : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util.Error {
  enum Category {
    ADS = 10.0 ,
    CAST = 8.0 ,
    DRM = 6.0 ,
    MANIFEST = 4.0 ,
    MEDIA = 3.0 ,
    NETWORK = 1.0 ,
    PLAYER = 7.0 ,
    STORAGE = 9.0 ,
    STREAMING = 5.0 ,
    TEXT = 2.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util.Error {
  enum Code {
    AES_128_INVALID_IV_LENGTH = 4048.0 ,
    AES_128_INVALID_KEY_LENGTH = 4049.0 ,
    ALREADY_CASTING = 8002.0 ,
    ATTEMPTS_EXHAUSTED = 1010.0 ,
    BAD_ENCODING = 2004.0 ,
    BAD_HTTP_STATUS = 1001.0 ,
    BUFFER_READ_OUT_OF_BOUNDS = 3000.0 ,
    CANNOT_ADD_EXTERNAL_CHAPTERS_TO_LIVE_STREAM = 4055.0 ,
    CANNOT_ADD_EXTERNAL_TEXT_TO_LIVE_STREAM = 4033.0 ,
    CANNOT_ADD_EXTERNAL_TEXT_TO_SRC_EQUALS = 2012.0 ,
    CANNOT_ADD_EXTERNAL_THUMBNAILS_TO_LIVE_STREAM = 4045.0 ,
    CANNOT_STORE_LIVE_OFFLINE = 9005.0 ,
    CAST_API_UNAVAILABLE = 8000.0 ,
    CAST_CANCELED_BY_USER = 8004.0 ,
    CAST_CONNECTION_TIMED_OUT = 8005.0 ,
    CAST_RECEIVER_APP_UNAVAILABLE = 8006.0 ,
    CONTENT_NOT_LOADED = 7004.0 ,
    CONTENT_TRANSFORMATION_FAILED = 3019.0 ,
    CONTENT_UNSUPPORTED_BY_BROWSER = 4032.0 ,
    CS_AD_MANAGER_NOT_INITIALIZED = 10001.0 ,
    CS_IMA_SDK_MISSING = 10000.0 ,
    CURRENT_DAI_REQUEST_NOT_FINISHED = 10004.0 ,
    DASH_CONFLICTING_AES_128 = 4050.0 ,
    DASH_CONFLICTING_KEY_IDS = 4010.0 ,
    DASH_DUPLICATE_REPRESENTATION_ID = 4018.0 ,
    DASH_EMPTY_ADAPTATION_SET = 4003.0 ,
    DASH_EMPTY_PERIOD = 4004.0 ,
    DASH_INVALID_PATCH = 4052.0 ,
    DASH_INVALID_XML = 4001.0 ,
    DASH_MSE_ENCRYPTED_LEGACY_APPLE_MEDIA_KEYS_NOT_SUPPORTED = 4054.0 ,
    DASH_MULTIPLE_KEY_IDS_NOT_SUPPORTED = 4009.0 ,
    DASH_NO_COMMON_KEY_SYSTEM = 4008.0 ,
    DASH_NO_SEGMENT_INFO = 4002.0 ,
    DASH_PSSH_BAD_ENCODING = 4007.0 ,
    DASH_UNSUPPORTED_AES_128 = 4051.0 ,
    DASH_UNSUPPORTED_CONTAINER = 4006.0 ,
    DASH_UNSUPPORTED_XLINK_ACTUATE = 4027.0 ,
    DASH_WEBM_MISSING_INIT = 4005.0 ,
    DASH_XLINK_DEPTH_LIMIT = 4028.0 ,
    DEPRECATED_OPERATION_ABORTED = 9002.0 ,
    DOWNLOAD_SIZE_CALLBACK_ERROR = 9015.0 ,
    EBML_BAD_FLOATING_POINT_SIZE = 3003.0 ,
    EBML_OVERFLOW = 3002.0 ,
    ENCRYPTED_CONTENT_WITHOUT_DRM_INFO = 6010.0 ,
    ERROR_CHECKING_HDCP_VERSION = 6019.0 ,
    EXPIRED = 6014.0 ,
    FAILED_TO_ATTACH_TO_VIDEO = 6003.0 ,
    FAILED_TO_CREATE_CDM = 6002.0 ,
    FAILED_TO_CREATE_SESSION = 6005.0 ,
    FAILED_TO_GENERATE_LICENSE_REQUEST = 6006.0 ,
    HLS_COULD_NOT_GUESS_CODECS = 4025.0 ,
    HLS_EMPTY_MEDIA_PLAYLIST = 4053.0 ,
    HLS_INVALID_PLAYLIST_HIERARCHY = 4017.0 ,
    HLS_KEYFORMATS_NOT_SUPPORTED = 4026.0 ,
    HLS_MSE_ENCRYPTED_LEGACY_APPLE_MEDIA_KEYS_NOT_SUPPORTED = 4041.0 ,
    HLS_MSE_ENCRYPTED_MP2T_NOT_SUPPORTED = 4040.0 ,
    HLS_MULTIPLE_MEDIA_INIT_SECTIONS_FOUND = 4020.0 ,
    HLS_PLAYLIST_HEADER_MISSING = 4015.0 ,
    HLS_REQUIRED_ATTRIBUTE_MISSING = 4023.0 ,
    HLS_REQUIRED_TAG_MISSING = 4024.0 ,
    HLS_VARIABLE_NOT_FOUND = 4039.0 ,
    HTTP_ERROR = 1002.0 ,
    INCONSISTENT_DRM_ACROSS_PERIODS = 4038.0 ,
    INDEXED_DB_ERROR = 9001.0 ,
    INDEXED_DB_INIT_TIMED_OUT = 9017.0 ,
    INIT_DATA_TRANSFORM_ERROR = 6016.0 ,
    INTERSTITIAL_AD_MANAGER_NOT_INITIALIZED = 10006.0 ,
    INVALID_HLS_TAG = 4016.0 ,
    INVALID_MP4_CEA = 2010.0 ,
    INVALID_MP4_TTML = 2007.0 ,
    INVALID_MP4_VTT = 2008.0 ,
    INVALID_SERVER_CERTIFICATE = 6004.0 ,
    INVALID_TEXT_CUE = 2001.0 ,
    INVALID_TEXT_HEADER = 2000.0 ,
    INVALID_XML = 2005.0 ,
    JS_INTEGER_OVERFLOW = 3001.0 ,
    KEY_NOT_FOUND = 9012.0 ,
    LICENSE_REQUEST_FAILED = 6007.0 ,
    LICENSE_RESPONSE_REJECTED = 6008.0 ,
    LOAD_INTERRUPTED = 7000.0 ,
    LOCAL_PLAYER_INSTANCE_REQUIRED = 9008.0 ,
    MALFORMED_DATA_URI = 1004.0 ,
    MALFORMED_OFFLINE_URI = 9004.0 ,
    MALFORMED_TEST_URI = 1008.0 ,
    MEDIA_SOURCE_OPERATION_FAILED = 3014.0 ,
    MEDIA_SOURCE_OPERATION_THREW = 3015.0 ,
    MIN_HDCP_VERSION_NOT_MATCH = 6018.0 ,
    MISSING_EME_SUPPORT = 6020.0 ,
    MISSING_STORAGE_CELL = 9013.0 ,
    MISSING_TEXT_PLUGIN = 2014.0 ,
    MODIFY_OPERATION_NOT_SUPPORTED = 9016.0 ,
    MP4_SIDX_INVALID_TIMESCALE = 3005.0 ,
    MP4_SIDX_TYPE_NOT_SUPPORTED = 3006.0 ,
    MP4_SIDX_WRONG_BOX_TYPE = 3004.0 ,
    MSS_INVALID_XML = 4046.0 ,
    MSS_LIVE_CONTENT_NOT_SUPPORTED = 4047.0 ,
    MSS_MISSING_DATA_FOR_TRANSMUXING = 3020.0 ,
    MSS_TRANSMUXING_FAILED = 3022.0 ,
    MT_AD_MANAGER_NOT_INITIALIZED = 10005.0 ,
    NEW_KEY_OPERATION_NOT_SUPPORTED = 9011.0 ,
    NO_CAST_RECEIVERS = 8001.0 ,
    NO_INIT_DATA_FOR_OFFLINE = 9007.0 ,
    NO_LICENSE_SERVER_GIVEN = 6012.0 ,
    NO_RECOGNIZED_KEY_SYSTEMS = 6000.0 ,
    NO_VARIANTS = 4036.0 ,
    NO_VIDEO_ELEMENT = 7002.0 ,
    NO_WEB_CRYPTO_API = 4042.0 ,
    OBJECT_DESTROYED = 7003.0 ,
    OFFLINE_SESSION_REMOVED = 6013.0 ,
    OPERATION_ABORTED = 7001.0 ,
    PERIOD_FLATTENING_FAILED = 4037.0 ,
    PRELOAD_DESTROYED = 7006.0 ,
    QUEUE_INDEX_OUT_OF_BOUNDS = 7007.0 ,
    QUOTA_EXCEEDED_ERROR = 3017.0 ,
    REQUESTED_ITEM_NOT_FOUND = 9003.0 ,
    REQUESTED_KEY_SYSTEM_CONFIG_UNAVAILABLE = 6001.0 ,
    REQUEST_FILTER_ERROR = 1006.0 ,
    RESPONSE_FILTER_ERROR = 1007.0 ,
    RESTRICTIONS_CANNOT_BE_MET = 4012.0 ,
    SEGMENT_MISSING = 1011.0 ,
    SERVER_CERTIFICATE_REQUEST_FAILED = 6017.0 ,
    SERVER_CERTIFICATE_REQUIRED = 6015.0 ,
    SRC_EQUALS_PRELOAD_NOT_SUPPORTED = 7005.0 ,
    SS_AD_MANAGER_NOT_INITIALIZED = 10003.0 ,
    SS_IMA_SDK_MISSING = 10002.0 ,
    STORAGE_LIMIT_REACHED = 9014.0 ,
    STORAGE_NOT_SUPPORTED = 9000.0 ,
    STREAMING_ENGINE_STARTUP_INVALID_STATE = 5006.0 ,
    STREAMING_NOT_ALLOWED = 3024.0 ,
    TEXT_COULD_NOT_GUESS_MIME_TYPE = 2011.0 ,
    TEXT_ONLY_WEBVTT_SRC_EQUALS = 2013.0 ,
    TIMEOUT = 1003.0 ,
    TRANSMUXING_FAILED = 3018.0 ,
    TRANSMUXING_NO_VIDEO_DATA = 3023.0 ,
    UNABLE_TO_DETECT_ENCODING = 2003.0 ,
    UNABLE_TO_EXTRACT_CUE_START_TIME = 2009.0 ,
    UNABLE_TO_GUESS_MANIFEST_TYPE = 4000.0 ,
    UNEXPECTED_CAST_ERROR = 8003.0 ,
    UNEXPECTED_TEST_REQUEST = 1009.0 ,
    UNSUPPORTED_EXTERNAL_THUMBNAILS_URI = 2017.0 ,
    UNSUPPORTED_SCHEME = 1000.0 ,
    VAST_INVALID_XML = 10007.0 ,
    VIDEO_ERROR = 3016.0 ,
    WEBM_CUES_ELEMENT_MISSING = 3007.0 ,
    WEBM_CUE_TIME_ELEMENT_MISSING = 3013.0 ,
    WEBM_CUE_TRACK_POSITIONS_ELEMENT_MISSING = 3012.0 ,
    WEBM_DURATION_ELEMENT_MISSING = 3011.0 ,
    WEBM_EBML_HEADER_ELEMENT_MISSING = 3008.0 ,
    WEBM_INFO_ELEMENT_MISSING = 3010.0 ,
    WEBM_SEGMENT_ELEMENT_MISSING = 3009.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util.Error {
  enum Severity {
    CRITICAL = 2.0 ,
    RECOVERABLE = 1.0 ,
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class EventManager implements shaka.util.IReleasable {
    private noStructuralTyping_shaka_util_EventManager : any;
    /**
     * Attaches an event listener to an event target.
     * @param target The event target.
     * @param type The event type.
     * @param listener The event listener.
     * @param options An object that specifies characteristics about the event listener. The passive option, if true, indicates that this function will never call preventDefault(), which improves scrolling performance.
     */
    listen (target : EventTarget | null , type : string , listener : shaka.util.EventManager.ListenerType , options ? : boolean | AddEventListenerOptions ) : any ;
    /**
     * Attaches an event listener to an event target.  The listener will be
     * removed when the first instance of the event is fired.
     * @param target The event target.
     * @param type The event type.
     * @param listener The event listener.
     * @param options An object that specifies characteristics about the event listener. The passive option, if true, indicates that this function will never call preventDefault(), which improves scrolling performance.
     */
    listenOnce (target : EventTarget | null , type : string , listener : shaka.util.EventManager.ListenerType , options ? : boolean | AddEventListenerOptions ) : any ;
    /**
     * Detaches all event listeners.
     */
    release ( ) : any ;
    /**
     * Detaches all event listeners from all targets.
     */
    removeAll ( ) : any ;
    /**
     * Detaches an event listener from an event target.
     * @param target The event target.
     * @param type The event type.
     * @param listener The event listener.
     */
    unlisten (target : EventTarget | null , type : string , listener ? : shaka.util.EventManager.ListenerType ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util.EventManager {
  type ListenerType = (a : Event ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class ExpGolomb {
    private noStructuralTyping_shaka_util_ExpGolomb : any;
    constructor (data : Uint8Array , convertEbsp2rbsp ? : boolean ) ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class FairPlayUtils extends shaka.drm.FairPlay {
    private noStructuralTyping_shaka_util_FairPlayUtils : any;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class FakeEvent extends Event {
    private noStructuralTyping_shaka_util_FakeEvent : any;
    constructor (type : string , dict ? : Map < string , object | null > | null ) ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class FakeEventTarget implements EventTarget , shaka.util.IReleasable {
    private noStructuralTyping_shaka_util_FakeEventTarget : any;
    /**
     * Add an event listener to this object.
     * @param type The event type to listen for.
     * @param listener The callback or listener object to invoke.
     * @param options Ignored.
     */
    addEventListener (type : string , listener : EventListener | null | ( (a : Event ) => any ) , options ? : AddEventListenerOptions | boolean ) : any ;
    /**
     * Dispatch an event from this object.
     * @param event The event to be dispatched from this object.
     */
    dispatchEvent (event : Event ) : boolean ;
    /**
     * Add an event listener to this object that is invoked for all events types
     * the object fires.
     * @param listener The callback or listener object to invoke.
     */
    listenToAllEvents (listener : EventListener | null | ( (a : Event ) => any ) ) : any ;
    release ( ) : any ;
    /**
     * Remove an event listener from this object.
     * @param type The event type for which you wish to remove a listener.
     * @param listener The callback or listener object to remove.
     * @param options Ignored.
     */
    removeEventListener (type : string , listener : EventListener | null | ( (a : Event ) => any ) , options ? : EventListenerOptions | null | boolean ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util.FakeEventTarget {
  /**
   * These are the listener types defined in the closure extern for EventTarget.
   */
  type ListenerType = EventListener | null | ( (a : Event ) => any ) ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  /**
   * An interface to standardize how objects are destroyed.
   */
  interface IDestroyable {
    /**
     * Request that this object be destroyed, releasing all resources and shutting
     * down all operations. Returns a Promise which is resolved when destruction
     * is complete. This Promise should never be rejected.
     */
    destroy ( ) : Promise < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  /**
   * An interface to standardize how objects release internal references
   * synchronously. If an object needs to asynchronously release references, then
   * it should use 'shaka.util.IDestroyable'.
   */
  interface IReleasable {
    /**
     * Request that this object release all internal references.
     */
    release ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class Id3Utils {
    private noStructuralTyping_shaka_util_Id3Utils : any;
    /**
     * Returns any adjacent ID3 tags found in data starting at offset, as one
     * block of data
     * @param id3Data - The ID3 data containing one or more ID3 tags
     * @param offset - The offset at which to start searching
     */
    static getID3Data (id3Data : Uint8Array | null , offset ? : number ) : Uint8Array ;
    /**
     * Returns an array of ID3 frames found in all the ID3 tags in the id3Data
     * @param id3Data - The ID3 data containing one or more ID3 tags
     */
    static getID3Frames (id3Data : Uint8Array | null ) : shaka.extern.MetadataFrame [] ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class LanguageUtils {
    private noStructuralTyping_shaka_util_LanguageUtils : any;
    /**
     * Check if |locale1| and |locale2| are language-compatible.
     * Language compatible is when the language component of each locale matches.
     * This means that no matter what region they have (or don't have) as long as
     * the language components match, they are language-compatible.
     * Examples:
     * Locale A | Locale B | Language-Compatible
     * -----------------------------------------
     * en-US    | en-US    | true
     * en-US    | en       | true
     * en-US    | en-CA    | true
     * en-CA    | fr-CA    | false
     */
    static areLanguageCompatible (locale1 : string , locale2 : string ) : boolean ;
    /**
     * Check if |locale1| and |locale2| are locale-compatible.
     * Locale-compatible is defined as all components in each locale match. Since
     * we only respect the language and region components, we only check that
     * the language and region components match.
     * Examples:
     * Locale A | Locale B | Locale Compatible
     * ---------------------------------------
     * en-US    | en-US    | true
     * en       | en-US    | false
     * en-US    | en-CA    | false
     */
    static areLocaleCompatible (locale1 : string , locale2 : string ) : boolean ;
    /**
     * Check if two language codes are siblings. Language codes are siblings if
     * they share the same base language while neither one is the base language.
     * For example, "en-US" and "en-CA" are siblings but "en-US" and "en" are not
     * siblings.
     */
    static areSiblings (a : string , b : string ) : boolean ;
    /**
     * Find the locale in |searchSpace| that comes closest to |target|. If no
     * locale is found to be close to |target|, then |null| will be returned.
     */
    static findClosestLocale (target : string , searchSpace : Iterable < string > ) : string | null ;
    /**
     * Get the normalized base language for a language code.
     */
    static getBase (lang : string ) : string ;
    /**
     * Get the normalized language of the given text stream. Will return 'und' if
     * a language is not found on the text stream.
     * This should always be used to get the language from a text stream.
     */
    static getLocaleForText (stream : shaka.extern.Stream ) : string ;
    /**
     * Get the normalized locale for the given variant. This will look through
     * the variant to find the locale that represents the content in the variant.
     * This will return 'und' if no language can be found.
     * This should always be used to get the locale from a variant.
     */
    static getLocaleForVariant (variant : shaka.extern.Variant ) : string ;
    /**
     * Check if |possibleParent| is the parent locale of |possibleChild|. Because
     * we do not support dialects, the parent-child relationship is a lot simpler.
     * In a parent child relationship:
     * - The parent and child have the same language-component
     * - The parent has no region-component
     * - The child has a region-component
     * Example:
     * Locale A | Locale B | Is A The parent of B?
     * --------------------------------------------
     * en-US    | en-US    | no
     * en-US    | en       | no
     * en       | en-US    | yes
     * en       | en       | no
     * en       | fr       | no
     */
    static isParentOf (possibleParent : string , possibleChild : string ) : boolean ;
    /**
     * Check if |localeA| shares the same parent with |localeB|. Since we don't
     * support dialect, we will only look at language and region. For two locales
     * to be siblings:
     * - Both must have language-components
     * - Both must have region-components
     * - Both must have the same language-component
     * Example:
     * Locale A | Locale B | Siblings?
     * --------------------------------------------
     * en-US    | en-US    | yes
     * en-US    | en-CA    | yes
     * en-US    | en       | no
     * en       | en-US    | no
     * en       | en       | no
     * en       | fr       | no
     */
    static isSiblingOf (localeA : string , localeB : string ) : boolean ;
    /**
     * Normalize a locale. This will take a locale and canonicalize it to a state
     * that we are prepared to work with.
     * We only support with:
     * - language
     * - language-REGION
     * If given a dialect, we will discard it. We will convert any 3-character
     * codes to 2-character codes. We will force language codes to lowercase and
     * region codes to uppercase.
     */
    static normalize (locale : string ) : string ;
    /**
     * Compute a numerical relatedness for language codes.  Language codes with a
     * higher relatedness are a better match.  Unrelated language codes have a
     * relatedness score of 0.
     */
    static relatedness (target : string , candidate : string ) : number ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class MimeUtils {
    private noStructuralTyping_shaka_util_MimeUtils : any;
    /**
     * Takes a MIME type and optional codecs string and produces the full MIME
     * type. Also remove the codecs for raw formats.
     */
    static getFullType (mimeType : string , codecs ? : string ) : string ;
    /**
     * Takes a MIME type and optional codecs string and produces the full MIME
     * type.
     */
    static getFullTypeWithAllCodecs (mimeType : string , codecs ? : string ) : string ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class Mp4Parser {
    private noStructuralTyping_shaka_util_Mp4Parser : any;
    /**
     * Declare a box type as a Box.
     */
    box (type : string , definition : shaka.util.Mp4Parser.CallbackType ) : shaka.util.Mp4Parser ;
    /**
     * Declare a box type as a Full Box.
     */
    fullBox (type : string , definition : shaka.util.Mp4Parser.CallbackType ) : shaka.util.Mp4Parser ;
    /**
     * Parse the given data using the added callbacks.
     * @param partialOkay If true, allow reading partial payloads from some boxes. If the goal is a child box, we can sometimes find it without enough data to find all child boxes.
     * @param stopOnPartial If true, stop reading if an incomplete box is detected.
     */
    parse (data : ArrayBuffer | ArrayBufferView , partialOkay ? : boolean , stopOnPartial ? : boolean ) : any ;
    /**
     * Parse the next box on the current level.
     * @param absStart The absolute start position in the original byte array.
     * @param partialOkay If true, allow reading partial payloads from some boxes. If the goal is a child box, we can sometimes find it without enough data to find all child boxes.
     * @param stopOnPartial If true, stop reading if an incomplete box is detected.
     */
    parseNext (absStart : number , reader : shaka.util.DataViewReader , partialOkay ? : boolean , stopOnPartial ? : boolean ) : any ;
    /**
     * Stop parsing.  Useful for extracting information from partial segments and
     * avoiding an out-of-bounds error once you find what you are looking for.
     */
    stop ( ) : any ;
    /**
     * Create a callback that tells the Mp4 parser to treat the body of a box as a
     * binary blob and to parse the body's contents using the provided callback.
     * @param clone True to clone the data into a new buffer, false to create a view on the existing buffer.  Creating a view on the existing buffer will keep the entire buffer in memory so long as the view is reachable.  Use false for temporary values, and true for values that need to outlive the underlying buffer.
     */
    static allData (callback : (a : Uint8Array ) => any , clone : boolean ) : shaka.util.Mp4Parser.CallbackType ;
    /**
     * A callback that tells the Mp4 parser to treat the body of a box as a audio
     * sample entry.  A audio sample entry has some fixed-sized fields
     * describing the audio codec parameters, followed by an arbitrary number of
     * appended children.  Each child is a box.
     */
    static audioSampleEntry (box : shaka.extern.ParsedBox ) : any ;
    /**
     * A callback that tells the Mp4 parser to treat the body of a box as a series
     * of boxes. The number of boxes is limited by the size of the parent box.
     */
    static children (box : shaka.extern.ParsedBox ) : any ;
    /**
     * Find the header size of the box.
     * Useful for modifying boxes in place or finding the exact offset of a field.
     */
    static headerSize (box : shaka.extern.ParsedBox ) : number ;
    /**
     * A callback that tells the Mp4 parser to treat the body of a box as a sample
     * description. A sample description box has a fixed number of children. The
     * number of children is represented by a 4 byte unsigned integer. Each child
     * is a box.
     */
    static sampleDescription (box : shaka.extern.ParsedBox ) : any ;
    /**
     * Convert an integer type from a box into an ascii string name.
     * Useful for debugging.
     * @param type The type of the box, a uint32.
     */
    static typeToString (type : number ) : string ;
    /**
     * A callback that tells the Mp4 parser to treat the body of a box as a visual
     * sample entry.  A visual sample entry has some fixed-sized fields
     * describing the video codec parameters, followed by an arbitrary number of
     * appended children.  Each child is a box.
     */
    static visualSampleEntry (box : shaka.extern.ParsedBox ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util.Mp4Parser {
  type CallbackType = (a : shaka.extern.ParsedBox ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class ObjectUtils {
    private noStructuralTyping_shaka_util_ObjectUtils : any;
    /**
     * Constructs a string out of a value, similar to the JSON.stringify method.
     * Unlike that method, this guarantees that the order of the keys in an
     * object is alphabetical, so it can be used as a way to reliably compare two
     * objects.
     */
    static alphabeticalKeyOrderStringify (value : any ) : string ;
    /**
     * Performs a deep clone of the given simple object.  This does not copy
     * prototypes, custom properties (e.g. read-only), or multiple references to
     * the same object.  If the caller needs these fields, it will need to set
     * them after this returns.
     */
    static cloneObject < T > (arg : T ) : T ;
    /**
     * Performs a shallow clone of the given simple object.  This does not copy
     * prototypes or custom properties (e.g. read-only).
     */
    static shallowCloneObject < T > (original : T ) : T ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  /**
   * A utility to combine streams across periods.
   */
  class PeriodCombiner implements shaka.util.IReleasable {
    private noStructuralTyping_shaka_util_PeriodCombiner : any;
    combinePeriods (periods : shaka.extern.Period [] , isDynamic : boolean , isPatchUpdate ? : boolean ) : Promise < any > ;
    /**
     * Deletes a stream from matchedStreams because it is no longer needed
     */
    deleteStream (stream : shaka.extern.Stream | null , periodId : string ) : any ;
    getImageStreams ( ) : shaka.extern.Stream [] ;
    getTextStreams ( ) : shaka.extern.Stream [] ;
    getVariants ( ) : shaka.extern.Variant [] ;
    release ( ) : any ;
    setUseStreamOnce (useOnce : boolean ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class PlayerConfiguration {
    private noStructuralTyping_shaka_util_PlayerConfiguration : any;
    static createDefault ( ) : shaka.extern.PlayerConfiguration ;
    static createDefaultForLL ( ) : object ;
    /**
     * Merges the given configuration changes into the given destination.  This
     * uses the default Player configurations as the template.
     */
    static mergeConfigObjects (destination : shaka.extern.PlayerConfiguration , updates : object , template ? : shaka.extern.PlayerConfiguration ) : boolean ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class StreamUtils {
    private noStructuralTyping_shaka_util_StreamUtils : any;
    static meetsRestrictions (variant : shaka.extern.Variant , restrictions : shaka.extern.Restrictions , maxHwRes : shaka.extern.Resolution ) : boolean ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class StringUtils {
    private noStructuralTyping_shaka_util_StringUtils : any;
    /**
     * Creates a string from the given buffer, auto-detecting the encoding that is
     * being used.  If it cannot detect the encoding, it will throw an exception.
     */
    static fromBytesAutoDetect (data : ArrayBuffer | ArrayBufferView | null ) : string ;
    /**
     * Creates a string from the given buffer as UTF-16 encoding.
     * @param littleEndian true to read little endian, false to read big.
     * @param noThrow true to avoid throwing in cases where we may expect invalid input.  If noThrow is true and the data has an odd length,it will be truncated.
     */
    static fromUTF16 (data : ArrayBuffer | ArrayBufferView | null , littleEndian : boolean , noThrow ? : boolean ) : string ;
    /**
     * Creates a string from the given buffer as UTF-8 encoding.
     */
    static fromUTF8 (data : ArrayBuffer | ArrayBufferView | null ) : string ;
    /**
     * Resets the fromCharCode method's implementation.
     * For debug use.
     */
    static resetFromCharCode ( ) : any ;
    /**
     * Creates a ArrayBuffer from the given string, converting to UTF-16 encoding.
     */
    static toUTF16 (str : string , littleEndian : boolean ) : ArrayBuffer ;
    /**
     * Creates a ArrayBuffer from the given string, converting to UTF-8 encoding.
     */
    static toUTF8 (str : string ) : ArrayBuffer ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  /**
   * A timer allows a single function to be executed at a later time or at
   * regular intervals.
   */
  class Timer {
    private noStructuralTyping_shaka_util_Timer : any;
    constructor (onTick : ( ) => any ) ;
    /**
     * Stop the timer and clear the previous behaviour. The timer is still usable
     * after calling |stop|.
     */
    stop ( ) : any ;
    /**
     * Have the timer call |onTick| after |seconds| has elapsed unless |stop| is
     * called first.
     */
    tickAfter (seconds : number ) : shaka.util.Timer ;
    /**
     * Have the timer call |onTick| every |seconds| until |stop| is called.
     */
    tickEvery (seconds : number ) : shaka.util.Timer ;
    /**
     * Have the timer call |onTick| now.
     */
    tickNow ( ) : shaka.util.Timer ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class TsParser {
    private noStructuralTyping_shaka_util_TsParser : any;
    /**
     * Clear previous data
     */
    clearData ( ) : any ;
    /**
     * Return the audio data
     */
    getAudioData ( ) : shaka.extern.MPEG_PES [] ;
    /**
     * Return the audio and video codecs
     */
    getCodecs ( ) : { audio : string | null , video : string | null } ;
    /**
     * Return the ID3 metadata
     */
    getMetadata ( ) : shaka.extern.ID3Metadata [] ;
    /**
     * Return the start time for the audio and video
     */
    getStartTime (contentType : string ) : number | null ;
    /**
     * Return the video data
     */
    getVideoData (naluProcessing ? : boolean ) : shaka.extern.MPEG_PES [] ;
    /**
     * Return the video information
     */
    getVideoInfo ( ) : { codec : string | null , frameRate : string | null , height : string | null , width : string | null } ;
    /**
     * Return the video data
     */
    getVideoNalus ( ) : shaka.extern.VideoNalu [] ;
    /**
     * Return the video resolution
     */
    getVideoResolution ( ) : { height : string | null , width : string | null } ;
    /**
     * Parse the given data
     */
    parse (data : Uint8Array | null ) : shaka.util.TsParser ;
    /**
     * Parse AVC Nalus
     * The code is based on hls.js
     * Credit to https://github.com/video-dev/hls.js/blob/master/src/demux/tsdemuxer.ts
     */
    parseAvcNalus (pes : shaka.extern.MPEG_PES , nextPes ? : shaka.extern.MPEG_PES | null ) : shaka.extern.VideoNalu [] ;
    /**
     * Parse AVC and HVC Nalus
     * The code is based on hls.js
     * Credit to https://github.com/video-dev/hls.js/blob/master/src/demux/tsdemuxer.ts
     */
    parseNalus (pes : shaka.extern.MPEG_PES , lastInfo : { nalu : shaka.extern.VideoNalu | null , state : number | null } ) : shaka.extern.VideoNalu [] ;
    /**
     * Set the current discontinuity sequence number.
     */
    setDiscontinuitySequence (discontinuitySequence : number ) : any ;
    static Timescale : number ;
    /**
     * Check if the passed data corresponds to an MPEG2-TS
     */
    static probe (data : Uint8Array | null ) : boolean ;
    /**
     * Returns the synchronization offset
     */
    static syncOffset (data : Uint8Array | null ) : number ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/dist/shaka-player.dash.externs.js
declare namespace shaka.util {
  class Uint8ArrayUtils {
    private noStructuralTyping_shaka_util_Uint8ArrayUtils : any;
    /**
     * Concatenate buffers.
     */
    static concat ( ...varArgs : ( ArrayBuffer | ArrayBufferView ) [] ) : Uint8Array ;
    /**
     * Convert a base64 string to a Uint8Array.  Accepts either the standard
     * alphabet or the alternate "base64url" alphabet.
     */
    static fromBase64 (str : string ) : Uint8Array ;
    /**
     * Convert a hex string to a Uint8Array.
     */
    static fromHex (str : string ) : Uint8Array ;
    /**
     * Convert a buffer to a base64 string.  The output will always use the
     * alternate encoding/alphabet also known as "base64url".
     * @param padding If true, pad the output with equals signs. Defaults to true.
     */
    static toBase64 (data : ArrayBuffer | ArrayBufferView , padding ? : boolean ) : string ;
    /**
     * Convert a buffer to a hex string.
     */
    static toHex (data : ArrayBuffer | ArrayBufferView ) : string ;
    /**
     * Convert a buffer to a base64 string. The output will be standard
     * alphabet as opposed to base64url safe alphabet.
     */
    static toStandardBase64 (data : ArrayBuffer | ArrayBufferView ) : string ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/abortable.js
declare namespace shaka.extern {
  /**
   * A representation of an abortable operation.  Note that these are not
   * cancelable.  Cancellation implies undoing what has been done so far,
   * whereas aborting only means that further work is stopped.
   */
  interface IAbortableOperation < T > {
    /**
     * A Promise which represents the underlying operation.  It is resolved when
     * the operation is complete, and rejected if the operation fails or is
     * aborted.  Aborted operations should be rejected with a shaka.util.Error
     * object using the error code OPERATION_ABORTED.
     */
    promise : Promise < T > ;
    /**
     * Can be called by anyone holding this object to abort the underlying
     * operation.  This is not cancellation, and will not necessarily result in
     * any work being undone.  abort() should return a Promise which is resolved
     * when the underlying operation has been aborted.  The returned Promise
     * should never be rejected.
     */
    abort ( ) : Promise < any > ;
    finally (onFinal : (a : boolean ) => any ) : shaka.extern.IAbortableOperation < T > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/abr_manager.js
declare namespace shaka.extern {
  /**
   * An object which selects Streams from a set of possible choices.  This also
   * watches for system changes to automatically adapt for the current streaming
   * requirements.  For example, when the network slows down, this class is in
   * charge of telling the Player which streams to switch to in order to reduce
   * the required bandwidth.
   *
   * This class is given a set of streams to choose from when the Player starts
   * up.  This class should store these and use them to make future decisions
   * about ABR.  It is up to this class how those decisions are made.  All the
   * Player will do is tell this class what streams to choose from.
   */
  interface AbrManager {
    /**
     * Chooses one variant to switch to.  Called by the Player.
     * @param preferFastSwitching If not provided meant "avoid fast switching if possible".
     */
    chooseVariant (preferFastSwitching ? : boolean ) : shaka.extern.Variant ;
    /**
     * Sets the ABR configuration.
     *
     * It is the responsibility of the AbrManager implementation to implement the
     * restrictions behavior described in shaka.extern.AbrConfiguration.
     */
    configure (config : shaka.extern.AbrConfiguration ) : any ;
    /**
     * Disables automatic Stream suggestions. After this, the AbrManager may not
     * call switchCallback().
     */
    disable ( ) : any ;
    /**
     * Enables automatic Variant choices from the last ones passed to setVariants.
     * After this, the AbrManager may call switchCallback() at any time.
     */
    enable ( ) : any ;
    /**
     * Gets an estimate of the current bandwidth in bit/sec.  This is used by the
     * Player to generate stats.
     */
    getBandwidthEstimate ( ) : number ;
    /**
     * Initializes the AbrManager.
     */
    init (switchCallback : shaka.extern.AbrManager.SwitchCallback ) : any ;
    /**
     * Updates manager playback rate.
     */
    playbackRateChanged (rate : number ) : any ;
    /**
     * Request that this object release all internal references.
     */
    release ( ) : any ;
    /**
     * Notifies the AbrManager that a segment has been downloaded (includes MP4
     * SIDX data, WebM Cues data, initialization segments, and media segments).
     * @param deltaTimeMs The duration, in milliseconds, that the request took to complete.
     * @param numBytes The total number of bytes transferred.
     * @param allowSwitch Indicate if the segment is allowed to switch to another stream.
     * @param request A reference to the request
     * @param context A reference to the request context
     */
    segmentDownloaded (deltaTimeMs : number , numBytes : number , allowSwitch : boolean , request ? : shaka.extern.Request , context ? : shaka.extern.RequestContext ) : any ;
    /**
     * Set CMSD manager.
     */
    setCmsdManager (cmsdManager : shaka.util.CmsdManager | null ) : any ;
    /**
     * Set media element.
     */
    setMediaElement (mediaElement : HTMLMediaElement | null ) : any ;
    /**
     * Updates manager's variants collection.
     * Returns true if the variants are updated. Returns false if the variants
     * are equal.
     */
    setVariants (variants : shaka.extern.Variant [] ) : boolean ;
    /**
     * Stops any background timers and frees any objects held by this instance.
     * This will only be called after a call to init.
     */
    stop ( ) : any ;
    /**
     * Notifies the ABR that it is a time to suggest new streams. This is used by
     * the Player when it finishes adding the last partial segment of a fast
     * switching stream.
     */
    trySuggestStreams ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/abr_manager.js
declare namespace shaka.extern.AbrManager {
  /**
   * A factory for creating the abr manager.
   */
  type Factory = ( ) => shaka.extern.AbrManager ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/abr_manager.js
declare namespace shaka.extern.AbrManager {
  /**
   * A callback into the Player that should be called when the AbrManager decides
   * it's time to change to a different variant.
   *
   * The first argument is a variant to switch to.
   *
   * The second argument is an optional boolean. If true, all data will be removed
   * from the buffer, which will result in a buffering event. Unless a third
   * argument is passed.
   *
   * The third argument in an optional number that specifies how much data (in
   * seconds) should be retained when clearing the buffer. This can help achieve
   * a fast switch that doesn't involve a buffering event. A minimum of two video
   * segments should always be kept buffered to avoid temporary hiccups.
   */
  type SwitchCallback = (a : shaka.extern.Variant , b ? : boolean , c ? : number ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/adaptation_set_criteria.js
declare namespace shaka.extern {
  /**
   * An adaptation set criteria is a unit of logic that can take a set of
   * variants and return a subset of variants that should (and can) be
   * adapted between.
   */
  interface AdaptationSetCriteria {
    /**
     * Sets the AdaptationSetCriteria configuration.
     */
    configure (config : shaka.extern.AdaptationSetCriteria.Configuration ) : any ;
    /**
     * Take a set of variants, and return a subset of variants that can be
     * adapted between.
     */
    create (variants : shaka.extern.Variant [] ) : shaka.media.AdaptationSet ;
    /**
     * Gets the current AdaptationSetCriteria configuration.
     */
    getConfiguration ( ) : shaka.extern.AdaptationSetCriteria.Configuration | null ;
    /**
     * Return the result of last create call.
     */
    getLastAdaptationSet ( ) : shaka.media.AdaptationSet | null ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/adaptation_set_criteria.js
declare namespace shaka.extern.AdaptationSetCriteria {
  type Configuration = { activeAudioChannelCount : number , activeAudioCodec : string , audioCodec : string , audioLabel : string , channelCount : number , codecSwitchingStrategy : shaka.config.CodecSwitchingStrategy , hdrLevel : string , language : string , preferredAudioChannelCount : number , preferredAudioCodecs : string [] , role : string , spatialAudio : boolean , videoLabel : string , videoLayout : string , videoRole : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/adaptation_set_criteria.js
declare namespace shaka.extern.AdaptationSetCriteria {
  /**
   * A factory for creating the AdaptationSetCriteria.
   */
  type Factory = ( ) => shaka.extern.AdaptationSetCriteria ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/ads.js
declare namespace shaka.extern {
  type AdCuePoint = { end : number | null , start : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/ads.js
declare namespace shaka.extern {
  type AdInterstitial = { background : string | null , canJump : boolean , clickThroughUrl : string | null , currentVideo : shaka.extern.AdPositionInfo | null , displayOnBackground : boolean , endTime : number | null , groupId : string | null , id : string | null , isSkippable : boolean , loop : boolean , mimeType : string | null , once : boolean , overlay : shaka.extern.AdPositionInfo | null , playoutLimit : number | null , post : boolean , pre : boolean , resumeOffset : number | null , skipFor : number | null , skipOffset : number | null , startTime : number , timelineRange : boolean , uri : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/ads.js
declare namespace shaka.extern {
  type AdPositionInfo = { size : { x : number , y : number } , topLeft : { x : number , y : number } , viewport : { x : number , y : number } } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/ads.js
declare namespace shaka.extern {
  type AdsStats = { averageLoadTime : number , errors : number , loadTimes : number [] , overlayAds : number , playedCompletely : number , skipped : number , started : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/ads.js
declare namespace shaka.extern {
  /**
   * Interface for Ad objects.
   */
  interface IAd extends shaka.util.IReleasable {
    canSkipNow ( ) : boolean ;
    getAdId ( ) : string ;
    getAdvertiserName ( ) : string ;
    getCreativeAdId ( ) : string ;
    getDescription ( ) : string ;
    getDuration ( ) : number ;
    getMediaUrl ( ) : string | null ;
    /**
     * Gets the minimum suggested duration.  Defaults to being equivalent to
     * getDuration() for server-side ads.
     */
    getMinSuggestedDuration ( ) : number ;
    getPodIndex ( ) : number ;
    getPositionInSequence ( ) : number ;
    getRemainingTime ( ) : number ;
    getSequenceLength ( ) : number ;
    getTimeOffset ( ) : number ;
    getTimeUntilSkippable ( ) : number ;
    getTitle ( ) : string ;
    getVastAdId ( ) : string ;
    getVastMediaBitrate ( ) : number ;
    getVastMediaHeight ( ) : number ;
    getVastMediaWidth ( ) : number ;
    getVolume ( ) : number ;
    hasCustomClick ( ) : boolean ;
    isClientRendering ( ) : boolean ;
    isLinear ( ) : boolean ;
    isMuted ( ) : boolean ;
    isPaused ( ) : boolean ;
    isSkippable ( ) : boolean ;
    isUsingAnotherMediaElement ( ) : boolean ;
    needsSkipUI ( ) : boolean ;
    pause ( ) : any ;
    play ( ) : any ;
    resize (width : number , height : number ) : any ;
    setMuted (muted : boolean ) : any ;
    setVolume (volume : number ) : any ;
    skip ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/ads.js
declare namespace shaka.extern {
  /**
   * An object that's responsible for all the ad-related logic
   * in the player.
   */
  interface IAdManager extends EventTarget {
    addAdUrlInterstitial (url : string ) : Promise < any > ;
    addCustomInterstitial (interstitial : shaka.extern.AdInterstitial ) : any ;
    addMediaTailorTrackingUrl (url : string ) : any ;
    /**
     * Called by the Player to provide an updated configuration any time it
     * changes.
     * Must be called at least once before init*().
     */
    configure (config : shaka.extern.AdsConfiguration ) : any ;
    getCuePoints ( ) : shaka.extern.AdCuePoint [] ;
    getInterstitialPlayer ( ) : shaka.Player | null ;
    getServerSideCuePoints ( ) : shaka.extern.AdCuePoint [] ;
    /**
     * Get statistics for the current playback session. If the player is not
     * playing content, this will return an empty stats object.
     */
    getStats ( ) : any ;
    initClientSide (adContainer : HTMLElement , video : HTMLMediaElement , adsRenderingSettings : any | null ) : any ;
    initInterstitial (adContainer : HTMLElement | null , basePlayer : shaka.Player , baseVideo : HTMLMediaElement ) : any ;
    initMediaTailor (adContainer : HTMLElement , networkingEngine : shaka.net.NetworkingEngine , video : HTMLMediaElement ) : any ;
    initServerSide (adContainer : HTMLElement , video : HTMLMediaElement ) : any ;
    onAssetUnload ( ) : any ;
    onCueMetadataChange (value : shaka.extern.MetadataFrame ) : any ;
    onDASHInterstitialMetadata (basePlayer : shaka.Player , baseVideo : HTMLMediaElement , region : shaka.extern.TimelineRegionInfo ) : any ;
    onDashTimedMetadata (region : shaka.extern.TimelineRegionInfo ) : any ;
    onHLSInterstitialMetadata (basePlayer : shaka.Player , baseVideo : HTMLMediaElement , interstitial : shaka.extern.HLSInterstitial ) : any ;
    onHlsTimedMetadata (metadata : shaka.extern.ID3Metadata , timestampOffset : number ) : any ;
    /**
     * Fired when the manifest is updated.
     */
    onManifestUpdated (isLive : boolean ) : any ;
    release ( ) : any ;
    replaceServerSideAdTagParameters (adTagParameters : object | null ) : any ;
    requestClientSideAds (imaRequest : any ) : any ;
    requestMediaTailorStream (url : string , adsParams : object | null , backupUrl ? : string ) : Promise < string > ;
    requestServerSideStream (imaRequest : any , backupUrl ? : string ) : Promise < string > ;
    setLocale (locale : string ) : any ;
    updateClientSideAdsRenderingSettings (adsRenderingSettings : any ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/ads.js
declare namespace shaka.extern.IAdManager {
  /**
   * A factory for creating the ad manager.
   */
  type Factory = ( ) => shaka.extern.IAdManager ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/cea.js
declare namespace shaka.extern {
  type CaptionDecoderPlugin = ( ) => shaka.extern.ICaptionDecoder ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/cea.js
declare namespace shaka.extern {
  type CeaParserPlugin = ( ) => shaka.extern.ICeaParser ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/cea.js
declare namespace shaka.extern {
  /**
   * Interface for decoding inband closed captions from packets.
   */
  interface ICaptionDecoder {
    /**
     * Clears the decoder state completely.
     * Should be used when an action renders the decoder state invalid,
     * e.g. unbuffered seeks.
     */
    clear ( ) : any ;
    /**
     * Decodes all currently extracted packets and then clears them.
     * This should be called once for a set of extracts (see comment on extract).
     */
    decode ( ) : shaka.extern.ICaptionDecoder.ClosedCaption [] ;
    /**
     * Extracts packets and prepares them for decoding. In a given media fragment,
     * all the caption packets found in its SEI messages should be extracted by
     * successive calls to extract(), followed by a single call to decode().
     * @param userDataSeiMessage This is a User Data registered by Rec.ITU-T T.35 SEI message. It is described in sections D.1.6 and D.2.6 of Rec. ITU-T H.264 (06/2019).
     * @param pts PTS when this packet was received, in seconds.
     */
    extract (userDataSeiMessage : Uint8Array , pts : number ) : any ;
    /**
     * Returns the streams that the CEA decoder found.
     */
    getStreams ( ) : string [] ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/cea.js
declare namespace shaka.extern.ICaptionDecoder {
  /**
   * Parsed Cue.
   */
  type ClosedCaption = { cue : shaka.text.Cue , stream : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/cea.js
declare namespace shaka.extern {
  /**
   * Interface for parsing inband closed caption data from MP4 streams.
   */
  interface ICeaParser {
    /**
     * Initializes the parser with init segment data.
     * @param initSegment init segment to parse.
     */
    init (initSegment : ArrayBuffer | ArrayBufferView ) : any ;
    /**
     * Parses the stream and extracts closed captions packets.
     * @param mediaSegment media segment to parse.
     */
    parse (mediaSegment : ArrayBuffer | ArrayBufferView ) : shaka.extern.ICeaParser.CaptionPacket [] ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/cea.js
declare namespace shaka.extern.ICeaParser {
  type CaptionPacket = { packet : Uint8Array , pts : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/codecs.js
declare namespace shaka.extern {
  type MPEG_PES = { data : Uint8Array , dts : number | null , nalus : shaka.extern.VideoNalu [] , packetLength : number , pts : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/codecs.js
declare namespace shaka.extern {
  type SpatialVideoInfo = { hfov : number | null , projection : string | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/codecs.js
declare namespace shaka.extern {
  type VideoNalu = { data : Uint8Array , fullData : Uint8Array , time : number | null , type : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/codecs.js
declare namespace shaka.extern {
  type VideoSample = { data : Uint8Array , dts : number | null , frame : boolean , isKeyframe : boolean , nalus : shaka.extern.VideoNalu [] , pts : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/drm_info.js
declare namespace shaka.extern {
  type DrmInfo = { audioRobustness : string , distinctiveIdentifierRequired : boolean , encryptionScheme : string , initData : shaka.extern.InitDataOverride [] | null , keyIds : Set < string > | null , keySystem : string , keySystemUris ? : Set < string > | null , licenseServerUri : string , persistentStateRequired : boolean , serverCertificate : Uint8Array | null , serverCertificateUri : string , sessionType : string , videoRobustness : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/drm_info.js
declare namespace shaka.extern {
  type InitDataOverride = { initData : Uint8Array , initDataType : string , keyId : string | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/error.js
declare namespace shaka.extern {
  interface Error {
    category : shaka.util.Error.Category ;
    code : shaka.util.Error.Code ;
    data : any [] ;
    handled : boolean ;
    severity : shaka.util.Error.Severity ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/error.js
declare namespace shaka.extern {
  type RestrictionInfo = { hasAppRestrictions : boolean , missingKeys : string [] , restrictedKeyStatuses : string [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  /**
   * Creates a SegmentIndex; returns a Promise that resolves after the
   * SegmentIndex has been created.
   */
  type CreateSegmentIndexFunction = ( ) => Promise < any > ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  /**
   * A function that fetches the crypto keys for AES-128.
   * Returns a promise that resolves when the keys have been fetched.
   */
  type FetchCryptoKeysFunction = ( ) => Promise < any > ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type Manifest = { gapCount : number , ignoreManifestTimestampsInSegmentsMode : boolean , imageStreams : shaka.extern.Stream [] , isLowLatency : boolean , nextUrl : string | null , offlineSessionIds : string [] , periodCount : number , presentationTimeline : shaka.media.PresentationTimeline , sequenceMode : boolean , serviceDescription : shaka.extern.ServiceDescription | null , startTime : number | null , textStreams : shaka.extern.Stream [] , type : string , variants : shaka.extern.Variant [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type MssPrivateData = { codecPrivateData : string | null , duration : number , timescale : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type Period = { audioStreams : shaka.extern.Stream [] , id : string , imageStreams : shaka.extern.Stream [] , textStreams : shaka.extern.Stream [] , videoStreams : shaka.extern.Stream [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  /**
   * SegmentIndex minimal API.
   */
  interface SegmentIndex {
    /**
     * Finds the position of the segment for the given time, in seconds, relative
     * to the start of the presentation.  Returns the position of the segment
     * with the largest end time if more than one segment is known for the given
     * time.
     */
    find (time : number ) : number | null ;
    /**
     * Gets the SegmentReference for the segment at the given position.
     * @param position The position of the segment as returned by find().
     */
    get (position : number ) : shaka.media.SegmentReference | null ;
    /**
     * Gets number of already evicted segments.
     */
    getNumEvicted ( ) : number ;
    /**
     * Get number of references.
     */
    getNumReferences ( ) : number ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type ServiceDescription = { maxLatency : number | null , maxPlaybackRate : number | null , minLatency : number | null , minPlaybackRate : number | null , targetLatency : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type Stream = { accessibilityPurpose : shaka.media.ManifestParser.AccessibilityPurpose | null , audioSamplingRate : number | null , bandwidth ? : number , baseOriginalId : string | null , channelsCount : number | null , closeSegmentIndex ? : ( ) => any , closedCaptions : Map < string , string > | null , codecs : string , colorGamut ? : string , createSegmentIndex : shaka.extern.CreateSegmentIndexFunction , dependencyStream : any , drmInfos : shaka.extern.DrmInfo [] , emsgSchemeIdUris : string [] | null , encrypted : boolean , external : boolean , fastSwitching : boolean , forced : boolean , frameRate ? : number , fullMimeTypes : Set < string > , groupId : string | null , hdr ? : string , height ? : number , id : number , isAudioMuxedInVideo : boolean , keyIds : Set < string > , kind ? : string , label : string | null , language : string , matchedStreams ? : any [] , mimeType : string , mssPrivateData ? : shaka.extern.MssPrivateData , originalId : string | null , originalLanguage : string | null , pixelAspectRatio ? : string , primary : boolean , roles : string [] , segmentIndex : shaka.media.SegmentIndex | null , spatialAudio : boolean , tilesLayout ? : string , trickModeVideo : any , type : string , videoLayout ? : string , width ? : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type ThumbnailSprite = { height : number , positionX : number , positionY : number , width : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type Variant = { allowedByApplication : boolean , allowedByKeySystem : boolean , audio : shaka.extern.Stream | null , bandwidth : number , decodingInfos : ( any | null ) [] , disabledUntilTime : number , id : number , language : string , primary : boolean , video : shaka.extern.Stream | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest.js
declare namespace shaka.extern {
  type aesKey = { bitsKey : number , blockCipherMode : string , cryptoKey ? : webCrypto.CryptoKey | null , fetchKey ? : shaka.extern.CreateSegmentIndexFunction , firstMediaSequenceNumber : number , iv ? : Uint8Array } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest_parser.js
declare namespace shaka.extern {
  /**
   * Parses media manifests and handles manifest updates.
   *
   * Given a URI where the initial manifest is found, a parser will request the
   * manifest, parse it, and return the resulting Manifest object.
   *
   * If the manifest requires updates (e.g. for live media), the parser will use
   * background timers to update the same Manifest object.
   *
   * There are many ways for |start| and |stop| to be called. Implementations
   * should support all cases:
   *
   * BASIC
   * await parser.start(uri, playerInterface);
   * await parser.stop();
   *
   * INTERRUPTING
   * const p = parser.start(uri, playerInterface);
   * await parser.stop();
   * await p;
   *
   * |p| should be rejected with an OPERATION_ABORTED error.
   *
   * STOPPED BEFORE STARTING
   * await parser.stop();
   */
  interface ManifestParser {
    /**
     * Tells the parser that a location should be banned. This is called on
     * retry.
     */
    banLocation (uri : string ) : any ;
    /**
     * Called by the Player to provide an updated configuration any time the
     * configuration changes.  Will be called at least once before start().
     */
    configure (config : shaka.extern.ManifestConfiguration , isPreloadFn ? : ( ) => boolean ) : any ;
    /**
     * Tells the parser that the expiration time of an EME session has changed.
     * Implementing this is optional.
     */
    onExpirationUpdated (sessionId : string , expiration : number ) : any ;
    /**
     * Tells the parser that the initial variant has been chosen.
     */
    onInitialVariantChosen (variant : shaka.extern.Variant ) : any ;
    /**
     * Set media element.
     */
    setMediaElement (mediaElement : HTMLMediaElement | null ) : any ;
    /**
     * Initialize and start the parser. When |start| resolves, it should return
     * the initial version of the manifest. |start| will only be called once. If
     * |stop| is called while |start| is pending, |start| should reject.
     * @param uri The URI of the manifest.
     * @param playerInterface The player interface contains the callbacks and members that the parser can use to communicate with the player and outside world.
     */
    start (uri : string , playerInterface : shaka.extern.ManifestParser.PlayerInterface ) : Promise < shaka.extern.Manifest > ;
    /**
     * Tell the parser that it must stop and free all internal resources as soon
     * as possible. Only once all internal resources are stopped and freed will
     * the promise resolve. Once stopped a parser will not be started again.
     *
     * The parser should support having |stop| called multiple times and the
     * promise should always resolve.
     */
    stop ( ) : Promise < any > ;
    /**
     * Tells the parser to do a manual manifest update.  Implementing this is
     * optional.  This is only called when 'emsg' boxes are present.
     */
    update ( ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest_parser.js
declare namespace shaka.extern.ManifestParser {
  /**
   * A factory for creating the manifest parser.  This function is registered with
   * shaka.media.ManifestParser to create parser instances.
   */
  type Factory = ( ) => shaka.extern.ManifestParser ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/manifest_parser.js
declare namespace shaka.extern.ManifestParser {
  type PlayerInterface = { addFont : (a : string , b : string ) => any , disableStream : (a : shaka.extern.Stream ) => any , filter : (a : shaka.extern.Manifest ) => Promise < any > , getBandwidthEstimate : ( ) => number , isLowLatencyMode : ( ) => boolean , makeTextStreamsForClosedCaptions : (a : shaka.extern.Manifest ) => any , networkingEngine : shaka.net.NetworkingEngine , newDrmInfo : (a : shaka.extern.Stream ) => any , onError : (a : shaka.util.Error ) => any , onEvent : shaka.util.EventManager.ListenerType , onManifestUpdated : ( ) => any , onMetadata : (a : string , b : number , c : number | null , d : shaka.extern.MetadataFrame [] ) => any , onTimelineRegionAdded : (a : shaka.extern.TimelineRegionInfo ) => any , updateDuration : ( ) => any } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/mp4_parser.js
declare namespace shaka.extern {
  type ParsedBox = { flags : number | null , has64BitSize : boolean , name : string , parser : shaka.util.Mp4Parser , partialOkay : boolean , reader : shaka.util.DataViewReader , size : number , start : number , stopOnPartial : boolean , version : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type HeadersReceived = (a : { [ key: string ]: string } ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type ProgressUpdated = (a : number , b : number , c : number ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type Request = { allowCrossSiteCredentials : boolean , body : ArrayBuffer | ArrayBufferView | null , contentType ? : string | null , drmInfo : shaka.extern.DrmInfo | null , headers : { [ key: string ]: string } , initData : Uint8Array | null , initDataType : string | null , licenseRequestType : string | null , method : string , packetNumber ? : number | null , requestStartTime ? : number | null , retryParameters : shaka.extern.RetryParameters , sessionId : string | null , streamDataCallback : ( (a : ArrayBuffer | ArrayBufferView ) => Promise < any > ) | null , timeToFirstByte ? : number | null , uris : string [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type RequestContext = { isPreload ? : boolean , segment ? : shaka.media.SegmentReference | null , stream ? : shaka.extern.Stream , type ? : shaka.net.NetworkingEngine.AdvancedRequestType } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  /**
   * Defines a filter for requests.  This filter takes the request and modifies
   * it before it is sent to the scheme plugin.
   * The RequestType describes the basic type of the request (manifest, segment,
   * etc). The optional RequestContext will be provided where applicable to
   * provide additional information about the request. A request filter can run
   * asynchronously by returning a promise; in this case, the request will not be
   * sent until the promise is resolved.
   */
  type RequestFilter = (a : shaka.net.NetworkingEngine.RequestType , b : shaka.extern.Request , c ? : shaka.extern.RequestContext ) => Promise < any > | void ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type Response = { data : ArrayBuffer | ArrayBufferView , fromCache ? : boolean , headers : { [ key: string ]: string } , originalRequest : shaka.extern.Request , originalUri : string , status ? : number , timeMs ? : number , uri : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  /**
   * Defines a filter for responses.  This filter takes the response and modifies
   * it before it is returned.
   * The RequestType describes the basic type of the request (manifest, segment,
   * etc). The optional RequestContext will be provided where applicable to
   * provide additional information about the request. A response filter can run
   * asynchronously by returning a promise.
   */
  type ResponseFilter = (a : shaka.net.NetworkingEngine.RequestType , b : shaka.extern.Response , c ? : shaka.extern.RequestContext ) => Promise < any > | void ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type RetryParameters = { backoffFactor : number , baseDelay : number , connectionTimeout : number , fuzzFactor : number , maxAttempts : number , stallTimeout : number , timeout : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type SchemePlugin = (a : string , b : shaka.extern.Request , c : shaka.net.NetworkingEngine.RequestType , d : shaka.extern.ProgressUpdated , e : shaka.extern.HeadersReceived , f : shaka.extern.SchemePluginConfig ) => shaka.extern.IAbortableOperation < shaka.extern.Response > ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/net.js
declare namespace shaka.extern {
  type SchemePluginConfig = { minBytesForProgressEvents ? : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type EmeSessionDB = { audioCapabilities : { contentType : string , robustness : string } [] , keySystem : string , licenseUri : string , serverCertificate : Uint8Array | null , sessionId : string , videoCapabilities : { contentType : string , robustness : string } [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  /**
   * Similar to storage cells (shaka.extern.StorageCell), an EmeSessionStorageCell
   * stores data persistently.  This only stores the license's session info, not
   * the license itself.  The license itself is stored using EME.
   */
  interface EmeSessionStorageCell {
    /**
     * Adds the given sessions to the store.
     */
    add (sessions : shaka.extern.EmeSessionDB [] ) : Promise < any > ;
    /**
     * Free all resources used by this cell. This won't affect the stored content.
     */
    destroy ( ) : Promise < any > ;
    /**
     * Gets the currently stored sessions.
     */
    getAll ( ) : Promise < shaka.extern.EmeSessionDB [] > ;
    /**
     * Removes the given session IDs from the store.
     */
    remove (sessionIds : string [] ) : Promise < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type ManifestDB = { appMetadata : object | null , creationTime : number , drmInfo : shaka.extern.DrmInfo | null , duration : number , expiration : number , isIncomplete ? : boolean , originalManifestUri : string , sequenceMode ? : boolean , sessionIds : string [] , size : number , streams : shaka.extern.StreamDB [] , type ? : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type OfflineSupport = { basic : boolean , encrypted : { [ key: string ]: boolean } } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type SegmentDB = { appendWindowEnd : number , appendWindowStart : number , codecs : string | null , dataKey : number , endTime : number , initSegmentKey : number | null , mimeType : string | null , pendingInitSegmentRefId ? : string , pendingSegmentRefId ? : string , startTime : number , thumbnailSprite : shaka.media.SegmentReference.ThumbnailSprite | null , tilesLayout : string | null , timestampOffset : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type SegmentDataDB = { data : ArrayBuffer } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  /**
   * An interface that defines access to collection of segments and manifests. All
   * methods are designed to be batched operations allowing the implementations to
   * optimize their operations based on how they store data.
   *
   * The storage cell is one of two exposed APIs used to control where and how
   * offline content is saved. The storage cell is responsible for converting
   * information between its internal structures and the external (library)
   * structures.
   */
  interface StorageCell {
    /**
     * Add a group of manifests. Will return a promise that resolves with a list
     * of keys for each manifest. If one manifest fails to be added, all manifests
     * should fail to be added.
     */
    addManifests (manifests : shaka.extern.ManifestDB [] ) : Promise < number [] > ;
    /**
     * Add a group of segments. Will return a promise that resolves with a list
     * of keys for each segment. If one segment fails to be added, all segments
     * should fail to be added.
     */
    addSegments (segments : shaka.extern.SegmentDataDB [] ) : Promise < number [] > ;
    /**
     * Free all resources used by this cell. This should not affect the stored
     * content.
     */
    destroy ( ) : Promise < any > ;
    /**
     * Get all manifests stored in this cell. Since manifests are small compared
     * to the asset they describe, it is assumed that it is feasible to have them
     * all in main memory at one time.
     */
    getAllManifests ( ) : Promise < Map < number , shaka.extern.ManifestDB > > ;
    /**
     * Get a group of manifests using their keys to identify them. If any key is
     * not found, the promise chain will be rejected.
     */
    getManifests (keys : number [] ) : Promise < shaka.extern.ManifestDB [] > ;
    /**
     * Get a group of segments using their keys to identify them. If any key is
     * not found, the promise chain will be rejected.
     */
    getSegments (keys : number [] ) : Promise < shaka.extern.SegmentDataDB [] > ;
    /**
     * Check if the cell can support new keys. If a cell has a fixed key space,
     * then all add-operations will fail as no new keys can be added. All
     * remove-operations and update-operations should still work.
     */
    hasFixedKeySpace ( ) : boolean ;
    /**
     * Remove a group of manifests using their keys to identify them. If a key
     * is not found, then that removal should be considered successful.
     * @param onRemove A callback for when a manifest is removed from the cell. The key of the manifest will be passed to the callback.
     */
    removeManifests (keys : number [] , onRemove : (a : number ) => any ) : Promise < any > ;
    /**
     * Remove a group of segments using their keys to identify them. If a key
     * is not found, then that removal should be considered successful.
     * @param onRemove A callback for when a segment is removed from the cell. The key of the segment will be passed to the callback.
     */
    removeSegments (keys : number [] , onRemove : (a : number ) => any ) : Promise < any > ;
    /**
     * Updates the given manifest, stored at the given key.
     */
    updateManifest (key : number , manifest : shaka.extern.ManifestDB ) : Promise < any > ;
    /**
     * Replace the expiration time of the manifest stored under |key| with
     * |newExpiration|. If no manifest is found under |key| then this should
     * act as a no-op.
     */
    updateManifestExpiration (key : number , expiration : number ) : Promise < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  /**
   * Storage mechanisms are one of two exported storage APIs. Storage mechanisms
   * are groups of storage cells (shaka.extern.StorageCell). Storage mechanisms
   * are responsible for managing the life cycle of resources shared between
   * storage cells in the same block.
   *
   * For example, a storage mechanism may manage a single database connection
   * while each cell would manage different tables in the database via the same
   * connection.
   */
  interface StorageMechanism {
    /**
     * Free all resources used by the storage mechanism and its cells. This should
     * not affect the stored content.
     */
    destroy ( ) : Promise < any > ;
    /**
     * Erase all content from storage and leave storage in an empty state. Erase
     * may be called with or without |init|.  This allows for storage to be wiped
     * in case of a version mismatch.
     *
     * After calling |erase|, the mechanism will be in an initialized state.
     */
    erase ( ) : Promise < any > ;
    /**
     * Get a map of all the cells managed by the storage mechanism. Editing the
     * map should have no effect on the storage mechanism. The map key is the
     * cell's address in the mechanism and should be consistent between calls to
     * |getCells|.
     */
    getCells ( ) : Map < string , shaka.extern.StorageCell > ;
    /**
     * Get the current EME session storage cell.
     */
    getEmeSessionCell ( ) : shaka.extern.EmeSessionStorageCell ;
    /**
     * Initialize the storage mechanism for first use. This should only be called
     * once. Calling |init| multiple times has an undefined behaviour.
     */
    init ( ) : Promise < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type StoredContent = { appMetadata : object | null , duration : number , expiration : number , isIncomplete : boolean , offlineUri : string | null , originalManifestUri : string , size : number , tracks : shaka.extern.TrackList } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline.js
declare namespace shaka.extern {
  type StreamDB = { audioSamplingRate : number | null , channelsCount : number | null , closedCaptions : Map < string , string > | null , codecs : string , colorGamut ? : string , encrypted : boolean , external : boolean , fastSwitching : boolean , forced : boolean , frameRate ? : number , groupId : string | null , hdr ? : string , height : number | null , id : number , isAudioMuxedInVideo : boolean , keyIds : Set < string > , kind ? : string , label : string | null , language : string , mimeType : string , mssPrivateData ? : shaka.extern.MssPrivateData , originalId : string | null , originalLanguage ? : string | null , pixelAspectRatio ? : string , primary : boolean , roles : string [] , segments : shaka.extern.SegmentDB [] , spatialAudio : boolean , tilesLayout ? : string , type : string , variantIds : number [] , videoLayout ? : string , width : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v1.js
declare namespace shaka.extern {
  type ManifestDBV1 = { appMetadata : object | null , drmInfo : shaka.extern.DrmInfo | null , duration : number , expiration : number , key : number , originalManifestUri : string , periods : shaka.extern.PeriodDBV1 [] , sessionIds : string [] , size : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v1.js
declare namespace shaka.extern {
  type PeriodDBV1 = { startTime : number , streams : shaka.extern.StreamDBV1 [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v1.js
declare namespace shaka.extern {
  type SegmentDBV1 = { endTime : number , startTime : number , uri : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v1.js
declare namespace shaka.extern {
  type SegmentDataDBV1 = { data : ArrayBuffer , key : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v1.js
declare namespace shaka.extern {
  type StreamDBV1 = { codecs : string , contentType : string , encrypted : boolean , frameRate ? : number , height : number | null , id : number , initSegmentUri : string | null , keyId : string | null , kind ? : string , label : string | null , language : string , mimeType : string , presentationTimeOffset : number , primary : boolean , segments : shaka.extern.SegmentDBV1 [] , variantIds : number [] , width : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v2.js
declare namespace shaka.extern {
  type ManifestDBV2 = { appMetadata : object | null , drmInfo : shaka.extern.DrmInfo | null , duration : number , expiration : number , originalManifestUri : string , periods : shaka.extern.PeriodDBV2 [] , sessionIds : string [] , size : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v2.js
declare namespace shaka.extern {
  type PeriodDBV2 = { startTime : number , streams : shaka.extern.StreamDBV2 [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v2.js
declare namespace shaka.extern {
  type SegmentDBV2 = { dataKey : number , endTime : number , startTime : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v2.js
declare namespace shaka.extern {
  type SegmentDataDBV2 = { data : ArrayBuffer } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/offline_compat_v2.js
declare namespace shaka.extern {
  type StreamDBV2 = { codecs : string , contentType : string , encrypted : boolean , frameRate ? : number , height : number | null , id : number , initSegmentKey : number | null , keyId : string | null , kind ? : string , label : string | null , language : string , mimeType : string , originalId : string | null , pixelAspectRatio ? : string , presentationTimeOffset : number , primary : boolean , segments : shaka.extern.SegmentDBV2 [] , variantIds : number [] , width : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type AbrConfiguration = { advanced : shaka.extern.AdvancedAbrConfiguration , bandwidthDowngradeTarget : number , bandwidthUpgradeTarget : number , cacheLoadThreshold : number , clearBufferSwitch : boolean , defaultBandwidthEstimate : number , enabled : boolean , ignoreDevicePixelRatio : boolean , minTimeToSwitch : number , preferNetworkInformationBandwidth : boolean , removeLatencyFromFirstPacketTime : boolean , restrictToElementSize : boolean , restrictToScreenSize : boolean , restrictions : shaka.extern.Restrictions , safeMarginSwitch : number , switchInterval : number , useNetworkInformation : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type AdsConfiguration = { allowPreloadOnDomElements : boolean , allowStartInMiddleOfInterstitial : boolean , customPlayheadTracker : boolean , disableDASHInterstitial : boolean , disableHLSInterstitial : boolean , skipPlayDetection : boolean , supportsMultipleMediaElements : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type AdvancedAbrConfiguration = { fastHalfLife : number , minBytes : number , minTotalBytes : number , slowHalfLife : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type AdvancedDrmConfiguration = { audioRobustness : string [] | null , distinctiveIdentifierRequired : boolean , headers : { [ key: string ]: string } , individualizationServer : string , persistentStateRequired : boolean , serverCertificate : Uint8Array | null , serverCertificateUri : string , sessionType : string , videoRobustness : string [] | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type AudioTrack = { accessibilityPurpose : shaka.media.ManifestParser.AccessibilityPurpose | null , active : boolean , audioSamplingRate : number | null , channelsCount : number | null , codecs : string | null , label : string | null , language : string , mimeType : string | null , originalLanguage : string | null , primary : boolean , roles : string [] , spatialAudio : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type BufferedInfo = { audio : shaka.extern.BufferedRange [] , text : shaka.extern.BufferedRange [] , total : shaka.extern.BufferedRange [] , video : shaka.extern.BufferedRange [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type BufferedRange = { end : number , start : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type Chapter = { endTime : number , id : string , startTime : number , title : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type CmcdConfiguration = { contentId : string , enabled : boolean , includeKeys : string [] , rtpSafetyFactor : number , sessionId : string , targets : shaka.extern.CmcdTarget [] | null , useHeaders : boolean , version : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type CmcdTarget = { enabled : boolean , events : string [] , includeKeys : string [] , mode : string , timeInterval : number , url : string , useHeaders : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type CmsdConfiguration = { applyMaximumSuggestedBitrate : boolean , enabled : boolean , estimatedThroughputWeightRatio : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type DashManifestConfiguration = { autoCorrectDrift : boolean , clockSyncUri : string , disableXlinkProcessing : boolean , enableFastSwitching : boolean , ignoreEmptyAdaptationSet : boolean , ignoreMaxSegmentDuration : boolean , ignoreMinBufferTime : boolean , ignoreSuggestedPresentationDelay : boolean , initialSegmentLimit : number , keySystemsByURI : { [ key: string ]: string } , manifestPreprocessor : (a : Element ) => any , manifestPreprocessorTXml : (a : shaka.extern.xml.Node ) => any , sequenceMode : boolean , useStreamOnceInPeriodFlattening : boolean , xlinkFailGracefully : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type DrmConfiguration = { advanced : { [ key: string ]: shaka.extern.AdvancedDrmConfiguration } | null , clearKeys : { [ key: string ]: string } , defaultAudioRobustnessForWidevine : string , defaultVideoRobustnessForWidevine : string , delayLicenseRequestUntilPlayed : boolean , ignoreDuplicateInitData : boolean , initDataTransform ? : shaka.extern.InitDataTransform , keySystemsMapping : { [ key: string ]: string } , logLicenseExchange : boolean , minHdcpVersion : string , parseInbandPsshEnabled : boolean , persistentSessionOnlinePlayback : boolean , persistentSessionsMetadata : shaka.extern.PersistentSessionMetadata [] , preferredKeySystems : string [] , retryParameters : shaka.extern.RetryParameters , servers : { [ key: string ]: string } , updateExpirationTime : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type DrmSessionMetadata = { initData : Uint8Array | null , initDataType : string | null , sessionId : string , sessionType : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type DrmSupportType = { audioRobustnessLevels : string [] , encryptionSchemes : ( string | null ) [] , minHdcpVersions : string [] , persistentState : boolean , videoRobustnessLevels : string [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type DynamicTargetLatencyConfiguration = { enabled : boolean , maxAttempts : number , maxLatency : number , minLatency : number , rebufferIncrement : number , stabilityThreshold : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type EmsgInfo = { endTime : number , eventDuration : number , id : number , messageData : Uint8Array | null , presentationTimeDelta : number , schemeIdUri : string , startTime : number , timescale : number , value : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type EmsgTimelineRegionInfo = { emsg : shaka.extern.EmsgInfo , endTime : number , id : string , schemeIdUri : string , startTime : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type ExtraChapter = { language : string , mime : string , uri : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type ExtraText = { codecs ? : string , kind : string , language : string , mime : string , uri : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type HLSInterstitial = { endTime : number | null , startTime : number , values : shaka.extern.MetadataFrame [] } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type HlsManifestConfiguration = { allowLowLatencyByteRangeOptimization : boolean , allowRangeRequestsToGuessMimeType : boolean , defaultAudioCodec : string , defaultVideoCodec : string , disableClosedCaptionsDetection : boolean , disableCodecGuessing : boolean , ignoreImageStreamFailures : boolean , ignoreManifestProgramDateTime : boolean , ignoreManifestProgramDateTimeForTypes : string [] , ignoreManifestTimestampsInSegmentsMode : boolean , ignoreTextStreamFailures : boolean , liveSegmentsDelay : number , mediaPlaylistFullMimeType : string , sequenceMode : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type ID3Metadata = { cueTime : number | null , data : Uint8Array , dts : number | null , frames : shaka.extern.MetadataFrame [] , pts : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type ImageTrack = { bandwidth : number , codecs : string | null , height : number | null , id : number , mimeType : string | null , originalImageId : string | null , tilesLayout : string | null , type : string , width : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type InitDataTransform = (a : Uint8Array , b : string , c : shaka.extern.DrmInfo | null ) => Uint8Array ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type LanguageRole = { label : string | null , language : string , role : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type LcevcConfiguration = { drawLogo : boolean , dynamicPerformanceScaling : boolean , enabled : boolean , logLevel : number , poster : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type LiveSyncConfiguration = { dynamicTargetLatency : shaka.extern.DynamicTargetLatencyConfiguration , enabled : boolean , maxPlaybackRate : number , minPlaybackRate : number , panicMode : boolean , panicThreshold : number , targetLatency : number , targetLatencyTolerance : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type ManifestConfiguration = { availabilityWindowOverride : number , continueLoadingWhenPaused : boolean , dash : shaka.extern.DashManifestConfiguration , defaultPresentationDelay : number , disableAudio : boolean , disableIFrames : boolean , disableText : boolean , disableThumbnails : boolean , disableVideo : boolean , enableAudioGroups : boolean , hls : shaka.extern.HlsManifestConfiguration , ignoreDrmInfo : boolean , ignoreSupplementalCodecs : boolean , mss : shaka.extern.MssManifestConfiguration , raiseFatalErrorOnManifestUpdateRequestFailure : boolean , retryParameters : shaka.extern.RetryParameters , segmentRelativeVttTiming : boolean , updatePeriod : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type MediaQualityInfo = { audioSamplingRate : number | null , bandwidth : number , channelsCount : number | null , codecs : string , contentType : string , frameRate : number | null , height : number | null , label : string | null , language : string | null , mimeType : string | null , pixelAspectRatio : string | null , roles : string [] | null , width : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type MediaSourceConfiguration = { addExtraFeaturesToSourceBuffer : (a : string ) => string , codecSwitchingStrategy : shaka.config.CodecSwitchingStrategy , correctEc3Enca : boolean , dispatchAllEmsgBoxes : boolean , durationReductionEmitsUpdateEnd : boolean , forceTransmux : boolean , insertFakeEncryptionInInit : boolean , modifyCueCallback : shaka.extern.TextParser.ModifyCueCallback , useSourceElements : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type MetadataFrame = { data : ArrayBuffer | null | string | number , description : string , key : string , mimeType : string | null , pictureType : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type MetadataRawFrame = { data : Uint8Array | null , size : number , type : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type MetadataTimelineRegionInfo = { endTime : number , id : string , payload : shaka.extern.MetadataFrame , schemeIdUri : string , startTime : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type MssManifestConfiguration = { keySystemsBySystemId : { [ key: string ]: string } , manifestPreprocessor : (a : Element ) => any , manifestPreprocessorTXml : (a : shaka.extern.xml.Node ) => any , sequenceMode : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type NetworkingConfiguration = { forceHTTP : boolean , forceHTTPS : boolean , minBytesForProgressEvents : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type OfflineConfiguration = { downloadSizeCallback : (a : number ) => Promise < boolean > , numberOfParallelDownloads : number , progressCallback : (a : shaka.extern.StoredContent , b : number ) => any , trackSelectionCallback : (a : shaka.extern.TrackList ) => Promise < shaka.extern.TrackList > , usePersistentLicense : boolean } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type PersistentSessionMetadata = { initData : Uint8Array | null , initDataType : string | null , sessionId : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type PlaybackInfo = { audio : shaka.extern.PlaybackStreamInfo | null , text : shaka.extern.PlaybackStreamInfo | null , video : shaka.extern.PlaybackStreamInfo | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type PlaybackStreamInfo = { bandwidth : number , codecs : string , height : number | null , mimeType : string , width : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type PlayerConfiguration = { abr : shaka.extern.AbrConfiguration , abrFactory : shaka.extern.AbrManager.Factory , adaptationSetCriteriaFactory : shaka.extern.AdaptationSetCriteria.Factory , ads : shaka.extern.AdsConfiguration , autoShowText : shaka.config.AutoShowText , cmcd : shaka.extern.CmcdConfiguration , cmsd : shaka.extern.CmsdConfiguration , drm : shaka.extern.DrmConfiguration , ignoreHardwareResolution : boolean , lcevc : shaka.extern.LcevcConfiguration , manifest : shaka.extern.ManifestConfiguration , mediaSource : shaka.extern.MediaSourceConfiguration , networking : shaka.extern.NetworkingConfiguration , offline : shaka.extern.OfflineConfiguration , playRangeEnd : number , playRangeStart : number , preferForcedSubs : boolean , preferSpatialAudio : boolean , preferredAudioChannelCount : number , preferredAudioCodecs : string [] , preferredAudioLabel : string , preferredAudioLanguage : string , preferredAudioRole : string , preferredDecodingAttributes : string [] , preferredTextFormats : string [] , preferredTextLanguage : string , preferredTextRole : string , preferredVideoCodecs : string [] , preferredVideoHdrLevel : string , preferredVideoLabel : string , preferredVideoLayout : string , preferredVideoRole : string , queue : shaka.extern.QueueConfiguration , restrictions : shaka.extern.Restrictions , streaming : shaka.extern.StreamingConfiguration , textDisplayFactory : shaka.extern.TextDisplayer.Factory , textDisplayer : shaka.extern.TextDisplayerConfiguration } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type ProducerReferenceTime = { programStartDate : Date | null , wallClockTime : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type QueueConfiguration = { preloadNextUrlWindow : number , preloadPrevItem : boolean , repeatMode : shaka.config.RepeatMode } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type Restrictions = { maxBandwidth : number , maxChannelsCount : number , maxFrameRate : number , maxHeight : number , maxPixels : number , maxWidth : number , minBandwidth : number , minChannelsCount : number , minFrameRate : number , minHeight : number , minPixels : number , minWidth : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type StateChange = { duration : number , state : string , timestamp : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type Stats = { bufferingTime : number , bytesDownloaded : number , completionPercent : number , corruptedFrames : number , currentCodecs : string , decodedFrames : number , drmTimeSeconds : number , droppedFrames : number , estimatedBandwidth : number , gapsJumped : number , height : number , licenseTime : number , liveLatency : number , loadLatency : number , manifestGapCount : number , manifestPeriodCount : number , manifestSizeBytes : number , manifestTimeSeconds : number , maxSegmentDuration : number , nonFatalErrorCount : number , pauseTime : number , playTime : number , stallsDetected : number , stateHistory : shaka.extern.StateChange [] , streamBandwidth : number , switchHistory : shaka.extern.TrackChoice [] , width : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type StreamingConfiguration = { allowMediaSourceRecoveries : boolean , alwaysStreamText : boolean , avoidEvictionOnQuotaExceededError : boolean , bufferBehind : number , bufferingGoal : number , clearDecodingCache : boolean , crossBoundaryStrategy : shaka.config.CrossBoundaryStrategy , disableAudioPrefetch : boolean , disableTextPrefetch : boolean , disableVideoPrefetch : boolean , dontChooseCodecs : boolean , durationBackoff : number , evictionGoal : number , failureCallback : (a : shaka.util.Error ) => any , gapDetectionThreshold : number , gapJumpTimerTime : number , gapPadding : number , ignoreTextStreamFailures : boolean , inaccurateManifestTolerance : number , liveSync : shaka.extern.LiveSyncConfiguration , loadTimeout : number , lowLatencyMode : boolean , maxDisabledTime : number , minTimeBetweenRecoveries : number , observeQualityChanges : boolean , preferNativeDash : boolean , preferNativeHls : boolean , prefetchAudioLanguages : string [] , preloadNextUrlWindow : number , rebufferingGoal : number , retryParameters : shaka.extern.RetryParameters , returnToEndOfLiveWindowWhenOutside : boolean , safeSeekEndOffset : number , safeSeekOffset : number , segmentPrefetchLimit : number , shouldFixTimestampOffset : boolean , stallEnabled : boolean , stallSkip : number , stallThreshold : number , startAtSegmentBoundary : boolean , updateIntervalSeconds : number , useNativeHlsForFairPlay : boolean , vodDynamicPlaybackRate : boolean , vodDynamicPlaybackRateBufferRatio : number , vodDynamicPlaybackRateLowBufferRate : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type SupportType = { drm : { [ key: string ]: shaka.extern.DrmSupportType | null } , hardwareResolution : shaka.extern.Resolution , manifest : { [ key: string ]: boolean } , media : { [ key: string ]: boolean } } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type TextDisplayerConfiguration = { captionsUpdatePeriod : number , fontScaleFactor : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type TextTrack = { accessibilityPurpose : shaka.media.ManifestParser.AccessibilityPurpose | null , active : boolean , bandwidth : number , codecs : string | null , forced : boolean , id : number , kind : string | null , label : string | null , language : string , mimeType : string | null , originalLanguage : string | null , originalTextId : string | null , primary : boolean , roles : string [] , type : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type Thumbnail = { codecs : string | null , duration : number , endByte : number | null , height : number , imageHeight : number , imageWidth : number , mimeType : string | null , positionX : number , positionY : number , segment : shaka.media.SegmentReference | null , sprite : boolean , startByte : number , startTime : number , uris : string [] , width : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type TimelineRegionInfo = { endTime : number , eventElement : Element | null , eventNode : shaka.extern.xml.Node | null , id : string , schemeIdUri : string , startTime : number , timescale : number , value : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type Track = { accessibilityPurpose : shaka.media.ManifestParser.AccessibilityPurpose | null , active : boolean , audioBandwidth : number | null , audioCodec : string | null , audioGroupId : string | null , audioId : number | null , audioMimeType : string | null , audioRoles : string [] | null , audioSamplingRate : number | null , bandwidth : number , channelsCount : number | null , codecs : string | null , colorGamut : string | null , forced : boolean , frameRate : number | null , hdr : string | null , height : number | null , id : number , kind : string | null , label : string | null , language : string , mimeType : string | null , originalAudioId : string | null , originalImageId : string | null , originalLanguage : string | null , originalTextId : string | null , originalVideoId : string | null , pixelAspectRatio : string | null , primary : boolean , roles : string [] , spatialAudio : boolean , tilesLayout : string | null , type : string , videoBandwidth : number | null , videoCodec : string | null , videoId : number | null , videoLabel : string | null , videoLayout : string | null , videoMimeType : string | null , videoRoles : string [] | null , width : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type TrackChoice = { bandwidth : number | null , fromAdaptation : boolean , id : number , timestamp : number , type : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type TrackList = shaka.extern.Track [] ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern {
  type VideoTrack = { active : boolean , bandwidth : number , codecs : string | null , colorGamut : string | null , frameRate : number | null , hdr : string | null , height : number | null , label : string | null , mimeType : string | null , pixelAspectRatio : string | null , roles : string [] , videoLayout : string | null , width : number | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/player.js
declare namespace shaka.extern.xml {
  type Node = { attributes : { [ key: string ]: string } , children : any [] , parent : any , tagName : string } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/queue.js
declare namespace shaka.extern {
  /**
   * An object that's responsible for all the queue-related logic
   * in the player.
   */
  interface IQueueManager extends shaka.util.IDestroyable, EventTarget {
    /**
     * Called by the Player to provide an updated configuration any time it
     * changes.
     */
    configure (config : shaka.extern.QueueConfiguration ) : any ;
    destroy ( ) : Promise < any > ;
    /**
     * Returns the current configuration.
     */
    getConfiguration ( ) : shaka.extern.QueueConfiguration | null ;
    /**
     * Returns the current item.
     */
    getCurrentItem ( ) : shaka.extern.QueueItem | null ;
    /**
     * Returns the index of the current playing item.
     */
    getCurrentItemIndex ( ) : number ;
    /**
     * Returns all items.
     */
    getItems ( ) : shaka.extern.QueueItem [] ;
    /**
     * Insert new items in the current queue.
     */
    insertItems (items : shaka.extern.QueueItem [] ) : any ;
    /**
     * Plays a item number in the queue.
     */
    playItem (itemIndex : number ) : Promise < any > ;
    /**
     * Remove all items.
     */
    removeAllItems ( ) : Promise < any > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/queue.js
declare namespace shaka.extern.IQueueManager {
  /**
   * A factory for creating the queue manager.
   */
  type Factory = (a : shaka.Player | null ) => shaka.extern.IQueueManager ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/queue.js
declare namespace shaka.extern {
  type QueueItem = { config : shaka.extern.PlayerConfiguration | null , extraChapter : shaka.extern.ExtraChapter [] | null , extraText : shaka.extern.ExtraText [] | null , extraThumbnail : string [] | null , manifestUri : string , mimeType : string | null , preloadManager : shaka.media.PreloadManager | null , startTime : number | Date | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/resolution.js
declare namespace shaka.extern {
  type Resolution = { height : number , width : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/text.js
declare namespace shaka.extern {
  interface TextDisplayer extends shaka.util.IDestroyable {
    /**
     * Append given text cues to the list of cues to be displayed.
     * @param cues Text cues to be appended.
     */
    append (cues : shaka.text.Cue [] ) : any ;
    /**
     * Sets the TextDisplayer configuration.
     */
    configure (config : shaka.extern.TextDisplayerConfiguration ) : any ;
    destroy ( ) : Promise < any > ;
    /**
     * Enable the current text displayer.
     */
    enableTextDisplayer ( ) : any ;
    /**
     * Returns true if text is currently visible.
     */
    isTextVisible ( ) : boolean ;
    /**
     * Remove all cues that are fully contained by the given time range (relative
     * to the presentation). <code>endTime</code> will be greater to equal to
     * <code>startTime</code>.  <code>remove</code> should only return
     * <code>false</code> if the displayer has been destroyed. If the displayer
     * has not been destroyed <code>remove</code> should return <code>true</code>.
     */
    remove (startTime : number , endTime : number ) : boolean ;
    /**
     * Set the current language.
     */
    setTextLanguage (language : string ) : any ;
    /**
     * Set text visibility.
     */
    setTextVisibility (on : boolean ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/text.js
declare namespace shaka.extern.TextDisplayer {
  /**
   * A factory for creating a TextDisplayer.
   */
  type Factory = ( ) => shaka.extern.TextDisplayer ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/text.js
declare namespace shaka.extern {
  /**
   * An interface for plugins that parse text tracks.
   */
  interface TextParser {
    /**
     * Parse an initialization segment. Some formats do not have init
     * segments so this won't always be called.
     * @param data The data that makes up the init segment.
     */
    parseInit (data : Uint8Array ) : any ;
    /**
     * Parse a media segment and return the cues that make up the segment.
     * @param data The next section of buffer.
     * @param timeContext The time information that should be used to adjust the times values for each cue.
     * @param uri The media uri.
     */
    parseMedia (data : Uint8Array , timeContext : shaka.extern.TextParser.TimeContext , uri : string | undefined | null , images : string [] ) : shaka.text.Cue [] ;
    /**
     * Notifies the manifest type.
     */
    setManifestType (manifestType : string ) : any ;
    /**
     * Notifies the stream if the manifest is in sequence mode or not.
     */
    setSequenceMode (sequenceMode : boolean ) : any ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/text.js
declare namespace shaka.extern.TextParser {
  /**
   * A callback used for editing cues before appending.
   * Provides the cue, the URI of the captions file the cue was parsed from, and
   * the time context that was used when generating that cue.
   * You can edit the cue object passed in.
   */
  type ModifyCueCallback = (a : shaka.text.Cue , b : string | null , c : shaka.extern.TextParser.TimeContext ) => any ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/text.js
declare namespace shaka.extern.TextParser {
  /**
   * A collection of time offsets used to adjust text cue times.
   */
  type TimeContext = { periodStart : number , segmentEnd : number , segmentStart : number , vttOffset : number } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/text.js
declare namespace shaka.extern {
  type TextParserPlugin = ( ) => shaka.extern.TextParser ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/transmuxer.js
declare namespace shaka.extern {
  /**
   * An interface for transmuxer plugins.
   */
  interface Transmuxer {
    /**
     * For any stream, convert its codecs to MP4 codecs.
     */
    convertCodecs (contentType : string , mimeType : string ) : string ;
    /**
     * Destroy
     */
    destroy ( ) : any ;
    /**
     * Returns the original mimetype of the transmuxer.
     */
    getOriginalMimeType ( ) : string ;
    /**
     * Check if the mime type and the content type is supported.
     */
    isSupported (mimeType : string , contentType ? : string ) : boolean ;
    /**
     * Transmux a input data to MP4.
     * @param reference The segment reference, or null for init segments
     */
    transmux (data : ArrayBuffer | ArrayBufferView , stream : shaka.extern.Stream , reference : shaka.media.SegmentReference | null , duration : number , contentType : string ) : Promise < Uint8Array | shaka.extern.TransmuxerOutput > ;
  }
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/transmuxer.js
declare namespace shaka.extern {
  type TransmuxerOutput = { data : Uint8Array , init : Uint8Array | null } ;
}
// Generated from /home/runner/work/shaka-player/shaka-player/externs/shaka/transmuxer.js
declare namespace shaka.extern {
  type TransmuxerPlugin = ( ) => shaka.extern.Transmuxer ;
}

export default shaka;
