'use strict';

var require$$1 = require('electron');
var require$$1$1 = require('events');
var require$$2 = require('fs');
var require$$3 = require('path');
var require$$0 = require('child_process');

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

var src = {};

var implementation = {};

var utils$1 = {};

var hasRequiredUtils$1;

function requireUtils$1 () {
	if (hasRequiredUtils$1) return utils$1;
	hasRequiredUtils$1 = 1;
	Object.defineProperty(utils$1, "__esModule", { value: true });
	utils$1.ChannelMessageCodec = void 0;
	class ChannelMessageCodec {
	    static serialize(payload) {
	        const eventName = payload.eventName;
	        const args = payload.args;
	        const eventMessage = JSON.stringify(args);
	        const data = {
	            eventName,
	            eventMessage,
	        };
	        const channelMessage = JSON.stringify(data);
	        return channelMessage;
	    }
	    static deserialize(channelMessage) {
	        const data = JSON.parse(channelMessage);
	        const eventName = data.eventName;
	        const eventMessage = data.eventMessage;
	        let args = [];
	        if (eventMessage) {
	            args = JSON.parse(eventMessage);
	        }
	        const payload = {
	            eventName,
	            args,
	        };
	        return payload;
	    }
	}
	utils$1.ChannelMessageCodec = ChannelMessageCodec;
	
	return utils$1;
}

var utils = {};

var hasRequiredUtils;

function requireUtils () {
	if (hasRequiredUtils) return utils;
	hasRequiredUtils = 1;
	Object.defineProperty(utils, "__esModule", { value: true });
	utils.joinEnv = void 0;
	const path_1 = require$$3;
	function joinEnv(...variables) {
	    let envVariable = '';
	    for (let index = 0; index < variables.length; index++) {
	        const variable = variables[index];
	        if (!variable)
	            continue;
	        envVariable += variable;
	        if (index < variables.length - 1) {
	            envVariable += path_1.delimiter;
	        }
	    }
	    return envVariable;
	}
	utils.joinEnv = joinEnv;
	
	return utils;
}

var hasRequiredImplementation;

function requireImplementation () {
	if (hasRequiredImplementation) return implementation;
	hasRequiredImplementation = 1;
	Object.defineProperty(implementation, "__esModule", { value: true });
	implementation.CapacitorNodeJSImplementation = void 0;
	const child_process_1 = require$$0;
	const electron_1 = require$$1;
	const fs_1 = require$$2;
	const path_1 = require$$3;
	const utils_1 = requireUtils$1();
	const index_1 = requireSrc();
	const utils_2 = requireUtils();
	class EngineStatus {
	    constructor() {
	        this.whenEngineReadyListeners = [];
	        this.isEngineStarted = false;
	        this.isEngineReady = false;
	    }
	    setStarted() {
	        this.isEngineStarted = true;
	    }
	    isStarted() {
	        return this.isEngineStarted;
	    }
	    setReady() {
	        this.isEngineReady = true;
	        while (this.whenEngineReadyListeners.length > 0) {
	            const whenEngineReadyListener = this.whenEngineReadyListeners[0];
	            whenEngineReadyListener();
	            this.whenEngineReadyListeners.splice(0, 1);
	        }
	    }
	    isReady() {
	        return this.isEngineReady;
	    }
	    whenReady(callback) {
	        if (this.isReady()) {
	            callback();
	        }
	        else {
	            this.whenEngineReadyListeners.push(callback);
	        }
	    }
	}
	class CapacitorNodeJSImplementation {
	    constructor(eventNotifier) {
	        this.engineStatus = new EngineStatus();
	        this.eventNotifier = eventNotifier;
	    }
	    async startEngine(projectDir, mainFile, args, env) {
	        var _a;
	        if (this.engineStatus.isStarted()) {
	            throw new Error('The Node.js engine has already been started.');
	        }
	        this.engineStatus.setStarted();
	        const projectPath = (0, path_1.join)(electron_1.app.getAppPath(), 'app', projectDir);
	        const modulesPath = (0, path_1.join)(__dirname, '..', 'assets', 'builtin_modules');
	        const dataPath = electron_1.app.getPath('userData');
	        if (!(0, fs_1.existsSync)(projectPath)) {
	            throw new Error('Unable to access the Node.js project. (No such directory)');
	        }
	        const projectPackageJsonPath = (0, path_1.join)(projectPath, 'package.json');
	        let projectMainFile = 'index.js';
	        if (mainFile) {
	            projectMainFile = mainFile;
	        }
	        else if ((0, fs_1.existsSync)(projectPackageJsonPath)) {
	            try {
	                const projectPackageJson = await (_a = projectPackageJsonPath, Promise.resolve().then(() => require(_a)));
	                const projectPackageJsonMainFile = projectPackageJson.main;
	                if (projectPackageJsonMainFile) {
	                    projectMainFile = projectPackageJson.main;
	                }
	            }
	            catch (_b) {
	                throw new Error('Failed to read the package.json file of the Node.js project.');
	            }
	        }
	        const projectMainPath = (0, path_1.join)(projectPath, projectMainFile);
	        if (!(0, fs_1.existsSync)(projectMainPath)) {
	            throw new Error('Unable to access main script of the Node.js project. (No such file)');
	        }
	        const modulesPaths = (0, utils_2.joinEnv)(projectPath, modulesPath);
	        const nodeEnv = Object.assign({ NODE_PATH: modulesPaths, DATADIR: dataPath }, env);
	        const nodeOptions = {
	            env: nodeEnv,
	            serialization: 'json',
	        };
	        this.nodeProcess = (0, child_process_1.fork)(projectMainPath, args, nodeOptions);
	        this.nodeProcess.on('message', (args) => {
	            this.receiveMessage(args.channelName, args.channelMessage);
	        });
	        electron_1.app.on('quit', () => {
	            var _a;
	            (_a = this.nodeProcess) === null || _a === void 0 ? void 0 : _a.kill();
	        });
	    }
	    resolveWhenReady() {
	        return new Promise((resolve, reject) => {
	            if (!this.engineStatus.isStarted()) {
	                reject('The Node.js engine has not been started yet.');
	            }
	            this.engineStatus.whenReady(() => resolve());
	        });
	    }
	    sendMessage(channelName, payload) {
	        if (!this.engineStatus.isStarted()) {
	            throw new Error('The Node.js engine has not been started yet.');
	        }
	        if (!this.engineStatus.isReady()) {
	            throw new Error('The Node.js engine is not ready yet.');
	        }
	        if (this.nodeProcess === undefined || !payload.eventName || !payload.args)
	            return;
	        const channelMessage = utils_1.ChannelMessageCodec.serialize(payload);
	        const channelData = {
	            channelName,
	            channelMessage,
	        };
	        this.nodeProcess.send(channelData);
	    }
	    receiveMessage(channelName, channelMessage) {
	        const payload = utils_1.ChannelMessageCodec.deserialize(channelMessage);
	        const eventName = payload.eventName;
	        const args = payload.args;
	        if (channelName === index_1.CapacitorNodeJS.CHANNEL_NAME_APP && eventName === 'ready') {
	            this.engineStatus.setReady();
	        }
	        else if (channelName === index_1.CapacitorNodeJS.CHANNEL_NAME_EVENT) {
	            this.eventNotifier.channelReceive(eventName, args);
	        }
	    }
	}
	implementation.CapacitorNodeJSImplementation = CapacitorNodeJSImplementation;
	
	return implementation;
}

var hasRequiredSrc;

function requireSrc () {
	if (hasRequiredSrc) return src;
	hasRequiredSrc = 1;
	Object.defineProperty(src, "__esModule", { value: true });
	src.CapacitorNodeJS = void 0;
	const electron_1 = require$$1;
	const events_1 = require$$1$1;
	const fs_1 = require$$2;
	const path_1 = require$$3;
	const implementation_1 = requireImplementation();
	class PluginSettings {
	    constructor() {
	        this.nodeDir = 'nodejs';
	        this.startMode = 'auto';
	    }
	}
	class CapacitorNodeJS extends events_1.EventEmitter {
	    constructor( /*config?: Record<string, any>*/) {
	        super();
	        // removeAllListeners() function is missing (https://github.com/capacitor-community/electron/pull/185)
	        //---------------------------------------------------------------------------------------
	        //#endregion
	        //#region PluginEvents
	        //---------------------------------------------------------------------------------------
	        this.PluginEventNotifier = {
	            // Bridge -------------------------------------------------------------------------------
	            channelReceive: (eventName, payloadArray) => {
	                this.notifyChannelListeners(eventName, payloadArray);
	            },
	        };
	        const browserWindow = electron_1.BrowserWindow.getAllWindows()[0];
	        //this.config = config;
	        this.implementation = new implementation_1.CapacitorNodeJSImplementation(this.PluginEventNotifier);
	        browserWindow.on('focus', () => {
	            this.implementation.sendMessage(CapacitorNodeJS.CHANNEL_NAME_APP, {
	                eventName: 'resume',
	                args: [],
	            });
	        });
	        browserWindow.on('blur', () => {
	            this.implementation.sendMessage(CapacitorNodeJS.CHANNEL_NAME_APP, {
	                eventName: 'pause',
	                args: [],
	            });
	        });
	        this.readPluginSettings().then((pluginSettings) => {
	            if (pluginSettings.startMode === 'auto') {
	                this.implementation.startEngine(pluginSettings.nodeDir);
	            }
	        });
	    }
	    async readPluginSettings() {
	        var _a;
	        //!-------------------------- workaround ---------------------------
	        // the configuration exposed by the capacitor-community/electron platform
	        // is always empty for some reason
	        const configPathBase = (0, path_1.join)(electron_1.app.getAppPath(), 'capacitor.config.');
	        const configPathExt = (0, fs_1.existsSync)(configPathBase + 'json')
	            ? 'json'
	            : (0, fs_1.existsSync)(configPathBase + 'js')
	                ? 'js'
	                : (0, fs_1.existsSync)(configPathBase + 'ts')
	                    ? 'ts'
	                    : undefined;
	        const configPath = configPathBase + configPathExt;
	        const configFile = await require(configPath);
	        const capacitorConfig = configFile.default || configFile;
	        const config = (_a = capacitorConfig === null || capacitorConfig === void 0 ? void 0 : capacitorConfig.plugins) === null || _a === void 0 ? void 0 : _a.CapacitorNodeJS;
	        //!-----------------------------------------------------------------
	        const settings = new PluginSettings();
	        settings.nodeDir = (config === null || config === void 0 ? void 0 : config.nodeDir) || settings.nodeDir;
	        settings.startMode = (config === null || config === void 0 ? void 0 : config.startMode) || settings.startMode;
	        return settings;
	    }
	    //#region PluginMethods
	    //---------------------------------------------------------------------------------------
	    async start(args) {
	        var _a;
	        const pluginSettings = await this.readPluginSettings();
	        if (pluginSettings.startMode !== 'manual') {
	            throw new Error('Manual startup of the Node.js engine is not enabled.');
	        }
	        const projectDir = (_a = args === null || args === void 0 ? void 0 : args.nodeDir) !== null && _a !== void 0 ? _a : pluginSettings.nodeDir;
	        const nodeMain = args === null || args === void 0 ? void 0 : args.script;
	        const nodeArgs = args === null || args === void 0 ? void 0 : args.args;
	        const nodeEnv = args === null || args === void 0 ? void 0 : args.env;
	        this.implementation.startEngine(projectDir, nodeMain, nodeArgs, nodeEnv);
	    }
	    async send(args) {
	        const eventName = args.eventName;
	        if (eventName === undefined || eventName === '') {
	            throw new Error("Required parameter 'eventName' was not specified");
	        }
	        if (args.args === undefined) {
	            args.args = [];
	        }
	        this.implementation.sendMessage(CapacitorNodeJS.CHANNEL_NAME_EVENT, args);
	    }
	    async whenReady() {
	        return this.implementation.resolveWhenReady();
	    }
	    //---------------------------------------------------------------------------------------
	    //#endregion
	    //#region PluginListeners
	    //---------------------------------------------------------------------------------------
	    notifyChannelListeners(eventName, payloadArray) {
	        const args = { args: payloadArray };
	        this.emit(eventName, args);
	    }
	}
	src.CapacitorNodeJS = CapacitorNodeJS;
	CapacitorNodeJS.CHANNEL_NAME_APP = 'APP_CHANNEL';
	CapacitorNodeJS.CHANNEL_NAME_EVENT = 'EVENT_CHANNEL';
	
	return src;
}

var srcExports = requireSrc();
var index = /*@__PURE__*/getDefaultExportFromCjs(srcExports);

module.exports = index;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
