// based on eslint-plugin-svelte README.md
import js from '@eslint/js';
import svelte from 'eslint-plugin-svelte';
import globals from 'globals';
import ts from 'typescript-eslint';
import svelteConfig from './svelte.config.js';

export default ts.config(
	js.configs.recommended,
	...ts.configs.recommended,
	...svelte.configs.recommended,
	{
		languageOptions: {
			globals: {
				...globals.browser,
				...globals.node
			}
		}
	},
	{
		files: ['**/*.svelte'],
		// See more details at: https://typescript-eslint.io/packages/parser/
		languageOptions: {
			parserOptions: {
				projectService: true,
				extraFileExtensions: ['.svelte'], // Add support for additional file extensions, such as .svelte
				parser: ts.parser,
				sourceType: 'module',
				ecmaVersion: 2020,
				// Specify a parser for each language, if needed:
				// parser: {
				//   ts: ts.parser,
				//   js: espree,    // Use espree for .js files (add: import espree from 'espree')
				//   typescript: ts.parser
				// },

				// We recommend importing and specifying svelte.config.js.
				// By doing so, some rules in eslint-plugin-svelte will automatically read the configuration and adjust their behavior accordingly.
				// While certain Svelte settings may be statically loaded from svelte.config.js even if you don’t specify it,
				// explicitly specifying it ensures better compatibility and functionality.
				//
				// If non-serializable properties are included, running ESLint with the --cache flag will fail.
				// In that case, please remove the non-serializable properties. (e.g. `svelteConfig: { ...svelteConfig, kit: { ...svelteConfig.kit, typescript: undefined }}`)
				svelteConfig
			}
		}
	},
	{
		rules: {
			// Override or add rule settings here, such as:
			// 'svelte/rule-name': 'error'
			'@typescript-eslint/no-explicit-any': ['off']
		}
	},
	{
		ignores: [
			'.DS_Store',
			'node_modules',
			'/build',
			'**/.svelte-kit/*',
			'/package',
			'.env',
			'.env.*',
			'!.env.example',
			// Ignore files for PNPM, NPM and YARN
			'pnpm-lock.yaml',
			'package-lock.json',
			'yarn.lock',
			// Ignore our nodejs android code
			'**/nodejs-android/*',
			// Ignore electron code from capacitorjs
			'**/electron/*',
			// Ignore build files
			'**/build/*',
			'**/android/app/src/main/assets/*'
		]
	}
);
