import { a as attr, s as store_get, u as unsubscribe_stores, d as bind_props, e as ensure_array_like, j as await_block, b as attr_class, h as head } from "../../../../../chunks/index.js";
import { r as resolve } from "../../../../../chunks/server.js";
import "../../../../../chunks/youtubejs.js";
import "@capacitor/core";
import { g as get } from "../../../../../chunks/index3.js";
import { a as interfaceLowBandwidthMode, x as playertheatreModeIsActive, t as playerState, C as playlistSettingsStore, D as syncPartyConnectionsStore, b as authStore, m as playlistCacheStore, E as playerTheatreModeByDefaultStore } from "../../../../../chunks/store.js";
import "@sveltejs/kit/internal/server";
import "@capacitor/share";
import "../../../../../chunks/beer.min.js";
import "@capacitor/clipboard";
import { _ } from "../../../../../chunks/index2.js";
import { e as escape_html } from "../../../../../chunks/context.js";
import { T as Thumbnail } from "../../../../../chunks/Thumbnail.js";
import { c as cleanNumber, n as numberWithCommas, h as humanizeSeconds } from "../../../../../chunks/numbers.js";
import { o as onDestroy } from "../../../../../chunks/index-server.js";
import "@sveltejs/kit/internal";
import "../../../../../chunks/exports.js";
import "../../../../../chunks/utils.js";
import "../../../../../chunks/state.svelte.js";
import "he";
import "../../../../../chunks/client2.js";
import { g as getBestThumbnail } from "../../../../../chunks/images.js";
import { l as letterCase } from "../../../../../chunks/letterCasing.js";
import { A as Author } from "../../../../../chunks/Author.js";
import { h as html } from "../../../../../chunks/html.js";
import dayjs from "dayjs";
import utc from "dayjs/plugin/utc.js";
import duration from "dayjs/plugin/duration.js";
import relativeTime from "dayjs/plugin/relativeTime.js";
import advancedFormat from "dayjs/plugin/advancedFormat.js";
import "@sveltejs/kit";
function ShareVideo($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { video, currentTime = void 0 } = $$props;
    let includeTimestamp = false;
    $$renderer2.push(`<menu class="no-wrap mobile" data-ui="#share-menu" id="share-menu">`);
    if (currentTime !== void 0) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<li class="row"><label class="switch"><input type="checkbox"${attr("checked", includeTimestamp, true)}/> <span></span></label> <div class="min">${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.share.includeTimestamp"))}</div></li> <div class="divider"></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <li data-ui="#share-menu" class="row" role="presentation"><div class="min">${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.share.materialiousLink"))}</div></li> <li data-ui="#share-menu" class="row" role="presentation"><div class="min">${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.share.invidiousRedirect"))}</div></li> <li data-ui="#share-menu" class="row" role="presentation"><div class="min">${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.share.youtubeLink"))}</div></li></menu> <div class="snackbar" id="share-success">${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.share.copiedSuccess"))}</div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { currentTime });
  });
}
function Description($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { video, description } = $$props;
    $$renderer2.push(`<details><summary id="description" class="bold none"><nav><div class="max">${escape_html(cleanNumber(video.viewCount))}
				${escape_html(store_get($$store_subs ??= {}, "$_", _)("views"))} • ${escape_html(video.publishedText)}</div></nav></summary> <div class="space"></div> <div class="medium scroll"><div style="white-space: pre-line; overflow-wrap: break-word;">${html(description)}</div> `);
    if (video.keywords && video.keywords.length > 0) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<article class="border"><nav class="scroll"><!--[-->`);
      const each_array = ensure_array_like(video.keywords);
      for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
        let keyword = each_array[$$index];
        $$renderer2.push(`<a${attr("href", resolve(`/search/[search]`, { search: encodeURIComponent(keyword) }))} class="chip">${escape_html(keyword)}</a>`);
      }
      $$renderer2.push(`<!--]--></nav></article>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div></details>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function LikesDislikes($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { video, returnYTDislikes } = $$props;
    await_block($$renderer2, returnYTDislikes, () => {
    }, (returnYTDislikes2) => {
      if (returnYTDislikes2) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<button style="cursor: default;margin-left: 0;" class="border"><i class="small">thumb_up</i> <span>${escape_html(cleanNumber(returnYTDislikes2.likes))}</span> <i class="small" style="margin-left: 0.5em;">thumb_down_alt</i> <span>${escape_html(cleanNumber(returnYTDislikes2.dislikes))}</span></button>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<button style="cursor: default;margin-left: 0;" class="border"><i class="small">thumb_up</i> <span>${escape_html(cleanNumber(video.likeCount))}</span></button>`);
      }
      $$renderer2.push(`<!--]-->`);
    });
    $$renderer2.push(`<!--]-->`);
  });
}
function Comment($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { comment, videoId, isSubComp = false } = $$props;
    const replyText = comment.replies?.replyCount > 1 ? store_get($$store_subs ??= {}, "$_", _)("replies") : store_get($$store_subs ??= {}, "$_", _)("reply");
    function commentTimestamps(html2) {
      const regex = /<a href="([^"]+)" data-onclick="jump_to_time" data-jump-time="(\d+)">([^<]+)<\/a>\s*(.+)/g;
      const replacement = `<a href=${resolve(`/watch/[videoId]?time=$2`, { videoId })} data-sveltekit-preload-data="off" class="link">$3 $4</a>`;
      const processedHtml = html2.replace(regex, replacement);
      return processedHtml;
    }
    $$renderer2.push(`<article${attr_class("comment svelte-c3m8z5", void 0, { "border": !isSubComp })}>`);
    if (!store_get($$store_subs ??= {}, "$interfaceLowBandwidthMode", interfaceLowBandwidthMode)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="comment-header svelte-c3m8z5">`);
      {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<progress class="circle"></progress>`);
      }
      $$renderer2.push(`<!--]--> <div class="comment-info svelte-c3m8z5"><a${attr("href", resolve(`/channel/[authorId]`, { authorId: comment.authorId }))} class="author svelte-c3m8z5"><span${attr_class("bold", void 0, { "channel-owner": comment.authorIsChannelOwner })}>${escape_html(comment.author)}</span> <span class="secondary-text">${escape_html(comment.publishedText)}</span></a> <p class="no-margin">${html(commentTimestamps(comment.contentHtml))}</p> <div class="comment-actions svelte-c3m8z5"><p class="no-margin no-padding"><i>thumb_up</i> ${escape_html(numberWithCommas(comment.likeCount))}</p> `);
      if (comment.replies && true) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<button class="transparent replies svelte-c3m8z5"><i>expand_more</i> <span>${escape_html(comment.replies.replyCount)} ${escape_html(replyText)}</span></button>`);
      } else {
        $$renderer2.push("<!--[!-->");
        {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]-->`);
      }
      $$renderer2.push(`<!--]--></div></div></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></article>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
dayjs.extend(utc);
dayjs.extend(duration);
dayjs.extend(relativeTime);
dayjs.extend(advancedFormat);
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data = void 0 } = $$props;
    let comments = null;
    data.streamed.comments?.then((streamedComments) => {
      comments = streamedComments;
    });
    let personalPlaylists = null;
    data.streamed.personalPlaylists?.then((streamPlaylists) => personalPlaylists = streamPlaylists);
    let loopPlaylist = false;
    let shufflePlaylist = false;
    playertheatreModeIsActive.set(get(playerTheatreModeByDefaultStore));
    let pauseTimerSeconds = -1;
    let playerCurrentTime = 0;
    let premiereTime = "";
    if (!data.video.premiereTimestamp && (!store_get($$store_subs ??= {}, "$playerState", playerState) || store_get($$store_subs ??= {}, "$playerState", playerState).data.video.videoId !== data.video.videoId)) {
      playerState.set({ data });
    }
    playlistSettingsStore.subscribe((playlistSetting) => {
      if (!data.playlistId) return;
      if (data.playlistId in playlistSetting) {
        loopPlaylist = playlistSetting[data.playlistId].loop;
        shufflePlaylist = playlistSetting[data.playlistId].shuffle;
      }
    });
    syncPartyConnectionsStore.subscribe((connections) => {
      return;
    });
    onDestroy(() => {
      document.title = "Materialious";
      {
        playerState.set(void 0);
      }
    });
    let $$settled = true;
    let $$inner_renderer;
    function $$render_inner($$renderer3) {
      head("1sad4mf", $$renderer3, ($$renderer4) => {
        $$renderer4.title(($$renderer5) => {
          $$renderer5.push(`<title>${escape_html(data.video.title)}</title>`);
        });
      });
      $$renderer3.push(`<div class="grid no-padding"><div${attr_class(`s12 m12 l${store_get($$store_subs ??= {}, "$playertheatreModeIsActive", playertheatreModeIsActive) ? "12" : "9"}`, "svelte-1sad4mf")}><div style="display: flex;justify-content: center;">`);
      if (data.video.premiereTimestamp) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<article class="video-placeholder svelte-1sad4mf"><p>${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.premiere"))}</p> <h6 class="no-margin no-padding">${escape_html(premiereTime)}</h6></article> <div class="space"></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <h5 class="no-margin">${escape_html(letterCase(data.video.title))}</h5> <div class="grid no-padding"><div class="s12 m12 l5" style="height: 100%;display: flex;align-items: center;">`);
      Author($$renderer3, { channel: data.video });
      $$renderer3.push(`<!----></div> <div class="s12 m12 l7 video-actions svelte-1sad4mf"><div>`);
      LikesDislikes($$renderer3, {
        video: data.video,
        returnYTDislikes: data.streamed.returnYTDislikes
      });
      $$renderer3.push(`<!----> <button${attr_class("m l", void 0, {
        "border": !store_get($$store_subs ??= {}, "$playertheatreModeIsActive", playertheatreModeIsActive)
      })}><i>width_wide</i> <div class="tooltip">${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.theatreMode"))}</div></button> `);
      if (data.video.lengthSeconds > 360 && !data.video.hlsUrl) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<button${attr_class("", void 0, { "border": pauseTimerSeconds < 1 })}><i>snooze</i> <div class="tooltip">${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.pauseTimer"))}</div></button>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> <button${attr_class("", void 0, { "border": true })}><i>description</i> <div class="tooltip">${escape_html(store_get($$store_subs ??= {}, "$_", _)("transcript"))}</div></button> <button class="border"><i>share</i> <div class="tooltip">${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.share.title"))}</div> `);
      ShareVideo($$renderer3, {
        video: data.video,
        get currentTime() {
          return playerCurrentTime;
        },
        set currentTime($$value) {
          playerCurrentTime = $$value;
          $$settled = false;
        }
      });
      $$renderer3.push(`<!----></button> `);
      if (personalPlaylists && personalPlaylists.length > 0) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<button class="border"><i>add</i> <div class="tooltip">${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.addToPlaylist"))}</div> <menu class="no-wrap mobile"><!--[-->`);
        const each_array = ensure_array_like(personalPlaylists);
        for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
          let personalPlaylist = each_array[$$index];
          $$renderer3.push(`<li role="presentation" class="row"><nav><span class="max">${escape_html(personalPlaylist.title)}</span> `);
          if (personalPlaylist.videos.filter((item) => {
            return item.videoId === data.video.videoId;
          }).length > 0) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<i>close</i>`);
          } else {
            $$renderer3.push("<!--[!-->");
            $$renderer3.push(`<i>add</i>`);
          }
          $$renderer3.push(`<!--]--></nav></li>`);
        }
        $$renderer3.push(`<!--]--></menu></button>`);
      } else {
        $$renderer3.push("<!--[!-->");
        $$renderer3.push(`<button disabled class="border"><i>add</i> <div class="tooltip">`);
        if (store_get($$store_subs ??= {}, "$authStore", authStore)) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.noPlaylists"))}`);
        } else {
          $$renderer3.push("<!--[!-->");
          $$renderer3.push(`${escape_html(store_get($$store_subs ??= {}, "$_", _)("loginRequired"))}`);
        }
        $$renderer3.push(`<!--]--></div></button>`);
      }
      $$renderer3.push(`<!--]--></div></div></div> <article class="border">`);
      Description($$renderer3, { video: data.video, description: data.content.description });
      $$renderer3.push(`<!----></article> `);
      if (data.content.timestamps.length > 0) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<article class="border"><details><summary id="chapter-section" class="bold none"><nav><div class="max"><p>${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.chapters"))}</p></div></nav></summary> <div class="space"></div> <div class="chapter-list svelte-1sad4mf" id="chapters"><ul class="list"><!--[-->`);
        const each_array_1 = ensure_array_like(data.content.timestamps);
        for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
          let timestamp = each_array_1[$$index_1];
          $$renderer3.push(`<li role="presentation"><img class="round large" loading="lazy"${attr("src", getBestThumbnail(data.video.videoThumbnails))} alt="Thumbnail for current video"/> <div class="max" style="white-space: pre-line; overflow-wrap: break-word;"><p style="no-margin no-padding">${escape_html(timestamp.title)}</p> <span${attr_class("chip no-margin", void 0, {
            "primary": playerCurrentTime >= timestamp.time && (playerCurrentTime <= timestamp.endTime || timestamp.endTime === -1)
          })}>${escape_html(timestamp.timePretty)}</span></div></li>`);
        }
        $$renderer3.push(`<!--]--></ul></div></details></article>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--> `);
      if (comments && comments.comments.length > 0) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<article class="border"><details><summary id="comment-section" class="none bold"><nav><div class="max">${escape_html(numberWithCommas(comments.commentCount))} ${escape_html(store_get($$store_subs ??= {}, "$_", _)("comments"))}</div></nav></summary> <div class="space"></div> <div class="medium scroll"><!--[-->`);
        const each_array_2 = ensure_array_like(comments.comments);
        for (let $$index_2 = 0, $$length = each_array_2.length; $$index_2 < $$length; $$index_2++) {
          let comment = each_array_2[$$index_2];
          Comment($$renderer3, { comment, videoId: data.video.videoId });
        }
        $$renderer3.push(`<!--]--> `);
        if (comments.continuation) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<button class="margin">${escape_html(store_get($$store_subs ??= {}, "$_", _)("loadMore"))}</button>`);
        } else {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--></div></details></article>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> `);
      if (!store_get($$store_subs ??= {}, "$playertheatreModeIsActive", playertheatreModeIsActive)) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<div class="s12 m12 l3 recommended svelte-1sad4mf">`);
        {
          $$renderer3.push("<!--[!-->");
        }
        $$renderer3.push(`<!--]--> `);
        if (data.playlistId && data.playlistId in store_get($$store_subs ??= {}, "$playlistCacheStore", playlistCacheStore)) {
          $$renderer3.push("<!--[-->");
          $$renderer3.push(`<article style="height: 85vh; position: relative;scrollbar-width: none;" id="playlist" class="scroll no-padding surface-container border"><article class="no-elevate border" style="position: sticky; top: 0; z-index: 3;"><h6>${escape_html(store_get($$store_subs ??= {}, "$playlistCacheStore", playlistCacheStore)[data.playlistId].info.title)}</h6> <p>${escape_html(cleanNumber(store_get($$store_subs ??= {}, "$playlistCacheStore", playlistCacheStore)[data.playlistId].info.viewCount))}
							${escape_html(store_get($$store_subs ??= {}, "$_", _)("views"))} • ${escape_html(store_get($$store_subs ??= {}, "$playlistCacheStore", playlistCacheStore)[data.playlistId].info.videoCount)}
							${escape_html(store_get($$store_subs ??= {}, "$_", _)("videos"))}</p> <p><a${attr("href", resolve(`/channel/[authorId]`, {
            authorId: store_get($$store_subs ??= {}, "$playlistCacheStore", playlistCacheStore)[data.playlistId].info.authorId
          }))}>${escape_html(store_get($$store_subs ??= {}, "$playlistCacheStore", playlistCacheStore)[data.playlistId].info.author)}</a></p> <nav><button${attr_class("circle", void 0, { "fill": !loopPlaylist })}><i>loop</i> <div class="tooltip bottom">${escape_html(store_get($$store_subs ??= {}, "$_", _)("playlist.loopPlaylist"))}</div></button> <button${attr_class("circle", void 0, { "fill": !shufflePlaylist })}><i>shuffle</i> <div class="tooltip bottom">${escape_html(store_get($$store_subs ??= {}, "$_", _)("playlist.shuffleVideos"))}</div></button> <button class="circle fill"><i>skip_previous</i> <div class="tooltip bottom">${escape_html(store_get($$store_subs ??= {}, "$_", _)("playlist.previous"))}</div></button> <button class="circle fill"><i>skip_next</i> <div class="tooltip bottom">${escape_html(store_get($$store_subs ??= {}, "$_", _)("playlist.next"))}</div></button></nav> <div class="space"></div> <div class="divider"></div></article> <div class="space"></div> <!--[-->`);
          const each_array_3 = ensure_array_like(store_get($$store_subs ??= {}, "$playlistCacheStore", playlistCacheStore)[data.playlistId].videos);
          for (let $$index_3 = 0, $$length = each_array_3.length; $$index_3 < $$length; $$index_3++) {
            let playlistVideo = each_array_3[$$index_3];
            $$renderer3.push(`<article${attr_class("no-padding border", void 0, {
              "primary-border": playlistVideo.videoId === data.video.videoId
            })} style="margin: .7em;"${attr("id", playlistVideo.videoId)}><!---->`);
            {
              Thumbnail($$renderer3, {
                video: playlistVideo,
                sideways: true,
                playlistId: data.playlistId || void 0
              });
            }
            $$renderer3.push(`<!----></article>`);
          }
          $$renderer3.push(`<!--]--></article>`);
        } else {
          $$renderer3.push("<!--[!-->");
          if (data.video.recommendedVideos) {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<!--[-->`);
            const each_array_4 = ensure_array_like(data.video.recommendedVideos);
            for (let $$index_4 = 0, $$length = each_array_4.length; $$index_4 < $$length; $$index_4++) {
              let recommendedVideo = each_array_4[$$index_4];
              $$renderer3.push(`<article class="no-padding border"><!---->`);
              {
                Thumbnail($$renderer3, { video: recommendedVideo, sideways: true });
              }
              $$renderer3.push(`<!----></article>`);
            }
            $$renderer3.push(`<!--]-->`);
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!--]--></div>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]--></div> <dialog id="pause-timer"><div><h6>${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.pauseVideoIn"))} ${escape_html(humanizeSeconds(pauseTimerSeconds))}</h6> <nav class="group"><button class="left-round">+5 mins</button> <button class="no-round">+30 mins</button> <button class="no-round">+1 hr</button> <button class="right-round">+2 hrs</button></nav> <div class="space"></div> <nav class="wrap"><button class="secondary max"><i>delete</i> <span>Clear</span></button></nav></div></dialog>`);
    }
    do {
      $$settled = true;
      $$inner_renderer = $$renderer2.copy();
      $$render_inner($$inner_renderer);
    } while (!$$settled);
    $$renderer2.subsume($$inner_renderer);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { data });
  });
}
export {
  _page as default
};
