import { a as attr, s as store_get, u as unsubscribe_stores } from "../../../../../chunks/index.js";
import { r as resolve } from "../../../../../chunks/server.js";
import { u as unsafeRandomItem } from "../../../../../chunks/misc.js";
import { c as cleanNumber } from "../../../../../chunks/numbers.js";
import { i as isAndroidTvStore } from "../../../../../chunks/store.js";
import "@capacitor/clipboard";
import { Capacitor } from "@capacitor/core";
import { _ } from "../../../../../chunks/index2.js";
import { I as ItemsList } from "../../../../../chunks/ItemsList.js";
import { e as escape_html } from "../../../../../chunks/context.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    $$renderer2.push(`<article class="border padding">`);
    if (data.playlist.videos) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<nav><a${attr("href", resolve(
        store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore) ? `/tv/[playlistId]?playlist=${data.playlist.info.playlistId}` : `/watch/[playlistId]?playlist=${data.playlist.info.playlistId}`,
        { playlistId: data.playlist.videos[0].videoId }
      ))} class="button circle extra no-margin"><i>play_arrow</i> <div class="tooltip bottom">${escape_html(store_get($$store_subs ??= {}, "$_", _)("playlist.playVideos"))}</div></a> <a${attr("href", resolve(
        store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore) ? `/tv/[playlistId]?playlist=${data.playlist.info.playlistId}` : `/watch/[playlistId]?playlist=${data.playlist.info.playlistId}`,
        { playlistId: unsafeRandomItem(data.playlist.videos).videoId }
      ))} class="button circle extra no-margin border"><i>shuffle</i> <div class="tooltip bottom">${escape_html(store_get($$store_subs ??= {}, "$_", _)("playlist.shuffleVideos"))}</div></a></nav>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <h3>${escape_html(data.playlist.info.title)}</h3> <p>${escape_html(cleanNumber(data.playlist.info.viewCount))}
		${escape_html(store_get($$store_subs ??= {}, "$_", _)("views"))} • ${escape_html(data.playlist.info.videoCount)}
		${escape_html(store_get($$store_subs ??= {}, "$_", _)("videos"))}</p> <div class="divider" style="margin-bottom: 1em;"></div> <article style="max-height: 200px;" class="scroll no-padding no-elevate no-round"><p style="white-space: pre-line;word-wrap: break-word;">${escape_html(data.playlist.info.description)}</p></article> <div class="space"></div> `);
    if (!store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<button class="border no-margin"><i>share</i> <span>${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.share.title"))}</span> <menu class="no-wrap mobile">`);
      if (!Capacitor.isNativePlatform()) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<li class="row" role="presentation">${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.share.materialiousLink"))}</li>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> <li class="row" role="presentation">${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.share.youtubeLink"))}</li></menu></button>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></article> <div class="space"></div> `);
    if (data.playlist.videos) {
      $$renderer2.push("<!--[-->");
      ItemsList($$renderer2, {
        items: data.playlist.videos,
        playlistAuthor: data.playlist.info.author,
        playlistId: data.playlist.info.playlistId
      });
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
