import { b as attr_class, c as attr_style, g as clsx, a as attr, s as store_get, u as unsubscribe_stores, e as ensure_array_like, l as store_set, h as head } from "../../../chunks/index.js";
import { r as resolve } from "../../../chunks/server.js";
import { g as goto } from "../../../chunks/client.js";
import { p as page, n as navigating } from "../../../chunks/stores.js";
import { registerPlugin, Capacitor } from "@capacitor/core";
import "../../../chunks/youtubejs.js";
import { v as darkModeStore, F as themeColorStore, G as interfaceSearchSuggestionsStore, i as isAndroidTvStore, B as synciousStore, l as synciousInstanceStore, H as deArrowTitlesOnly, I as deArrowEnabledStore, J as deArrowInstanceStore, K as deArrowThumbnailInstanceStore, L as interfaceAllowInsecureRequests, M as interfaceDisableAutoUpdate, b as authStore, h as interfaceRegionStore, e as interfaceForceCase, u as interfaceDefaultPage, w as interfaceAmoledTheme, N as interfaceSearchHistoryEnabled, a as interfaceLowBandwidthMode, O as interfaceAutoExpandDesc, P as interfaceAutoExpandChapters, Q as interfaceAutoExpandComments, R as interfaceAndroidUseNativeShare, g as instanceStore, S as playerDefaultLanguage, k as playerYouTubeJsFallback, j as playerYouTubeJsAlways, T as playerDefaultQualityStore, U as playerDefaultPlaybackSpeed, V as playerCCByDefault, W as playerMiniplayerEnabled, z as playerAutoPlayStore, y as playerAlwaysLoopStore, A as playerAndroidLockOrientation, n as playerProxyVideosStore, p as playerSavePlaybackPositionStore, E as playerTheatreModeByDefaultStore, X as playerAutoplayNextByDefaultStore, Y as playerStatisticsByDefault, q as returnYtDislikesStore, r as returnYTDislikesInstanceStore, Z as sponsorBlockCategoriesStore, _ as sponsorBlockStore, $ as sponsorBlockDisplayToastStore, a0 as sponsorBlockUrlStore, d as syncPartyPeerStore, D as syncPartyConnectionsStore, t as playerState, x as playertheatreModeIsActive } from "../../../chunks/store.js";
import { c as cn } from "../../../chunks/beer.min.js";
import { g as getDynamicTheme, s as setAmoledTheme, a as setStatusBarColor, b as setTheme, P as Player$1 } from "../../../chunks/Player.js";
import { P as PageLoading } from "../../../chunks/PageLoading.js";
import "@sveltejs/kit/internal/server";
import "@sveltejs/kit/internal";
import "../../../chunks/exports.js";
import "../../../chunks/utils.js";
import "../../../chunks/state.svelte.js";
import Mousetrap from "mousetrap";
import { _ } from "../../../chunks/index2.js";
import "he";
import "../../../chunks/client2.js";
import { g as get } from "../../../chunks/index3.js";
import { e as escape_html } from "../../../chunks/context.js";
import { l as letterCase, t as titleCases, a as titleCase } from "../../../chunks/letterCasing.js";
import "@capacitor-community/safe-area";
import "@capacitor/clipboard";
import { iso31661 } from "iso-3166";
import { g as getPages } from "../../../chunks/navPages.js";
import ISO6391 from "iso-639-1";
import "clsx";
import { o as onDestroy } from "../../../chunks/index-server.js";
import { T as Thumbnail } from "../../../chunks/Thumbnail.js";
import { App } from "@capacitor/app";
import "@capacitor/browser";
import "material-dynamic-colors";
import { t as truncate } from "../../../chunks/misc.js";
import { A as Author } from "../../../chunks/Author.js";
import { h as html } from "../../../chunks/html.js";
registerPlugin("ColorTheme");
function Logo($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { classes = "" } = $$props;
    let fillColor = "";
    async function setFill() {
      fillColor = (await getDynamicTheme())["--primary"];
    }
    darkModeStore.subscribe(async () => {
      await setFill();
    });
    themeColorStore.subscribe(async () => {
      await setFill();
    });
    $$renderer2.push(`<svg version="1.1"${attr_class(clsx(classes))} height="100%" width="70px" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" viewBox="50.17 104.37 109.67 88.27"><defs id="defs1"></defs><g id="layer1"><g id="g6" transform="matrix(1.0140222,0,0,1.0140222,-1.4722742,-56.323482)"><g id="g1" transform="matrix(-1,0,0,1,201.63735,-7.4456246e-6)"><g id="g5"><path id="path5"${attr_style(`color:#000000;fill:${fillColor};stroke-linecap:square;-inkscape-stroke:none;paint-order:stroke markers fill`)} d="m 114.65661,173.40906 -1.29294,4.82606 h -5.2e-4 l -44.404523,11.89798 32.504993,32.50551 10e-4,0.001 -6.12107,22.84563 -26.381853,-26.38185 -26.381335,-26.38134 36.03811,-9.65625 z m -4.28191,15.97939 -5.37486,20.05872 -0.54622,2.03915 -16.176276,-16.17679 z"></path><path${attr_style(`color:#000000;fill:${fillColor};stroke-linecap:square;-inkscape-stroke:none;paint-order:stroke markers fill`)} d="M 131.38171,245.48534 105,219.10365 l -26.381696,-26.3817 36.038076,-9.65637 36.03807,-9.65638 -9.65637,36.03807 z" id="path3"></path></g></g><circle${attr_style(`opacity:1;fill:${fillColor};fill-opacity:1;stroke:none;stroke-width:10.8326;stroke-linecap:square;stroke-dasharray:none;stroke-opacity:1;paint-order:stroke markers fill`)} id="path6" cx="86.980743" cy="163.40662" r="4.9097047"></circle></g></g></svg>`);
  });
}
function Search($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    interfaceSearchSuggestionsStore.subscribe((value) => value);
    let search = "";
    $$renderer2.push(`<form role="presentation"><div${attr_class("field prefix fill no-margin rounded svelte-1002zyw", void 0, {
      "search": !store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore),
      "search-tv": store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)
    })}><i class="front" tabindex="-1">search</i> <input tabindex="0" id="search-box"${attr("placeholder", store_get($$store_subs ??= {}, "$_", _)("searchPlaceholder"))}${attr("value", search)} class="rounded"/> `);
    {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div></form>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function ApiExtended($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let synciousInstance = get(synciousInstanceStore);
    $$renderer2.push(`<form><nav><div class="field label border max"><input tabindex="0"${attr("value", synciousInstance)} name="syncious-instance" type="text"/> <label tabindex="-1" for="syncious-instance">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.instanceUrl"))}</label></div> <button class="square round"><i>done</i></button></nav></form> <nav class="no-padding"><div class="max"><p>${escape_html(store_get($$store_subs ??= {}, "$_", _)("enabled"))}</p></div> <label class="switch" tabindex="0"><input${attr("checked", store_get($$store_subs ??= {}, "$synciousStore", synciousStore), true)} type="checkbox" role="switch"/> <span></span></label></nav>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function DeArrow($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let deArrowUrl = get(deArrowInstanceStore);
    let deArrowThumbnailUrl = get(deArrowThumbnailInstanceStore);
    $$renderer2.push(`<form><nav><div class="field label border max"><input${attr("value", deArrowUrl)} name="dearrow-instance" type="text"/> <label for="dearrow-instance">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.instanceUrl"))}</label></div> <button class="square round"><i>done</i></button></nav></form> <form><nav><div class="field label border max"><input${attr("value", deArrowThumbnailUrl)} name="dearrow-thumbnail-instance" type="text"/> <label for="dearrow-thumbnail-instance">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.deArrow.thumbnailInstanceUrl"))}</label></div> <button class="square round"><i>done</i></button></nav></form> <nav class="no-padding"><div class="max"><p>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.deArrow.titleOnly"))}</p></div> <label class="switch" tabindex="0"><input${attr("checked", store_get($$store_subs ??= {}, "$deArrowTitlesOnly", deArrowTitlesOnly), true)} type="checkbox" role="switch"/> <span></span></label></nav> <nav class="no-padding"><div class="max"><p>${escape_html(store_get($$store_subs ??= {}, "$_", _)("enabled"))}</p></div> <label class="switch" tabindex="0"><input${attr("checked", store_get($$store_subs ??= {}, "$deArrowEnabledStore", deArrowEnabledStore), true)} type="checkbox" role="switch"/> <span></span></label></nav>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function Interface($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let invidiousInstance = get(instanceStore);
    let region = get(interfaceRegionStore);
    let forceCase = get(interfaceForceCase);
    let defaultPage = get(interfaceDefaultPage);
    let invalidInstance = false;
    interfaceAllowInsecureRequests.subscribe(async (isAllowed) => {
      if (Capacitor.getPlatform() === "android") {
        if (isAllowed) {
          await fetch("http://materialious__allow-insecure-requests");
        } else {
          await fetch("http://materialious__deny-insecure-requests");
        }
      } else if (Capacitor.getPlatform() === "electron") {
        await window.electronAPI.setAllowInsecureSSL(isAllowed);
      }
    });
    if (Capacitor.getPlatform() === "electron") {
      interfaceDisableAutoUpdate.subscribe((isDisabled) => {
        window.electronAPI.doUpdateCheck(isDisabled);
      });
    }
    let pages = [];
    authStore.subscribe(() => {
      pages = getPages();
    });
    if (Capacitor.isNativePlatform()) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<form><nav><div${attr_class("field label border max", void 0, { "invalid": invalidInstance })}><input tabindex="0"${attr("value", invidiousInstance)} name="invidious-instance" type="text"/> <label tabindex="-1" for="invidious-instance">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.instanceUrl"))}</label> `);
      {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div> <button class="square round"><i>done</i></button></nav></form> `);
      {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (Capacitor.isNativePlatform() && store_get($$store_subs ??= {}, "$interfaceAllowInsecureRequests", interfaceAllowInsecureRequests)) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.allowInsecureRequests"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$interfaceAllowInsecureRequests", interfaceAllowInsecureRequests), true)} role="switch"/> <span></span></label></nav></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <button class="no-margin">`);
    if (!store_get($$store_subs ??= {}, "$darkModeStore", darkModeStore)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<i>dark_mode</i> <span>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.theme.darkMode"))}</span>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<i>light_mode</i> <span>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.theme.lightMode"))}</span>`);
    }
    $$renderer2.push(`<!--]--></button> <button><i>palette</i> <span>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.theme.color"))}</span> <input type="color"/></button> <div class="margin"></div> `);
    if (store_get($$store_subs ??= {}, "$darkModeStore", darkModeStore)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.theme.AmoledTheme"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$interfaceAmoledTheme", interfaceAmoledTheme), true)} role="switch"/> <span></span></label></nav></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.searchHistory"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$interfaceSearchHistoryEnabled", interfaceSearchHistoryEnabled), true)} role="switch"/> <span></span></label></nav></div> <div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.lowBandwidthMode"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$interfaceLowBandwidthMode", interfaceLowBandwidthMode), true)} role="switch"/> <span></span></label></nav></div> <div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.searchSuggestions"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$interfaceSearchSuggestionsStore", interfaceSearchSuggestionsStore), true)} role="switch"/> <span></span></label></nav></div> <div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.expandDescription"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$interfaceAutoExpandDesc", interfaceAutoExpandDesc), true)} role="switch"/> <span></span></label></nav></div> <div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.expandChapters"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$interfaceAutoExpandChapters", interfaceAutoExpandChapters), true)} role="switch"/> <span></span></label></nav></div> <div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.expandComments"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$interfaceAutoExpandComments", interfaceAutoExpandComments), true)} role="switch"/> <span></span></label></nav></div> `);
    if (Capacitor.getPlatform() == "android") {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.androidNativeShare"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$interfaceAndroidUseNativeShare", interfaceAndroidUseNativeShare), true)} role="switch"/> <span></span></label></nav></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (Capacitor.getPlatform() == "electron") {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.disableAutoUpdate"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$interfaceDisableAutoUpdate", interfaceDisableAutoUpdate), true)} role="switch"/> <span></span></label></nav></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="field label suffix border">`);
    $$renderer2.select(
      {
        tabindex: "0",
        name: "region",
        value: region,
        onchange: () => interfaceRegionStore.set(region)
      },
      ($$renderer3) => {
        $$renderer3.push(`<!--[-->`);
        const each_array = ensure_array_like(iso31661);
        for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
          let region2 = each_array[$$index];
          $$renderer3.option(
            {
              selected: store_get($$store_subs ??= {}, "$interfaceRegionStore", interfaceRegionStore) === region2.alpha2,
              value: region2.alpha2
            },
            ($$renderer4) => {
              $$renderer4.push(`${escape_html(region2.alpha2)} - ${escape_html(region2.name)}`);
            }
          );
        }
        $$renderer3.push(`<!--]-->`);
      }
    );
    $$renderer2.push(` <label tabindex="-1" for="region">${escape_html(store_get($$store_subs ??= {}, "$_", _)("region"))}</label> <i>arrow_drop_down</i></div> <div class="field label suffix border">`);
    $$renderer2.select(
      {
        tabindex: "0",
        name: "case",
        value: forceCase,
        onchange: () => interfaceForceCase.set(forceCase)
      },
      ($$renderer3) => {
        $$renderer3.option(
          {
            selected: store_get($$store_subs ??= {}, "$interfaceForceCase", interfaceForceCase) === null,
            value: null
          },
          ($$renderer4) => {
            $$renderer4.push(`Default`);
          }
        );
        $$renderer3.push(`<!--[-->`);
        const each_array_1 = ensure_array_like(titleCases);
        for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
          let caseType = each_array_1[$$index_1];
          $$renderer3.option(
            {
              selected: store_get($$store_subs ??= {}, "$interfaceForceCase", interfaceForceCase) === caseType,
              value: caseType
            },
            ($$renderer4) => {
              $$renderer4.push(`${escape_html(letterCase(`${caseType}`, caseType))}`);
            }
          );
        }
        $$renderer3.push(`<!--]-->`);
      }
    );
    $$renderer2.push(` <label tabindex="-1" for="case">${escape_html(store_get($$store_subs ??= {}, "$_", _)("letterCase"))}</label> <i>arrow_drop_down</i></div> <div class="field label suffix border">`);
    $$renderer2.select(
      {
        name: "defaultPage",
        tabindex: "0",
        value: defaultPage,
        onchange: () => interfaceDefaultPage.set(defaultPage)
      },
      ($$renderer3) => {
        $$renderer3.push(`<!--[-->`);
        const each_array_2 = ensure_array_like(pages);
        for (let $$index_2 = 0, $$length = each_array_2.length; $$index_2 < $$length; $$index_2++) {
          let page2 = each_array_2[$$index_2];
          if (!page2.requiresAuth || get(authStore)) {
            $$renderer3.push("<!--[-->");
            $$renderer3.option(
              {
                selected: store_get($$store_subs ??= {}, "$interfaceDefaultPage", interfaceDefaultPage) === page2.href,
                value: page2.href
              },
              ($$renderer4) => {
                $$renderer4.push(`${escape_html(page2.name)}`);
              }
            );
          } else {
            $$renderer3.push("<!--[!-->");
          }
          $$renderer3.push(`<!--]-->`);
        }
        $$renderer3.push(`<!--]-->`);
      }
    );
    $$renderer2.push(` <label tabindex="-1" for="defaultPage">${escape_html(store_get($$store_subs ??= {}, "$_", _)("defaultPage"))}</label> <i>arrow_drop_down</i></div> `);
    if (!Capacitor.isNativePlatform()) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="settings"><h6>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.bookmarklet"))}</h6> <button class="no-margin">${escape_html(store_get($$store_subs ??= {}, "$_", _)("copyUrl"))}</button></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
const playbackRates = [0.25, 0.5, 0.75, 1, 1.25, 1.5, 1.75, 2, 2.25, 2.5, 2.75, 3];
function Player($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let defaultLanguage = get(playerDefaultLanguage);
    let localVideoFallback = "enabled";
    if (!store_get($$store_subs ??= {}, "$playerYouTubeJsFallback", playerYouTubeJsFallback)) {
      localVideoFallback = "disabled";
    } else if (store_get($$store_subs ??= {}, "$playerYouTubeJsAlways", playerYouTubeJsAlways)) {
      localVideoFallback = "always";
    }
    const languageNames = ISO6391.getAllCodes().map((code) => ISO6391.getName(code).toLocaleLowerCase());
    function onQualityChange(event) {
      const value = event.target.value;
      playerDefaultQualityStore.set(value);
    }
    function onSpeedChange(event) {
      const value = event.target.value;
      playerDefaultPlaybackSpeed.set(Number(value));
    }
    function onLocalVideoFallbackChange() {
      switch (localVideoFallback) {
        case "enabled":
          playerYouTubeJsFallback.set(true);
          playerYouTubeJsAlways.set(false);
          break;
        case "disabled":
          playerYouTubeJsFallback.set(false);
          playerYouTubeJsAlways.set(false);
          break;
        case "always":
          playerYouTubeJsAlways.set(true);
          playerYouTubeJsFallback.set(true);
          break;
      }
    }
    $$renderer2.push(`<div class="margin"></div> <div class="field label suffix border">`);
    $$renderer2.select(
      {
        tabindex: "0",
        name: "case",
        value: defaultLanguage,
        onchange: () => playerDefaultLanguage.set(defaultLanguage)
      },
      ($$renderer3) => {
        $$renderer3.option(
          {
            selected: store_get($$store_subs ??= {}, "$playerDefaultLanguage", playerDefaultLanguage) === "original",
            value: "original"
          },
          ($$renderer4) => {
            $$renderer4.push(`Original`);
          }
        );
        $$renderer3.push(`<!--[-->`);
        const each_array = ensure_array_like(languageNames);
        for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
          let language = each_array[$$index];
          $$renderer3.option(
            {
              selected: store_get($$store_subs ??= {}, "$playerDefaultLanguage", playerDefaultLanguage) === language,
              value: language
            },
            ($$renderer4) => {
              $$renderer4.push(`${escape_html(titleCase(language))}`);
            }
          );
        }
        $$renderer3.push(`<!--]-->`);
      }
    );
    $$renderer2.push(` <label tabindex="-1" for="case">${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.defaultLanguage"))}</label> <i>arrow_drop_down</i></div> <div class="field label suffix border">`);
    $$renderer2.select(
      {
        tabindex: "0",
        name: "quality",
        id: "quality",
        value: store_get($$store_subs ??= {}, "$playerDefaultQualityStore", playerDefaultQualityStore),
        onchange: onQualityChange
      },
      ($$renderer3) => {
        $$renderer3.option({ value: "auto" }, ($$renderer4) => {
          $$renderer4.push(`Auto (Recommended)`);
        });
        $$renderer3.option({ value: "144" }, ($$renderer4) => {
          $$renderer4.push(`144p (Ultra low)`);
        });
        $$renderer3.option({ value: "240" }, ($$renderer4) => {
          $$renderer4.push(`240p (Low)`);
        });
        $$renderer3.option({ value: "360" }, ($$renderer4) => {
          $$renderer4.push(`360p (SD)`);
        });
        $$renderer3.option({ value: "480" }, ($$renderer4) => {
          $$renderer4.push(`480p (SD+)`);
        });
        $$renderer3.option({ value: "720" }, ($$renderer4) => {
          $$renderer4.push(`720p (HD)`);
        });
        $$renderer3.option({ value: "1080" }, ($$renderer4) => {
          $$renderer4.push(`1080p (Full HD)`);
        });
        $$renderer3.option({ value: "1440" }, ($$renderer4) => {
          $$renderer4.push(`1440p (2K)`);
        });
        $$renderer3.option({ value: "2160" }, ($$renderer4) => {
          $$renderer4.push(`2160p (4K UHD)`);
        });
      }
    );
    $$renderer2.push(` <label tabindex="-1" for="quality">${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.preferredQuality"))}</label> <i>arrow_drop_down</i></div> <div class="field label suffix border">`);
    $$renderer2.select(
      {
        tabindex: "0",
        name: "quality",
        id: "quality",
        value: store_get($$store_subs ??= {}, "$playerDefaultPlaybackSpeed", playerDefaultPlaybackSpeed),
        onchange: onSpeedChange
      },
      ($$renderer3) => {
        $$renderer3.push(`<!--[-->`);
        const each_array_1 = ensure_array_like(playbackRates);
        for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
          let speed = each_array_1[$$index_1];
          $$renderer3.option({ value: speed }, ($$renderer4) => {
            $$renderer4.push(`x${escape_html(speed)}`);
          });
        }
        $$renderer3.push(`<!--]-->`);
      }
    );
    $$renderer2.push(` <label tabindex="-1" for="quality">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.player.defaultPlaybackSpeed"))}</label> <i>arrow_drop_down</i></div> `);
    if (Capacitor.isNativePlatform()) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="field suffix border label">`);
      $$renderer2.select(
        {
          tabindex: "0",
          name: "ytfallback",
          value: localVideoFallback,
          onchange: onLocalVideoFallbackChange
        },
        ($$renderer3) => {
          $$renderer3.option({ value: "enabled" }, ($$renderer4) => {
            $$renderer4.push(`${escape_html(store_get($$store_subs ??= {}, "$_", _)("enabled"))}`);
          });
          $$renderer3.option({ value: "always" }, ($$renderer4) => {
            $$renderer4.push(`${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.player.youtubeJsAlways"))}`);
          });
          $$renderer3.option({ value: "disabled" }, ($$renderer4) => {
            $$renderer4.push(`${escape_html(store_get($$store_subs ??= {}, "$_", _)("disabled"))}`);
          });
        }
      );
      $$renderer2.push(` <label tabindex="-1" for="ytfallback">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.player.localVideoFallback"))}</label> <i>arrow_drop_down</i></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.player.ccByDefault"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$playerCCByDefault", playerCCByDefault), true)} role="switch"/> <span></span></label></nav></div> <div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.player.miniPlayer"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$playerMiniplayerEnabled", playerMiniplayerEnabled), true)} role="switch"/> <span></span></label></nav></div> <div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.player.autoPlay"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$playerAutoPlayStore", playerAutoPlayStore), true)} role="switch"/> <span></span></label></nav></div> <div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.player.alwaysLoopVideo"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$playerAlwaysLoopStore", playerAlwaysLoopStore), true)} role="switch"/> <span></span></label></nav></div> `);
    if (Capacitor.getPlatform() === "android") {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.player.lockOrientation"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$playerAndroidLockOrientation", playerAndroidLockOrientation), true)} role="switch"/> <span></span></label></nav></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (Capacitor.isNativePlatform()) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.player.proxyVideos"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$playerProxyVideosStore", playerProxyVideosStore), true)} role="switch"/> <span></span></label></nav></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.player.savePlaybackPosition"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$playerSavePlaybackPositionStore", playerSavePlaybackPositionStore), true)} role="switch"/> <span></span></label></nav></div> <div class="field no-margin m l"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.player.theatreModeByDefault"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$playerTheatreModeByDefaultStore", playerTheatreModeByDefaultStore), true)} role="switch"/> <span></span></label></nav></div> <div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.player.autoPlayNextByDefault"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$playerAutoplayNextByDefaultStore", playerAutoplayNextByDefaultStore), true)} role="switch"/> <span></span></label></nav></div> <div class="field no-margin"><nav class="no-padding"><div class="max"><div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.player.playerStatistics"))}</div></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", store_get($$store_subs ??= {}, "$playerStatisticsByDefault", playerStatisticsByDefault), true)} role="switch"/> <span></span></label></nav></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function RYD($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let returnYTInstance = get(returnYTDislikesInstanceStore);
    $$renderer2.push(`<form><nav><div class="field label border max"><input tabindex="0"${attr("value", returnYTInstance)} name="returnyt-instance" type="text"/> <label tabindex="-1" for="returnyt-instance">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.instanceUrl"))}</label></div> <button class="square round"><i>done</i></button></nav></form> <nav class="no-padding"><div class="max"><p>${escape_html(store_get($$store_subs ??= {}, "$_", _)("enabled"))}</p></div> <label class="switch" tabindex="0"><input${attr("checked", store_get($$store_subs ??= {}, "$returnYtDislikesStore", returnYtDislikesStore), true)} type="checkbox" role="switch"/> <span></span></label></nav>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function SponsorBlock($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let sponsorCategoriesList = [];
    sponsorBlockCategoriesStore.subscribe((value) => {
      sponsorCategoriesList = value;
    });
    let sponsorBlockInstance = get(sponsorBlockUrlStore);
    const sponsorCategories = [
      {
        name: store_get($$store_subs ??= {}, "$_", _)("layout.sponsors.sponsor"),
        category: "sponsor"
      },
      {
        name: store_get($$store_subs ??= {}, "$_", _)("layout.sponsors.unpaidSelfPromotion"),
        category: "selfpromo"
      },
      {
        name: store_get($$store_subs ??= {}, "$_", _)("layout.sponsors.interactionReminder"),
        category: "interaction"
      },
      {
        name: store_get($$store_subs ??= {}, "$_", _)("layout.sponsors.intermissionIntroAnimation"),
        category: "intro"
      },
      {
        name: store_get($$store_subs ??= {}, "$_", _)("layout.sponsors.credits"),
        category: "outro"
      },
      {
        name: store_get($$store_subs ??= {}, "$_", _)("layout.sponsors.preViewRecapHook"),
        category: "preview"
      },
      {
        name: store_get($$store_subs ??= {}, "$_", _)("layout.sponsors.tangentJokes"),
        category: "filler"
      }
    ];
    $$renderer2.push(`<form><nav><div class="field label border max"><input tabindex="0"${attr("value", sponsorBlockInstance)} name="sponsorblock-instance" type="text"/> <label tabindex="-1" for="sponsorblock-instance">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.instanceUrl"))}</label></div> <button class="square round"><i>done</i></button></nav></form> <nav class="no-padding"><div class="max"><p>${escape_html(store_get($$store_subs ??= {}, "$_", _)("enabled"))}</p></div> <label class="switch" tabindex="0"><input${attr("checked", store_get($$store_subs ??= {}, "$sponsorBlockStore", sponsorBlockStore), true)} type="checkbox" role="switch"/> <span></span></label></nav> <nav class="no-padding"><div class="max"><p>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.sponsors.disableToast"))}</p></div> <label class="switch" tabindex="0"><input${attr("checked", store_get($$store_subs ??= {}, "$sponsorBlockDisplayToastStore", sponsorBlockDisplayToastStore), true)} type="checkbox" role="switch"/> <span></span></label></nav> <hr style="margin: 1em 0;"/> <p class="bold">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.sponsors.Catagories"))}</p> <!--[-->`);
    const each_array = ensure_array_like(sponsorCategories);
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let sponsor = each_array[$$index];
      $$renderer2.push(`<div class="field middle-align no-margin"><nav class="no-padding"><div class="max"><p>${escape_html(sponsor.name)}</p></div> <label class="switch" tabindex="0"><input type="checkbox"${attr("checked", sponsorCategoriesList.includes(sponsor.category), true)} role="switch"/> <span></span></label></nav></div>`);
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function About($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let ghContributors = [];
    $$renderer2.push(`<div class="grid"><div class="s12 m4 l4"><a href="https://github.com/sponsors/WardPearce" target="_blank" referrerpolicy="no-referrer" class="svelte-15e61jh"><article class="svelte-15e61jh"><i>favorite</i> <span>${escape_html(store_get($$store_subs ??= {}, "$_", _)("donate"))}</span></article></a></div> <div class="s12 m4 l4"><a href="https://github.com/Materialious/Materialious" target="_blank" referrerpolicy="no-referrer" class="svelte-15e61jh"><article class="svelte-15e61jh"><i>code</i> <span>GitHub</span></article></a></div> <div class="s12 m4 l4"><article class="svelte-15e61jh"><span>${escape_html(store_get($$store_subs ??= {}, "$_", _)("version"))}</span> <span>${escape_html("1.12.8")}</span></article></div></div> <h4>${escape_html(store_get($$store_subs ??= {}, "$_", _)("contributors"))}</h4> <div class="grid"><!--[-->`);
    const each_array = ensure_array_like(ghContributors);
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let contributor = each_array[$$index];
      if (contributor.type === "User") {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="s12 m4 l4"><article class="svelte-15e61jh"><img class="circle"${attr("src", contributor.avatar_url)}${attr("alt", contributor.login)}/> <p>${escape_html(contributor.login)}</p></article></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function Settings($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let activeTab = "interface";
    const isActive = (id) => activeTab === id;
    const tabs = [
      {
        id: "interface",
        label: store_get($$store_subs ??= {}, "$_", _)("layout.interface"),
        icon: "grid_view",
        component: Interface
      },
      {
        id: "player",
        label: store_get($$store_subs ??= {}, "$_", _)("layout.player.title"),
        icon: "smart_display",
        component: Player
      },
      { id: "ryd", label: "RYD", icon: "thumb_down", component: RYD },
      {
        id: "api extended",
        label: "API Extended",
        icon: "sync",
        component: ApiExtended
      },
      {
        id: "sponsorblock",
        label: "Sponsorblock",
        icon: "block",
        component: SponsorBlock
      },
      {
        id: "dearrow",
        label: store_get($$store_subs ??= {}, "$_", _)("layout.deArrow.title"),
        icon: "keyboard_double_arrow_down",
        component: DeArrow
      },
      {
        id: "about",
        label: store_get($$store_subs ??= {}, "$_", _)("layout.about"),
        icon: "info",
        component: About
      }
    ];
    const tabIds = tabs.map((tab) => tab.id);
    let dialogType = "";
    $$renderer2.push(`<dialog id="dialog-settings"${attr_class(dialogType + " surface-container")}><nav class="s m" style="margin-bottom: 1em;"><h4 class="max">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.settings"))}</h4> <button class="circle transparent" data-ui="#dialog-settings"><i>close</i></button></nav> <div><nav class="wrap s"><button class="large small-round secondary max" data-ui="#tab-menu"><i>${escape_html(tabs[tabIds.indexOf(activeTab)].icon)}</i> <span>${escape_html(tabs[tabIds.indexOf(activeTab)].label)}</span> <menu style="width: 100%;" data-ui="#tab-menu" id="tab-menu"><!--[-->`);
    const each_array = ensure_array_like(tabs);
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let tab = each_array[$$index];
      $$renderer2.push(`<li role="presentation" data-ui="#tab-menu"><i>${escape_html(tab.icon)}</i> <span>${escape_html(tab.label)}</span></li>`);
    }
    $$renderer2.push(`<!--]--></menu></button></nav> <nav class="tabbed small m l svelte-1mhnvjn" style="outline: none" role="tablist" tabindex="0"><!--[-->`);
    const each_array_1 = ensure_array_like(tabs);
    for (let index = 0, $$length = each_array_1.length; index < $$length; index++) {
      let tab = each_array_1[index];
      $$renderer2.push(`<a role="tab"${attr("aria-selected", isActive(tab.id))}${attr("id", `tab-${tab.id}`)}${attr("aria-controls", `panel-${tab.id}`)}${attr("tabindex", isActive(tab.id) ? 0 : -1)}${attr_class("svelte-1mhnvjn", void 0, { "active": isActive(tab.id) })}><i>${escape_html(tab.icon)}</i> <span>${escape_html(tab.label)}</span></a>`);
    }
    $$renderer2.push(`<!--]--> `);
    if (!store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<a${attr("href", `${store_get($$store_subs ??= {}, "$instanceStore", instanceStore)}/preferences`)} target="_blank" referrerpolicy="no-referrer" class="svelte-1mhnvjn"><i><svg viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg"><svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" viewBox="0 0 512 512"><path d="M244.2 502.3c-25.1-1-49.2-5.4-72.6-13.3-77.4-26.1-138-87.1-161.3-162.4C.2 294.1-2.5 258 2.3 222.3c4.7-34.9 17.3-68 37.3-98.2 15.3-23.2 37-46.1 60-63.3 46.9-35.1 109.2-54 168.2-51 32.9 1.7 63.4 8.6 92.9 21.1 10.4 4.4 25.4 12.3 35.2 18.5 18 11.3 28.4 19.7 43.8 35 16.8 16.8 28.1 30.8 38.6 48.1 9.2 15.1 17.9 34.5 23.2 51.3 2 6.5 5.6 20.9 7.2 28.8 3 15.1 3.4 20 3.4 42.3 0 23.5-.6 31-3.7 46.7-11.8 59.6-45.2 112-95.1 149.4-29 21.7-63.5 37.5-99.8 45.5-21.3 4.8-45.1 6.7-69.3 5.8m-44.6-100.1c0-.7-.1-2.6-.2-4.3l-.2-3.1-6-.3c-5.1-.3-6.1-.4-6.8-1-2.6-1.9-1.9-7.7 2.9-23.4 1.1-3.7 4.2-14.4 7-23.8 2.7-9.5 6.6-22.7 8.6-29.3 2-6.7 5.3-18.1 7.4-25.5 2.1-7.3 4.6-15.8 5.5-18.8s4.1-14 7.2-24.5c6.3-21.6 10.4-35.2 11.4-37.9.7-1.8.7-1.8 1.3-1.2.3.3 4.9 9.4 10.1 20.1 5.3 10.7 16.6 33.8 25.3 51.2 21.8 44.1 48.1 97.3 55 111.3l5.8 11.8 14.4-.1c7.9-.1 14.8-.2 15.2-.4.7-.3.7-.4-1.7-5.5-1.4-2.9-10.3-21.1-20-40.5-62.1-125-78-157.4-86.5-176-6-13.1-8.8-18.8-9.8-20-1.1-1.2-2.1-1.4-3-.3-1.5 1.7-5.2 12.8-11.9 35.9-2.6 9-8.3 28.5-12.6 43.3-8.4 28.7-10.8 36.9-18.2 62.1-2.6 8.8-6.1 20.8-7.8 26.6s-5.1 17.5-7.6 26.1c-5.5 18.9-7.8 26.5-9.4 30.8-2.7 7.3-3.3 8-6.3 8.6-1.1.2-3.1.4-4.3.4-2.8 0-4.5.5-5.2 1.4-.5.8-.7 6.2-.2 7 .3.4 3.1.5 29.6.7l10.9.1zm46.7-261.1c5.5-1.2 10.7-6.3 12-11.7.5-2 .4-6.3-.1-8.2-1.1-4-4.2-8-7.7-9.9-4.8-2.6-12-2.6-16.9 0-7.6 4.1-10.4 14.1-6.1 22.1 3.5 6.4 10.7 9.4 18.8 7.7" style="fill:#f0f0f0"></path><path d="M2712.8 5196.2c-157.5-82.6-156.2-323.9 3.8-405.2 109.2-55.9 249-20.3 313.7 78.8 73.7 110.5 33 268-85.1 327.7-64.7 33-167.6 33-232.4-1.3z" style="fill:#00b6f0;stroke:#00b6f0;stroke-width:.297;stroke-miterlimit:10" transform="matrix(.0699 0 0 -.0699 44.236 474.48)"></path><path d="M2833.5 4483.6c-15.2-20.3-80-210.9-129.6-384.9-38.1-132.1-128.3-444.6-209.6-717.7-25.4-87.6-73.7-252.8-108-368.4-33-115.6-81.3-280.7-108-368.4-25.4-87.6-73.7-252.8-108-368.4-33-115.6-81.3-280.7-108-368.4-25.4-87.6-72.4-247.7-102.9-355.7-74.9-262.9-118.1-379.8-146.1-393.8-12.7-7.6-44.5-12.7-71.1-12.7-92.7 0-106.7-10.2-102.9-68.6l3.8-52.1 289.6-3.8 289.6-2.5-3.8 59.7-3.8 61-92.7 3.8c-83.8 3.8-94 6.4-106.7 34.3-16.5 35.6 0 132.1 47 285.8 16.5 52.1 59.7 198.2 95.3 323.9 35.6 125.8 83.8 292.2 108 368.4 22.9 77.5 71.1 242.6 108 368.4 35.6 125.8 83.8 292.2 108 368.4 22.9 77.5 71.1 242.6 108 368.4 108 377.3 156.2 532.2 166.4 544.9 6.4 6.4 21.6-14 35.6-44.5 12.7-30.5 243.9-499.2 511.9-1040.3s567.8-1145.7 664.3-1343.9l176.6-358.2h213.4c116.9 0 213.4 5.1 213.4 10.2s-95.3 200.7-210.9 434.4C3613.4 2965.6 3129.4 3950 3048.2 4130.4c-36.8 80-87.6 191.8-113.1 247.7-55.9 120.8-73.7 139.8-101.6 105.5" style="fill:#575757" transform="matrix(.0699 0 0 -.0699 44.236 474.48)"></path></svg></svg></i> <span>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.settings"))}</span></a>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></nav> <div class="space"></div> <div class="divider"></div> <!--[-->`);
    const each_array_2 = ensure_array_like(tabs);
    for (let $$index_2 = 0, $$length = each_array_2.length; $$index_2 < $$length; $$index_2++) {
      let tab = each_array_2[$$index_2];
      $$renderer2.push(`<div${attr_class("page padding", void 0, { "active": isActive(tab.id) })}${attr("id", `panel-${tab.id}`)} role="tabpanel"${attr("aria-labelledby", `tab-${tab.id}`)}${attr("hidden", !isActive(tab.id))}${attr("inert", !store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore) && !isActive(tab.id), true)}${attr("aria-hidden", !isActive(tab.id))}><!---->`);
      tab.component($$renderer2, {});
      $$renderer2.push(`<!----></div>`);
    }
    $$renderer2.push(`<!--]--></div></dialog>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function SyncParty($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    page.subscribe((newPage) => {
      if (!newPage.url.pathname.startsWith(resolve("/watch", {})) && store_get($$store_subs ??= {}, "$syncPartyPeerStore", syncPartyPeerStore)) {
        store_get($$store_subs ??= {}, "$syncPartyConnectionsStore", syncPartyConnectionsStore)?.forEach((conn) => {
          conn.send({ events: [{ type: "goto", path: newPage.url.pathname }] });
        });
      }
    });
    onDestroy(() => {
      if (store_get($$store_subs ??= {}, "$syncPartyPeerStore", syncPartyPeerStore)) {
        store_get($$store_subs ??= {}, "$syncPartyPeerStore", syncPartyPeerStore).destroy();
        store_set(syncPartyPeerStore, null);
      }
    });
    $$renderer2.push(`<dialog id="sync-party"><h6>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.syncParty"))}</h6> <p>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.syncPartyWarning"))}</p> `);
    if (store_get($$store_subs ??= {}, "$syncPartyPeerStore", syncPartyPeerStore)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<nav><div class="field label border max"><input name="sync-share" readonly${attr("value", `${location.origin}${resolve(`/?sync=${store_get($$store_subs ??= {}, "$syncPartyPeerStore", syncPartyPeerStore)?.id}`, {})}`)} type="text"/> <label class="active" for="sync-share">Share URL</label></div> <button class="square round"><i>content_copy</i></button></nav>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="space"></div> <button class="no-margin"${attr("data-ui", `${store_get($$store_subs ??= {}, "$syncPartyPeerStore", syncPartyPeerStore) ? "#sync-party" : ""}`)}>`);
    if (store_get($$store_subs ??= {}, "$syncPartyPeerStore", syncPartyPeerStore)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.endSyncParty"))}`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.startSyncParty"))}`);
    }
    $$renderer2.push(`<!--]--></button></dialog> <div class="snackbar" id="sync-party-connection-join"><i>person_add</i> <span>${escape_html(store_get($$store_subs ??= {}, "$_", _)("syncParty.userJoined"))}</span></div> <div class="snackbar" id="sync-party-connection-left"><i>person_remove</i> <span>${escape_html(store_get($$store_subs ??= {}, "$_", _)("syncParty.userLeft"))}</span></div> <div class="snackbar" id="sync-party-private-page"><i>shield_person</i> <span>${escape_html(store_get($$store_subs ??= {}, "$_", _)("syncParty.userOnPrivatePage"))}</span></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
const pwaInfo = { "webManifest": { "linkTag": '<link rel="manifest" href="/manifest.webmanifest">' } };
function _layout($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { children } = $$props;
    let isLoggedIn = false;
    authStore.subscribe((value) => {
      isLoggedIn = value !== null;
    });
    let notifications = [];
    let playerIsPip = false;
    page.subscribe((pageData) => {
      playerIsPip = !pageData.url.pathname.includes("/watch");
    });
    interfaceAmoledTheme.subscribe(async () => {
      setAmoledTheme();
      await setStatusBarColor();
    });
    darkModeStore.subscribe(async () => {
      setTheme();
      setAmoledTheme();
      await setStatusBarColor();
    });
    App.addListener("backButton", async (data) => {
      if (data.canGoBack) {
        window.history.back();
      } else {
        await App.exitApp();
      }
    });
    App.addListener("appUrlOpen", (data) => {
      const url = new URL(data.url);
      if (url.protocol !== "materialious-auth:") {
        let videoId = url.searchParams.get("v");
        if (!videoId) {
          videoId = url.pathname.split("/")[1];
        }
        if (videoId === "shorts") {
          videoId = url.pathname.split("/")[2];
        }
        if (!videoId) {
          return;
        }
        goto(resolve(`/watch/[videoId]`, { videoId }));
      } else {
        const username = url.searchParams.get("username");
        const token = url.searchParams.get("token");
        if (username && token) {
          authStore.set({ username, token });
        }
      }
    });
    let loginError = false;
    let rawUsername = "";
    let rawPassword = "";
    themeColorStore.subscribe(async (hex) => {
      if (!hex) return;
      await cn("theme", hex);
    });
    onDestroy(() => {
      if (store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)) {
        Mousetrap.unbind("down", "keyup");
      }
    });
    let webManifestLink = pwaInfo ? pwaInfo.webManifest.linkTag : "";
    head("1v2axqk", $$renderer2, ($$renderer3) => {
      $$renderer3.push(`${html(webManifestLink)} `);
      if (Capacitor.getPlatform() === "android" && !store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)) {
        $$renderer3.push("<!--[-->");
        $$renderer3.push(`<style>
			nav.top {
				height: 120px;
			}
		</style>`);
      } else {
        $$renderer3.push("<!--[!-->");
      }
      $$renderer3.push(`<!--]-->`);
    });
    $$renderer2.push(`<div><nav${attr_class("left m l surface-container svelte-1v2axqk", void 0, {
      "tv-nav": store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)
    })}><header role="presentation" style="cursor: pointer;" tabindex="-1" class="small-padding">`);
    Logo($$renderer2, {});
    $$renderer2.push(`<!----></header> <!--[-->`);
    const each_array = ensure_array_like(getPages());
    for (let $$index = 0, $$length = each_array.length; $$index < $$length; $$index++) {
      let navPage = each_array[$$index];
      if (!navPage.requiresAuth || isLoggedIn) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<a${attr("href", resolve(navPage.href, {}))}${attr_class("", void 0, {
          "active": store_get($$store_subs ??= {}, "$page", page).url.href.endsWith(navPage.href)
        })}><i>${escape_html(navPage.icon)}</i> <div>${escape_html(navPage.name)}</div></a>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></nav> <nav${attr_class("top svelte-1v2axqk", void 0, {
      "tv-nav": store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)
    })} id="top-content">`);
    {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<button class="transparent s circle large"><i>search</i></button>`);
    }
    $$renderer2.push(`<!--]--> `);
    if (Capacitor.getPlatform() === "electron") {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<nav class="no-space"><button class="border"><i>arrow_back</i></button> <button class="border"><i>arrow_forward</i></button></nav>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="max m l"></div> <div class="m l">`);
    Search($$renderer2);
    $$renderer2.push(`<!----></div> `);
    {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="max"></div>`);
    }
    $$renderer2.push(`<!--]--> `);
    {
      $$renderer2.push("<!--[!-->");
      if (!Capacitor.isNativePlatform()) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<button data-ui="#sync-party" class="circle large transparent"><i${attr_class("", void 0, {
          "primary-text": store_get($$store_subs ??= {}, "$syncPartyPeerStore", syncPartyPeerStore)
        })}>group</i> <div class="tooltip bottom">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.syncParty"))}</div></button>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      if (isLoggedIn) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<button class="circle large transparent"><i>notifications</i> <div class="tooltip bottom">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.notifications"))}</div></button>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> <button class="circle large transparent"><i>settings</i> <div class="tooltip bottom">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.settings"))}</div></button> `);
      if (!isLoggedIn) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<button class="circle large transparent"><i>login</i> <div class="tooltip bottom">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.login"))}</div></button>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<button class="circle large transparent"><i>logout</i> <div class="tooltip bottom">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.logout"))}</div></button>`);
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></nav> <nav class="bottom s"><!--[-->`);
    const each_array_1 = ensure_array_like(getPages());
    for (let $$index_1 = 0, $$length = each_array_1.length; $$index_1 < $$length; $$index_1++) {
      let navPage = each_array_1[$$index_1];
      if (!navPage.requiresAuth || isLoggedIn) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<a${attr_class("round", void 0, {
          "active": store_get($$store_subs ??= {}, "$page", page).url.href.endsWith(navPage.href)
        })}${attr("href", resolve(navPage.href, {}))} data-sveltekit-preload-data="off"><i>${escape_html(navPage.icon)}</i> <span style="font-size: .8em;">${escape_html(navPage.name)}</span></a>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></nav> `);
    Settings($$renderer2);
    $$renderer2.push(`<!----> <dialog class="right" id="dialog-notifications"><nav><h5 class="max">${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.notifications"))}</h5> <button class="circle transparent" data-ui="#dialog-notifications"><i>close</i></button></nav> `);
    if (notifications.length === 0) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<p>${escape_html(store_get($$store_subs ??= {}, "$_", _)("layout.noNewNotifications"))}</p>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<!--[-->`);
      const each_array_2 = ensure_array_like(notifications);
      for (let $$index_2 = 0, $$length = each_array_2.length; $$index_2 < $$length; $$index_2++) {
        let notification = each_array_2[$$index_2];
        $$renderer2.push(`<article class="no-padding border">`);
        Thumbnail($$renderer2, { video: notification });
        $$renderer2.push(`<!----></article>`);
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></dialog> <main id="main-content" class="responsive max root" tabindex="0" role="region">`);
    if (store_get($$store_subs ??= {}, "$playerState", playerState)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="grid"><div${attr_class("svelte-1v2axqk", void 0, {
        "pip": playerIsPip,
        "s12": !playerIsPip,
        "m12": !playerIsPip,
        "l12": store_get($$store_subs ??= {}, "$playertheatreModeIsActive", playertheatreModeIsActive) && !playerIsPip,
        "l9": !store_get($$store_subs ??= {}, "$playertheatreModeIsActive", playertheatreModeIsActive) && !playerIsPip
      })}><div class="pip-info svelte-1v2axqk">`);
      if (playerIsPip) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div><nav><h6 class="max svelte-1v2axqk">${escape_html(truncate(store_get($$store_subs ??= {}, "$playerState", playerState).data.video.title, 25))}</h6> <button class="border m l"><i>close</i></button></nav> <div class="space"></div> <nav class="s"><a class="button border"${attr("href", resolve(`/watch/[videoId]`, {
          videoId: store_get($$store_subs ??= {}, "$playerState", playerState).data.video.videoId
        }))}><i>keyboard_arrow_right</i></a> <button class="border"><i>close</i></button></nav></div>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> <div class="player svelte-1v2axqk"><!---->`);
      {
        Player$1($$renderer2, {
          data: store_get($$store_subs ??= {}, "$playerState", playerState).data,
          hideControls: playerIsPip
        });
      }
      $$renderer2.push(`<!----></div></div> `);
      if (playerIsPip) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<nav class="m l">`);
        Author($$renderer2, {
          channel: store_get($$store_subs ??= {}, "$playerState", playerState).data.video,
          hideSubscribe: true
        });
        $$renderer2.push(`<!----> <div class="max"></div> <a class="button border"${attr("href", resolve(`/watch/[videoId]`, {
          videoId: store_get($$store_subs ??= {}, "$playerState", playerState).data.video.videoId
        }))}><i>keyboard_arrow_right</i></a></nav>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></div></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (store_get($$store_subs ??= {}, "$navigating", navigating)) {
      $$renderer2.push("<!--[-->");
      PageLoading($$renderer2);
    } else {
      $$renderer2.push("<!--[!-->");
      children?.($$renderer2);
      $$renderer2.push(`<!---->`);
    }
    $$renderer2.push(`<!--]--> `);
    SyncParty($$renderer2);
    $$renderer2.push(`<!----></main></div> <dialog class="modal" id="tv-login"><h5>${escape_html(store_get($$store_subs ??= {}, "$_", _)("loginRequired"))}</h5> <div>${escape_html(store_get($$store_subs ??= {}, "$_", _)("invidiousLogin"))}</div> <form><div${attr_class("field label border", void 0, { "invalid": loginError })}><input id="username"${attr("value", rawUsername)} name="username" type="text"/> <label for="username">Username</label></div> <div${attr_class("field label border", void 0, { "invalid": loginError })}><input${attr("value", rawPassword)} name="password" type="password"/> <label for="password">Password</label></div> <nav class="right-align no-space"><button class="transparent link" type="button">${escape_html(store_get($$store_subs ??= {}, "$_", _)("cancel"))}</button> <button class="transparent link" type="submit">${escape_html(store_get($$store_subs ??= {}, "$_", _)("login"))}</button></nav></form></dialog>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _layout as default
};
