import { g as get } from "./index3.js";
import { i as getPlaylist } from "./index5.js";
import { m as playlistCacheStore } from "./store.js";
async function loadEntirePlaylist(playlistId) {
  const cachedPlaylists = get(playlistCacheStore);
  if (playlistId in cachedPlaylists) {
    return cachedPlaylists[playlistId];
  }
  let playlistVideos = [];
  let playlist = void 0;
  const ignoreVideos = [];
  for (let page = 1; page < Infinity; page++) {
    const newPlaylist = await getPlaylist(playlistId, page);
    if (page === 1) {
      playlist = newPlaylist;
    }
    let newVideos = newPlaylist.videos;
    if (newVideos.length === 0) {
      break;
    }
    newVideos = newVideos.filter((playlistVideo) => {
      playlistVideo.type = "video";
      return playlistVideo.lengthSeconds > 0 && !ignoreVideos.includes(playlistVideo.videoId);
    });
    newVideos.forEach((playlistVideo) => {
      ignoreVideos.push(playlistVideo.videoId);
    });
    playlistVideos = [...playlistVideos, ...newVideos].sort(
      (a, b) => {
        return a.index < b.index ? -1 : 1;
      }
    );
  }
  if (typeof playlist === "undefined") {
    throw new Error("Unable to fetch playlist");
  }
  const combined = { videos: playlistVideos, info: playlist };
  playlistCacheStore.set({ [playlistId]: combined });
  return combined;
}
export {
  loadEntirePlaylist as l
};
