import humanNumber from "human-number";
function numberWithCommas(number) {
  if (typeof number === "undefined") return;
  return number.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}
function cleanNumber(number) {
  return humanNumber(
    number,
    (number2) => Number.parseFloat(number2.toString()).toFixed(1)
  ).replace(".0", "");
}
function videoLength(lengthSeconds) {
  const hours = Math.floor(lengthSeconds / 3600);
  let minutes = Math.floor(lengthSeconds % 3600 / 60);
  let seconds = Math.round(lengthSeconds % 60);
  if (minutes < 10) {
    minutes = `0${minutes}`;
  }
  if (seconds < 10) {
    seconds = `0${seconds}`;
  }
  if (hours !== 0) {
    return `${hours}:${minutes}:${seconds}`;
  } else {
    return `${minutes}:${seconds}`;
  }
}
function convertToSeconds(time) {
  const parts = time.split(":").map((part) => parseInt(part));
  let seconds = 0;
  if (parts.length === 3) {
    seconds = parts[0] * 3600 + parts[1] * 60 + parts[2];
  } else if (parts.length === 2) {
    seconds = parts[0] * 60 + parts[1];
  } else if (parts.length === 1) {
    seconds = parts[0];
  }
  return seconds;
}
function humanizeSeconds(totalSeconds) {
  const secondsInMinute = 60;
  const secondsInHour = 3600;
  const hours = Math.floor(totalSeconds / secondsInHour);
  const minutes = Math.floor(totalSeconds % secondsInHour / secondsInMinute);
  const parts = [];
  if (hours > 0) {
    parts.push(`${hours} hour${hours > 1 ? "s" : ""}`);
  }
  if (minutes > 0) {
    parts.push(`${minutes} minute${minutes > 1 ? "s" : ""}`);
  }
  return parts.join(", ");
}
export {
  convertToSeconds as a,
  cleanNumber as c,
  humanizeSeconds as h,
  numberWithCommas as n,
  videoLength as v
};
