import { YTNode } from '../helpers.js';
import { Thumbnail } from '../misc.js';
export default class AvatarView extends YTNode {
    static type = 'AvatarView';
    image;
    image_processor;
    avatar_image_size;
    constructor(data) {
        super();
        this.image = Thumbnail.fromResponse(data.image);
        this.avatar_image_size = data.avatarImageSize;
        if (data.image.processor) {
            this.image_processor = {
                border_image_processor: {
                    circular: data.image.processor.borderImageProcessor.circular
                }
            };
        }
    }
}
//# sourceMappingURL=AvatarView.js.map