(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.InfiniteLoading = factory());
})(this, (function () { 'use strict';

    function noop() { }
    function assign(tar, src) {
        // @ts-ignore
        for (const k in src)
            tar[k] = src[k];
        return tar;
    }
    function run(fn) {
        return fn();
    }
    function blank_object() {
        return Object.create(null);
    }
    function run_all(fns) {
        fns.forEach(run);
    }
    function is_function(thing) {
        return typeof thing === 'function';
    }
    function safe_not_equal(a, b) {
        return a != a ? b == b : a !== b || ((a && typeof a === 'object') || typeof a === 'function');
    }
    function is_empty(obj) {
        return Object.keys(obj).length === 0;
    }
    function create_slot(definition, ctx, $$scope, fn) {
        if (definition) {
            const slot_ctx = get_slot_context(definition, ctx, $$scope, fn);
            return definition[0](slot_ctx);
        }
    }
    function get_slot_context(definition, ctx, $$scope, fn) {
        return definition[1] && fn
            ? assign($$scope.ctx.slice(), definition[1](fn(ctx)))
            : $$scope.ctx;
    }
    function get_slot_changes(definition, $$scope, dirty, fn) {
        if (definition[2] && fn) {
            const lets = definition[2](fn(dirty));
            if ($$scope.dirty === undefined) {
                return lets;
            }
            if (typeof lets === 'object') {
                const merged = [];
                const len = Math.max($$scope.dirty.length, lets.length);
                for (let i = 0; i < len; i += 1) {
                    merged[i] = $$scope.dirty[i] | lets[i];
                }
                return merged;
            }
            return $$scope.dirty | lets;
        }
        return $$scope.dirty;
    }
    function update_slot_base(slot, slot_definition, ctx, $$scope, slot_changes, get_slot_context_fn) {
        if (slot_changes) {
            const slot_context = get_slot_context(slot_definition, ctx, $$scope, get_slot_context_fn);
            slot.p(slot_context, slot_changes);
        }
    }
    function get_all_dirty_from_scope($$scope) {
        if ($$scope.ctx.length > 32) {
            const dirty = [];
            const length = $$scope.ctx.length / 32;
            for (let i = 0; i < length; i++) {
                dirty[i] = -1;
            }
            return dirty;
        }
        return -1;
    }
    function append(target, node) {
        target.appendChild(node);
    }
    function append_styles(target, style_sheet_id, styles) {
        const append_styles_to = get_root_for_style(target);
        if (!append_styles_to.getElementById(style_sheet_id)) {
            const style = element('style');
            style.id = style_sheet_id;
            style.textContent = styles;
            append_stylesheet(append_styles_to, style);
        }
    }
    function get_root_for_style(node) {
        if (!node)
            return document;
        const root = node.getRootNode ? node.getRootNode() : node.ownerDocument;
        if (root && root.host) {
            return root;
        }
        return node.ownerDocument;
    }
    function append_stylesheet(node, style) {
        append(node.head || node, style);
        return style.sheet;
    }
    function insert(target, node, anchor) {
        target.insertBefore(node, anchor || null);
    }
    function detach(node) {
        if (node.parentNode) {
            node.parentNode.removeChild(node);
        }
    }
    function element(name) {
        return document.createElement(name);
    }
    function text(data) {
        return document.createTextNode(data);
    }
    function space() {
        return text(' ');
    }
    function empty() {
        return text('');
    }
    function listen(node, event, handler, options) {
        node.addEventListener(event, handler, options);
        return () => node.removeEventListener(event, handler, options);
    }
    function attr(node, attribute, value) {
        if (value == null)
            node.removeAttribute(attribute);
        else if (node.getAttribute(attribute) !== value)
            node.setAttribute(attribute, value);
    }
    function children(element) {
        return Array.from(element.childNodes);
    }
    function custom_event(type, detail, { bubbles = false, cancelable = false } = {}) {
        const e = document.createEvent('CustomEvent');
        e.initCustomEvent(type, bubbles, cancelable, detail);
        return e;
    }

    let current_component;
    function set_current_component(component) {
        current_component = component;
    }
    function get_current_component() {
        if (!current_component)
            throw new Error('Function called outside component initialization');
        return current_component;
    }
    /**
     * The `onMount` function schedules a callback to run as soon as the component has been mounted to the DOM.
     * It must be called during the component's initialisation (but doesn't need to live *inside* the component;
     * it can be called from an external module).
     *
     * `onMount` does not run inside a [server-side component](/docs#run-time-server-side-component-api).
     *
     * https://svelte.dev/docs#run-time-svelte-onmount
     */
    function onMount(fn) {
        get_current_component().$$.on_mount.push(fn);
    }
    /**
     * Schedules a callback to run immediately before the component is unmounted.
     *
     * Out of `onMount`, `beforeUpdate`, `afterUpdate` and `onDestroy`, this is the
     * only one that runs inside a server-side component.
     *
     * https://svelte.dev/docs#run-time-svelte-ondestroy
     */
    function onDestroy(fn) {
        get_current_component().$$.on_destroy.push(fn);
    }
    /**
     * Creates an event dispatcher that can be used to dispatch [component events](/docs#template-syntax-component-directives-on-eventname).
     * Event dispatchers are functions that can take two arguments: `name` and `detail`.
     *
     * Component events created with `createEventDispatcher` create a
     * [CustomEvent](https://developer.mozilla.org/en-US/docs/Web/API/CustomEvent).
     * These events do not [bubble](https://developer.mozilla.org/en-US/docs/Learn/JavaScript/Building_blocks/Events#Event_bubbling_and_capture).
     * The `detail` argument corresponds to the [CustomEvent.detail](https://developer.mozilla.org/en-US/docs/Web/API/CustomEvent/detail)
     * property and can contain any type of data.
     *
     * https://svelte.dev/docs#run-time-svelte-createeventdispatcher
     */
    function createEventDispatcher() {
        const component = get_current_component();
        return (type, detail, { cancelable = false } = {}) => {
            const callbacks = component.$$.callbacks[type];
            if (callbacks) {
                // TODO are there situations where events could be dispatched
                // in a server (non-DOM) environment?
                const event = custom_event(type, detail, { cancelable });
                callbacks.slice().forEach(fn => {
                    fn.call(component, event);
                });
                return !event.defaultPrevented;
            }
            return true;
        };
    }

    const dirty_components = [];
    const binding_callbacks = [];
    let render_callbacks = [];
    const flush_callbacks = [];
    const resolved_promise = /* @__PURE__ */ Promise.resolve();
    let update_scheduled = false;
    function schedule_update() {
        if (!update_scheduled) {
            update_scheduled = true;
            resolved_promise.then(flush);
        }
    }
    function tick() {
        schedule_update();
        return resolved_promise;
    }
    function add_render_callback(fn) {
        render_callbacks.push(fn);
    }
    // flush() calls callbacks in this order:
    // 1. All beforeUpdate callbacks, in order: parents before children
    // 2. All bind:this callbacks, in reverse order: children before parents.
    // 3. All afterUpdate callbacks, in order: parents before children. EXCEPT
    //    for afterUpdates called during the initial onMount, which are called in
    //    reverse order: children before parents.
    // Since callbacks might update component values, which could trigger another
    // call to flush(), the following steps guard against this:
    // 1. During beforeUpdate, any updated components will be added to the
    //    dirty_components array and will cause a reentrant call to flush(). Because
    //    the flush index is kept outside the function, the reentrant call will pick
    //    up where the earlier call left off and go through all dirty components. The
    //    current_component value is saved and restored so that the reentrant call will
    //    not interfere with the "parent" flush() call.
    // 2. bind:this callbacks cannot trigger new flush() calls.
    // 3. During afterUpdate, any updated components will NOT have their afterUpdate
    //    callback called a second time; the seen_callbacks set, outside the flush()
    //    function, guarantees this behavior.
    const seen_callbacks = new Set();
    let flushidx = 0; // Do *not* move this inside the flush() function
    function flush() {
        // Do not reenter flush while dirty components are updated, as this can
        // result in an infinite loop. Instead, let the inner flush handle it.
        // Reentrancy is ok afterwards for bindings etc.
        if (flushidx !== 0) {
            return;
        }
        const saved_component = current_component;
        do {
            // first, call beforeUpdate functions
            // and update components
            try {
                while (flushidx < dirty_components.length) {
                    const component = dirty_components[flushidx];
                    flushidx++;
                    set_current_component(component);
                    update(component.$$);
                }
            }
            catch (e) {
                // reset dirty state to not end up in a deadlocked state and then rethrow
                dirty_components.length = 0;
                flushidx = 0;
                throw e;
            }
            set_current_component(null);
            dirty_components.length = 0;
            flushidx = 0;
            while (binding_callbacks.length)
                binding_callbacks.pop()();
            // then, once components are updated, call
            // afterUpdate functions. This may cause
            // subsequent updates...
            for (let i = 0; i < render_callbacks.length; i += 1) {
                const callback = render_callbacks[i];
                if (!seen_callbacks.has(callback)) {
                    // ...so guard against infinite loops
                    seen_callbacks.add(callback);
                    callback();
                }
            }
            render_callbacks.length = 0;
        } while (dirty_components.length);
        while (flush_callbacks.length) {
            flush_callbacks.pop()();
        }
        update_scheduled = false;
        seen_callbacks.clear();
        set_current_component(saved_component);
    }
    function update($$) {
        if ($$.fragment !== null) {
            $$.update();
            run_all($$.before_update);
            const dirty = $$.dirty;
            $$.dirty = [-1];
            $$.fragment && $$.fragment.p($$.ctx, dirty);
            $$.after_update.forEach(add_render_callback);
        }
    }
    /**
     * Useful for example to execute remaining `afterUpdate` callbacks before executing `destroy`.
     */
    function flush_render_callbacks(fns) {
        const filtered = [];
        const targets = [];
        render_callbacks.forEach((c) => fns.indexOf(c) === -1 ? filtered.push(c) : targets.push(c));
        targets.forEach((c) => c());
        render_callbacks = filtered;
    }
    const outroing = new Set();
    let outros;
    function group_outros() {
        outros = {
            r: 0,
            c: [],
            p: outros // parent group
        };
    }
    function check_outros() {
        if (!outros.r) {
            run_all(outros.c);
        }
        outros = outros.p;
    }
    function transition_in(block, local) {
        if (block && block.i) {
            outroing.delete(block);
            block.i(local);
        }
    }
    function transition_out(block, local, detach, callback) {
        if (block && block.o) {
            if (outroing.has(block))
                return;
            outroing.add(block);
            outros.c.push(() => {
                outroing.delete(block);
                if (callback) {
                    if (detach)
                        block.d(1);
                    callback();
                }
            });
            block.o(local);
        }
        else if (callback) {
            callback();
        }
    }
    function create_component(block) {
        block && block.c();
    }
    function mount_component(component, target, anchor, customElement) {
        const { fragment, after_update } = component.$$;
        fragment && fragment.m(target, anchor);
        if (!customElement) {
            // onMount happens before the initial afterUpdate
            add_render_callback(() => {
                const new_on_destroy = component.$$.on_mount.map(run).filter(is_function);
                // if the component was destroyed immediately
                // it will update the `$$.on_destroy` reference to `null`.
                // the destructured on_destroy may still reference to the old array
                if (component.$$.on_destroy) {
                    component.$$.on_destroy.push(...new_on_destroy);
                }
                else {
                    // Edge case - component was destroyed immediately,
                    // most likely as a result of a binding initialising
                    run_all(new_on_destroy);
                }
                component.$$.on_mount = [];
            });
        }
        after_update.forEach(add_render_callback);
    }
    function destroy_component(component, detaching) {
        const $$ = component.$$;
        if ($$.fragment !== null) {
            flush_render_callbacks($$.after_update);
            run_all($$.on_destroy);
            $$.fragment && $$.fragment.d(detaching);
            // TODO null out other refs, including component.$$ (but need to
            // preserve final state?)
            $$.on_destroy = $$.fragment = null;
            $$.ctx = [];
        }
    }
    function make_dirty(component, i) {
        if (component.$$.dirty[0] === -1) {
            dirty_components.push(component);
            schedule_update();
            component.$$.dirty.fill(0);
        }
        component.$$.dirty[(i / 31) | 0] |= (1 << (i % 31));
    }
    function init(component, options, instance, create_fragment, not_equal, props, append_styles, dirty = [-1]) {
        const parent_component = current_component;
        set_current_component(component);
        const $$ = component.$$ = {
            fragment: null,
            ctx: [],
            // state
            props,
            update: noop,
            not_equal,
            bound: blank_object(),
            // lifecycle
            on_mount: [],
            on_destroy: [],
            on_disconnect: [],
            before_update: [],
            after_update: [],
            context: new Map(options.context || (parent_component ? parent_component.$$.context : [])),
            // everything else
            callbacks: blank_object(),
            dirty,
            skip_bound: false,
            root: options.target || parent_component.$$.root
        };
        append_styles && append_styles($$.root);
        let ready = false;
        $$.ctx = instance
            ? instance(component, options.props || {}, (i, ret, ...rest) => {
                const value = rest.length ? rest[0] : ret;
                if ($$.ctx && not_equal($$.ctx[i], $$.ctx[i] = value)) {
                    if (!$$.skip_bound && $$.bound[i])
                        $$.bound[i](value);
                    if (ready)
                        make_dirty(component, i);
                }
                return ret;
            })
            : [];
        $$.update();
        ready = true;
        run_all($$.before_update);
        // `false` as a special case of no DOM component
        $$.fragment = create_fragment ? create_fragment($$.ctx) : false;
        if (options.target) {
            if (options.hydrate) {
                const nodes = children(options.target);
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                $$.fragment && $$.fragment.l(nodes);
                nodes.forEach(detach);
            }
            else {
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                $$.fragment && $$.fragment.c();
            }
            if (options.intro)
                transition_in(component.$$.fragment);
            mount_component(component, options.target, options.anchor, options.customElement);
            flush();
        }
        set_current_component(parent_component);
    }
    /**
     * Base class for Svelte components. Used when dev=false.
     */
    class SvelteComponent {
        $destroy() {
            destroy_component(this, 1);
            this.$destroy = noop;
        }
        $on(type, callback) {
            if (!is_function(callback)) {
                return noop;
            }
            const callbacks = (this.$$.callbacks[type] || (this.$$.callbacks[type] = []));
            callbacks.push(callback);
            return () => {
                const index = callbacks.indexOf(callback);
                if (index !== -1)
                    callbacks.splice(index, 1);
            };
        }
        $set($$props) {
            if (this.$$set && !is_empty($$props)) {
                this.$$.skip_bound = true;
                this.$$set($$props);
                this.$$.skip_bound = false;
            }
        }
    }

    /* src/Spinner.svelte generated by Svelte v3.59.2 */

    function add_css$1(target) {
    	append_styles(target, "svelte-10h86fq", ".loading-wave-dots.svelte-10h86fq.svelte-10h86fq{position:relative}.loading-wave-dots.svelte-10h86fq .wave-item.svelte-10h86fq{position:absolute;top:50%;left:50%;display:inline-block;margin-top:-4px;width:8px;height:8px;border-radius:50%;-webkit-animation:svelte-10h86fq-loading-wave-dots linear 2.8s infinite;animation:svelte-10h86fq-loading-wave-dots linear 2.8s infinite}.loading-wave-dots.svelte-10h86fq .wave-item.svelte-10h86fq:first-child{margin-left:-36px}.loading-wave-dots.svelte-10h86fq .wave-item.svelte-10h86fq:nth-child(2){margin-left:-20px;-webkit-animation-delay:0.14s;animation-delay:0.14s}.loading-wave-dots.svelte-10h86fq .wave-item.svelte-10h86fq:nth-child(3){margin-left:-4px;-webkit-animation-delay:0.28s;animation-delay:0.28s}.loading-wave-dots.svelte-10h86fq .wave-item.svelte-10h86fq:nth-child(4){margin-left:12px;-webkit-animation-delay:0.42s;animation-delay:0.42s}.loading-wave-dots.svelte-10h86fq .wave-item.svelte-10h86fq:last-child{margin-left:28px;-webkit-animation-delay:0.56s;animation-delay:0.56s}@-webkit-keyframes svelte-10h86fq-loading-wave-dots{0%{-webkit-transform:translateY(0);transform:translateY(0);background:#bbb}10%{-webkit-transform:translateY(-6px);transform:translateY(-6px);background:#999}20%{-webkit-transform:translateY(0);transform:translateY(0);background:#bbb}100%{-webkit-transform:translateY(0);transform:translateY(0);background:#bbb}}@keyframes svelte-10h86fq-loading-wave-dots{0%{-webkit-transform:translateY(0);transform:translateY(0);background:#bbb}10%{-webkit-transform:translateY(-6px);transform:translateY(-6px);background:#999}20%{-webkit-transform:translateY(0);transform:translateY(0);background:#bbb}100%{-webkit-transform:translateY(0);transform:translateY(0);background:#bbb}}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq{width:5px;height:5px;-webkit-animation:svelte-10h86fq-loading-circles linear .75s infinite;animation:svelte-10h86fq-loading-circles linear .75s infinite}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:first-child{margin-top:-14.5px;margin-left:-2.5px}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:nth-child(2){margin-top:-11.26px;margin-left:6.26px}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:nth-child(3){margin-top:-2.5px;margin-left:9.5px}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:nth-child(4){margin-top:6.26px;margin-left:6.26px}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:nth-child(5){margin-top:9.5px;margin-left:-2.5px}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:nth-child(6){margin-top:6.26px;margin-left:-11.26px}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:nth-child(7){margin-top:-2.5px;margin-left:-14.5px}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:last-child{margin-top:-11.26px;margin-left:-11.26px}@-webkit-keyframes svelte-10h86fq-loading-circles{0%{background:#dfdfdf}90%{background:#505050}100%{background:#dfdfdf}}@keyframes svelte-10h86fq-loading-circles{0%{background:#dfdfdf}90%{background:#505050}100%{background:#dfdfdf}}.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq{background:#666;-webkit-animation:svelte-10h86fq-loading-bubbles linear .75s infinite;animation:svelte-10h86fq-loading-bubbles linear .75s infinite}.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:first-child{margin-top:-12.5px;margin-left:-0.5px}.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:nth-child(2){margin-top:-9.26px;margin-left:8.26px}.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:nth-child(3){margin-top:-0.5px;margin-left:11.5px}.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:nth-child(4){margin-top:8.26px;margin-left:8.26px}.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:nth-child(5){margin-top:11.5px;margin-left:-0.5px}.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:nth-child(6){margin-top:8.26px;margin-left:-9.26px}.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:nth-child(7){margin-top:-0.5px;margin-left:-12.5px}.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:last-child{margin-top:-9.26px;margin-left:-9.26px}@-webkit-keyframes svelte-10h86fq-loading-bubbles{0%{width:1px;height:1px;box-shadow:0 0 0 3px #666}90%{width:1px;height:1px;box-shadow:0 0 0 0 #666}100%{width:1px;height:1px;box-shadow:0 0 0 3px #666}}@keyframes svelte-10h86fq-loading-bubbles{0%{width:1px;height:1px;box-shadow:0 0 0 3px #666}90%{width:1px;height:1px;box-shadow:0 0 0 0 #666}100%{width:1px;height:1px;box-shadow:0 0 0 3px #666}}.loading-default.svelte-10h86fq.svelte-10h86fq{position:relative;border:1px solid #999;-webkit-animation:svelte-10h86fq-loading-rotating ease 1.5s infinite;animation:svelte-10h86fq-loading-rotating ease 1.5s infinite}.loading-default.svelte-10h86fq.svelte-10h86fq:before{content:'';position:absolute;display:block;top:0;left:50%;margin-top:-3px;margin-left:-3px;width:6px;height:6px;background-color:#999;border-radius:50%}.loading-spiral.svelte-10h86fq.svelte-10h86fq{border:2px solid #777;border-right-color:transparent;-webkit-animation:svelte-10h86fq-loading-rotating linear .85s infinite;animation:svelte-10h86fq-loading-rotating linear .85s infinite}@-webkit-keyframes svelte-10h86fq-loading-rotating{0%{-webkit-transform:rotate(0);transform:rotate(0)}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@keyframes svelte-10h86fq-loading-rotating{0%{-webkit-transform:rotate(0);transform:rotate(0)}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}.loading-bubbles.svelte-10h86fq.svelte-10h86fq,.loading-circles.svelte-10h86fq.svelte-10h86fq{position:relative}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq,.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq{position:absolute;top:50%;left:50%;display:inline-block;border-radius:50%}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:nth-child(2),.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:nth-child(2){-webkit-animation-delay:0.093s;animation-delay:0.093s}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:nth-child(3),.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:nth-child(3){-webkit-animation-delay:0.186s;animation-delay:0.186s}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:nth-child(4),.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:nth-child(4){-webkit-animation-delay:0.279s;animation-delay:0.279s}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:nth-child(5),.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:nth-child(5){-webkit-animation-delay:0.372s;animation-delay:0.372s}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:nth-child(6),.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:nth-child(6){-webkit-animation-delay:0.465s;animation-delay:0.465s}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:nth-child(7),.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:nth-child(7){-webkit-animation-delay:0.558s;animation-delay:0.558s}.loading-circles.svelte-10h86fq .circle-item.svelte-10h86fq:last-child,.loading-bubbles.svelte-10h86fq .bubble-item.svelte-10h86fq:last-child{-webkit-animation-delay:0.651s;animation-delay:0.651s}.loading-bubbles.svelte-10h86fq.svelte-10h86fq,.loading-circles.svelte-10h86fq.svelte-10h86fq,.loading-spiral.svelte-10h86fq.svelte-10h86fq,.loading-wave-dots.svelte-10h86fq.svelte-10h86fq,.loading-default.svelte-10h86fq.svelte-10h86fq{display:inline-block;margin:5px 0;width:28px;height:28px;font-size:28px;line-height:28px;border-radius:50%}");
    }

    // (49:0) {:else}
    function create_else_block(ctx) {
    	let i;

    	return {
    		c() {
    			i = element("i");
    			attr(i, "class", "loading-default svelte-10h86fq");
    		},
    		m(target, anchor) {
    			insert(target, i, anchor);
    		},
    		d(detaching) {
    			if (detaching) detach(i);
    		}
    	};
    }

    // (38:33) 
    function create_if_block_3$1(ctx) {
    	let span5;

    	return {
    		c() {
    			span5 = element("span");

    			span5.innerHTML = `<span class="wave-item svelte-10h86fq"></span> 
		<span class="wave-item svelte-10h86fq"></span> 
		<span class="wave-item svelte-10h86fq"></span> 
		<span class="wave-item svelte-10h86fq"></span> 
		<span class="wave-item svelte-10h86fq"></span>`;

    			attr(span5, "class", "loading-wave-dots svelte-10h86fq");
    		},
    		m(target, anchor) {
    			insert(target, span5, anchor);
    		},
    		d(detaching) {
    			if (detaching) detach(span5);
    		}
    	};
    }

    // (33:31) 
    function create_if_block_2$1(ctx) {
    	let i;

    	return {
    		c() {
    			i = element("i");
    			attr(i, "class", "loading-spiral svelte-10h86fq");
    		},
    		m(target, anchor) {
    			insert(target, i, anchor);
    		},
    		d(detaching) {
    			if (detaching) detach(i);
    		}
    	};
    }

    // (19:32) 
    function create_if_block_1$1(ctx) {
    	let span8;

    	return {
    		c() {
    			span8 = element("span");

    			span8.innerHTML = `<span class="circle-item svelte-10h86fq"></span> 
		<span class="circle-item svelte-10h86fq"></span> 
		<span class="circle-item svelte-10h86fq"></span> 
		<span class="circle-item svelte-10h86fq"></span> 
		<span class="circle-item svelte-10h86fq"></span> 
		<span class="circle-item svelte-10h86fq"></span> 
		<span class="circle-item svelte-10h86fq"></span> 
		<span class="circle-item svelte-10h86fq"></span>`;

    			attr(span8, "class", "loading-circles svelte-10h86fq");
    		},
    		m(target, anchor) {
    			insert(target, span8, anchor);
    		},
    		d(detaching) {
    			if (detaching) detach(span8);
    		}
    	};
    }

    // (5:0) {#if spinner === 'bubbles'}
    function create_if_block$1(ctx) {
    	let span8;

    	return {
    		c() {
    			span8 = element("span");

    			span8.innerHTML = `<span class="bubble-item svelte-10h86fq"></span> 
		<span class="bubble-item svelte-10h86fq"></span> 
		<span class="bubble-item svelte-10h86fq"></span> 
		<span class="bubble-item svelte-10h86fq"></span> 
		<span class="bubble-item svelte-10h86fq"></span> 
		<span class="bubble-item svelte-10h86fq"></span> 
		<span class="bubble-item svelte-10h86fq"></span> 
		<span class="bubble-item svelte-10h86fq"></span>`;

    			attr(span8, "class", "loading-bubbles svelte-10h86fq");
    		},
    		m(target, anchor) {
    			insert(target, span8, anchor);
    		},
    		d(detaching) {
    			if (detaching) detach(span8);
    		}
    	};
    }

    function create_fragment$1(ctx) {
    	let if_block_anchor;

    	function select_block_type(ctx, dirty) {
    		if (/*spinner*/ ctx[0] === 'bubbles') return create_if_block$1;
    		if (/*spinner*/ ctx[0] === 'circles') return create_if_block_1$1;
    		if (/*spinner*/ ctx[0] === 'spiral') return create_if_block_2$1;
    		if (/*spinner*/ ctx[0] === 'wavedots') return create_if_block_3$1;
    		return create_else_block;
    	}

    	let current_block_type = select_block_type(ctx);
    	let if_block = current_block_type(ctx);

    	return {
    		c() {
    			if_block.c();
    			if_block_anchor = empty();
    		},
    		m(target, anchor) {
    			if_block.m(target, anchor);
    			insert(target, if_block_anchor, anchor);
    		},
    		p(ctx, [dirty]) {
    			if (current_block_type !== (current_block_type = select_block_type(ctx))) {
    				if_block.d(1);
    				if_block = current_block_type(ctx);

    				if (if_block) {
    					if_block.c();
    					if_block.m(if_block_anchor.parentNode, if_block_anchor);
    				}
    			}
    		},
    		i: noop,
    		o: noop,
    		d(detaching) {
    			if_block.d(detaching);
    			if (detaching) detach(if_block_anchor);
    		}
    	};
    }

    function instance$1($$self, $$props, $$invalidate) {
    	let { spinner = '' } = $$props;

    	$$self.$$set = $$props => {
    		if ('spinner' in $$props) $$invalidate(0, spinner = $$props.spinner);
    	};

    	return [spinner];
    }

    class Spinner extends SvelteComponent {
    	constructor(options) {
    		super();
    		init(this, options, instance$1, create_fragment$1, safe_not_equal, { spinner: 0 }, add_css$1);
    	}
    }

    /* src/InfiniteLoading.svelte generated by Svelte v3.59.2 */

    function add_css(target) {
    	append_styles(target, "svelte-o3w4bf", ".infinite-loading-container.svelte-o3w4bf{clear:both;text-align:center}.btn-try-infinite.svelte-o3w4bf{margin-top:5px;padding:5px 10px;color:#999;font-size:14px;line-height:1;background:transparent;border:1px solid #ccc;border-radius:3px;outline:none;cursor:pointer}.btn-try-infinite.svelte-o3w4bf:not(:active):hover{opacity:0.8}");
    }

    const get_error_slot_changes = dirty => ({});
    const get_error_slot_context = ctx => ({ attemptLoad: /*attemptLoad*/ ctx[7] });
    const get_noMore_slot_changes = dirty => ({});
    const get_noMore_slot_context = ctx => ({});
    const get_noResults_slot_changes = dirty => ({});
    const get_noResults_slot_context = ctx => ({});
    const get_spinner_slot_changes = dirty => ({ isFirstLoad: dirty & /*isFirstLoad*/ 2 });
    const get_spinner_slot_context = ctx => ({ isFirstLoad: /*isFirstLoad*/ ctx[1] });

    // (326:1) {#if showSpinner}
    function create_if_block_3(ctx) {
    	let div;
    	let current;
    	const spinner_slot_template = /*#slots*/ ctx[15].spinner;
    	const spinner_slot = create_slot(spinner_slot_template, ctx, /*$$scope*/ ctx[14], get_spinner_slot_context);
    	const spinner_slot_or_fallback = spinner_slot || fallback_block_3(ctx);

    	return {
    		c() {
    			div = element("div");
    			if (spinner_slot_or_fallback) spinner_slot_or_fallback.c();
    			attr(div, "class", "infinite-status-prompt");
    		},
    		m(target, anchor) {
    			insert(target, div, anchor);

    			if (spinner_slot_or_fallback) {
    				spinner_slot_or_fallback.m(div, null);
    			}

    			current = true;
    		},
    		p(ctx, dirty) {
    			if (spinner_slot) {
    				if (spinner_slot.p && (!current || dirty & /*$$scope, isFirstLoad*/ 16386)) {
    					update_slot_base(
    						spinner_slot,
    						spinner_slot_template,
    						ctx,
    						/*$$scope*/ ctx[14],
    						!current
    						? get_all_dirty_from_scope(/*$$scope*/ ctx[14])
    						: get_slot_changes(spinner_slot_template, /*$$scope*/ ctx[14], dirty, get_spinner_slot_changes),
    						get_spinner_slot_context
    					);
    				}
    			} else {
    				if (spinner_slot_or_fallback && spinner_slot_or_fallback.p && (!current || dirty & /*spinner*/ 1)) {
    					spinner_slot_or_fallback.p(ctx, !current ? -1 : dirty);
    				}
    			}
    		},
    		i(local) {
    			if (current) return;
    			transition_in(spinner_slot_or_fallback, local);
    			current = true;
    		},
    		o(local) {
    			transition_out(spinner_slot_or_fallback, local);
    			current = false;
    		},
    		d(detaching) {
    			if (detaching) detach(div);
    			if (spinner_slot_or_fallback) spinner_slot_or_fallback.d(detaching);
    		}
    	};
    }

    // (328:38)      
    function fallback_block_3(ctx) {
    	let spinner_1;
    	let current;
    	spinner_1 = new Spinner({ props: { spinner: /*spinner*/ ctx[0] } });

    	return {
    		c() {
    			create_component(spinner_1.$$.fragment);
    		},
    		m(target, anchor) {
    			mount_component(spinner_1, target, anchor);
    			current = true;
    		},
    		p(ctx, dirty) {
    			const spinner_1_changes = {};
    			if (dirty & /*spinner*/ 1) spinner_1_changes.spinner = /*spinner*/ ctx[0];
    			spinner_1.$set(spinner_1_changes);
    		},
    		i(local) {
    			if (current) return;
    			transition_in(spinner_1.$$.fragment, local);
    			current = true;
    		},
    		o(local) {
    			transition_out(spinner_1.$$.fragment, local);
    			current = false;
    		},
    		d(detaching) {
    			destroy_component(spinner_1, detaching);
    		}
    	};
    }

    // (334:1) {#if showNoResults}
    function create_if_block_2(ctx) {
    	let div;
    	let current;
    	const noResults_slot_template = /*#slots*/ ctx[15].noResults;
    	const noResults_slot = create_slot(noResults_slot_template, ctx, /*$$scope*/ ctx[14], get_noResults_slot_context);
    	const noResults_slot_or_fallback = noResults_slot || fallback_block_2();

    	return {
    		c() {
    			div = element("div");
    			if (noResults_slot_or_fallback) noResults_slot_or_fallback.c();
    			attr(div, "class", "infinite-status-prompt");
    		},
    		m(target, anchor) {
    			insert(target, div, anchor);

    			if (noResults_slot_or_fallback) {
    				noResults_slot_or_fallback.m(div, null);
    			}

    			current = true;
    		},
    		p(ctx, dirty) {
    			if (noResults_slot) {
    				if (noResults_slot.p && (!current || dirty & /*$$scope*/ 16384)) {
    					update_slot_base(
    						noResults_slot,
    						noResults_slot_template,
    						ctx,
    						/*$$scope*/ ctx[14],
    						!current
    						? get_all_dirty_from_scope(/*$$scope*/ ctx[14])
    						: get_slot_changes(noResults_slot_template, /*$$scope*/ ctx[14], dirty, get_noResults_slot_changes),
    						get_noResults_slot_context
    					);
    				}
    			}
    		},
    		i(local) {
    			if (current) return;
    			transition_in(noResults_slot_or_fallback, local);
    			current = true;
    		},
    		o(local) {
    			transition_out(noResults_slot_or_fallback, local);
    			current = false;
    		},
    		d(detaching) {
    			if (detaching) detach(div);
    			if (noResults_slot_or_fallback) noResults_slot_or_fallback.d(detaching);
    		}
    	};
    }

    // (336:26)      No results :(    
    function fallback_block_2(ctx) {
    	let t;

    	return {
    		c() {
    			t = text("No results :(");
    		},
    		m(target, anchor) {
    			insert(target, t, anchor);
    		},
    		d(detaching) {
    			if (detaching) detach(t);
    		}
    	};
    }

    // (342:1) {#if showNoMore}
    function create_if_block_1(ctx) {
    	let div;
    	let current;
    	const noMore_slot_template = /*#slots*/ ctx[15].noMore;
    	const noMore_slot = create_slot(noMore_slot_template, ctx, /*$$scope*/ ctx[14], get_noMore_slot_context);
    	const noMore_slot_or_fallback = noMore_slot || fallback_block_1();

    	return {
    		c() {
    			div = element("div");
    			if (noMore_slot_or_fallback) noMore_slot_or_fallback.c();
    			attr(div, "class", "infinite-status-prompt");
    		},
    		m(target, anchor) {
    			insert(target, div, anchor);

    			if (noMore_slot_or_fallback) {
    				noMore_slot_or_fallback.m(div, null);
    			}

    			current = true;
    		},
    		p(ctx, dirty) {
    			if (noMore_slot) {
    				if (noMore_slot.p && (!current || dirty & /*$$scope*/ 16384)) {
    					update_slot_base(
    						noMore_slot,
    						noMore_slot_template,
    						ctx,
    						/*$$scope*/ ctx[14],
    						!current
    						? get_all_dirty_from_scope(/*$$scope*/ ctx[14])
    						: get_slot_changes(noMore_slot_template, /*$$scope*/ ctx[14], dirty, get_noMore_slot_changes),
    						get_noMore_slot_context
    					);
    				}
    			}
    		},
    		i(local) {
    			if (current) return;
    			transition_in(noMore_slot_or_fallback, local);
    			current = true;
    		},
    		o(local) {
    			transition_out(noMore_slot_or_fallback, local);
    			current = false;
    		},
    		d(detaching) {
    			if (detaching) detach(div);
    			if (noMore_slot_or_fallback) noMore_slot_or_fallback.d(detaching);
    		}
    	};
    }

    // (344:23)      No more data :)    
    function fallback_block_1(ctx) {
    	let t;

    	return {
    		c() {
    			t = text("No more data :)");
    		},
    		m(target, anchor) {
    			insert(target, t, anchor);
    		},
    		d(detaching) {
    			if (detaching) detach(t);
    		}
    	};
    }

    // (350:1) {#if showError}
    function create_if_block(ctx) {
    	let div;
    	let current;
    	const error_slot_template = /*#slots*/ ctx[15].error;
    	const error_slot = create_slot(error_slot_template, ctx, /*$$scope*/ ctx[14], get_error_slot_context);
    	const error_slot_or_fallback = error_slot || fallback_block(ctx);

    	return {
    		c() {
    			div = element("div");
    			if (error_slot_or_fallback) error_slot_or_fallback.c();
    			attr(div, "class", "infinite-status-prompt");
    		},
    		m(target, anchor) {
    			insert(target, div, anchor);

    			if (error_slot_or_fallback) {
    				error_slot_or_fallback.m(div, null);
    			}

    			current = true;
    		},
    		p(ctx, dirty) {
    			if (error_slot) {
    				if (error_slot.p && (!current || dirty & /*$$scope*/ 16384)) {
    					update_slot_base(
    						error_slot,
    						error_slot_template,
    						ctx,
    						/*$$scope*/ ctx[14],
    						!current
    						? get_all_dirty_from_scope(/*$$scope*/ ctx[14])
    						: get_slot_changes(error_slot_template, /*$$scope*/ ctx[14], dirty, get_error_slot_changes),
    						get_error_slot_context
    					);
    				}
    			}
    		},
    		i(local) {
    			if (current) return;
    			transition_in(error_slot_or_fallback, local);
    			current = true;
    		},
    		o(local) {
    			transition_out(error_slot_or_fallback, local);
    			current = false;
    		},
    		d(detaching) {
    			if (detaching) detach(div);
    			if (error_slot_or_fallback) error_slot_or_fallback.d(detaching);
    		}
    	};
    }

    // (352:36)      Oops, something went wrong :(     
    function fallback_block(ctx) {
    	let t0;
    	let br;
    	let t1;
    	let button;
    	let mounted;
    	let dispose;

    	return {
    		c() {
    			t0 = text("Oops, something went wrong :(\n\t\t\t\t");
    			br = element("br");
    			t1 = space();
    			button = element("button");
    			button.textContent = "Retry";
    			attr(button, "class", "btn-try-infinite svelte-o3w4bf");
    		},
    		m(target, anchor) {
    			insert(target, t0, anchor);
    			insert(target, br, anchor);
    			insert(target, t1, anchor);
    			insert(target, button, anchor);

    			if (!mounted) {
    				dispose = listen(button, "click", /*attemptLoad*/ ctx[7]);
    				mounted = true;
    			}
    		},
    		p: noop,
    		d(detaching) {
    			if (detaching) detach(t0);
    			if (detaching) detach(br);
    			if (detaching) detach(t1);
    			if (detaching) detach(button);
    			mounted = false;
    			dispose();
    		}
    	};
    }

    function create_fragment(ctx) {
    	let div;
    	let t0;
    	let t1;
    	let t2;
    	let current;
    	let if_block0 = /*showSpinner*/ ctx[6] && create_if_block_3(ctx);
    	let if_block1 = /*showNoResults*/ ctx[4] && create_if_block_2(ctx);
    	let if_block2 = /*showNoMore*/ ctx[3] && create_if_block_1(ctx);
    	let if_block3 = /*showError*/ ctx[5] && create_if_block(ctx);

    	return {
    		c() {
    			div = element("div");
    			if (if_block0) if_block0.c();
    			t0 = space();
    			if (if_block1) if_block1.c();
    			t1 = space();
    			if (if_block2) if_block2.c();
    			t2 = space();
    			if (if_block3) if_block3.c();
    			attr(div, "class", "infinite-loading-container svelte-o3w4bf");
    		},
    		m(target, anchor) {
    			insert(target, div, anchor);
    			if (if_block0) if_block0.m(div, null);
    			append(div, t0);
    			if (if_block1) if_block1.m(div, null);
    			append(div, t1);
    			if (if_block2) if_block2.m(div, null);
    			append(div, t2);
    			if (if_block3) if_block3.m(div, null);
    			/*div_binding*/ ctx[16](div);
    			current = true;
    		},
    		p(ctx, [dirty]) {
    			if (/*showSpinner*/ ctx[6]) {
    				if (if_block0) {
    					if_block0.p(ctx, dirty);

    					if (dirty & /*showSpinner*/ 64) {
    						transition_in(if_block0, 1);
    					}
    				} else {
    					if_block0 = create_if_block_3(ctx);
    					if_block0.c();
    					transition_in(if_block0, 1);
    					if_block0.m(div, t0);
    				}
    			} else if (if_block0) {
    				group_outros();

    				transition_out(if_block0, 1, 1, () => {
    					if_block0 = null;
    				});

    				check_outros();
    			}

    			if (/*showNoResults*/ ctx[4]) {
    				if (if_block1) {
    					if_block1.p(ctx, dirty);

    					if (dirty & /*showNoResults*/ 16) {
    						transition_in(if_block1, 1);
    					}
    				} else {
    					if_block1 = create_if_block_2(ctx);
    					if_block1.c();
    					transition_in(if_block1, 1);
    					if_block1.m(div, t1);
    				}
    			} else if (if_block1) {
    				group_outros();

    				transition_out(if_block1, 1, 1, () => {
    					if_block1 = null;
    				});

    				check_outros();
    			}

    			if (/*showNoMore*/ ctx[3]) {
    				if (if_block2) {
    					if_block2.p(ctx, dirty);

    					if (dirty & /*showNoMore*/ 8) {
    						transition_in(if_block2, 1);
    					}
    				} else {
    					if_block2 = create_if_block_1(ctx);
    					if_block2.c();
    					transition_in(if_block2, 1);
    					if_block2.m(div, t2);
    				}
    			} else if (if_block2) {
    				group_outros();

    				transition_out(if_block2, 1, 1, () => {
    					if_block2 = null;
    				});

    				check_outros();
    			}

    			if (/*showError*/ ctx[5]) {
    				if (if_block3) {
    					if_block3.p(ctx, dirty);

    					if (dirty & /*showError*/ 32) {
    						transition_in(if_block3, 1);
    					}
    				} else {
    					if_block3 = create_if_block(ctx);
    					if_block3.c();
    					transition_in(if_block3, 1);
    					if_block3.m(div, null);
    				}
    			} else if (if_block3) {
    				group_outros();

    				transition_out(if_block3, 1, 1, () => {
    					if_block3 = null;
    				});

    				check_outros();
    			}
    		},
    		i(local) {
    			if (current) return;
    			transition_in(if_block0);
    			transition_in(if_block1);
    			transition_in(if_block2);
    			transition_in(if_block3);
    			current = true;
    		},
    		o(local) {
    			transition_out(if_block0);
    			transition_out(if_block1);
    			transition_out(if_block2);
    			transition_out(if_block3);
    			current = false;
    		},
    		d(detaching) {
    			if (detaching) detach(div);
    			if (if_block0) if_block0.d();
    			if (if_block1) if_block1.d();
    			if (if_block2) if_block2.d();
    			if (if_block3) if_block3.d();
    			/*div_binding*/ ctx[16](null);
    		}
    	};
    }

    const THROTTLE_LIMIT = 50;
    const LOOP_CHECK_TIMEOUT = 1000;
    const LOOP_CHECK_MAX_CALLS = 10;

    const ERROR_INFINITE_LOOP = [
    	`executed the callback function more than ${LOOP_CHECK_MAX_CALLS} times for a short time, it looks like searched a wrong scroll wrapper that doest not has fixed height or maximum height, please check it. If you want to force to set a element as scroll wrapper rather than automatic searching, you can do this:`,
    	'<!-- add a special attribute for the real scroll wrapper (can also be data-infinite-wrapper) -->',
    	'<div infinite-wrapper>',
    	'  ...',
    	'  <!-- set forceUseInfiniteWrapper -->',
    	'  <InfiniteLoading forceUseInfiniteWrapper>',
    	'</div>',
    	'or',
    	'<div class="infinite-wrapper">',
    	'  ...',
    	'  <!-- set forceUseInfiniteWrapper as css selector of the real scroll wrapper -->',
    	'  <InfiniteLoading forceUseInfiniteWrapper=".infinite-wrapper" />',
    	'</div>'
    ].join('\n');

    /**
     * the third argument for event bundler
     * @see https://github.com/WICG/EventListenerOptions/blob/gh-pages/explainer.md
     */
    const thirdEventArg = (() => {
    	let supportsPassive = false;

    	try {
    		const opts = Object.defineProperty({}, 'passive', {
    			get() {
    				supportsPassive = { passive: true };
    				return true;
    			}
    		});

    		window.addEventListener('testPassive', null, opts);
    		window.removeEventListener('testPassive', null, opts);
    	} catch(e) {
    		
    	} //

    	return supportsPassive;
    })();

    const throttler = {
    	timers: [],
    	caches: [],
    	throttle(fn) {
    		if (this.caches.indexOf(fn) === -1) {
    			// cache current handler
    			this.caches.push(fn);

    			// save timer for current handler
    			this.timers.push(setTimeout(
    				() => {
    					fn();

    					// empty cache and timer
    					this.caches.splice(this.caches.indexOf(fn), 1);

    					this.timers.shift();
    				},
    				THROTTLE_LIMIT
    			));
    		}
    	},
    	reset() {
    		// reset all timers
    		this.timers.forEach(timer => {
    			clearTimeout(timer);
    		});

    		this.timers.length = 0;

    		// empty caches
    		this.caches = [];
    	}
    };

    const loopTracker = {
    	isChecked: false,
    	timer: null,
    	times: 0,
    	track() {
    		// record track times
    		this.times += 1;

    		// try to mark check status
    		clearTimeout(this.timer);

    		this.timer = setTimeout(
    			() => {
    				this.isChecked = true;
    			},
    			LOOP_CHECK_TIMEOUT
    		);

    		// throw warning if the times of continuous calls large than the maximum times
    		if (this.times > LOOP_CHECK_MAX_CALLS) {
    			console.error(ERROR_INFINITE_LOOP);
    			this.isChecked = true;
    		}
    	}
    };

    const scrollBarStorage = {
    	key: '_infiniteScrollHeight',
    	getScrollElement(element) {
    		return element === window ? document.documentElement : element;
    	},
    	save(element) {
    		const target = this.getScrollElement(element);

    		// save scroll height on the scroll parent
    		target[this.key] = target.scrollHeight;
    	},
    	restore(element) {
    		const target = this.getScrollElement(element);

    		/* istanbul ignore else */
    		if (typeof target[this.key] === 'number') {
    			target.scrollTop = target.scrollHeight - target[this.key] + target.scrollTop;
    		}

    		this.remove(target);
    	},
    	remove(element) {
    		if (element[this.key] !== undefined) {
    			// remove scroll height
    			delete element[this.key]; // eslint-disable-line no-param-reassign
    		}
    	}
    };

    function isVisible(element) {
    	return element && element.offsetWidth + element.offsetHeight > 0;
    }

    function instance($$self, $$props, $$invalidate) {
    	let showSpinner;
    	let showError;
    	let showNoResults;
    	let showNoMore;
    	let { $$slots: slots = {}, $$scope } = $$props;
    	const dispatch = createEventDispatcher();

    	const STATUS = {
    		READY: 0,
    		LOADING: 1,
    		COMPLETE: 2,
    		ERROR: 3
    	};

    	let { distance = 100 } = $$props;
    	let { spinner = 'default' } = $$props;
    	let { direction = 'bottom' } = $$props;
    	let { forceUseInfiniteWrapper = false } = $$props;
    	let { identifier = +new Date() } = $$props;
    	let isFirstLoad = true; // save the current loading whether it is the first loading
    	let status = STATUS.READY;
    	let mounted = false;
    	let thisElement;
    	let scrollParent;

    	const stateChanger = {
    		loaded: async () => {
    			$$invalidate(1, isFirstLoad = false);

    			if (direction === 'top') {
    				// wait for DOM updated
    				await tick();

    				scrollBarStorage.restore(scrollParent);
    			}

    			if (status === STATUS.LOADING) {
    				await tick();
    				await attemptLoad(true);
    			}
    		},
    		complete: async () => {
    			$$invalidate(12, status = STATUS.COMPLETE);

    			// force re-complation computed properties to fix the problem of get slot text delay
    			await tick();

    			scrollParent.removeEventListener('scroll', scrollHandler, thirdEventArg);
    		},
    		reset: () => {
    			$$invalidate(12, status = STATUS.READY);
    			$$invalidate(1, isFirstLoad = true);
    			scrollBarStorage.remove(scrollParent);
    			scrollParent.addEventListener('scroll', scrollHandler, thirdEventArg);

    			// wait for list to be empty and the empty action may trigger a scroll event
    			setTimeout(
    				() => {
    					throttler.reset();
    					scrollHandler();
    				},
    				1
    			);
    		},
    		error: () => {
    			$$invalidate(12, status = STATUS.ERROR);
    			throttler.reset();
    		}
    	};

    	function scrollHandler(event) {
    		if (status === STATUS.READY) {
    			if (event && event.constructor === Event && isVisible(thisElement)) {
    				throttler.throttle(attemptLoad);
    			} else {
    				attemptLoad();
    			}
    		}
    	}

    	// Attempt to trigger load
    	async function attemptLoad(isContinuousCall) {
    		if (status !== STATUS.COMPLETE && isVisible(thisElement) && getCurrentDistance() <= distance) {
    			$$invalidate(12, status = STATUS.LOADING);

    			if (direction === 'top') {
    				// wait for spinner display
    				await tick();

    				scrollBarStorage.save(scrollParent);
    			}

    			dispatch('infinite', stateChanger);

    			if (isContinuousCall && !forceUseInfiniteWrapper && !loopTracker.isChecked) {
    				// check this component whether be in an infinite loop if it is not checked
    				loopTracker.track();
    			}
    		} else if (status === STATUS.LOADING) {
    			$$invalidate(12, status = STATUS.READY);
    		}
    	}

    	// Get current distance from the specified direction
    	function getCurrentDistance() {
    		let distance;

    		if (direction === 'top') {
    			distance = typeof scrollParent.scrollTop === 'number'
    			? scrollParent.scrollTop
    			: scrollParent.pageYOffset;
    		} else {
    			const infiniteElementOffsetTopFromBottom = thisElement.getBoundingClientRect().top;

    			const scrollElementOffsetTopFromBottom = scrollParent === window
    			? window.innerHeight
    			: scrollParent.getBoundingClientRect().bottom;

    			distance = infiniteElementOffsetTopFromBottom - scrollElementOffsetTopFromBottom;
    		}

    		return distance;
    	}

    	// Get the first scroll parent of an element
    	function getScrollParent(element = thisElement) {
    		let result;

    		if (typeof forceUseInfiniteWrapper === 'string') {
    			result = document.querySelector(forceUseInfiniteWrapper);
    		}

    		if (!result) {
    			if (element.tagName === 'BODY') {
    				result = window;
    			} else if (!forceUseInfiniteWrapper && ['scroll', 'auto'].indexOf(getComputedStyle(element).overflowY) > -1) {
    				result = element;
    			} else if (element.hasAttribute('infinite-wrapper') || element.hasAttribute('data-infinite-wrapper')) {
    				result = element;
    			}
    		}

    		return result || getScrollParent(element.parentNode);
    	}

    	function updateScrollParent() {
    		if (mounted) scrollParent = getScrollParent();
    	}

    	function identifierUpdated() {
    		if (mounted) stateChanger.reset();
    	}

    	onMount(async () => {
    		$$invalidate(13, mounted = true);

    		setTimeout(
    			() => {
    				scrollHandler();
    				scrollParent.addEventListener('scroll', scrollHandler, thirdEventArg);
    			},
    			1
    		);
    	});

    	onDestroy(() => {
    		if (mounted && status !== STATUS.COMPLETE) {
    			throttler.reset();
    			scrollBarStorage.remove(scrollParent);
    			scrollParent.removeEventListener('scroll', scrollHandler, thirdEventArg);
    		}
    	});

    	function div_binding($$value) {
    		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
    			thisElement = $$value;
    			$$invalidate(2, thisElement);
    		});
    	}

    	$$self.$$set = $$props => {
    		if ('distance' in $$props) $$invalidate(8, distance = $$props.distance);
    		if ('spinner' in $$props) $$invalidate(0, spinner = $$props.spinner);
    		if ('direction' in $$props) $$invalidate(9, direction = $$props.direction);
    		if ('forceUseInfiniteWrapper' in $$props) $$invalidate(10, forceUseInfiniteWrapper = $$props.forceUseInfiniteWrapper);
    		if ('identifier' in $$props) $$invalidate(11, identifier = $$props.identifier);
    		if ('$$scope' in $$props) $$invalidate(14, $$scope = $$props.$$scope);
    	};

    	$$self.$$.update = () => {
    		if ($$self.$$.dirty & /*status*/ 4096) {
    			$$invalidate(6, showSpinner = status === STATUS.LOADING);
    		}

    		if ($$self.$$.dirty & /*status*/ 4096) {
    			$$invalidate(5, showError = status === STATUS.ERROR);
    		}

    		if ($$self.$$.dirty & /*status, isFirstLoad*/ 4098) {
    			$$invalidate(4, showNoResults = status === STATUS.COMPLETE && isFirstLoad);
    		}

    		if ($$self.$$.dirty & /*status, isFirstLoad*/ 4098) {
    			$$invalidate(3, showNoMore = status === STATUS.COMPLETE && !isFirstLoad);
    		}

    		if ($$self.$$.dirty & /*forceUseInfiniteWrapper, mounted*/ 9216) {
    			// Watch forceUseInfiniteWrapper and mounted
    			(updateScrollParent());
    		}

    		if ($$self.$$.dirty & /*identifier, mounted*/ 10240) {
    			// Watch identifier and mounted
    			(identifierUpdated());
    		}
    	};

    	return [
    		spinner,
    		isFirstLoad,
    		thisElement,
    		showNoMore,
    		showNoResults,
    		showError,
    		showSpinner,
    		attemptLoad,
    		distance,
    		direction,
    		forceUseInfiniteWrapper,
    		identifier,
    		status,
    		mounted,
    		$$scope,
    		slots,
    		div_binding
    	];
    }

    class InfiniteLoading extends SvelteComponent {
    	constructor(options) {
    		super();

    		init(
    			this,
    			options,
    			instance,
    			create_fragment,
    			safe_not_equal,
    			{
    				distance: 8,
    				spinner: 0,
    				direction: 9,
    				forceUseInfiniteWrapper: 10,
    				identifier: 11
    			},
    			add_css
    		);
    	}
    }

    return InfiniteLoading;

}));
