<p align="center"><img src="https://raw.githubusercontent.com/jonasgeiler/svelte-infinite-loading/master/assets/InfiniteLogo.svg" alt="InfiniteLogo" width="225"></p>
<h2 align="center">svelte-infinite-loading</h2>
<p align="center">An infinite scroll component for Svelte apps</p>
<p align="center">
  <a href="https://npmjs.com/package/svelte-infinite-loading"><img src="https://img.shields.io/npm/v/svelte-infinite-loading?style=for-the-badge" alt="NPM VERSION"></a>
  <a href="https://npmjs.com/package/svelte-infinite-loading"><img src="https://img.shields.io/npm/dt/svelte-infinite-loading?style=for-the-badge" alt="NPM DOWNLOADS"></a>
  <a href="https://npmjs.com/package/svelte-infinite-loading"><img src="https://img.shields.io/librariesio/release/npm/svelte-infinite-loading?style=for-the-badge" alt="DEPENDENCIES"></a>
</p>
<p align="center">
  <a href="#about">About</a> •
  <a href="#features">Features</a> •
  <a href="#installation">Installation</a> •
  <a href="#documentation">Documentation</a> •
  <a href="#examples--demo">Examples</a> •
  <a href="#license">License</a>
</p>

## About

An infinite scroll component for Svelte, to help you implement an infinite scroll list more easily.  
This is heavily inspired by [vue-infinite-loading](https://peachscript.github.io/vue-infinite-loading/) and uses most of its code and functionality!

### Features

- Mobile friendly
- Built-in spinners
- 2-directional support
- Load result message display


## Installation

> If you're using this component in a Sapper application, make sure to install the package to `devDependencies`!  
> [More Details](https://github.com/sveltejs/sapper-template#using-external-components)

With npm:
```shell
$ npm install svelte-infinite-loading
```

With yarn:
```shell
$ yarn add svelte-infinite-loading
```

With [pnpm](https://pnpm.js.org/) (recommended):
```shell
$ npm i -g pnpm
$ pnpm install svelte-infinite-loading
```

From CDN (via [unpkg](https://unpkg.com/)):
```html
<!-- UMD -->
<script src="https://unpkg.com/svelte-infinite-loading@^1/dist/svelte-infinite-loading.js"></script>

<!-- ES Module -->
<script src="https://unpkg.com/svelte-infinite-loading@^1/dist/svelte-infinite-loading.mjs"></script>
```

## Examples / Demo

- [Hacker News](https://svelte.dev/repl/c053fb0b13154b07a503ac04e0cb2c66)
- [Hacker News with Filter](https://svelte.dev/repl/73d404d5a26a47db969c4ebc154e8079)
- [Hacker News with Top Direction](https://svelte.dev/repl/9a04b19fcf5f4da0bead27f1cdf55cfb)
- [Hacker News using svelte-tiny-virtual-list](https://svelte.dev/repl/2239cc4c861c41d18abbc858248f5a0d)

For more information on how to use this library, check the [documentation](https://github.com/jonasgeiler/svelte-infinite-loading/wiki)!


## Documentation

You can find the documentation in the [repository wiki](https://github.com/jonasgeiler/svelte-infinite-loading/wiki)


## License

[MIT License](https://github.com/jonasgeiler/svelte-infinite-loading/blob/master/LICENSE)
