"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SponsorBlockVIP = void 0;
const axios_1 = __importDefault(require("axios"));
const user_1 = require("./user");
const utils_1 = require("../utils");
class SponsorBlockVIP extends user_1.SponsorBlock {
    constructor(userID, options = {}) {
        super(userID, options);
        this.userID = userID;
        this.options = options;
        this.isVIP().then((result) => result || console.info('\x1b[31m%s\x1b[0m', 'User is not VIP, VIP methods will be unauthorized'));
    }
    blockSubmissionsOfCategory(video, ...categories) {
        return __awaiter(this, void 0, void 0, function* () {
            let videoID = utils_1.resolveVideo(video);
            let res = yield axios_1.default.post('/api/noSegments', { videoID, userID: this.userID, categories }, { baseURL: this.options.baseURL, validateStatus: null });
            utils_1.statusCheck(res);
            // returns nothing (status code 200)
        });
    }
    shadowBan(publicUserID, hideOldSubmissions) {
        return __awaiter(this, void 0, void 0, function* () {
            let res = yield axios_1.default.post('/api/shadowBanUser', null, { params: { userID: publicUserID, adminUserID: this.userID, unHideOldSubmissions: hideOldSubmissions !== null && hideOldSubmissions !== void 0 ? hideOldSubmissions : false }, baseURL: this.options.baseURL, validateStatus: null });
            utils_1.statusCheck(res);
            // returns nothing (status code 200)
        });
    }
    removeShadowBan(publicUserID) {
        return __awaiter(this, void 0, void 0, function* () {
            let res = yield axios_1.default.post('/api/shadowBanUser', null, { params: { userID: publicUserID, adminUserID: this.userID, enabled: false }, baseURL: this.options.baseURL, validateStatus: null });
            utils_1.statusCheck(res);
            // returns nothing (status code 200)
        });
    }
    hideOldSubmissions(publicUserID) {
        return __awaiter(this, void 0, void 0, function* () {
            let res = yield axios_1.default.post('/api/shadowBanUser', null, { params: { userID: publicUserID, adminUserID: this.userID, enabled: true, unHideOldSubmissions: true }, baseURL: this.options.baseURL, validateStatus: null });
            utils_1.statusCheck(res);
            // returns nothing (status code 200)
        });
    }
    warnUser(publicUserID, reason = '', enabled) {
        return __awaiter(this, void 0, void 0, function* () {
            let res = yield axios_1.default.post('/api/warnUser', { issuerUserID: this.userID, userID: publicUserID, enabled, reason }, { baseURL: this.options.baseURL, validateStatus: null });
            utils_1.statusCheck(res);
            // returns nothing (status code 200)
        });
    }
    clearCache(video) {
        return __awaiter(this, void 0, void 0, function* () {
            let videoID = utils_1.resolveVideo(video);
            let res = yield axios_1.default.get('/api/clearCache?videoID', { params: { videoID, userID: this.userID }, baseURL: this.options.baseURL, validateStatus: null });
            // let res = await fetch(`${this.options.baseURL}/api/clearCache?videoID=${videoID}&userID=${this.userID}`);
            utils_1.statusCheck(res);
            // returns nothing (status code 200)
        });
    }
    purgeAllSegments(video) {
        return __awaiter(this, void 0, void 0, function* () {
            let videoID = utils_1.resolveVideo(video);
            let res = yield axios_1.default.get('/api/purgeAllSegments', { params: { videoID, userID: this.userID }, baseURL: this.options.baseURL, validateStatus: null });
            utils_1.statusCheck(res);
            // returns nothing (status code 200)
        });
    }
}
exports.SponsorBlockVIP = SponsorBlockVIP;
