import { g as goto } from "../../chunks/client.js";
import { r as resolve } from "../../chunks/server.js";
import { registerPlugin, WebPlugin, Capacitor } from "@capacitor/core";
import { m as getResolveUrl } from "../../chunks/index5.js";
import "i18next";
import { g as get } from "../../chunks/index3.js";
import "dayjs";
import { g as getPages } from "../../chunks/navPages.js";
import { i as isAndroidTvStore, u as interfaceDefaultPage, b as authStore } from "../../chunks/store.js";
class AndroidTvWeb extends WebPlugin {
  async isAndroidTv() {
    return { value: false };
  }
}
const androidTv = registerPlugin("AndroidTv", {
  web: new AndroidTvWeb()
});
const originalFetch = window.fetch;
const corsProxyUrl = "http://localhost:3000/";
function needsProxying(target) {
  if (!target.startsWith("http")) return false;
  return true;
}
const androidFetch = async (requestInput, requestOptions) => {
  const uri = requestInput instanceof Request ? requestInput.url : requestInput.toString();
  if (needsProxying(uri)) {
    if (requestInput instanceof Request) {
      requestInput = new Request(corsProxyUrl + uri, {
        method: requestInput.method,
        headers: requestInput.headers,
        body: requestInput.body,
        mode: requestInput.mode,
        credentials: requestInput.credentials,
        cache: requestInput.cache,
        redirect: requestInput.redirect,
        referrer: requestInput.referrer,
        integrity: requestInput.integrity,
        keepalive: requestInput.keepalive,
        ...requestInput.body ? { duplex: "half" } : {}
      });
    } else {
      requestInput = corsProxyUrl + uri;
    }
  }
  return originalFetch(requestInput, requestOptions);
};
if (Capacitor.getPlatform() === "android") {
  window.fetch = androidFetch;
  const originalXhrOpen = XMLHttpRequest.prototype.open;
  XMLHttpRequest.prototype.open = function(...args) {
    if (needsProxying(args[1])) {
      args[1] = corsProxyUrl + args[1];
    }
    return originalXhrOpen.apply(this, args);
  };
}
const ssr = false;
async function load({ url }) {
  isAndroidTvStore.set((await androidTv.isAndroidTv()).value);
  const resolvedRoot = resolve("/", {});
  if (url.pathname.startsWith(resolvedRoot + "@")) {
    const username = url.pathname.substring(resolvedRoot.length).split("/")[0];
    try {
      const resolvedUrl = await getResolveUrl(`www.youtube.com/${username}`);
      if (resolvedUrl.pageType === "WEB_PAGE_TYPE_CHANNEL") {
        goto(resolve(`/channel/[authorId]`, { authorId: resolvedUrl.ucid }));
      }
    } catch {
    }
  }
  const defaultPage = get(interfaceDefaultPage);
  if (defaultPage && defaultPage !== "/" && defaultPage.startsWith("/") && url.pathname === resolvedRoot && window.history.length < 3) {
    getPages().forEach((page) => {
      if (page.href === defaultPage && (!page.requiresAuth || get(authStore))) {
        goto(resolve(defaultPage, {}));
      }
    });
  }
}
export {
  load,
  ssr
};
