import { g as goto } from "../../../../chunks/client.js";
import { r as resolve } from "../../../../chunks/server.js";
import { error } from "@sveltejs/kit";
async function load({ url }) {
  const videoId = url.searchParams.get("v");
  const playlistId = url.searchParams.get("list");
  const timestamp = url.searchParams.get("t");
  if (videoId) {
    const goToUrl = new URL(`${location.origin}${resolve(`/watch/[videoId]`, { videoId })}`);
    if (playlistId) {
      goToUrl.searchParams.set("playlist", playlistId);
    }
    if (timestamp) {
      goToUrl.searchParams.set("time", timestamp);
    }
    goto();
  } else {
    error(404);
  }
}
export {
  load
};
