import { f as getFeed } from "../../../../chunks/index5.js";
import { l as localDb } from "../../../../chunks/dexie.js";
import { e as excludeDuplicateFeeds } from "../../../../chunks/misc.js";
import { f as feedCacheStore } from "../../../../chunks/store.js";
import { error } from "@sveltejs/kit";
import { g as get } from "../../../../chunks/index3.js";
async function sortVideosByFavourites(videos) {
  if (!window.indexedDB) return videos;
  const favouritedChannels = (await localDb.favouriteChannels.toArray()).map(
    (channel) => channel.channelId
  );
  if (favouritedChannels.length === 0) {
    return videos;
  }
  const regularVideos = [];
  const favouriteVideos = [];
  videos.forEach((video) => {
    if (favouritedChannels.includes(video.authorId)) {
      video.promotedBy = "favourited";
      favouriteVideos.push(video);
    } else {
      regularVideos.push(video);
    }
  });
  return [...favouriteVideos, ...regularVideos];
}
async function load() {
  let videos = get(feedCacheStore).subscription;
  if (!videos) {
    let feeds;
    try {
      feeds = await getFeed(100, 1);
    } catch (errorMessage) {
      error(500, errorMessage);
    }
    videos = await sortVideosByFavourites([...feeds.notifications, ...feeds.videos]);
    feedCacheStore.set({ ...get(feedCacheStore), subscription: videos });
  } else {
    await getFeed(100, 1).then(async (feeds) => {
      const newVideos = await sortVideosByFavourites([
        ...feeds.notifications,
        ...feeds.videos,
        ...videos
      ]);
      feedCacheStore.set({
        ...get(feedCacheStore),
        subscription: excludeDuplicateFeeds(videos, newVideos)
      });
    });
  }
}
export {
  load
};
