import { e as getSearch } from "../../../../../chunks/index5.js";
import { e as excludeDuplicateFeeds } from "../../../../../chunks/misc.js";
import { s as searchCacheStore } from "../../../../../chunks/store.js";
import { error } from "@sveltejs/kit";
import { g as get } from "../../../../../chunks/index3.js";
async function load({ params, url }) {
  let type;
  const queryFlag = url.searchParams.get("type");
  if (queryFlag && ["playlist", "video", "channel", "all"].includes(queryFlag)) {
    type = queryFlag;
  } else {
    type = "all";
  }
  const searchStoreId = type + params.slug;
  const search = get(searchCacheStore)[searchStoreId];
  if (!search) {
    try {
      searchCacheStore.set({
        ...get(searchCacheStore),
        [searchStoreId]: await getSearch(params.slug, { type })
      });
    } catch (errorMessage) {
      error(500, errorMessage);
    }
  } else {
    getSearch(params.slug, { type }).then((newSearch) => {
      searchCacheStore.set({
        [searchStoreId]: excludeDuplicateFeeds(search, newSearch),
        ...get(searchCacheStore)
      });
    });
  }
  return {
    slug: params.slug,
    searchType: type,
    searchStoreId
  };
}
export {
  load
};
