import { s as store_get, a as attr, e as ensure_array_like, b as attr_class, u as unsubscribe_stores } from "../../../../../chunks/index.js";
import "../../../../../chunks/youtubejs.js";
import "@capacitor/core";
import { s as searchCacheStore } from "../../../../../chunks/store.js";
import { P as PageLoading } from "../../../../../chunks/PageLoading.js";
import { _ } from "../../../../../chunks/index2.js";
import { I as InfiniteLoading } from "../../../../../chunks/InfiniteLoading.js";
import { I as ItemsList } from "../../../../../chunks/ItemsList.js";
import { e as escape_html } from "../../../../../chunks/context.js";
function _page($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data } = $$props;
    let currentPage = 1;
    let filtersOpen = false;
    let searchOptions = {
      type: "all",
      page: currentPage.toString(),
      sort_by: "relevance"
    };
    const filters = [
      {
        options: ["all", "video", "playlist", "channel"],
        title: store_get($$store_subs ??= {}, "$_", _)("filters.type"),
        key: "type"
      },
      {
        options: ["hour", "today", "week", "month", "year"],
        title: store_get($$store_subs ??= {}, "$_", _)("filters.uploadDate"),
        key: "date"
      },
      {
        options: ["short", "medium", "long"],
        title: store_get($$store_subs ??= {}, "$_", _)("filters.duration"),
        key: "duration"
      },
      {
        options: ["relevance", "rating", "upload_date", "view_count"],
        title: store_get($$store_subs ??= {}, "$_", _)("filters.sortBy"),
        key: "sort_by"
      },
      {
        options: [
          "hd",
          "subtitles",
          "creative_commons",
          "3d",
          "live",
          "purchased",
          "4k",
          "360",
          "location",
          "hdr",
          "vr180"
        ],
        title: store_get($$store_subs ??= {}, "$_", _)("filters.features"),
        key: "features"
      }
    ];
    $$renderer2.push(`<details${attr("open", filtersOpen, true)}><summary><nav><button class="secondary"><i>filter_alt</i> <span>${escape_html(store_get($$store_subs ??= {}, "$_", _)("filters.filters"))}</span></button></nav></summary> <article class="scroll medium"><div class="grid"><!--[-->`);
    const each_array = ensure_array_like(filters);
    for (let $$index_1 = 0, $$length = each_array.length; $$index_1 < $$length; $$index_1++) {
      let filter = each_array[$$index_1];
      $$renderer2.push(`<div class="s12 m2 l2"><h6>${escape_html(filter.title)}</h6> <ul class="list no-margin no-padding"><!--[-->`);
      const each_array_1 = ensure_array_like(filter.options);
      for (let $$index = 0, $$length2 = each_array_1.length; $$index < $$length2; $$index++) {
        let filterOption = each_array_1[$$index];
        $$renderer2.push(`<li><button${attr_class("small border", void 0, { "active": filterOption === searchOptions[filter.key] })} style="text-transform: capitalize;"${attr("disabled", filter.key !== "type" && !["all", "video", void 0].includes(searchOptions.type), true)}><span>${escape_html(filterOption.replaceAll("_", " "))}</span></button></li>`);
      }
      $$renderer2.push(`<!--]--></ul></div>`);
    }
    $$renderer2.push(`<!--]--></div></article></details> <div class="space"></div> `);
    if (store_get($$store_subs ??= {}, "$searchCacheStore", searchCacheStore)[data.searchStoreId]) {
      $$renderer2.push("<!--[-->");
      ItemsList($$renderer2, {
        items: store_get($$store_subs ??= {}, "$searchCacheStore", searchCacheStore)[data.searchStoreId]
      });
    } else {
      $$renderer2.push("<!--[!-->");
      PageLoading($$renderer2);
    }
    $$renderer2.push(`<!--]--> `);
    InfiniteLoading($$renderer2, {});
    $$renderer2.push(`<!---->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  _page as default
};
