import { g as getPopular } from "../../../chunks/index5.js";
import { f as feedCacheStore } from "../../../chunks/store.js";
import { error } from "@sveltejs/kit";
import { g as get } from "../../../chunks/index3.js";
async function load() {
  let popular = get(feedCacheStore).popular;
  let popularDisabled = false;
  if (!popular) {
    try {
      popular = await getPopular();
    } catch (errorMessage) {
      if (errorMessage.toString() === "Error: Administrator has disabled this endpoint.") {
        popularDisabled = true;
      } else {
        error(500, errorMessage);
      }
    }
    feedCacheStore.set({ ...get(feedCacheStore), popular });
  } else {
    getPopular().then(
      (newPopular) => feedCacheStore.set({ ...get(feedCacheStore), popular: newPopular })
    );
  }
  return {
    popularDisabled
  };
}
export {
  load
};
