import { j as getVideo, p as postHistory, d as getPersonalPlaylists, k as getComments, l as getDislikes } from "./index5.js";
import { l as loadEntirePlaylist } from "./playlist.js";
import { n as playerProxyVideosStore, q as returnYtDislikesStore, t as playerState, b as authStore, r as returnYTDislikesInstanceStore } from "./store.js";
import { d as decodeHtmlCharCodes } from "./misc.js";
import { a as convertToSeconds } from "./numbers.js";
import { error } from "@sveltejs/kit";
import { g as get } from "./index3.js";
import { _ } from "./index2.js";
function extractActualLink(url) {
  const urlParams = new URLSearchParams(url.split("?")[1]);
  const actualLink = urlParams.get("q");
  if (actualLink) {
    return decodeURIComponent(actualLink);
  }
  return url;
}
function processYoutubeLink(line) {
  const urlRegex = /<a href="https:\/\/www\.youtube\.com\/redirect\?([^"]+)"/;
  const urlMatch = urlRegex.exec(line);
  if (urlMatch) {
    const redirectUrl = urlMatch[0];
    const actualUrl = extractActualLink(redirectUrl);
    return line.replace(urlRegex, `<a href="${actualUrl}"`);
  } else {
    return line;
  }
}
function phaseDescription(videoId, content, fallbackPatch) {
  const timestamps = [];
  const lines = content.split("\n");
  const filteredLines = [];
  const parser = new DOMParser();
  lines.forEach((line) => {
    const doc = parser.parseFromString(line, "text/html");
    const link = doc.querySelector("a");
    if (link) {
      const href = link.getAttribute("href") || "";
      if (fallbackPatch === "youtubejs" && href.includes(`https://www.youtube.com/watch?v=${videoId}`)) {
        const url = new URL(href);
        const timeParam = url.searchParams.get("t") || "0";
        const timePretty = link.textContent?.trim() || "";
        const spans = doc.querySelectorAll("span");
        const title = spans.length > 1 ? spans[1].textContent?.trim() || "" : "";
        timestamps.push({
          time: convertToSeconds(timeParam.replace("s", "")),
          title: decodeHtmlCharCodes(title),
          timePretty,
          endTime: -1
        });
      } else if (fallbackPatch !== "youtubejs" && link.hasAttribute("data-onclick") && link.getAttribute("data-onclick") === "jump_to_time") {
        const timePretty = link.textContent?.trim() || "";
        const time = link.getAttribute("data-jump-time") || "0";
        const title = link.nextSibling?.textContent?.trim() || "";
        timestamps.push({
          time: convertToSeconds(time),
          title: decodeHtmlCharCodes(title),
          timePretty,
          endTime: -1
        });
      } else {
        const modifiedLine = processYoutubeLink(line).replace(
          /<a href="([^"]+)"/,
          '<a href="$1" target="_blank" rel="noopener noreferrer" class="link"'
        );
        filteredLines.push(modifiedLine);
      }
    } else {
      filteredLines.push(line);
    }
  });
  timestamps.forEach((ts, idx) => {
    ts.endTime = idx < timestamps.length - 1 ? timestamps[idx + 1].time : -1;
  });
  const filteredContent = filteredLines.join("\n");
  return { description: filteredContent, timestamps };
}
async function getWatchDetails(videoId, url) {
  const playerStateRetrieved = get(playerState);
  let video;
  if (playerStateRetrieved && playerStateRetrieved.data.video.videoId === videoId) {
    video = playerStateRetrieved.data.video;
  } else {
    try {
      video = await getVideo(videoId, get(playerProxyVideosStore), { priority: "high" });
    } catch (errorMessage) {
      error(500, errorMessage);
    }
  }
  if (video.premium) {
    error(400, get(_)("premium"));
  }
  let personalPlaylists;
  if (get(authStore)) {
    postHistory(video.videoId);
    personalPlaylists = getPersonalPlaylists({ priority: "low" });
  } else {
    personalPlaylists = null;
  }
  let comments;
  try {
    comments = video.liveNow ? null : getComments(videoId, { sort_by: "top", source: "youtube" }, { priority: "low" });
  } catch {
    comments = null;
  }
  let returnYTDislikes;
  const returnYTDislikesInstance = get(returnYTDislikesInstanceStore);
  if (returnYTDislikesInstance && returnYTDislikesInstance !== "") {
    try {
      returnYTDislikes = get(returnYtDislikesStore) ? getDislikes(videoId, { priority: "low" }) : null;
    } catch {
    }
  }
  const playlistId = url.searchParams.get("playlist");
  if (playlistId) {
    await loadEntirePlaylist(playlistId);
  }
  return {
    video,
    content: phaseDescription(video.videoId, video.descriptionHtml, video.fallbackPatch),
    playlistId,
    streamed: {
      personalPlaylists,
      returnYTDislikes,
      comments
    }
  };
}
export {
  getWatchDetails as g
};
