import "clsx";
import { g as get } from "./index3.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import { r as resolve } from "./server.js";
import "./state.svelte.js";
import he from "he";
import { i as isAndroidTvStore } from "./store.js";
import "./client2.js";
function truncate(value, maxLength = 50) {
  return value.length > maxLength ? `${value.substring(0, maxLength)}...` : value;
}
function decodeHtmlCharCodes(str) {
  const { decode } = he;
  return decode(str);
}
function unsafeRandomItem(array) {
  return array[Math.floor(Math.random() * array.length)];
}
function extractUniqueId(item) {
  if ("videoId" in item) {
    return item.videoId;
  } else if ("playlistId" in item) {
    return item.playlistId;
  } else if ("authorId" in item) {
    return item.authorId;
  } else {
    return item.title;
  }
}
function excludeDuplicateFeeds(currentItems, newItems) {
  const existingIds = [];
  currentItems.forEach((item) => {
    existingIds.push(extractUniqueId(item));
  });
  const nonDuplicatedNewItems = [];
  newItems.forEach((item) => {
    if (!existingIds.includes(extractUniqueId(item))) {
      nonDuplicatedNewItems.push(item);
    }
  });
  return [...nonDuplicatedNewItems, ...currentItems];
}
function createVideoUrl(videoId, playlistId) {
  const watchPath = resolve(`/${get(isAndroidTvStore) ? "tv" : "watch"}/[videoId]`, {
    videoId
  });
  const watchUrl = new URL(`${location.origin}${watchPath}`);
  if (playlistId !== "") {
    watchUrl.searchParams.set("playlist", playlistId);
  }
  return watchUrl;
}
export {
  extractUniqueId as a,
  createVideoUrl as c,
  decodeHtmlCharCodes as d,
  excludeDuplicateFeeds as e,
  truncate as t,
  unsafeRandomItem as u
};
