import { s as store_get, b as attr_class, a as attr, u as unsubscribe_stores, d as bind_props } from "./index.js";
import { p as page } from "./stores.js";
import { g as getBestThumbnail } from "./images.js";
import { v as videoLength } from "./numbers.js";
import { SafeArea } from "@capacitor-community/safe-area";
import { Capacitor } from "@capacitor/core";
import { ScreenOrientation } from "@capacitor/screen-orientation";
import "@sveltejs/kit";
import { c as cn } from "./beer.min.js";
import "iso-639-1";
import Mousetrap from "mousetrap";
import { CapacitorMusicControls } from "capacitor-music-controls-plugin";
import "shaka-player/dist/shaka-player.ui.js";
import "sponsorblock-api";
import { t as tick, o as onDestroy } from "./index-server.js";
import { _ } from "./index2.js";
import { s as saveVideoProgress, n as deleteVideoProgress } from "./index5.js";
import { v as darkModeStore, w as interfaceAmoledTheme, x as playertheatreModeIsActive, y as playerAlwaysLoopStore, i as isAndroidTvStore, z as playerAutoPlayStore, A as playerAndroidLockOrientation, B as synciousStore, l as synciousInstanceStore, b as authStore, p as playerSavePlaybackPositionStore } from "./store.js";
import { g as get } from "./index3.js";
import "./youtubejs.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import "./state.svelte.js";
import "he";
import "./client2.js";
import "googlevideo/sabr-streaming-adapter";
import "googlevideo/utils";
import "youtubei.js";
import { e as escape_html } from "./context.js";
async function getDynamicTheme(mode) {
  const givenSettings = await cn("theme");
  const themes = givenSettings[cn("mode")];
  const themeVars = {};
  themes.split(";").forEach((keyVar) => {
    const [key, value] = keyVar.split(":");
    themeVars[key] = value;
  });
  return themeVars;
}
async function setStatusBarColor() {
  if (Capacitor.getPlatform() !== "android") return;
  await tick();
  const surfaceColor = get(interfaceAmoledTheme) ? "#000000" : (await getDynamicTheme())["--surface-container"];
  const contentColor = !get(darkModeStore) ? "dark" : "light";
  await SafeArea.enable({
    config: {
      customColorsForSystemBars: true,
      statusBarColor: surfaceColor,
      statusBarContent: contentColor,
      navigationBarColor: surfaceColor,
      navigationBarContent: contentColor
    }
  });
}
function setAmoledTheme() {
  const isAmoled = get(interfaceAmoledTheme);
  const isDark = get(darkModeStore);
  if (isAmoled && isDark) {
    const rootVars = [
      "--surface-container",
      "--surface",
      "--surface-container-lowest",
      "--surface-container-low",
      "--surface-container-high",
      "--surface-container-highest"
    ];
    rootVars.forEach((varName) => {
      document.body.style.setProperty(varName, "#000");
    });
  } else {
    setTheme();
  }
}
function setTheme() {
  const isDark = get(darkModeStore);
  if (isDark === null) {
    if (window.matchMedia && window.matchMedia("(prefers-color-scheme: dark)").matches) {
      darkModeStore.set(true);
      cn("mode", "dark");
    } else {
      darkModeStore.set(false);
      cn("mode", "light");
    }
  } else {
    if (isDark) {
      cn("mode", "dark");
    } else {
      cn("mode", "light");
    }
  }
}
function Player($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      data,
      isEmbed = false,
      playerElement = void 0,
      hideControls = false
    } = $$props;
    let snackBarAlert = "";
    let originalOrigination;
    let showVideoRetry = false;
    let playerCurrentTime = 0;
    let playerMaxKnownTime = 0;
    let playerVolume = 0;
    let playerLoop = store_get($$store_subs ??= {}, "$playerAlwaysLoopStore", playerAlwaysLoopStore);
    playertheatreModeIsActive.subscribe(async () => {
      await tick();
    });
    async function onAndroidFullscreenChange() {
      const videoFormats = data.video.adaptiveFormats.filter((format) => format.type.startsWith("video/"));
      const isFullScreen = !!document.fullscreenElement;
      if (isFullScreen) {
        await SafeArea.enable({
          config: {
            customColorsForSystemBars: true,
            statusBarColor: "#00000000",
            statusBarContent: "light",
            navigationBarColor: "#00000000",
            navigationBarContent: "light"
          }
        });
      } else {
        await setStatusBarColor();
      }
      if (!store_get($$store_subs ??= {}, "$playerAndroidLockOrientation", playerAndroidLockOrientation)) return;
      if (isFullScreen && videoFormats[0].resolution) {
        const widthHeight = videoFormats[0].resolution.split("x");
        if (widthHeight.length !== 2) return;
        if (Number(widthHeight[0]) > Number(widthHeight[1])) {
          await ScreenOrientation.lock({ orientation: "landscape" });
        } else {
          await ScreenOrientation.lock({ orientation: "portrait" });
        }
      } else {
        await ScreenOrientation.lock({ orientation: originalOrigination.type });
      }
    }
    function loadTimeFromUrl(page2) {
      return false;
    }
    page.subscribe((pageUpdate) => loadTimeFromUrl());
    function updateVideoPlayerHeight() {
    }
    function savePlayerPos() {
      if (data.video.liveNow) return;
      const synciousEnabled = store_get($$store_subs ??= {}, "$synciousStore", synciousStore) && store_get($$store_subs ??= {}, "$synciousInstanceStore", synciousInstanceStore) && store_get($$store_subs ??= {}, "$authStore", authStore);
      if (store_get($$store_subs ??= {}, "$playerSavePlaybackPositionStore", playerSavePlaybackPositionStore) && playerElement) {
        if (playerElement.currentTime < playerElement.duration - 10 && playerElement.currentTime > 10) {
          try {
            localStorage.setItem(`v_${data.video.videoId}`, playerElement.currentTime.toString());
          } catch {
          }
          if (synciousEnabled) {
            saveVideoProgress(data.video.videoId, playerElement.currentTime);
          }
        } else {
          try {
            localStorage.removeItem(`v_${data.video.videoId}`);
          } catch {
          }
          if (synciousEnabled) {
            deleteVideoProgress(data.video.videoId);
          }
        }
      }
    }
    onDestroy(async () => {
      if (Capacitor.getPlatform() === "android") {
        if (!store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)) {
          document.removeEventListener("fullscreenchange", onAndroidFullscreenChange);
        }
        await CapacitorMusicControls.destroy();
      }
      try {
        savePlayerPos();
      } catch {
      }
      window.removeEventListener("resize", updateVideoPlayerHeight);
      Mousetrap.unbind([
        "left",
        "right",
        "space",
        "c",
        "f",
        "shift+left",
        "shift+right"
      ]);
    });
    $$renderer2.push(`<div id="player-container" role="presentation"${attr_class("svelte-nfsfpn", void 0, {
      "contain-video": !store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore),
      "tv-contain-video": store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore),
      "hide": showVideoRetry
    })}><video${attr("controls", false, true)}${attr("autoplay", store_get($$store_subs ??= {}, "$playerAutoPlayStore", playerAutoPlayStore), true)} id="player"${attr("poster", getBestThumbnail(data.video.videoThumbnails, 9999, 9999))} class="svelte-nfsfpn"></video> `);
    if (isEmbed && !store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="chip blur embed" style="position: absolute;top: 10px;left: 10px;font-size: 18px;">${escape_html(data.video.title)}</div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (!hideControls) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<p id="mobile-time" class="chip primary s svelte-nfsfpn">`);
      if (data.video.liveNow) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`${escape_html(store_get($$store_subs ??= {}, "$_", _)("thumbnail.live"))}`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`${escape_html(videoLength(playerCurrentTime))} / ${escape_html(videoLength(data.video.lengthSeconds))}`);
      }
      $$renderer2.push(`<!--]--></p>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div id="player-center" class="svelte-nfsfpn">`);
    {
      $$renderer2.push("<!--[!-->");
      {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<button class="extra"><i>play_arrow</i></button>`);
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></div> `);
    if (!hideControls) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div id="player-controls" class="svelte-nfsfpn"><article class="round" style="width: 100%;padding: 0;height: 10px;"><label class="slider max"><!---->`);
      {
        $$renderer2.push(`<input type="range"${attr("min", 0)}${attr("step", 0.1)}${attr("value", playerCurrentTime)}${attr("max", data.video.liveNow ? playerMaxKnownTime : data.video.lengthSeconds)}/>`);
      }
      $$renderer2.push(`<!----> <span></span></label></article> `);
      {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> <nav><nav class="no-wrap"><button><i>`);
      {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`play_arrow`);
      }
      $$renderer2.push(`<!--]--></i></button> `);
      if (Capacitor.getPlatform() !== "android") {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<article id="volume-slider" class="round m l" style="padding: 0;height: 10px;width: 150px;"><label class="slider max"><!---->`);
        {
          $$renderer2.push(`<input${attr("value", playerVolume)} type="range" step="0.1" max="1"/>`);
        }
        $$renderer2.push(`<!----> <span></span></label></article>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--></nav> <div class="max"></div> <nav class="no-wrap"><p class="chip primary m l" style="border: none;">`);
      if (data.video.liveNow) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`${escape_html(store_get($$store_subs ??= {}, "$_", _)("thumbnail.live"))}`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`${escape_html(videoLength(playerCurrentTime))} / ${escape_html(videoLength(data.video.lengthSeconds))}`);
      }
      $$renderer2.push(`<!--]--></p> `);
      {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> <button><i>settings</i> <menu class="no-wrap mobile svelte-nfsfpn" id="settings-menu">`);
      {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> `);
      {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<li role="presentation"><nav class="no-wrap" style="width: 100%;"><i>high_quality</i> ${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.controls.quality"))} <div class="max"></div> <span class="chip">`);
        {
          $$renderer2.push("<!--[!-->");
          $$renderer2.push(`${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.controls.auto"))}`);
        }
        $$renderer2.push(`<!--]--></span></nav></li> <li role="presentation"><nav class="no-wrap" style="width: 100%;"><i>speed</i> ${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.controls.playbackSpeed"))} <div class="max"></div> <span class="chip">${escape_html(playerElement?.playbackRate)}x</span></nav></li> `);
        {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]--> <li role="presentation"><nav class="no-wrap" style="width: 100%;"><i>all_inclusive</i> ${escape_html(store_get($$store_subs ??= {}, "$_", _)("player.controls.loop"))} <div class="max"></div> <span class="chip">${escape_html(playerLoop ? store_get($$store_subs ??= {}, "$_", _)("player.controls.on") : store_get($$store_subs ??= {}, "$_", _)("player.controls.off"))}</span></nav></li>`);
      }
      $$renderer2.push(`<!--]--></menu></button> `);
      if (document.pictureInPictureEnabled) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<button><i>pip</i></button>`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]--> <button><i>`);
      if (document.fullscreenElement) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`fullscreen_exit`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`fullscreen`);
      }
      $$renderer2.push(`<!--]--></i></button></nav></nav></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div> `);
    {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (!isEmbed) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="snackbar" id="snackbar-alert"><span class="bold" style="text-transform: capitalize;">${escape_html(snackBarAlert)}</span></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { playerElement });
  });
}
export {
  Player as P,
  setStatusBarColor as a,
  setTheme as b,
  getDynamicTheme as g,
  setAmoledTheme as s
};
