import { d as bind_props, i as slot } from "./index.js";
import { o as onDestroy } from "./index-server.js";
import { f as fallback } from "./utils2.js";
function Spinner($$renderer, $$props) {
  let spinner = fallback($$props["spinner"], "");
  if (spinner === "bubbles") {
    $$renderer.push("<!--[-->");
    $$renderer.push(`<span class="loading-bubbles svelte-1ixraw5"><span class="bubble-item svelte-1ixraw5"></span> <span class="bubble-item svelte-1ixraw5"></span> <span class="bubble-item svelte-1ixraw5"></span> <span class="bubble-item svelte-1ixraw5"></span> <span class="bubble-item svelte-1ixraw5"></span> <span class="bubble-item svelte-1ixraw5"></span> <span class="bubble-item svelte-1ixraw5"></span> <span class="bubble-item svelte-1ixraw5"></span></span>`);
  } else {
    $$renderer.push("<!--[!-->");
    if (spinner === "circles") {
      $$renderer.push("<!--[-->");
      $$renderer.push(`<span class="loading-circles svelte-1ixraw5"><span class="circle-item svelte-1ixraw5"></span> <span class="circle-item svelte-1ixraw5"></span> <span class="circle-item svelte-1ixraw5"></span> <span class="circle-item svelte-1ixraw5"></span> <span class="circle-item svelte-1ixraw5"></span> <span class="circle-item svelte-1ixraw5"></span> <span class="circle-item svelte-1ixraw5"></span> <span class="circle-item svelte-1ixraw5"></span></span>`);
    } else {
      $$renderer.push("<!--[!-->");
      if (spinner === "spiral") {
        $$renderer.push("<!--[-->");
        $$renderer.push(`<i class="loading-spiral svelte-1ixraw5"></i>`);
      } else {
        $$renderer.push("<!--[!-->");
        if (spinner === "wavedots") {
          $$renderer.push("<!--[-->");
          $$renderer.push(`<span class="loading-wave-dots svelte-1ixraw5"><span class="wave-item svelte-1ixraw5"></span> <span class="wave-item svelte-1ixraw5"></span> <span class="wave-item svelte-1ixraw5"></span> <span class="wave-item svelte-1ixraw5"></span> <span class="wave-item svelte-1ixraw5"></span></span>`);
        } else {
          $$renderer.push("<!--[!-->");
          $$renderer.push(`<i class="loading-default svelte-1ixraw5"></i>`);
        }
        $$renderer.push(`<!--]-->`);
      }
      $$renderer.push(`<!--]-->`);
    }
    $$renderer.push(`<!--]-->`);
  }
  $$renderer.push(`<!--]-->`);
  bind_props($$props, { spinner });
}
(() => {
  let supportsPassive = false;
  try {
    const opts = Object.defineProperty({}, "passive", {
      get() {
        supportsPassive = { passive: true };
        return true;
      }
    });
    window.addEventListener("testPassive", null, opts);
    window.removeEventListener("testPassive", null, opts);
  } catch (e) {
  }
  return supportsPassive;
})();
function InfiniteLoading($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let showSpinner, showError, showNoResults, showNoMore;
    const STATUS = { READY: 0, LOADING: 1, COMPLETE: 2, ERROR: 3 };
    let distance = fallback($$props["distance"], 100);
    let spinner = fallback($$props["spinner"], "default");
    let direction = fallback($$props["direction"], "bottom");
    let forceUseInfiniteWrapper = fallback($$props["forceUseInfiniteWrapper"], false);
    let identifier = fallback($$props["identifier"], () => +/* @__PURE__ */ new Date(), true);
    let isFirstLoad = true;
    let status = STATUS.READY;
    async function attemptLoad(isContinuousCall) {
    }
    onDestroy(() => {
    });
    showSpinner = status === STATUS.LOADING;
    showError = status === STATUS.ERROR;
    showNoResults = status === STATUS.COMPLETE;
    showNoMore = status === STATUS.COMPLETE;
    $$renderer2.push(`<div class="infinite-loading-container svelte-14nc1y8">`);
    if (showSpinner) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="infinite-status-prompt"><!--[-->`);
      slot($$renderer2, $$props, "spinner", { isFirstLoad }, () => {
        Spinner($$renderer2, { spinner });
      });
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (showNoResults) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="infinite-status-prompt"><!--[-->`);
      slot($$renderer2, $$props, "noResults", {}, () => {
        $$renderer2.push(`No results :(`);
      });
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (showNoMore) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="infinite-status-prompt"><!--[-->`);
      slot($$renderer2, $$props, "noMore", {}, () => {
        $$renderer2.push(`No more data :)`);
      });
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (showError) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="infinite-status-prompt"><!--[-->`);
      slot($$renderer2, $$props, "error", { attemptLoad }, () => {
        $$renderer2.push(`Oops, something went wrong :( <br/> <button class="btn-try-infinite svelte-14nc1y8">Retry</button>`);
      });
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div>`);
    bind_props($$props, {
      distance,
      spinner,
      direction,
      forceUseInfiniteWrapper,
      identifier
    });
  });
}
export {
  InfiniteLoading as I
};
