import { a as attr, s as store_get, b as attr_class, u as unsubscribe_stores } from "./index.js";
import { r as resolve } from "./server.js";
import "./youtubejs.js";
import "@capacitor/core";
import { a as interfaceLowBandwidthMode, i as isAndroidTvStore, b as authStore } from "./store.js";
import { p as proxyGoogleImage, g as getBestThumbnail } from "./images.js";
import { t as truncate } from "./misc.js";
import { _ } from "./index2.js";
import { l as localDb } from "./dexie.js";
import { e as escape_html } from "./context.js";
function Author($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { channel, hideSubscribe = false } = $$props;
    let subscribed = false;
    localDb.favouriteChannels.filter((item) => {
      return item.channelId === channel.authorId;
    });
    $$renderer2.push(`<nav><a${attr("href", resolve(`/channel/[authorId]`, { authorId: channel.authorId }))}><nav style="gap: 0.5em;">`);
    if (!store_get($$store_subs ??= {}, "$interfaceLowBandwidthMode", interfaceLowBandwidthMode)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<img loading="lazy" class="circle large"${attr("src", proxyGoogleImage(getBestThumbnail(channel.authorThumbnails)))} alt="Channel profile"/>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div><p style="margin: 0;" class="bold">${escape_html(store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore) ? channel.author : truncate(channel.author, 16))}</p> <p style="margin: 0;">${escape_html(channel.subCountText)}</p></div></nav></a> `);
    if (!hideSubscribe) {
      $$renderer2.push("<!--[-->");
      if (store_get($$store_subs ??= {}, "$authStore", authStore)) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<nav class="group split"><button${attr_class("", void 0, { "inverse-surface": !subscribed, "border": subscribed })}>`);
        {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`${escape_html(store_get($$store_subs ??= {}, "$_", _)("subscribe"))}`);
        }
        $$renderer2.push(`<!--]--></button> `);
        {
          $$renderer2.push("<!--[!-->");
        }
        $$renderer2.push(`<!--]--></nav>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<button class="inverse-surface" disabled>${escape_html(store_get($$store_subs ??= {}, "$_", _)("subscribe"))} <div class="tooltip">${escape_html(store_get($$store_subs ??= {}, "$_", _)("loginRequired"))}</div></button>`);
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></nav>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  Author as A
};
