export { matchers } from './matchers.js';

export const nodes = [
	() => import('./nodes/0'),
	() => import('./nodes/1'),
	() => import('./nodes/2'),
	() => import('./nodes/3'),
	() => import('./nodes/4'),
	() => import('./nodes/5'),
	() => import('./nodes/6'),
	() => import('./nodes/7'),
	() => import('./nodes/8'),
	() => import('./nodes/9'),
	() => import('./nodes/10'),
	() => import('./nodes/11'),
	() => import('./nodes/12'),
	() => import('./nodes/13'),
	() => import('./nodes/14'),
	() => import('./nodes/15'),
	() => import('./nodes/16'),
	() => import('./nodes/17'),
	() => import('./nodes/18'),
	() => import('./nodes/19'),
	() => import('./nodes/20')
];

export const server_loads = [];

export const dictionary = {
		"/(app)": [6,[2],[3]],
		"/(app)/auth": [7,[2],[3]],
		"/(app)/channel/[slug]": [8,[2],[3]],
		"/(no-layout)/embed/[slug]": [19],
		"/(app)/hashtag/[slug]": [9,[2],[3]],
		"/(app)/playlists": [12,[2],[3]],
		"/(app)/playlist": [10,[2],[3]],
		"/(app)/playlist/[slug]": [11,[2],[3]],
		"/(app)/search/[slug]": [13,[2],[3]],
		"/(app)/shorts/[slug]": [14,[2],[3]],
		"/(app)/subscriptions": [15,[2],[3]],
		"/(app)/subscriptions/manage": [16,[2],[3]],
		"/(no-layout)/tv/[slug]": [20,[4],[5]],
		"/(app)/watch": [17,[2],[3]],
		"/(app)/watch/[slug]": [18,[2],[3]]
	};

export const hooks = {
	handleError: (({ error }) => { console.error(error) }),
	
	reroute: (() => {}),
	transport: {}
};

export const decoders = Object.fromEntries(Object.entries(hooks.transport).map(([k, v]) => [k, v.decode]));
export const encoders = Object.fromEntries(Object.entries(hooks.transport).map(([k, v]) => [k, v.encode]));

export const hash = false;

export const decode = (type, value) => decoders[type](value);

export { default as root } from '../root.js';