"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateYoutubeURL = exports.extractVideoID = void 0;
const regex = /^((?:https?:)?\/\/)?((?:www|m)\.)?((?:youtube\.com|youtu.be))(\/(?:[\w\-]+\?v=|embed\/|v\/)?)([\w\-]+)(\S+)?$/;
/**
 * Extracts the video ID from the full URL.
 * this function assumes the input is surely a YouTube video URL, otherwise may return null or a part of the input.
 * @param youtubeURL The complete YouTube URL of a video.
 * @returns The video ID extracted from the input URL.
 */
function extractVideoID(youtubeURL) {
    let matchArray = youtubeURL.match(regex);
    return matchArray && matchArray[5];
}
exports.extractVideoID = extractVideoID;
function validateYoutubeURL(youtubeURL) {
    return regex.test(youtubeURL);
}
exports.validateYoutubeURL = validateYoutubeURL;
