import { Category } from '../../types/segment/Category';
import { SponsorBlockOptions } from '../../types/SponsorBlockOptions';
import { SponsorBlock } from './user';
import { SponsorBlockVIPInterface } from '../interfaces/vip';
import { VideoResolvable } from '../../types/Video';
export declare class SponsorBlockVIP extends SponsorBlock implements SponsorBlockVIPInterface {
    userID: string;
    options: SponsorBlockOptions;
    constructor(userID: string, options?: SponsorBlockOptions);
    blockSubmissionsOfCategory(video: VideoResolvable, ...categories: Category[]): Promise<void>;
    shadowBan(publicUserID: string, hideOldSubmissions?: boolean): Promise<void>;
    removeShadowBan(publicUserID: string): Promise<void>;
    hideOldSubmissions(publicUserID: string): Promise<void>;
    warnUser(publicUserID: string, reason?: string, enabled?: boolean): Promise<void>;
    clearCache(video: VideoResolvable): Promise<void>;
    purgeAllSegments(video: VideoResolvable): Promise<void>;
}
