import { a as getChannelContent, b as getChannel } from "../../../../../chunks/index5.js";
import { e as excludeDuplicateFeeds } from "../../../../../chunks/misc.js";
import { c as channelCacheStore } from "../../../../../chunks/store.js";
import { error } from "@sveltejs/kit";
import { g as get } from "../../../../../chunks/index3.js";
async function load({ params }) {
  const currentChannelCache = get(channelCacheStore);
  if (params.slug in currentChannelCache) {
    getChannelContent(params.slug, {
      type: "videos"
    }).then((channelContent) => {
      if (!("videos" in currentChannelCache[params.slug].displayContent)) return;
      currentChannelCache[params.slug].displayContent.videos.videos = excludeDuplicateFeeds(
        currentChannelCache[params.slug].displayContent.videos.videos,
        channelContent.videos
      );
    });
    return;
  }
  let channel;
  try {
    channel = await getChannel(params.slug);
  } catch (errorMessage) {
    error(500, errorMessage);
  }
  const displayContent = await getChannelContent(params.slug, {
    type: "videos"
  });
  channelCacheStore.set({
    ...currentChannelCache,
    [params.slug]: {
      channel,
      displayContent: { videos: displayContent }
    }
  });
}
export {
  load
};
