import { g as get } from "./index3.js";
import { e as interfaceForceCase } from "./store.js";
const titleCases = ["lowercase", "uppercase", "title case", "sentence case"];
function letterCase(text, caseTypeOverwrite) {
  const casing = caseTypeOverwrite ? caseTypeOverwrite : get(interfaceForceCase);
  if (!casing) return text;
  switch (casing) {
    case "lowercase":
      return text.toLowerCase();
    case "uppercase":
      return text.toUpperCase();
    case "sentence case":
      return sentenceCase(text);
    default:
      return titleCase(text);
  }
}
function sentenceCase(text) {
  const sentences = text.match(/[^.!?]*[.!?]*/g) || [];
  const casedSentences = sentences.map((sentence) => {
    sentence = sentence.trim();
    if (sentence.length === 0) return "";
    return sentence.charAt(0).toUpperCase() + sentence.slice(1).toLowerCase();
  });
  return casedSentences.join(" ");
}
function titleCase(text) {
  if (!text) return "";
  const words = text.split(/(\s+)/).filter((word) => word.trim().length > 0);
  const titleCasedWords = words.map((word) => {
    if (word.length === 0) return "";
    const firstChar = word.charAt(0);
    const restOfWord = word.slice(1).toLowerCase();
    if (/[a-zA-Z]/.test(firstChar)) {
      return firstChar.toUpperCase() + restOfWord;
    }
    return word;
  });
  return titleCasedWords.join(" ");
}
export {
  titleCase as a,
  letterCase as l,
  titleCases as t
};
