import { g as get } from "./index3.js";
import { g as instanceStore } from "./store.js";
function getBestThumbnail(images, maxWidthDimension = 480, maxHeightDimension = 360) {
  if (images && images.length > 0) {
    const imagesFiltered = images.filter(
      (image) => image.width < maxWidthDimension && image.height < maxHeightDimension
    );
    if (imagesFiltered.length === 0) {
      return images[0].url;
    }
    imagesFiltered.sort((a, b) => {
      return b.width * b.height - a.width * a.height;
    });
    return imagesFiltered[0].url;
  } else {
    return "";
  }
}
function proxyGoogleImage(source) {
  if (source.startsWith("//")) source = `https:${source}`;
  let path;
  try {
    path = new URL(source).pathname;
  } catch {
  }
  if (typeof path === "undefined") return "";
  return `${get(instanceStore)}/ggpht${path}`;
}
export {
  getBestThumbnail as g,
  proxyGoogleImage as p
};
