import { b as attr_class, a as attr, s as store_get, c as attr_style, u as unsubscribe_stores, d as bind_props, f as stringify } from "./index.js";
import { r as resolve } from "./server.js";
import { g as get } from "./index3.js";
import { d as syncPartyPeerStore, a as interfaceLowBandwidthMode, p as playerSavePlaybackPositionStore } from "./store.js";
import { l as letterCase } from "./letterCasing.js";
import { v as videoLength, c as cleanNumber } from "./numbers.js";
import { o as onDestroy } from "./index-server.js";
import { _ } from "./index2.js";
import "./youtubejs.js";
import "@capacitor/core";
import { c as createVideoUrl } from "./misc.js";
/* empty css                                        */
import { e as escape_html } from "./context.js";
function Thumbnail($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { video = void 0, playlistId = "", sideways = false } = $$props;
    let placeholderHeight = 0;
    let watchUrl = createVideoUrl(video.videoId, playlistId);
    syncPartyPeerStore.subscribe((peer) => {
      if (peer) {
        watchUrl.searchParams.set("sync", peer.id);
      }
    });
    let progress = void 0;
    if (get(playerSavePlaybackPositionStore)) {
      try {
        progress = localStorage.getItem(`v_${video.videoId}`) ?? void 0;
      } catch {
        progress = void 0;
      }
    } else {
      progress = void 0;
    }
    let startedSideways = sideways === true;
    function disableSideways() {
      if (!startedSideways) return;
      if (window.innerWidth <= 1800) {
        sideways = false;
      } else sideways = true;
    }
    onDestroy(() => {
      removeEventListener("resize", disableSideways);
    });
    $$renderer2.push(`<div tabindex="0" role="button"${attr_class("svelte-16uaffw", void 0, { "sideways-root": sideways })}><div id="thumbnail-container"><a tabindex="-1" class="wave thumbnail svelte-16uaffw"${attr("href", watchUrl.toString())} data-sveltekit-preload-data="off">`);
    if (!store_get($$store_subs ??= {}, "$interfaceLowBandwidthMode", interfaceLowBandwidthMode)) {
      $$renderer2.push("<!--[-->");
      {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="secondary-container"${attr_style(`width: 100%;height: ${stringify(placeholderHeight)}px;`)}></div>`);
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (progress) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<progress class="absolute right bottom" style="z-index: 1;"${attr("value", progress)}${attr("max", video.lengthSeconds)}></progress>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (!("liveVideo" in video) || !video.liveVideo) {
      $$renderer2.push("<!--[-->");
      if (video.lengthSeconds !== 0) {
        $$renderer2.push("<!--[-->");
        if (!store_get($$store_subs ??= {}, "$interfaceLowBandwidthMode", interfaceLowBandwidthMode)) {
          $$renderer2.push("<!--[-->");
          $$renderer2.push(`<div class="absolute right bottom small-margin black white-text small-text thumbnail-corner"> ${escape_html(videoLength(video.lengthSeconds))} </div>`);
        } else {
          $$renderer2.push("<!--[!-->");
          $$renderer2.push(`<h3>${escape_html(videoLength(video.lengthSeconds))}</h3>`);
        }
        $$renderer2.push(`<!--]-->`);
      } else {
        $$renderer2.push("<!--[!-->");
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
      if (video.lengthSeconds !== 0) {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<div class="absolute right bottom small-margin red white-text small-text thumbnail-corner">${escape_html(store_get($$store_subs ??= {}, "$_", _)("thumbnail.live"))}</div>`);
      } else {
        $$renderer2.push("<!--[!-->");
        $$renderer2.push(`<h3>${escape_html(store_get($$store_subs ??= {}, "$_", _)("thumbnail.live"))}</h3>`);
      }
      $$renderer2.push(`<!--]-->`);
    }
    $$renderer2.push(`<!--]--></a></div> <div class="thumbnail-details video-title svelte-16uaffw"><div class="video-title svelte-16uaffw"><a tabindex="-1" style="padding-left: 1px;" class="video-title svelte-16uaffw" data-sveltekit-preload-data="off"${attr("href", watchUrl.toString())}><span class="bold svelte-16uaffw">${escape_html(letterCase(video.title.trimEnd()))}</span></a> <div>`);
    if (video.authorId) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<a tabindex="-1"${attr("href", resolve(`/channel/[authorId]`, { authorId: video.authorId }))}${attr_class("", void 0, { "author": !sideways })}>${escape_html(video.author)}</a>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<p>${escape_html(video.author)}</p>`);
    }
    $$renderer2.push(`<!--]--> `);
    if (video.promotedBy === "favourited") {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<i>star</i>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (!("publishedText" in video) && "viewCountText" in video) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`•
					${escape_html(video.viewCountText ?? cleanNumber(video.viewCount ?? 0))}
					${escape_html(store_get($$store_subs ??= {}, "$_", _)("views"))}`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if ("publishedText" in video) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="max">${escape_html(video.viewCountText ?? cleanNumber(video.viewCount ?? 0))} • ${escape_html(video.publishedText)}</div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div></div></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { video, sideways });
  });
}
export {
  Thumbnail as T
};
