import { b as attr_class, f as stringify, a as attr, s as store_get, u as unsubscribe_stores } from "./index.js";
import { a as interfaceLowBandwidthMode } from "./store.js";
import { r as resolve } from "./server.js";
import { l as letterCase } from "./letterCasing.js";
import { _ } from "./index2.js";
import { t as truncate } from "./misc.js";
/* empty css                                                */
import { e as escape_html } from "./context.js";
function ContentColumn($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    let { children } = $$props;
    let largeCol = "2";
    let smallCol = "12";
    let mediumCol = "6";
    $$renderer2.push(`<div${attr_class(`s${stringify(smallCol)} m${stringify(mediumCol)} l${stringify(largeCol)}`)}>`);
    children?.($$renderer2);
    $$renderer2.push(`<!----></div>`);
  });
}
function PlaylistThumbnail($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { playlist, disabled = false } = $$props;
    const playlistLink = resolve("/playlist/[playlistId]", { playlistId: playlist.playlistId });
    $$renderer2.push(`<a${attr("href", playlistLink)} style="width: 100%; overflow: hidden;min-height:100px;"${attr_class("wave svelte-172hvki", void 0, { "link-disabled": disabled })}>`);
    if (playlist.videoCount > 0 && !store_get($$store_subs ??= {}, "$interfaceLowBandwidthMode", interfaceLowBandwidthMode)) {
      $$renderer2.push("<!--[-->");
      {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<progress class="circle"></progress>`);
      }
      $$renderer2.push(`<!--]-->`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<h6 style="margin: 3em 0;">No image</h6>`);
    }
    $$renderer2.push(`<!--]--> <div class="absolute right bottom small-margin black white-text small-text thumbnail-corner">${escape_html(playlist.videoCount)}
		${escape_html(store_get($$store_subs ??= {}, "$_", _)("videos"))}</div></a> <div class="small-padding"><nav class="no-margin"><div class="max"><a${attr("href", playlistLink)}${attr_class("svelte-172hvki", void 0, { "link-disabled": disabled })}><div class="bold">${escape_html(letterCase(truncate(playlist.title)))}</div></a> <div>`);
    if (playlist.authorId) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<a${attr("href", resolve("/channel/[authorId]", { authorId: playlist.authorId }))}>${escape_html(playlist.author)}</a>`);
    } else {
      $$renderer2.push("<!--[!-->");
      $$renderer2.push(`<p>${escape_html(playlist.author)}</p>`);
    }
    $$renderer2.push(`<!--]--></div></div></nav></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  ContentColumn as C,
  PlaylistThumbnail as P
};
