import { b as attr_class, a as attr, s as store_get, u as unsubscribe_stores, d as bind_props } from "./index.js";
import { p as page } from "./stores.js";
import { g as getBestThumbnail } from "./images.js";
import "human-number";
import { SafeArea } from "@capacitor-community/safe-area";
import { Capacitor } from "@capacitor/core";
import { ScreenOrientation } from "@capacitor/screen-orientation";
import "@sveltejs/kit";
import { c as cn } from "./beer.min.js";
import "iso-639-1";
import Mousetrap from "mousetrap";
import { CapacitorMusicControls } from "capacitor-music-controls-plugin";
import shaka from "shaka-player/dist/shaka-player.ui.js";
import "sponsorblock-api";
import { t as tick, o as onDestroy } from "./index-server.js";
import "i18next";
import "dayjs";
import { s as saveVideoProgress, n as deleteVideoProgress } from "./index5.js";
import { v as darkModeStore, w as interfaceAmoledTheme, x as themeColorStore, i as isAndroidTvStore, y as playerAutoPlayStore, z as playerAndroidLockOrientation, A as synciousStore, l as synciousInstanceStore, b as authStore, p as playerSavePlaybackPositionStore } from "./store.js";
import { g as get } from "./index3.js";
import "./youtubejs.js";
import "@sveltejs/kit/internal";
import "./exports.js";
import "./utils.js";
import "@sveltejs/kit/internal/server";
import "./state.svelte.js";
import "he";
import "./client2.js";
import "googlevideo/sabr-streaming-adapter";
import "googlevideo/utils";
import "youtubei.js";
import { e as escape_html } from "./context.js";
async function getDynamicTheme(mode) {
  const givenSettings = await cn("theme");
  const themes = givenSettings[cn("mode")];
  const themeVars = {};
  themes.split(";").forEach((keyVar) => {
    const [key, value] = keyVar.split(":");
    themeVars[key] = value;
  });
  return themeVars;
}
async function setStatusBarColor() {
  if (Capacitor.getPlatform() !== "android") return;
  await tick();
  const surfaceColor = get(interfaceAmoledTheme) ? "#000000" : (await getDynamicTheme())["--surface-container"];
  const contentColor = !get(darkModeStore) ? "dark" : "light";
  await SafeArea.enable({
    config: {
      customColorsForSystemBars: true,
      statusBarColor: surfaceColor,
      statusBarContent: contentColor,
      navigationBarColor: surfaceColor,
      navigationBarContent: contentColor
    }
  });
}
function setAmoledTheme() {
  const isAmoled = get(interfaceAmoledTheme);
  const isDark = get(darkModeStore);
  if (isAmoled && isDark) {
    const rootVars = [
      "--surface-container",
      "--surface",
      "--surface-container-lowest",
      "--surface-container-low",
      "--surface-container-high",
      "--surface-container-highest"
    ];
    rootVars.forEach((varName) => {
      document.body.style.setProperty(varName, "#000");
    });
  } else {
    setTheme();
  }
}
function setTheme() {
  const isDark = get(darkModeStore);
  if (isDark === null) {
    if (window.matchMedia && window.matchMedia("(prefers-color-scheme: dark)").matches) {
      darkModeStore.set(true);
      cn("mode", "dark");
    } else {
      darkModeStore.set(false);
      cn("mode", "light");
    }
  } else {
    if (isDark) {
      cn("mode", "dark");
    } else {
      cn("mode", "light");
    }
  }
}
class EndTimeElement extends shaka.ui.Element {
  video;
  button;
  constructor(parent, controls) {
    super(parent, controls);
    this.video = this.player.getMediaElement();
    this.button = document.createElement("button");
    this.button.classList.add("shaka-current-time", "shaka-end-time");
    this.button.disabled = true;
    this.parent.appendChild(this.button);
    this.updateTime = this.updateTime.bind(this);
    this.eventManager.listen(
      this.video,
      "timeupdate",
      this.updateTime
    );
  }
  updateTime() {
    const duration = this.video.duration;
    const currentTime = this.video.currentTime;
    if (isNaN(duration) || isNaN(currentTime)) return;
    const remainingTime = duration - currentTime;
    const end = new Date(Date.now() + remainingTime * 1e3);
    const formatted = end.toLocaleTimeString([], {
      hour: "2-digit",
      minute: "2-digit",
      hour12: true
    });
    this.button.textContent = `Ends at ${formatted}`;
  }
}
function Player($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { data, isEmbed = false, playerElement = void 0 } = $$props;
    let snackBarAlert = "";
    let originalOrigination;
    let showVideoRetry = false;
    async function updateSeekBarTheme() {
      return;
    }
    themeColorStore.subscribe(updateSeekBarTheme);
    darkModeStore.subscribe(updateSeekBarTheme);
    async function onAndroidFullscreenChange() {
      const videoFormats = data.video.adaptiveFormats.filter((format) => format.type.startsWith("video/"));
      const isFullScreen = !!document.fullscreenElement;
      if (isFullScreen) {
        await SafeArea.enable({
          config: {
            customColorsForSystemBars: true,
            statusBarColor: "#00000000",
            statusBarContent: "light",
            navigationBarColor: "#00000000",
            navigationBarContent: "light"
          }
        });
      } else {
        await setStatusBarColor();
      }
      if (!store_get($$store_subs ??= {}, "$playerAndroidLockOrientation", playerAndroidLockOrientation)) return;
      if (isFullScreen && videoFormats[0].resolution) {
        const widthHeight = videoFormats[0].resolution.split("x");
        if (widthHeight.length !== 2) return;
        if (Number(widthHeight[0]) > Number(widthHeight[1])) {
          await ScreenOrientation.lock({ orientation: "landscape" });
        } else {
          await ScreenOrientation.lock({ orientation: "portrait" });
        }
      } else {
        await ScreenOrientation.lock({ orientation: originalOrigination.type });
      }
    }
    function loadTimeFromUrl(page2) {
      return false;
    }
    page.subscribe((pageUpdate) => loadTimeFromUrl());
    function savePlayerPos() {
      if (data.video.liveNow) return;
      const synciousEnabled = store_get($$store_subs ??= {}, "$synciousStore", synciousStore) && store_get($$store_subs ??= {}, "$synciousInstanceStore", synciousInstanceStore) && store_get($$store_subs ??= {}, "$authStore", authStore);
      if (store_get($$store_subs ??= {}, "$playerSavePlaybackPositionStore", playerSavePlaybackPositionStore) && playerElement) {
        if (playerElement.currentTime < playerElement.duration - 10 && playerElement.currentTime > 10) {
          try {
            localStorage.setItem(`v_${data.video.videoId}`, playerElement.currentTime.toString());
          } catch {
          }
          if (synciousEnabled) {
            saveVideoProgress(data.video.videoId, playerElement.currentTime);
          }
        } else {
          try {
            localStorage.removeItem(`v_${data.video.videoId}`);
          } catch {
          }
          if (synciousEnabled) {
            deleteVideoProgress(data.video.videoId);
          }
        }
      }
    }
    onDestroy(async () => {
      if (Capacitor.getPlatform() === "android") {
        if (!store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)) {
          document.removeEventListener("fullscreenchange", onAndroidFullscreenChange);
        }
        await CapacitorMusicControls.destroy();
      }
      try {
        savePlayerPos();
      } catch {
      }
      Mousetrap.unbind([
        "left",
        "right",
        "space",
        "c",
        "f",
        "shift+left",
        "shift+right"
      ]);
    });
    $$renderer2.push(`<div id="shaka-container"${attr_class("player-theme svelte-nfsfpn", void 0, {
      "contain-video": !store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore),
      "tv-contain-video": store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore),
      "hide": showVideoRetry
    })} data-shaka-player-container=""><video${attr("controls", false, true)}${attr("autoplay", store_get($$store_subs ??= {}, "$playerAutoPlayStore", playerAutoPlayStore), true)} id="player"${attr("poster", getBestThumbnail(data.video.videoThumbnails, 9999, 9999))} class="svelte-nfsfpn"></video> `);
    if (isEmbed && !store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="chip blur embed" style="position: absolute;top: 10px;left: 10px;font-size: 18px;">${escape_html(data.video.title)}</div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--></div> `);
    {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> `);
    if (!isEmbed) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="snackbar" id="snackbar-alert"><span class="bold" style="text-transform: capitalize;">${escape_html(snackBarAlert)}</span></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]-->`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
    bind_props($$props, { playerElement });
  });
}
export {
  Player as P,
  setStatusBarColor as a,
  setTheme as b,
  getDynamicTheme as g,
  setAmoledTheme as s
};
