import { a as attr, s as store_get, u as unsubscribe_stores, b as attr_class, g as clsx, e as ensure_array_like } from "./index.js";
import { T as Thumbnail } from "./Thumbnail.js";
import { _ } from "./index2.js";
import "./youtubejs.js";
import "@capacitor/core";
import { a as interfaceLowBandwidthMode, i as isAndroidTvStore, b as authStore } from "./store.js";
import { C as ContentColumn, P as PlaylistThumbnail } from "./PlaylistThumbnail.js";
import { o as onDestroy } from "./index-server.js";
import Mousetrap from "mousetrap";
import { t as truncate, a as extractUniqueId } from "./misc.js";
import { r as resolve } from "./server.js";
import { c as cleanNumber } from "./numbers.js";
import { e as escape_html } from "./context.js";
/* empty css                                        */
function ChannelThumbnail($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { channel } = $$props;
    $$renderer2.push(`<a${attr("href", resolve(`/channel/[authorId]`, { authorId: channel.authorId }))} class="wave" style="min-width: 100%;min-height: 100%;"><div class="padding">`);
    if (!store_get($$store_subs ??= {}, "$interfaceLowBandwidthMode", interfaceLowBandwidthMode)) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="center-align">`);
      {
        $$renderer2.push("<!--[-->");
        $$renderer2.push(`<progress class="circle"></progress>`);
      }
      $$renderer2.push(`<!--]--></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <h5 class="center-align">${escape_html(truncate(channel.author, 14))}</h5> <h6 style="margin-top: 0;" class="center-align grey-text medium-text">${escape_html(cleanNumber(channel.subCount))}
			${escape_html(store_get($$store_subs ??= {}, "$_", _)("subscribers"))}</h6> <p>${escape_html(channel.description)}</p></div></a>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function HashtagThumbnail($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let { hashtag } = $$props;
    $$renderer2.push(`<a${attr("href", resolve(hashtag.url, {}))} class="wave" style="min-width: 100%;min-height: 100%;"><div class="padding"><h5 class="center-align">${escape_html(truncate(hashtag.title, 14))}</h5> <h6 style="margin-top: 0;" class="center-align grey-text medium-text">${escape_html(cleanNumber(hashtag.channelCount))}
			${escape_html(store_get($$store_subs ??= {}, "$_", _)("channels"))}</h6> <h6 style="margin-top: 0;" class="center-align grey-text medium-text">${escape_html(cleanNumber(hashtag.videoCount))}
			${escape_html(store_get($$store_subs ??= {}, "$_", _)("videos"))}</h6></div></a>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
function ItemsList($$renderer, $$props) {
  $$renderer.component(($$renderer2) => {
    var $$store_subs;
    let {
      items = [],
      playlistId = "",
      playlistAuthor = "",
      classes = "page right active"
    } = $$props;
    function calculateColumns() {
      return;
    }
    function checkComponentFocus() {
      return;
    }
    onDestroy(() => {
      if (store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)) {
        Mousetrap.unbind(["up", "down", "left", "right"]);
        window.removeEventListener("resize", calculateColumns);
        document.removeEventListener("focusin", checkComponentFocus);
        document.removeEventListener("focusout", checkComponentFocus);
      }
    });
    $$renderer2.push(`<div${attr_class(
      clsx(
        // Update navigation when items change
        classes
      ),
      "svelte-1hiob04",
      {
        "android-container": store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)
      }
    )}>`);
    if (items.length === 0) {
      $$renderer2.push("<!--[-->");
      $$renderer2.push(`<div class="space"></div> <div class="center-align"><svg width="200" height="200" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path style="fill: var(--secondary);" d="M11 0h2v4h-2zM5.001.586L3.587 2L6.5 4.914L7.915 3.5zM1 13.734L5.42 6h13.16L23 13.734V22H1zM6.58 8l-2.857 5h5.178l.193.75a3.002 3.002 0 0 0 5.812 0l.193-.75h5.178L17.42 8zM18.999.586L16.085 3.5l1.414 1.414L20.413 2z"></path></svg> <h1>${escape_html(store_get($$store_subs ??= {}, "$_", _)("noResult"))}</h1></div>`);
    } else {
      $$renderer2.push("<!--[!-->");
    }
    $$renderer2.push(`<!--]--> <div class="grid"><!--[-->`);
    const each_array = ensure_array_like(items);
    for (let index = 0, $$length = each_array.length; index < $$length; index++) {
      let item = each_array[index];
      ContentColumn($$renderer2, {
        children: ($$renderer3) => {
          $$renderer3.push(`<article${attr_class("no-padding android-tv-item border svelte-1hiob04", void 0, {
            "android-tv-focused": store_get($$store_subs ??= {}, "$isAndroidTvStore", isAndroidTvStore)
          })} style="height: 100%;"${attr("id", extractUniqueId(item))} role="presentation">`);
          if (item.type === "video" || item.type === "shortVideo" || item.type === "stream") {
            $$renderer3.push("<!--[-->");
            $$renderer3.push(`<!---->`);
            {
              Thumbnail($$renderer3, { video: item, playlistId });
            }
            $$renderer3.push(`<!----> `);
            if (store_get($$store_subs ??= {}, "$authStore", authStore) && decodeURIComponent(store_get($$store_subs ??= {}, "$authStore", authStore).username) === playlistAuthor && "indexId" in item) {
              $$renderer3.push("<!--[-->");
              $$renderer3.push(`<div class="right-align" style="margin: 1em .5em;"><button class="tertiary circle small"><i>delete</i> <div class="tooltip">${escape_html(store_get($$store_subs ??= {}, "$_", _)("delete"))}</div></button></div>`);
            } else {
              $$renderer3.push("<!--[!-->");
            }
            $$renderer3.push(`<!--]-->`);
          } else {
            $$renderer3.push("<!--[!-->");
            if (item.type === "channel") {
              $$renderer3.push("<!--[-->");
              ChannelThumbnail($$renderer3, { channel: item });
            } else {
              $$renderer3.push("<!--[!-->");
              if (item.type === "playlist") {
                $$renderer3.push("<!--[-->");
                PlaylistThumbnail($$renderer3, { playlist: item });
              } else {
                $$renderer3.push("<!--[!-->");
                if (item.type === "hashtag") {
                  $$renderer3.push("<!--[-->");
                  HashtagThumbnail($$renderer3, { hashtag: item });
                } else {
                  $$renderer3.push("<!--[!-->");
                }
                $$renderer3.push(`<!--]-->`);
              }
              $$renderer3.push(`<!--]-->`);
            }
            $$renderer3.push(`<!--]-->`);
          }
          $$renderer3.push(`<!--]--></article>`);
        }
      });
    }
    $$renderer2.push(`<!--]--></div></div>`);
    if ($$store_subs) unsubscribe_stores($$store_subs);
  });
}
export {
  ItemsList as I
};
