/*
 * Copyright (c) 2011 Kurt Aaholst <kaaholst@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package uk.org.ngo.squeezer.itemlist;
import java.util.List;
import java.util.Map;

import uk.org.ngo.squeezer.service.ServiceCallback;

public interface IServiceItemListCallback<T> extends ServiceCallback {
    void onItemsReceived(int count, int start, Map<String, Object> parameters, List<T> items, Class<T> dataType);
}

