/*
 * Copyright (c) 2015 Kurt Aaholst <kaaholst@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package uk.org.ngo.squeezer.framework;

import android.util.SparseArray;

/**
 * Reverse mapping of EnumWithId.
 * <p>
 * Enables lookup of enum value via it's id.
 */
public class EnumIdLookup<E extends Enum<E> & EnumWithId> {

    private final SparseArray<E> map = new SparseArray<>();

    public EnumIdLookup(Class<E> enumType) {
        for (E v : enumType.getEnumConstants()) {
            map.put(v.getId(), v);
        }
    }

    public E get(int num) {
        return map.get(num);
    }
}
