package uk.nktnet.webviewkiosk.ui.components.setting.fielditems.device

import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.stringResource
import uk.nktnet.webviewkiosk.R
import uk.nktnet.webviewkiosk.config.UserSettings
import uk.nktnet.webviewkiosk.config.UserSettingsKeys
import uk.nktnet.webviewkiosk.ui.components.setting.fields.BooleanSettingFieldItem
import uk.nktnet.webviewkiosk.utils.applyBlockScreenCapture

@Composable
fun BlockScreenCaptureSetting() {
    val context = LocalContext.current
    val userSettings = remember { UserSettings(context) }
    val settingKey = UserSettingsKeys.Device.BLOCK_SCREEN_CAPTURE

    BooleanSettingFieldItem(
        label = stringResource(id = R.string.device_block_screen_capture_title),
        infoText = """
            Prevent screenshots, screen recording and content previews in Recent Apps.
            This is done by setting the FLAG_SECURE window flag.
        """.trimIndent(),
        initialValue = userSettings.blockScreenCapture,
        settingKey = settingKey,
        restricted = userSettings.isRestricted(settingKey),
        onSave = {
            userSettings.blockScreenCapture = it
            applyBlockScreenCapture(context, it)
        }
    )
}
