/*
 *
 *     Copyright (C) 2015 Ingo Fuchs
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc.,
 *     51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * /
 */

package freed.cam.apis.camera2.parameters.manual;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.os.Build.VERSION_CODES;

import freed.cam.apis.basecamera.parameters.AbstractParameter;
import freed.cam.apis.camera2.Camera2;
import freed.cam.apis.camera2.CameraHolderApi2;
import freed.settings.SettingKeys;
import freed.utils.Log;

/**
 * Created by troop on 06.03.2015.
 */
@TargetApi(VERSION_CODES.LOLLIPOP)
public class ZoomApi2 extends AbstractParameter<Camera2>
{
    private final String TAG = ZoomApi2.class.getSimpleName();
    private final float maxzoom;
    private final Rect sensorSize;
    private final int minCropWidth;
    private final int minCropHeight;
    private int zoom;

    private final int ZOOM_LIMITER = 100;

    public ZoomApi2(Camera2 cameraUiWrapper)  {
        super(cameraUiWrapper, SettingKeys.M_ZOOM);
        maxzoom = ((CameraHolderApi2) cameraUiWrapper.getCameraHolder()).characteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        sensorSize = ((CameraHolderApi2) cameraUiWrapper.getCameraHolder()).characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        //1000 - (1000 / 4) = 750 /100 = 7,5
        int minCropW = (int)(sensorSize.width() - (sensorSize.width() / maxzoom));
        int minCropH = (int)(sensorSize.height() - (sensorSize.height() / maxzoom));

        minCropWidth = minCropW/ZOOM_LIMITER;
        minCropHeight = minCropH/ZOOM_LIMITER;

        stringvalues = createStringArray(0,ZOOM_LIMITER,1);
    }

    @Override
    public ViewState getViewState() {
        if (((CameraHolderApi2) cameraUiWrapper.getCameraHolder()).characteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM) > 0)
            return ViewState.Visible;
        else
            return ViewState.Hidden;
    }

    @Override
    public int getIntValue() {
        return zoom;
    }

    @Override
    public String getStringValue() {
        return String.valueOf(zoom);
    }

    @TargetApi(VERSION_CODES.LOLLIPOP)
    @Override
    public void setValue(int valueToSet, boolean setToCamera)
    {
        zoom = valueToSet;
        fireIntValueChanged(zoom);
        // diff values /2 cause we set it foreach side.
        int cropW = (minCropWidth * zoom)/2;
        int cropH = (minCropHeight * zoom)/2;
        Log.d(TAG, "maxZoomSize: " + minCropWidth +"/"+ minCropHeight + " cropSize: " + cropW+"/"+cropH);
        Rect zoom = new Rect(cropW, cropH,sensorSize.width()-cropW, sensorSize.height() - cropH);
        cameraUiWrapper.captureSessionHandler.SetParameterRepeating(CaptureRequest.SCALER_CROP_REGION, zoom,setToCamera);
    }

}
