# Archived CleverKeys Features

These files were part of the original CleverKeys codebase but were archived during 
the Unexpected-Keyboard source migration (2025-11-28). They may be reviewed for 
potential reintegration once the core keyboard is stable.

## Feature Categories

### Auto-Correction & Prediction
- `AutoCorrection.kt` - Auto-correction engine
- `AutoCorrectionEngine.kt` - Core correction logic
- `AutoCorrectionSettingsActivity.kt` - Settings UI
- `CompletionEngine.kt` - Word completion
- `ContextAnalyzer.kt` - Context-aware predictions
- `ContextModel.kt` - ML context model
- `TextPredictionEngine.kt` - Text prediction
- `TypingPredictionEngine.kt` - Typing predictions

### UI Enhancements
- `AnimationManager.kt` - UI animations
- `DarkModeManager.kt` - Dark mode support
- `KeyBorderRenderer.kt` - Key border rendering
- `KeyPreviewManager.kt` - Key press previews
- `LayoutSwitchAnimator.kt` - Layout switch animations
- `GestureTrailRenderer.kt` - Swipe trail rendering

### Accessibility
- `AccessibilityHelper.kt` - Accessibility features
- `ScreenReaderManager.kt` - Screen reader support
- `SwitchAccessSupport.kt` - Switch access
- `VoiceGuidanceEngine.kt` - Voice guidance

### Advanced Features
- `FloatingKeyboardManager.kt` - Floating keyboard mode
- `OneHandedModeManager.kt` - One-handed mode
- `SplitKeyboardManager.kt` - Split keyboard
- `ThumbModeOptimizer.kt` - Thumb mode optimization
- `MacroExpander.kt` - Macro expansion
- `TextExpander.kt` - Text expansion
- `ShortcutManager.kt` - Keyboard shortcuts

### Swipe/Gesture
- `GestureTypingCustomizer.kt` - Gesture customization
- `KeyboardSwipeRecognizer.kt` - Swipe recognition
- `ContinuousInputManager.kt` - Continuous input
- `SwipePredictionService.kt` - Swipe prediction service
- `SwipeTypingHandler.kt` - Swipe typing handler

### Settings/Configuration
- `CleverKeysSettings.kt` - Settings management
- `ThemeSettingsActivity.kt` - Theme settings
- `ClipboardSettingsActivity.kt` - Clipboard settings
- `ExtraKeysConfigActivity.kt` - Extra keys config
- `LayoutManagerActivity.kt` - Layout management
- `NeuralSettingsActivity.kt` - Neural settings

### Neural/ML
- `NeuralBrowserActivity.kt` - Neural model browser
- `NeuralConfig.kt` - Neural configuration
- `NeuralPredictionPipeline.kt` - Prediction pipeline
- `NeuralSwipeEngine.kt` - Neural swipe engine
- `OnnxSwipePredictorImpl.kt` - ONNX swipe predictor
- `BeamSearchDecoder.kt` - Beam search decoding

### Language Support
- `LocaleManager.kt` - Locale management
- `LanguageManager.kt` - Language switching
- `IMELanguageSelector.kt` - Language selector
- `RTLLanguageHandler.kt` - RTL support
- `TranslationEngine.kt` - Translation

### Utilities
- `BatchedMemoryOptimizer.kt` - Memory optimization
- `BenchmarkSuite.kt` - Performance benchmarks
- `RuntimeTestSuite.kt` - Runtime tests
- `RuntimeValidator.kt` - Validation
- `SystemIntegrationTester.kt` - Integration tests

## Total: 120 archived files

These can be reviewed and selectively reintegrated based on priority and stability.
